/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements;

import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.dmlStatements.TradeSecuritiesDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlutil.GFXDStructImpl;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class TradePortfolioDMLStmt
extends AbstractDMLStmt {
    private static boolean reproduceTicket48840 = true;
    protected static String insert = "insert into trade.portfolio values (?,?,?,?,?, ?)";
    protected static String put = "put into trade.portfolio values (?,?,?,?,?, ?)";
    protected static String[] update = new String[]{"update trade.portfolio set availQty=availQty-100 where cid = ? and sid = ?  and tid= ?", "update trade.portfolio set qty=qty-? where cid = ? and sid = ?  and tid= ?", "update trade.portfolio set subTotal = ? * qty  where cid = ? and sid = ?  and tid= ?", "update trade.portfolio set subTotal=? where cid = ? and sid = ?  and tid= ?", "update trade.portfolio set cid=? where cid = ? and sid = ?  and tid= ?", "update trade.portfolio set availQty=availQty-100 where cid = ? and sid = ? ", "update trade.portfolio set qty=qty-? where cid = ? and sid = ?  ", "update trade.portfolio set subTotal=? * qty where cid = ? and sid = ? ", "update trade.portfolio set subTotal=? where cid = ? and sid = ? ", "update trade.portfolio set cid=? where cid = ? and sid = ? ", "update trade.portfolio set sid=? where cid = ? and sid = ? "};
    protected static String[] select = new String[]{"select * from trade.portfolio where tid = ?", "select sid, cid, subTotal from trade.portfolio where (subTotal >? and subTotal <= ?) and tid=? ", reproduceTicket48840 ? "select count(distinct cid) as num_distinct_cid from trade.portfolio where (subTotal<? or subTotal >=?) and tid =?" : "select count (cid) as num_cid from trade.portfolio where (subTotal<? or subTotal >=?) and tid =?", "select distinct sid from trade.portfolio where (qty >=? and subTotal >= ?) and tid =?", "select sid, cid, qty from trade.portfolio  where (qty >=? and availQty<?) and tid =?", "select * from trade.portfolio where sid =? and cid=? and tid = ?", "select * from trade.portfolio ", "select sid, cid from trade.portfolio where subTotal >? and subTotal <= ? ", "select distinct cid from trade.portfolio where subTotal<? or subTotal >=?", "select distinct sid from trade.portfolio where qty >=? and subTotal >= ? ", "select sid, cid, qty from trade.portfolio  where (qty >=? and availQty<?) ", "select * from trade.portfolio where sid =? and cid=?"};
    protected static String[] delete = new String[]{"delete from trade.portfolio where cid=? and sid=? and tid=?", "delete from trade.portfolio where cid=? and sid=?"};
    protected static int maxNumOfTries = 1;
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    public static boolean useFunction = TestConfig.tab().booleanAt(SQLPrms.populateTableUsingFunction, false);
    protected static ArrayList<String> partitionKeys = null;

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        int cid = 0;
        cid = dConn != null ? (rand.nextInt(10) == 0 ? TradePortfolioDMLStmt.getCid(dConn) : TradePortfolioDMLStmt.getCid(gConn)) : TradePortfolioDMLStmt.getCid(gConn);
        if (cid != 0) {
            this.insert(dConn, gConn, size, cid);
        }
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        int numOfNonUniqUpdate = 6;
        int whichUpdate = this.getWhichUpdate(numOfNonUniqUpdate, update.length);
        int[] cid = new int[size];
        int[] sid = new int[size];
        int[] newCid = new int[size];
        int[] newSid = new int[size];
        int[] qty = new int[size];
        int[] availQty = new int[size];
        BigDecimal[] sub = new BigDecimal[size];
        BigDecimal[] price = new BigDecimal[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (isHATest && (whichUpdate == 0 || whichUpdate == 1 || whichUpdate == 5 || whichUpdate == 6) && !SQLTest.setTx) {
            Log.getLogWriter().info("avoid x=x+1 in HA test without txn, do not execute this update");
            return;
        }
        if (dConn != null) {
            int availSize = rand.nextInt(numGettingDataFromDerby) == 1 ? this.getDataForUpdate(dConn, cid, sid, qty, availQty, sub, newCid, newSid, price, size) : this.getDataForUpdate(gConn, cid, sid, qty, availQty, sub, newCid, newSid, price, size);
            if (SQLTest.testSecurity && availSize == 0) {
                Log.getLogWriter().info("does not have data to perform operation in security test");
                return;
            }
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            boolean success = this.updateDerbyTable(dConn, cid, sid, qty, availQty, sub, newCid, newSid, price, availSize, whichUpdate, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the update op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.updateDerbyTable(dConn, cid, sid, qty, availQty, sub, newCid, newSid, price, availSize, whichUpdate, exceptionList);
            }
            this.updateGFETable(gConn, cid, sid, qty, availQty, sub, newCid, newSid, price, availSize, whichUpdate, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else if (this.getDataForUpdate(gConn, cid, sid, qty, availQty, sub, newCid, newSid, price, size) > 0) {
            this.updateGFETable(gConn, cid, sid, qty, availQty, sub, newCid, newSid, price, size, whichUpdate);
        }
    }

    @Override
    public void delete(Connection dConn, Connection gConn) {
        int numOfNonUniqDelete = delete.length / 2;
        int whichDelete = this.getWhichOne(numOfNonUniqDelete, delete.length);
        int[] cid = new int[1];
        int[] sid = new int[1];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        int availSize = dConn != null ? (rand.nextInt(numGettingDataFromDerby) == 1 ? this.getDataForDelete(dConn, cid, sid, cid.length) : this.getDataForDelete(gConn, cid, sid, cid.length)) : this.getDataForDelete(gConn, cid, sid, cid.length);
        if (availSize == 0) {
            return;
        }
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, whichDelete, cid, sid, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the delete op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.deleteFromDerbyTable(dConn, whichDelete, cid, sid, exceptionList);
            }
            this.deleteFromGFETable(gConn, whichDelete, cid, sid, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.deleteFromGFETable(gConn, whichDelete, cid, sid);
        }
    }

    @Override
    public void query(Connection dConn, Connection gConn) {
        int numOfNonUniq = 6;
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        int qty = 1000;
        int avail = 500;
        int startPoint = 10000;
        int range = 100000;
        BigDecimal subTotal1 = new BigDecimal(Integer.toString(rand.nextInt(startPoint)));
        BigDecimal subTotal2 = subTotal1.add(new BigDecimal(Integer.toString(rand.nextInt(range))));
        int queryQty = rand.nextInt(qty);
        int queryAvail = rand.nextInt(avail);
        int sid = 0;
        int cid = 0;
        int[] key = TradePortfolioDMLStmt.getKey(gConn);
        if (key != null) {
            sid = key[0];
            cid = key[1];
        }
        int tid = TradePortfolioDMLStmt.getMyTid();
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        ResultSet discRS = null;
        ResultSet gfeRS = null;
        if (dConn != null) {
            try {
                discRS = TradePortfolioDMLStmt.query(dConn, whichQuery, subTotal1, subTotal2, queryQty, queryAvail, sid, cid, tid);
                if (discRS == null) {
                    Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                    if (!alterTableDropColumn || SQLTest.alterTableException.get() == null || !((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                        return;
                    }
                }
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exceptionList);
            }
            try {
                gfeRS = TradePortfolioDMLStmt.query(gConn, whichQuery, subTotal1, subTotal2, queryQty, queryAvail, sid, cid, tid);
                if (gfeRS == null) {
                    if (isHATest) {
                        Log.getLogWriter().info("Testing HA and did not get GFXD result set after retry");
                        return;
                    }
                    if (setCriticalHeap) {
                        Log.getLogWriter().info("got XCL54 and does not get query result");
                        return;
                    }
                    throw new TestException("Not able to get gfe result set after retry");
                }
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptionList);
            }
            SQLHelper.handleMissedSQLException(exceptionList);
            if (discRS == null || gfeRS == null) {
                return;
            }
            boolean success = ResultSetHelper.compareResultSets(discRS, gfeRS);
            if (!success) {
                Log.getLogWriter().info("Not able to compare results due to derby server error");
            }
        } else {
            try {
                gfeRS = TradePortfolioDMLStmt.query(gConn, whichQuery, subTotal1, subTotal2, queryQty, queryAvail, sid, cid, tid);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && SQLTest.testSecurity) {
                    Log.getLogWriter().info("Got expected no SELECT permission, continuing test");
                    return;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X04")) {
                    Log.getLogWriter().info("Got expected column not found exception, continuing test");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            if (gfeRS != null) {
                ResultSetHelper.asList(gfeRS, false);
            } else if (isHATest) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            } else if (setCriticalHeap) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to XCL54");
            } else {
                throw new TestException("gfxd query returns null and not a HA test");
            }
        }
        SQLHelper.closeResultSet(gfeRS, gConn);
    }

    @Override
    public void populate(Connection dConn, Connection gConn) {
        int numCid = rand.nextInt(60) + 1;
        int initSize = rand.nextInt(10) + 1;
        if (!useFunction) {
            for (int i = 0; i < numCid; ++i) {
                for (int j = 0; j < initSize; ++j) {
                    if (setCriticalHeap) {
                        this.resetCanceledFlag();
                    }
                    this.insert(dConn, gConn, 1);
                    this.commit(gConn);
                    if (dConn == null) continue;
                    this.commit(dConn);
                }
            }
        } else {
            for (int i = 0; i < numCid; ++i) {
                this.insert(dConn, initSize);
                this.commit(dConn);
            }
            try {
                this.populateUsingFunction(gConn);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    public void insert(Connection dConn, int size) {
        int cid = TradePortfolioDMLStmt.getCid(dConn);
        if (cid != 0) {
            this.insert(dConn, size, cid);
        }
    }

    public void insert(Connection dConn, int size, int cid) {
        int[] sid = new int[size];
        int[] qty = new int[size];
        BigDecimal[] sub = new BigDecimal[size];
        BigDecimal[] price = new BigDecimal[size];
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        int availSize = 0;
        availSize = this.getDataFromResultSet(dConn, sid, qty, sub, price, size);
        boolean success = this.insertToDerbyTable(dConn, cid, sid, qty, sub, availSize, exList);
        int count = 0;
        while (!success) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
            }
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            ++count;
            exList.clear();
            success = this.insertToDerbyTable(dConn, cid, sid, qty, sub, availSize, exList);
        }
    }

    private void populateUsingFunction(Connection gConn) throws SQLException {
        String insertSQL = null;
        insertSQL = " insert into trade.portfolio select p.* from table (trade.funcPortf( " + TradePortfolioDMLStmt.getMyTid() + ")) p";
        PreparedStatement stmt = TradePortfolioDMLStmt.getStmt(gConn, insertSQL);
        Log.getLogWriter().info("gemfirexd - inserting into trade.portfolio using function " + insertSQL);
        int rowCount = stmt.executeUpdate();
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        Log.getLogWriter().info("gemfirexd - inserted " + rowCount + " rows into trade.portfolio using function" + insertSQL);
    }

    public void insert(Connection dConn, Connection gConn, int size, int cid) {
        this.insert(dConn, gConn, size, cid, false);
    }

    public void insert(Connection dConn, Connection gConn, int size, int cid, boolean isPut) {
        int[] sid = new int[size];
        int[] qty = new int[size];
        BigDecimal[] sub = new BigDecimal[size];
        BigDecimal[] price = new BigDecimal[size];
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        int availSize = 0;
        if (dConn != null) {
            availSize = rand.nextInt(numGettingDataFromDerby) == 1 ? this.getDataFromResultSet(dConn, sid, qty, sub, price, size) : this.getDataFromResultSet(gConn, sid, qty, sub, price, size);
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            boolean success = this.insertToDerbyTable(dConn, cid, sid, qty, sub, availSize, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the insert op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.insertToDerbyTable(dConn, cid, sid, qty, sub, availSize, exList);
            }
            try {
                this.insertToGFETable(gConn, cid, sid, qty, sub, availSize, exList, isPut);
            }
            catch (TestException te) {
                if (te.getMessage().contains("Execute SQL statement failed with: 23505") && isHATest && SQLTest.isEdge) {
                    try {
                        this.checkTicket49605(dConn, gConn, "customers", cid, sid[0], null, null);
                    }
                    catch (TestException e) {
                        Log.getLogWriter().info("insert failed due to #49605 ", (Throwable)e);
                        Log.getLogWriter().info("retry this using put to work around #49605");
                        this.insertToGFETable(gConn, cid, sid, qty, sub, availSize, exList, true);
                        this.checkTicket49605(dConn, gConn, "customers", cid, sid[0], null, null);
                    }
                }
                throw te;
            }
            SQLHelper.handleMissedSQLException(exList);
        } else if (testUniqueKeys || testWanUniqueness) {
            availSize = this.getDataFromResultSet(gConn, sid, qty, sub, price, size);
            this.insertToGFETable(gConn, cid, sid, qty, sub, availSize, isPut);
        } else if (this.getRandomData(gConn, sid, qty, sub, price, size)) {
            this.insertToGFETable(gConn, cid, sid, qty, sub, size, isPut);
        }
    }

    protected int getDataFromResultSet(Connection regConn, int[] sid, int[] qty, BigDecimal[] sub, BigDecimal[] price, int size) {
        Connection conn = TradePortfolioDMLStmt.getAuthConn(regConn);
        int availSize = size;
        int firstQuery = 0;
        ResultSet rs = null;
        int[] offset = new int[1];
        if (testUniqueKeys || testWanUniqueness) {
            rs = TradeSecuritiesDMLStmt.getQuery(conn, firstQuery, 0, null, null, null, TradePortfolioDMLStmt.getMyTid());
            if (rs == null) {
                Log.getLogWriter().info("Already retried, will skip this operation");
                return 0;
            }
            ArrayList result = (ArrayList)ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
            SQLHelper.closeResultSet(rs, conn);
            if (result == null) {
                if (!SQLHelper.isDerbyConn(conn) && isHATest) {
                    return 0;
                }
                if (setCriticalHeap) {
                    boolean[] getCanceled = (boolean[])SQLTest.getCanceled.get();
                    if (getCanceled[0]) {
                        Log.getLogWriter().info("Not able to get data for due to query cancellation");
                        return 0;
                    }
                } else {
                    throw new TestException("could not get list from resultset, and it is not HA test");
                }
            }
            availSize = this.getAvailSize(result, size, offset);
            for (int i = 0; i < availSize; ++i) {
                sid[i] = (Integer)((GFXDStructImpl)result.get(i + offset[0])).get("SEC_ID");
                price[i] = (BigDecimal)((GFXDStructImpl)result.get(i + offset[0])).get("PRICE");
                qty[i] = rand.nextInt(1901) + 100;
                sub[i] = price[i].multiply(new BigDecimal(String.valueOf(qty[i])));
            }
        } else {
            this.getRandomData(conn, sid, qty, sub, price, availSize);
        }
        return availSize;
    }

    protected boolean getRandomData(Connection regConn, int[] sid, int[] qty, BigDecimal[] sub, BigDecimal[] price, int size) {
        Connection conn = TradePortfolioDMLStmt.getAuthConn(regConn);
        int fifthQuery = 4;
        ResultSet rs = null;
        try {
            for (int i = 0; i < size; ++i) {
                sid[i] = this.getSid();
                qty[i] = this.getQty();
                rs = TradeSecuritiesDMLStmt.getQuery(conn, fifthQuery, sid[i], null, null, null, -1);
                if (rs != null && rs.next()) {
                    price[i] = rs.getBigDecimal("price");
                    rs.close();
                }
                if (price[i] == null) continue;
                sub[i] = price[i].multiply(new BigDecimal(String.valueOf(qty[i])));
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkGFXDException(conn, se)) {
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean insertToDerbyTable(Connection conn, int cid, int[] sid, int[] qty, BigDecimal[] sub, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = TradePortfolioDMLStmt.getStmt(conn, insert);
        if (stmt == null) {
            return false;
        }
        int tid = TradePortfolioDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                verifyRowCount.put(tid + "_insert" + i, 0);
                count = this.insertToTable(stmt, cid, sid[i], qty[i], sub[i], tid);
                verifyRowCount.put(tid + "_insert" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected void insertToGFETable(Connection conn, int cid, int[] sid, int[] qty, BigDecimal[] sub, int size, List<SQLException> exceptions, boolean isPut) {
        PreparedStatement stmt = TradePortfolioDMLStmt.getStmt(conn, isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (SQLTest.setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradePortfolioDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, cid, sid[i], qty[i], sub[i], tid, isPut);
                if (count == verifyRowCount.get(tid + "_insert" + i)) continue;
                String str = "Gfxd insert has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void insertToGFETable(Connection conn, int cid, int[] sid, int[] qty, BigDecimal[] sub, int size, boolean isPut) {
        PreparedStatement stmt = TradePortfolioDMLStmt.getStmt(conn, isPut ? put : insert);
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradePortfolioDMLStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, cid, sid[i], qty[i], sub[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("detected foreign key constraint violation during " + (isPut ? "Put" : "Insert") + ", continuing test");
                    continue;
                }
                if (se.getSQLState().equals("23505")) {
                    Log.getLogWriter().info("detected primary key constraint violation during " + (isPut ? "Put" : "Insert") + ", continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42802")) {
                    Log.getLogWriter().info("Got expected column not found exception in insert, continuing test");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int cid, int sid, int qty, BigDecimal sub, int tid) throws SQLException {
        return this.insertToTable(stmt, cid, sid, qty, sub, tid, false);
    }

    protected int insertToTable(PreparedStatement stmt, int cid, int sid, int qty, BigDecimal sub, int tid, boolean isPut) throws SQLException {
        String txId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID: " + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - " + txId;
        Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.portfolio with CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ":AVAILQTY:" + qty + ",SUBTOTAL:" + sub);
        stmt.setInt(1, cid);
        stmt.setInt(2, sid);
        stmt.setInt(3, qty);
        stmt.setInt(4, qty);
        stmt.setBigDecimal(5, sub);
        stmt.setInt(6, tid);
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows into trade.portfolio CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ":AVAILQTY:" + qty + ",SUBTOTAL:" + sub);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        if (database.contains("gemfirexd") && isPut && !SQLTest.ticket49794fixed) {
            String deleteStatement = "DELETE FROM TRADE.PORTFOLIO_FULLDATASET  WHERE CID= " + cid + " and SID = " + sid;
            String insertStatement = " INSERT INTO TRADE.PORTFOLIO_FULLDATASET  VALUES ( " + cid + " ,  " + sid + " ,  " + qty + " ,  " + qty + " ,  " + sub + " ,  " + tid + ")";
            Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence deleting  the  row  from TRADE.PORTFOLIO_FULLDATASET with data CID:" + cid + ",SID:" + sid);
            stmt.getConnection().createStatement().execute(deleteStatement);
            Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence inserting  the  row  into  TRADE.PORTFOLIO_FULLDATASET with data CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ":AVAILQTY:" + qty + ",SUBTOTAL:" + sub);
            stmt.getConnection().createStatement().execute(insertStatement);
        }
        if (database.contains("gemfirexd") && isPut) {
            Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.portfolio with CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ":AVAILQTY:" + qty + ",SUBTOTAL:" + sub);
            rowCount = stmt.executeUpdate();
            Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows into trade.portfolio CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ":AVAILQTY:" + qty + ",SUBTOTAL:" + sub);
            warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        return rowCount;
    }

    protected int getDataForUpdate(Connection regConn, int[] cid, int[] sid, int[] qty, int[] availQty, BigDecimal[] sub, int[] newCid, int[] newSid, BigDecimal[] price, int size) {
        Connection conn = TradePortfolioDMLStmt.getAuthConn(regConn);
        int availSize = this.getDataFromResultSet(conn, newSid, qty, sub, price, size);
        this.getCids(conn, newCid);
        this.getCids(conn, cid);
        for (int i = 0; i < availSize; ++i) {
            sid[i] = this.getSid();
            availQty[i] = Math.abs(qty[i] - this.getQty());
        }
        return availSize;
    }

    protected boolean updateDerbyTable(Connection conn, int[] cid, int[] sid, int[] qty, int[] availQty, BigDecimal[] sub, int[] newCid, int[] newSid, BigDecimal[] price, int size, int whichUpdate, List<SQLException> exceptions) {
        if (whichUpdate == 4 || whichUpdate == 9 || whichUpdate == 10) {
            Log.getLogWriter().info("update on gfxd primary key, do not execute update in derby as well");
            return true;
        }
        PreparedStatement stmt = null;
        int tid = TradePortfolioDMLStmt.getMyTid();
        int count = -1;
        boolean[] unsupported = new boolean[1];
        stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, unsupported) : TradePortfolioDMLStmt.getStmt(conn, update[whichUpdate]);
        if (stmt == null) {
            if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                return true;
            }
            return unsupported[0];
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (stmt == null) continue;
                verifyRowCount.put(tid + "_update" + i, 0);
                count = this.updateTable(stmt, cid[i], sid[i], qty[i], availQty[i], sub[i], newCid[i], newSid[i], price[i], tid, whichUpdate);
                verifyRowCount.put(tid + "_update" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, boolean[] unsupported) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys, unsupported);
    }

    protected void setPartitionKeys() {
        if (!isWanTest) {
            partitionKeys = (ArrayList)partitionMap.get((Object)"portfolioPartition");
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_portfolioPartition"));
        }
        Log.getLogWriter().info("partition keys are " + partitionKeys);
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys, boolean[] unsupported) {
        PreparedStatement stmt = null;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("availQty")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("qty")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("subTotal")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("subTotal")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                throw new TestException("Test issue, this should not happen");
            }
            case 5: {
                if (partitionKeys.contains("availQty")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 6: {
                if (partitionKeys.contains("qty")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 7: {
                if (partitionKeys.contains("subTotal")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 8: {
                if (partitionKeys.contains("subTotal")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 9: {
                throw new TestException("Test issue, this should not happen");
            }
            case 10: {
                throw new TestException("Test issue, this should not happen");
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] qty, int[] availQty, BigDecimal[] sub, int[] newCid, int[] newSid, BigDecimal[] price, int size, int whichUpdate, List<SQLException> exceptions) {
        int tid = TradePortfolioDMLStmt.getMyTid();
        int count = -1;
        if (whichUpdate == 4 || whichUpdate == 9 || whichUpdate == 10) {
            PreparedStatement stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
            if (stmt == null) {
                return;
            }
            throw new TestException("Test issue, should not happen\n");
        }
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : TradePortfolioDMLStmt.getStmt(conn, update[whichUpdate]);
        if (SQLTest.testSecurity && stmt == null) {
            if (SQLSecurityTest.prepareStmtException.get() != null) {
                SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
        } else if (SQLTest.setCriticalHeap && stmt == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (stmt == null || (count = this.updateTable(stmt, cid[i], sid[i], qty[i], availQty[i], sub[i], newCid[i], newSid[i], price[i], tid, whichUpdate)) == verifyRowCount.get(tid + "_update" + i)) continue;
                String str = "Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] qty, int[] availQty, BigDecimal[] sub, int[] newCid, int[] newSid, BigDecimal[] price, int size, int whichUpdate) {
        int tid = TradePortfolioDMLStmt.getMyTid();
        if (whichUpdate == 4 || whichUpdate == 9 || whichUpdate == 10) {
            PreparedStatement stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
            if (stmt == null) {
                return;
            }
            throw new TestException("Test issue, should not happen%n");
        }
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : TradePortfolioDMLStmt.getStmt(conn, update[whichUpdate]);
        if (stmt == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            try {
                this.updateTable(stmt, cid[i], sid[i], qty[i], availQty[i], sub[i], newCid[i], newSid[i], price[i], tid, whichUpdate);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503") && (whichUpdate == 4 || whichUpdate == 9 || whichUpdate == 10)) {
                    Log.getLogWriter().info("detected foreign key constraint violation during update, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("23513")) {
                    Log.getLogWriter().info("detected check constraint violation during update, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int updateTable(PreparedStatement stmt, int cid, int sid, int qty, int availQty, BigDecimal sub, int newCid, int newSid, BigDecimal price, int tid, int whichUpdate) throws SQLException {
        String txId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID: " + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - " + txId;
        String query = " QUERY: " + update[whichUpdate];
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.portfolio with AVAILQTY:(availQty-100)  where CID:" + cid + ",SID:" + newSid + ",TID:" + tid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, newSid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.portfolio AVAILQTY:(availQty-100) where CID:" + cid + ",SID:" + newSid + ",TID:" + tid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating trade.portfolio with QTY:qty - " + qty + " where CID:" + cid + ",SID:" + newSid + ",TID:" + tid + query);
                stmt.setInt(1, qty);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.portfolio QTY:qty - " + qty + " where CID:" + cid + ",SID:" + newSid + ",TID:" + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updaing trade.portfolio  with SUBTOTAL:price( " + price + " ) * qty where CID:" + cid + ",SID:" + newSid + ",TID:" + tid + query);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                stmt.setInt(4, tid);
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.portfolio SUBTOTAL: price( " + price + " ) * qty where CID:" + cid + ",SID:" + newSid + ",TID:" + tid + query);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.portfolio with SUBTOTAL:" + sub + " where CID:" + cid + ",SID:" + newSid + ",TID:" + tid + query);
                stmt.setBigDecimal(1, sub);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.portfolio SUBTOTAL:" + sub + " where CID:" + cid + ",SID:" + newSid + ",TID:" + tid + query);
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "updating trade.portfolio with CID:" + newCid + " where CID:" + cid + ",SID:" + newSid + ",TID:" + tid + query);
                stmt.setInt(1, newCid);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                stmt.setInt(4, tid);
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.portfolio CID:" + newCid + " where CID:" + cid + ",SID:" + newSid + ",TID:" + tid + query);
                break;
            }
            case 5: {
                Log.getLogWriter().info(database + "updating trade.portfolio with AVAILQTY:(availQty-100) where CID:" + cid + ",SID:" + newSid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, newSid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.portfolio AVAILQTY:(availQty-100) where CID:" + cid + ",SID:" + newSid + query);
                break;
            }
            case 6: {
                Log.getLogWriter().info(database + "updating trade.portfolio QTY:qty -" + qty + " where CID:" + cid + ",SID:" + newSid + query);
                stmt.setInt(1, qty);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.portfolio QTY:qty -" + qty + " where CID:" + cid + ",SID:" + newSid + query);
                break;
            }
            case 7: {
                Log.getLogWriter().info(database + "updating trade.portfolio with SUBTOTAL:price( " + price + " ) * qty where CID:" + cid + ",SID:" + newSid + query);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.portfolio SUBTOTAL:price( " + price + " ) * qty where CID:" + cid + ",SID:" + newSid + query);
                break;
            }
            case 8: {
                Log.getLogWriter().info(database + "updating trade.portfolio with SUBTOTAL:" + sub + " where CID:" + cid + ",SID:" + newSid + query);
                stmt.setBigDecimal(1, sub);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.portfolio SUBTOTAL:" + sub + " where CID:" + cid + ",SID:" + newSid + query);
                break;
            }
            case 9: {
                Log.getLogWriter().info(database + "updating trade.portfolio with CID:" + newCid + " where CID:" + cid + ",SID:" + newSid + query);
                stmt.setInt(1, newCid);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.portfolio CID:" + newCid + " where CID:" + cid + ",SID:" + newSid + query);
                break;
            }
            case 10: {
                Log.getLogWriter().info(database + "updating trade.portfolio with NEWSID:" + newSid + " where CID:" + cid + ",SID:" + newSid + query);
                stmt.setInt(1, newSid);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.portfolio NEWSID:" + newSid + " where CID:" + cid + ",SID:" + newSid + query);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int getDataForDelete(Connection regConn, int[] cid, int[] sid, int size) {
        Connection conn = TradePortfolioDMLStmt.getAuthConn(regConn);
        int availSize = size;
        int firstQuery = 0;
        ResultSet rs = null;
        int[] offset = new int[1];
        int tid = 0;
        tid = testUniqueKeys || testWanUniqueness ? TradePortfolioDMLStmt.getMyTid() : rand.nextInt(TradePortfolioDMLStmt.getMyTid() + 1);
        rs = TradePortfolioDMLStmt.getQuery(conn, firstQuery, null, null, 0, 0, 0, 0, tid);
        int count = 0;
        while (rs == null && !setCriticalHeap) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("not able to get info, use random data instead");
                this.getCids(conn, cid);
                for (int i = 0; i < availSize; ++i) {
                    sid[i] = this.getSid();
                }
                return availSize;
            }
            ++count;
            rs = TradePortfolioDMLStmt.getQuery(conn, firstQuery, null, null, 0, 0, 0, 0, TradePortfolioDMLStmt.getMyTid());
        }
        ArrayList result = (ArrayList)ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
        SQLHelper.closeResultSet(rs, conn);
        availSize = this.getAvailSize(result, size, offset);
        for (int i = 0; i < availSize; ++i) {
            cid[i] = (Integer)((GFXDStructImpl)result.get(i + offset[0])).get("CID");
            sid[i] = (Integer)((GFXDStructImpl)result.get(i + offset[0])).get("SID");
        }
        return availSize;
    }

    protected boolean deleteFromDerbyTable(Connection dConn, int whichDelete, int[] cid, int[] sid, List<SQLException> exList) {
        PreparedStatement stmt = TradePortfolioDMLStmt.getStmt(dConn, delete[whichDelete]);
        if (stmt == null) {
            return false;
        }
        int tid = TradePortfolioDMLStmt.getMyTid();
        int count = -1;
        try {
            for (int i = 0; i < cid.length; ++i) {
                verifyRowCount.put(tid + "_delete" + i, 0);
                count = this.deleteFromTable(stmt, cid[i], sid[i], tid, whichDelete);
                verifyRowCount.put(tid + "_delete" + i, new Integer(count));
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void deleteFromGFETable(Connection gConn, int whichDelete, int[] cid, int[] sid, List<SQLException> exList) {
        PreparedStatement stmt = TradePortfolioDMLStmt.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (SQLTest.setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradePortfolioDMLStmt.getMyTid();
        int count = -1;
        try {
            for (int i = 0; i < cid.length; ++i) {
                count = this.deleteFromTable(stmt, cid[i], sid[i], tid, whichDelete);
                if (count == verifyRowCount.get(tid + "_delete" + i)) continue;
                String str = "Gfxd delete (portfolio) has different row count from that of derby derby deleted " + verifyRowCount.get(tid + "_delete" + i) + " but gfxd deleted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void deleteFromGFETable(Connection gConn, int whichDelete, int[] cid, int[] sid) {
        PreparedStatement stmt = TradePortfolioDMLStmt.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            if (SQLSecurityTest.prepareStmtException.get() != null) {
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
        } else if (SQLTest.setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradePortfolioDMLStmt.getMyTid();
        try {
            for (int i = 0; i < cid.length; ++i) {
                this.deleteFromTable(stmt, cid[i], sid[i], tid, whichDelete);
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("detected the foreign key constraint violation, continuing test");
            }
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                Log.getLogWriter().info("Got expected column not found exception in delete, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected int deleteFromTable(PreparedStatement stmt, int cid, int sid, int tid, int whichDelete) throws SQLException {
        String txId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID: " + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - " + txId;
        String query = " QUERY: " + delete[whichDelete];
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting trade.portfolio with CID:" + cid + ",SID:" + sid + ",TID:" + tid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows from trade.portfolio CID:" + cid + ",SID:" + sid + ",TID:" + tid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting trade.portfolio with CID:" + cid + ",SID:" + sid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows from trade.portfolio  CID:" + cid + ",SID:" + sid + query);
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, BigDecimal sub1, BigDecimal sub2, int qty, int availQty, int sid, int cid, int tid) {
        ResultSet rs;
        block4: {
            boolean[] success = new boolean[1];
            rs = null;
            try {
                rs = TradePortfolioDMLStmt.getQuery(conn, whichQuery, sub1, sub2, qty, availQty, sid, cid, tid, success);
                int count = 0;
                while (!success[0]) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                        return null;
                    }
                    ++count;
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    rs = TradePortfolioDMLStmt.getQuery(conn, whichQuery, sub1, sub2, qty, availQty, sid, cid, tid, success);
                }
            }
            catch (SQLException se) {
                if (SQLHelper.isAlterTableException(conn, se)) break block4;
                SQLHelper.handleSQLException(se);
            }
        }
        return rs;
    }

    protected static ResultSet query(Connection conn, int whichQuery, BigDecimal sub1, BigDecimal sub2, int qty, int availQty, int sid, int cid, int tid) throws SQLException {
        boolean[] success = new boolean[1];
        ResultSet rs = TradePortfolioDMLStmt.getQuery(conn, whichQuery, sub1, sub2, qty, availQty, sid, cid, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = TradePortfolioDMLStmt.getQuery(conn, whichQuery, sub1, sub2, qty, availQty, sid, cid, tid, success);
        }
        return rs;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, BigDecimal sub1, BigDecimal sub2, int qty, int availQty, int sid, int cid, int tid, boolean[] success) throws SQLException {
        ResultSet rs = null;
        success[0] = true;
        String txId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID: " + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - " + txId;
        String query = " QUERY: " + select[whichQuery];
        try {
            PreparedStatement stmt = conn.prepareStatement(select[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.portfolio with" + " TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.portfolio with SUBTOTAL1:" + sub1 + ",SUBTOTAL2:" + sub2 + ",TID:" + tid + query);
                    stmt.setBigDecimal(1, sub1);
                    stmt.setBigDecimal(2, sub2);
                    stmt.setInt(3, tid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.portfolio with SUBTOTAL1:" + sub1 + ",SUBTOTAL2:" + sub2 + ",TID:" + tid + query);
                    stmt.setBigDecimal(1, sub1);
                    stmt.setBigDecimal(2, sub2);
                    stmt.setInt(3, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.portfolio with SUBTOTAL1:" + sub1 + "QTY:" + qty + ",TID:" + tid + query);
                    stmt.setInt(1, qty);
                    stmt.setBigDecimal(2, sub1);
                    stmt.setInt(3, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.portfolio with QTY:" + qty + ",AVAILQTY:" + availQty + ",TID:" + tid + query);
                    stmt.setInt(1, qty);
                    stmt.setInt(2, availQty);
                    stmt.setInt(3, tid);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "querying trade.portfolio with SID:" + sid + ",CID:" + cid + ",TID:" + tid + query + query);
                    stmt.setInt(1, sid);
                    stmt.setInt(2, cid);
                    stmt.setInt(3, tid);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    Log.getLogWriter().info(database + "querying trade.portfolio with SUBTOTAL1:" + sub1 + ",SUBTOTAL2:" + sub2 + query);
                    stmt.setBigDecimal(1, sub1);
                    stmt.setBigDecimal(2, sub2);
                    break;
                }
                case 8: {
                    Log.getLogWriter().info(database + "querying trade.portfolio with SUBTOTAL1:" + sub1 + ",SUBTOTAL2:" + sub2 + query);
                    stmt.setBigDecimal(1, sub1);
                    stmt.setBigDecimal(2, sub2);
                    break;
                }
                case 9: {
                    Log.getLogWriter().info(database + "querying trade.portfolio with SUBTOTAL1:" + sub1 + ",QTY:" + qty + query);
                    stmt.setInt(1, qty);
                    stmt.setBigDecimal(2, sub1);
                    break;
                }
                case 10: {
                    Log.getLogWriter().info(database + "querying trade.portfolio with QTY:" + qty + ",AVAILQTY:" + availQty + query);
                    stmt.setInt(1, qty);
                    stmt.setInt(2, availQty);
                    break;
                }
                case 11: {
                    Log.getLogWriter().info(database + "data will be used in the query SID:" + sid + ",CID:" + cid + query);
                    stmt.setInt(1, sid);
                    stmt.setInt(2, cid);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            throw se;
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getKey(Connection regConn) {
        ResultSet rs;
        int[] key;
        Connection conn;
        block6: {
            conn = TradePortfolioDMLStmt.getAuthConn(regConn);
            key = new int[2];
            rs = null;
            try {
                rs = TradePortfolioDMLStmt.getQuery(conn, 0, null, null, 0, 0, 0, 0, TradePortfolioDMLStmt.getMyTid());
                if (rs != null && rs.next()) {
                    key[0] = rs.getInt("sid");
                    key[1] = rs.getInt("cid");
                }
                if (rs == null) break block6;
                rs.close();
            }
            catch (SQLException se) {
                block7: {
                    int[] nArray;
                    try {
                        if (SQLHelper.checkGFXDException(conn, se)) break block7;
                        nArray = null;
                    }
                    catch (Throwable throwable) {
                        SQLHelper.closeResultSet(rs, conn);
                        throw throwable;
                    }
                    SQLHelper.closeResultSet(rs, conn);
                    return nArray;
                }
                SQLHelper.handleSQLException(se);
                SQLHelper.closeResultSet(rs, conn);
            }
        }
        SQLHelper.closeResultSet(rs, conn);
        return key;
    }

    protected int getWhichUpdate(int numOfNonUniq, int total) {
        return this.getWhichOne(numOfNonUniq, total);
    }

    @Override
    public void put(Connection dConn, Connection gConn, int size) {
        int cid = 0;
        cid = dConn != null ? (rand.nextInt(10) == 0 ? TradePortfolioDMLStmt.getCid(dConn) : TradePortfolioDMLStmt.getCid(gConn)) : TradePortfolioDMLStmt.getCid(gConn);
        if (cid != 0) {
            this.insert(dConn, gConn, size, cid, false);
        }
    }
}

