/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements;

import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.TradePortfolioDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class TradePortfolioV1DMLStmt
extends TradePortfolioDMLStmt {
    private static boolean reproduceTicket48840 = true;
    protected static String insert = "insert into trade.portfoliov1 values (?,?,?,?,?, ?, ?)";
    protected static String put = "put into trade.portfoliov1 values (?,?,?,?,?, ?, ?)";
    protected static String[] update = new String[]{"update trade.portfoliov1 set availQty=availQty-100 where cid = ? and sid = ?  and tid= ?", "update trade.portfoliov1 set qty=qty-? where cid = ? and sid = ?  and tid= ?", "update trade.portfoliov1 set subTotal = ? * qty  where cid = ? and sid = ?  and tid= ?", "update trade.portfoliov1 set subTotal=? where cid = ? and sid = ?  and tid= ?", "update trade.portfoliov1 set cid=? where cid = ? and sid = ?  and tid= ?", "update trade.portfoliov1 set data=? where cid = ? and sid = ?  and tid= ?", "update trade.portfoliov1 set data=?  where cid = ? and sid = ? and tid= ? and data is not null and length(data) > 100 ", "update trade.portfoliov1 set availQty=availQty-100 where cid = ? and sid = ? ", "update trade.portfoliov1 set qty=qty-? where cid = ? and sid = ?  ", "update trade.portfoliov1 set subTotal=? * qty where cid = ? and sid = ? ", "update trade.portfoliov1 set subTotal=? where cid = ? and sid = ? ", "update trade.portfoliov1 set cid=? where cid = ? and sid = ? ", "update trade.portfoliov1 set sid=? where cid = ? and sid = ? ", "update trade.portfoliov1 set data=? where cid = ? and sid < ? ", "update trade.portfoliov1 set data=? where cid < ? and sid = ? and data is not null and length(data) > 100 "};
    protected static String[] select = new String[]{"select * from trade.portfoliov1 where tid = ?", "select sid, cid, subTotal from trade.portfoliov1 where (subTotal >? and subTotal <= ?) and tid=? ", reproduceTicket48840 ? "select count(distinct cid) as num_distinct_cid from trade.portfoliov1 where (subTotal<? or subTotal >=?) and tid =?" : "select count (cid) as num_cid from trade.portfoliov1 where (subTotal<? or subTotal >=?) and tid =?", "select distinct sid from trade.portfoliov1 where (qty >=? and subTotal >= ?) and tid =?", "select sid, cid, qty from trade.portfoliov1  where (qty >=? and availQty<?) and tid =?", "select * from trade.portfoliov1 where sid =? and cid=? and tid = ?", "select * from trade.portfoliov1 ", "select sid, cid from trade.portfoliov1 where subTotal >? and subTotal <= ? ", "select distinct cid from trade.portfoliov1 where subTotal<? or subTotal >=?", "select distinct sid from trade.portfoliov1 where qty >=? and subTotal >= ? ", "select sid, cid, qty from trade.portfoliov1  where (qty >=? and availQty<?) ", "select * from trade.portfoliov1 where sid =? and cid=?"};
    protected static String[] delete = new String[]{"delete from trade.portfoliov1 where cid=? and sid=? and tid=?", "delete from trade.portfoliov1 where sid=? and tid=? and cid = (select max(cid) from trade.portfoliov1 where sid =? and tid= ? and data is not null and length(data) > 1000 and length(data) < 2000)", "delete from trade.portfoliov1 where cid=? and sid=?", "delete from trade.portfoliov1 where cid<? and sid=? and data is not null and length(data) > 1000 and length(data) < 2000"};
    private static boolean reproduceTicket50115 = TestConfig.tab().booleanAt(SQLPrms.toReproduce50115, true);

    @Override
    public void insert(Connection dConn, Connection gConn, int size, int cid, boolean isPut) {
        int[] sid = new int[size];
        int[] qty = new int[size];
        BigDecimal[] sub = new BigDecimal[size];
        BigDecimal[] price = new BigDecimal[size];
        Blob[] data = new Blob[size];
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        int availSize = 0;
        this.getBlobData(size, data);
        if (dConn != null) {
            availSize = rand.nextInt(numGettingDataFromDerby) == 1 ? this.getDataFromResultSet(dConn, sid, qty, sub, price, size) : this.getDataFromResultSet(gConn, sid, qty, sub, price, size);
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            boolean success = this.insertToDerbyTable(dConn, cid, sid, qty, sub, data, availSize, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the insert op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.insertToDerbyTable(dConn, cid, sid, qty, sub, data, availSize, exList);
            }
            try {
                this.insertToGFETable(gConn, cid, sid, qty, sub, data, availSize, exList, isPut);
            }
            catch (TestException te) {
                if (te.getMessage().contains("Execute SQL statement failed with: 23505") && isHATest && SQLTest.isEdge) {
                    try {
                        this.checkTicket49605(dConn, gConn, "customers", cid, sid[0], null, null);
                    }
                    catch (TestException e) {
                        Log.getLogWriter().info("insert failed due to #49605 ", (Throwable)e);
                        Log.getLogWriter().info("retry this using put to work around #49605");
                        this.insertToGFETable(gConn, cid, sid, qty, sub, availSize, exList, true);
                        this.checkTicket49605(dConn, gConn, "customers", cid, sid[0], null, null);
                    }
                }
                throw te;
            }
            SQLHelper.handleMissedSQLException(exList);
        } else if (testUniqueKeys || testWanUniqueness) {
            availSize = this.getDataFromResultSet(gConn, sid, qty, sub, price, size);
            this.insertToGFETable(gConn, cid, sid, qty, sub, data, availSize, isPut);
        } else if (this.getRandomData(gConn, sid, qty, sub, price, size)) {
            this.insertToGFETable(gConn, cid, sid, qty, sub, data, size, isPut);
        }
    }

    protected void getBlobData(int size, Blob[] data) {
        int regBlobSize = 10000;
        int maxBlobSize = useMD5Checksum ? 2000000 : regBlobSize;
        try {
            for (int i = 0; i < size; ++i) {
                if (!rand.nextBoolean()) continue;
                byte[] bytes = rand.nextInt(10) != 0 ? this.getByteArray(regBlobSize) : (rand.nextInt(100) == 0 ? this.getMaxByteArray(maxBlobSize) : new byte[]{});
                data[i] = new SerialBlob(bytes);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected boolean insertToDerbyTable(Connection conn, int cid, int[] sid, int[] qty, BigDecimal[] sub, Blob[] data, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = TradePortfolioV1DMLStmt.getStmt(conn, insert);
        if (stmt == null) {
            return false;
        }
        int tid = TradePortfolioV1DMLStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into derby, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            try {
                verifyRowCount.put(tid + "_insert" + i, 0);
                count = this.insertToTable(stmt, cid, sid[i], qty[i], sub[i], data[i], tid);
                verifyRowCount.put(tid + "_insert" + i, new Integer(count));
                Log.getLogWriter().info("Derby inserts " + verifyRowCount.get(tid + "_insert" + i) + " rows");
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected void insertToGFETable(Connection conn, int cid, int[] sid, int[] qty, BigDecimal[] sub, Blob[] data, int size, List<SQLException> exceptions, boolean isPut) {
        PreparedStatement stmt = TradePortfolioV1DMLStmt.getStmt(conn, isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (SQLTest.setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradePortfolioV1DMLStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info((isPut ? "Put" : "Insert") + " into gemfirexd, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, cid, sid[i], qty[i], sub[i], data[i], tid, isPut);
                if (count == (Integer)verifyRowCount.get(tid + "_insert" + i)) continue;
                String str = "Gfxd insert has different row count from that of derby derby inserted " + (Integer)verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            catch (SQLException se) {
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void insertToGFETable(Connection conn, int cid, int[] sid, int[] qty, BigDecimal[] sub, Blob[] data, int size, boolean isPut) {
        PreparedStatement stmt = TradePortfolioV1DMLStmt.getStmt(conn, isPut ? put : insert);
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradePortfolioV1DMLStmt.getMyTid();
        Log.getLogWriter().info((isPut ? "Put" : "Insert") + " into gemfirexd, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, cid, sid[i], qty[i], sub[i], data[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("detected foreign key constraint violation during " + (isPut ? "Put" : "Insert") + ", continuing test");
                    continue;
                }
                if (se.getSQLState().equals("23505")) {
                    Log.getLogWriter().info("detected primary key constraint violation during " + (isPut ? "Put" : "Insert") + ", continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42802")) {
                    Log.getLogWriter().info("Got expected column not found exception in insert, continuing test");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int cid, int sid, int qty, BigDecimal sub, Blob data, int tid) throws SQLException {
        return this.insertToTable(stmt, cid, sid, qty, sub, data, tid, false);
    }

    protected int insertToTable(PreparedStatement stmt, int cid, int sid, int qty, BigDecimal sub, Blob data, int tid, boolean isPut) throws SQLException {
        String blob = null;
        if (data != null) {
            blob = data.length() == 0L ? "empty data" : (useMD5Checksum ? ResultSetHelper.convertByteArrayToChecksum(data.getBytes(1L, (int)data.length()), data.length()) : ResultSetHelper.convertByteArrayToString(data.getBytes(1L, (int)data.length())));
        }
        Log.getLogWriter().info((isPut ? "putting" : "inserting") + " into table trade.portfoliov1 cid is " + cid + " sid is " + sid + " qty is " + qty + " availQty is " + qty + " subTotal is " + sub + " data is " + blob);
        String driverName = stmt.getConnection().getMetaData().getDriverName();
        stmt.setInt(1, cid);
        stmt.setInt(2, sid);
        stmt.setInt(3, qty);
        stmt.setInt(4, qty);
        stmt.setBigDecimal(5, sub);
        stmt.setInt(6, tid);
        stmt.setBlob(7, data);
        int rowCount = stmt.executeUpdate();
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        if (driverName.toLowerCase().contains("gemfirexd") && isPut) {
            Log.getLogWriter().info((isPut ? "putting" : "inserting") + " into table trade.portfoliov1 cid is " + cid + " sid is " + sid + " qty is " + qty + " availQty is " + qty + " subTotal is " + sub + " data is " + blob + " stmt " + stmt.toString());
            rowCount = stmt.executeUpdate();
            warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        return rowCount;
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        int numOfNonUniqUpdate = 8;
        int whichUpdate = this.getWhichUpdate(numOfNonUniqUpdate, update.length);
        int[] cid = new int[size];
        int[] sid = new int[size];
        int[] newCid = new int[size];
        int[] newSid = new int[size];
        int[] qty = new int[size];
        int[] availQty = new int[size];
        BigDecimal[] sub = new BigDecimal[size];
        BigDecimal[] price = new BigDecimal[size];
        Blob[] data = new Blob[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        this.getBlobData(size, data);
        Log.getLogWriter().info("update statement is " + update[whichUpdate]);
        if (isHATest && (whichUpdate == 0 || whichUpdate == 1 || whichUpdate == 7 || whichUpdate == 8)) {
            Log.getLogWriter().info("avoid x=x+1 in HA test for now, do not execute this update");
            return;
        }
        if (dConn != null) {
            int availSize = rand.nextInt(numGettingDataFromDerby) == 1 ? this.getDataForUpdate(dConn, cid, sid, qty, availQty, sub, newCid, newSid, price, size) : this.getDataForUpdate(gConn, cid, sid, qty, availQty, sub, newCid, newSid, price, size);
            if (SQLTest.testSecurity && availSize == 0) {
                Log.getLogWriter().info("does not have data to perform operation in security test");
                return;
            }
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            boolean success = this.updateDerbyTable(dConn, cid, sid, qty, availQty, sub, newCid, newSid, price, data, availSize, whichUpdate, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the update op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.updateDerbyTable(dConn, cid, sid, qty, availQty, sub, newCid, newSid, price, data, availSize, whichUpdate, exceptionList);
            }
            this.updateGFETable(gConn, cid, sid, qty, availQty, sub, newCid, newSid, price, data, availSize, whichUpdate, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else if (this.getDataForUpdate(gConn, cid, sid, qty, availQty, sub, newCid, newSid, price, size) > 0) {
            this.updateGFETable(gConn, cid, sid, qty, availQty, sub, newCid, newSid, price, data, size, whichUpdate);
        }
    }

    protected boolean updateDerbyTable(Connection conn, int[] cid, int[] sid, int[] qty, int[] availQty, BigDecimal[] sub, int[] newCid, int[] newSid, BigDecimal[] price, Blob[] data, int size, int whichUpdate, List<SQLException> exceptions) {
        if (whichUpdate == 4 || whichUpdate == 11 || whichUpdate == 12) {
            Log.getLogWriter().info("update on gfxd primary key, do not execute update in derby as well");
            return true;
        }
        PreparedStatement stmt = null;
        int tid = TradePortfolioV1DMLStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Update derby, myTid is " + tid);
        boolean[] unsupported = new boolean[1];
        stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, unsupported) : TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
        if (stmt == null) {
            if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                return true;
            }
            return unsupported[0];
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (stmt == null) continue;
                verifyRowCount.put(tid + "_update" + i, 0);
                count = this.updateTable(stmt, cid[i], sid[i], qty[i], availQty[i], sub[i], newCid[i], newSid[i], price[i], data[i], tid, whichUpdate);
                verifyRowCount.put(tid + "_update" + i, new Integer(count));
                Log.getLogWriter().info("Derby updates " + count + " rows");
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected int updateTable(PreparedStatement stmt, int cid, int sid, int qty, int availQty, BigDecimal sub, int newCid, int newSid, BigDecimal price, Blob data, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating portfoliov1 table availQty (availQty-100) for cid: " + cid + " sid: " + newSid + " tid: " + tid);
                stmt.setInt(1, cid);
                stmt.setInt(2, newSid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating portfoliov1 table qty = qty - " + qty + " for cid: " + cid + " sid: " + newSid + " tid: " + tid);
                stmt.setInt(1, qty);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updaing portfoliov1 table with subTotal = price( " + price + " ) * qty for cid: " + cid + " sid: " + newSid + " tid: " + tid);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info("updating portfoliov1 table with subTotal = " + sub + " for cid: " + cid + " sid: " + newSid + " tid: " + tid);
                stmt.setBigDecimal(1, sub);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 4: {
                Log.getLogWriter().info("updating portfoliov1 table with newCid = " + newCid + " for cid: " + cid + " sid: " + newSid + " tid: " + tid);
                stmt.setInt(1, newCid);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                stmt.setInt(4, tid);
                break;
            }
            case 5: {
                Log.getLogWriter().info("updating portfoliov1 table with data = " + (data != null ? (data.length() > 0L ? ResultSetHelper.convertByteArrayToChecksum(data.getBytes(1L, (int)data.length()), data.length()) : "empty") : "null") + " for cid: " + cid + " sid: " + newSid + " tid: " + tid);
                stmt.setBlob(1, data);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 6: {
                Log.getLogWriter().info("updating portfoliov1 table with data = " + (data != null ? (data.length() > 0L ? ResultSetHelper.convertByteArrayToChecksum(data.getBytes(1L, (int)data.length()), data.length()) : "empty") : "null") + " for cid: " + cid + " sid: " + newSid + " tid: " + tid + " and data is not null and length(data) > 100 ");
                stmt.setBlob(1, data);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 7: {
                Log.getLogWriter().info("updating portfoliov1 table availQty (availQty-100) for cid: " + cid + " sid: " + newSid);
                stmt.setInt(1, cid);
                stmt.setInt(2, newSid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 8: {
                Log.getLogWriter().info("updating portfoliov1 table qty = qty - " + qty + " for cid: " + cid + " sid: " + newSid);
                stmt.setInt(1, qty);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 9: {
                Log.getLogWriter().info("updating portfoliov1 table with subTotal = price( " + price + " ) * qty for cid: " + cid + " sid: " + newSid);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 10: {
                Log.getLogWriter().info("updating portfoliov1 table with subTotal = " + sub + " for cid: " + cid + " sid: " + newSid);
                stmt.setBigDecimal(1, sub);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 11: {
                Log.getLogWriter().info("updating portfoliov1 table with newCid = " + newCid + " for cid: " + cid + " sid: " + newSid);
                stmt.setInt(1, newCid);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 12: {
                Log.getLogWriter().info("updating portfoliov1 table with newSid = " + newSid + " for cid: " + cid + " sid: " + newSid);
                stmt.setInt(1, newSid);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 13: {
                Log.getLogWriter().info("updating portfoliov1 table with data = " + (data != null ? (data.length() > 0L ? ResultSetHelper.convertByteArrayToChecksum(data.getBytes(1L, (int)data.length()), data.length()) : "empty") : "null") + " for cid: " + cid + " sid: " + newSid);
                stmt.setBlob(1, data);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 14: {
                Log.getLogWriter().info("updating portfoliov1 table with data = " + (data != null ? (data.length() > 0L ? ResultSetHelper.convertByteArrayToChecksum(data.getBytes(1L, (int)data.length()), data.length()) : "empty") : "null") + " for cid: " + cid + " sid: " + newSid + " and data is not null and length(data) > 100 ");
                stmt.setBlob(1, data);
                stmt.setInt(2, cid);
                stmt.setInt(3, newSid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] qty, int[] availQty, BigDecimal[] sub, int[] newCid, int[] newSid, BigDecimal[] price, Blob[] data, int size, int whichUpdate, List<SQLException> exceptions) {
        int tid = TradePortfolioV1DMLStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Update gemfirexd, myTid is " + tid);
        if (whichUpdate == 4 || whichUpdate == 11 || whichUpdate == 12) {
            PreparedStatement stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
            if (stmt == null) {
                return;
            }
            throw new TestException("Test issue, should not happen\n");
        }
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
        if (SQLTest.testSecurity && stmt == null) {
            if (SQLSecurityTest.prepareStmtException.get() != null) {
                SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
        } else if (SQLTest.setCriticalHeap && stmt == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (stmt == null || (count = this.updateTable(stmt, cid[i], sid[i], qty[i], availQty[i], sub[i], newCid[i], newSid[i], price[i], data[i], tid, whichUpdate)) == (Integer)verifyRowCount.get(tid + "_update" + i)) continue;
                String str = "Gfxd update has different row count from that of derby derby updated " + (Integer)verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] qty, int[] availQty, BigDecimal[] sub, int[] newCid, int[] newSid, BigDecimal[] price, Blob[] data, int size, int whichUpdate) {
        int tid = TradePortfolioV1DMLStmt.getMyTid();
        Log.getLogWriter().info("Update gemfirexd, myTid is " + tid);
        if (whichUpdate == 4 || whichUpdate == 11 || whichUpdate == 12) {
            PreparedStatement stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
            if (stmt == null) {
                return;
            }
            throw new TestException("Test issue, should not happen%n");
        }
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
        if (stmt == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            try {
                this.updateTable(stmt, cid[i], sid[i], qty[i], availQty[i], sub[i], newCid[i], newSid[i], price[i], data[i], tid, whichUpdate);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503") && (whichUpdate == 4 || whichUpdate == 11 || whichUpdate == 12)) {
                    Log.getLogWriter().info("detected foreign key constraint violation during update, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("23513")) {
                    Log.getLogWriter().info("detected check constraint violation during update, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    @Override
    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys, boolean[] unsupported) {
        PreparedStatement stmt = null;
        Log.getLogWriter().info("update statement is " + update[whichUpdate]);
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("availQty")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("qty")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("subTotal")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("subTotal")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                throw new TestException("Test issue, this should not happen");
            }
            case 5: {
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 6: {
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 7: {
                if (partitionKeys.contains("availQty")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 8: {
                if (partitionKeys.contains("qty")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 9: {
                if (partitionKeys.contains("subTotal")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 10: {
                if (partitionKeys.contains("subTotal")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 11: {
                throw new TestException("Test issue, this should not happen");
            }
            case 12: {
                throw new TestException("Test issue, this should not happen");
            }
            case 13: {
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 14: {
                stmt = TradePortfolioV1DMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    @Override
    public void delete(Connection dConn, Connection gConn) {
        if (!reproduceTicket50115) {
            Log.getLogWriter().info("Do not execute delete op to avoid #50115");
            return;
        }
        int numOfNonUniqDelete = delete.length / 2;
        int whichDelete = this.getWhichOne(numOfNonUniqDelete, delete.length);
        int[] cid = new int[1];
        int[] sid = new int[1];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        int availSize = dConn != null ? (rand.nextInt(numGettingDataFromDerby) == 1 ? this.getDataForDelete(dConn, cid, sid, cid.length) : this.getDataForDelete(gConn, cid, sid, cid.length)) : this.getDataForDelete(gConn, cid, sid, cid.length);
        if (availSize == 0) {
            return;
        }
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, whichDelete, cid, sid, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the delete op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.deleteFromDerbyTable(dConn, whichDelete, cid, sid, exceptionList);
            }
            this.deleteFromGFETable(gConn, whichDelete, cid, sid, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.deleteFromGFETable(gConn, whichDelete, cid, sid);
        }
    }

    @Override
    protected boolean deleteFromDerbyTable(Connection dConn, int whichDelete, int[] cid, int[] sid, List<SQLException> exList) {
        PreparedStatement stmt = TradePortfolioV1DMLStmt.getStmt(dConn, delete[whichDelete]);
        if (stmt == null) {
            return false;
        }
        int tid = TradePortfolioV1DMLStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete from derby, myTid is " + tid);
        try {
            for (int i = 0; i < cid.length; ++i) {
                verifyRowCount.put(tid + "_delete" + i, 0);
                count = this.deleteFromTable(stmt, cid[i], sid[i], tid, whichDelete);
                verifyRowCount.put(tid + "_delete" + i, new Integer(count));
                Log.getLogWriter().info("Derby deletes " + count + " rows");
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    @Override
    protected void deleteFromGFETable(Connection gConn, int whichDelete, int[] cid, int[] sid, List<SQLException> exList) {
        PreparedStatement stmt = TradePortfolioV1DMLStmt.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (SQLTest.setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradePortfolioV1DMLStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete from gemfirexd, myTid is " + tid);
        try {
            for (int i = 0; i < cid.length; ++i) {
                count = this.deleteFromTable(stmt, cid[i], sid[i], tid, whichDelete);
                if (count == (Integer)verifyRowCount.get(tid + "_delete" + i)) continue;
                String str = "Gfxd delete (portfolio) has different row count from that of derby derby deleted " + (Integer)verifyRowCount.get(tid + "_delete" + i) + " but gfxd deleted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    @Override
    protected void deleteFromGFETable(Connection gConn, int whichDelete, int[] cid, int[] sid) {
        PreparedStatement stmt = TradePortfolioV1DMLStmt.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            if (SQLSecurityTest.prepareStmtException.get() != null) {
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
        } else if (SQLTest.setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradePortfolioV1DMLStmt.getMyTid();
        Log.getLogWriter().info("delete from gemfirexd, myTid is " + tid);
        try {
            for (int i = 0; i < cid.length; ++i) {
                this.deleteFromTable(stmt, cid[i], sid[i], tid, whichDelete);
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("detected the foreign key constraint violation, continuing test");
            }
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                Log.getLogWriter().info("Got expected column not found exception in delete, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    @Override
    protected int deleteFromTable(PreparedStatement stmt, int cid, int sid, int tid, int whichDelete) throws SQLException {
        SQLWarning warning;
        Log.getLogWriter().info("delete statement is " + delete[whichDelete]);
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("deleting record in portfoliov1 where cid is " + cid + " and sid is " + sid + " and tid is " + tid);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                if (!reproduceTicket50115) break;
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("deleting record in portfoliov1 where sid = " + sid + " and tid = " + tid + " and sid is " + sid + " and tid = " + tid + " and length(data) > 1000 and length(data) < 2000");
                stmt.setInt(1, sid);
                stmt.setInt(2, tid);
                stmt.setInt(3, sid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("deleting record in portfoliov1 where cid is " + cid + " and sid is " + sid);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info("deleting record in portfoliov1 where cid < " + cid + " and sid = " + sid + " and length(data) > 1000 and length(data) < 2000");
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        if ((warning = stmt.getWarnings()) != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }
}

