/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements;

import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.dmlStatements.TradeCompaniesDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlutil.ResultSetHelper;
import sql.wan.SQLWanPrms;
import util.TestException;
import util.TestHelper;

public class TradeSecuritiesDMLStmt
extends AbstractDMLStmt {
    private static boolean reproduceTicket48725 = true;
    protected static boolean addSecidInProjection = TestConfig.tab().booleanAt(SQLPrms.addSecidInProjection, false);
    protected static String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
    static boolean isEdge = SQLTest.isEdge;
    protected static String insert = "insert into trade.securities (sec_id, symbol, price, exchange, tid )values (?,?,?,?,?)";
    protected static String put = "put into trade.securities (sec_id, symbol, price, exchange, tid )values (?,?,?,?,?)";
    protected static String specialput = "put into trade.securities (sec_id, symbol, price, exchange, tid )values ";
    protected static String specialinsert = "insert into trade.securities (sec_id, symbol, price, exchange, tid )values ";
    protected static String[] update = new String[]{"update trade.securities set price = ? where sec_id = ? and tid = ? ", "update trade.securities set symbol = ? where sec_id = ? and tid = ?", "update trade.securities set symbol = ?, exchange =? where sec_id = ? and tid = ?", "update trade.securities set exchange =? where sec_id = ? and tid = ?", "update trade.securities set price = ? where sec_id = ?", "update trade.securities set symbol = ? where sec_id = ? ", "update trade.securities set exchange =? where sec_id = ? "};
    protected static String[] select = new String[]{"select sec_id, symbol, price, exchange, tid from trade.securities where tid = ? ", reproduceTicket48725 ? "select cast(avg( distinct price) as decimal (30, 20)) as avg_distinct_price from trade.securities where tid=? and symbol >?" : "select cast(avg( price) as decimal (30, 20)) as avg_price from trade.securities where tid=? and symbol >?", "select " + (addSecidInProjection ? "sec_id, " : "") + "price, symbol, exchange from trade.securities where (price<? or price >=?) and tid =? " + (RemoteTestModule.getCurrentThread().getThreadId() % 2 == 0 ? " order by   CASE when exchange ='" + exchanges[0] + "' then symbol END desc, " + (RemoteTestModule.getCurrentThread().getThreadId() % 3 == 0 ? " CASE when exchange ='" + exchanges[1] + "' then sec_id END asc, " + " CASE when exchange ='" + exchanges[2] + "' then sec_id END desc, " : " CASE when exchange in('" + exchanges[1] + "', '" + exchanges[2] + "') then sec_id END desc, ") + " CASE when exchange ='" + exchanges[3] + "' then symbol END asc, " + " CASE when exchange ='" + exchanges[4] + "' then sec_id END desc, " + " CASE when exchange ='" + exchanges[5] + "' then symbol END asc, " + " CASE when exchange ='" + exchanges[6] + "' then symbol END desc " + " fetch first 10 rows only" : ""), "select sec_id, symbol, price, " + (isEdge ? "cast " : "") + "(case  " + " when exchange='" + exchanges[0] + "' then '" + exchanges[0].toUpperCase() + "'" + " when exchange='" + exchanges[1] + "' then '" + exchanges[1].toUpperCase() + "'" + " when exchange='" + exchanges[2] + "' then '" + exchanges[2].toUpperCase() + "'" + " when exchange='" + exchanges[3] + "' then '" + exchanges[3].toUpperCase() + "'" + " when exchange='" + exchanges[4] + "' then '" + exchanges[4].toUpperCase() + "'" + " when exchange='" + exchanges[5] + "' then '" + exchanges[5].toUpperCase() + "'" + " else '" + exchanges[6].toUpperCase() + "'" + " end " + (isEdge ? "as varchar(10) " : "") + ") as exchange " + " from trade.securities  where (price >=? and price<?) and " + (RemoteTestModule.getCurrentThread().getThreadId() % 2 == 0 ? " exchange =? " : "exchange not in (?)") + "and tid =?", "select sec_id, symbol, price, exchange, tid from trade.securities where sec_id = ?", "select sec_id, price, symbol from trade.securities where symbol >? order by   CASE when exchange ='" + exchanges[0] + "' then symbol END desc, " + " CASE when exchange ='" + exchanges[1] + "' then sec_id END asc, " + " CASE when exchange ='" + exchanges[2] + "' then sec_id END desc, " + " CASE when exchange ='" + exchanges[3] + "' then symbol END asc, " + " CASE when exchange ='" + exchanges[4] + "' then sec_id END desc, " + " CASE when exchange ='" + exchanges[5] + "' then symbol END asc, " + " CASE when exchange ='" + exchanges[6] + "' then symbol END desc ", "select price, symbol, exchange from trade.securities where (price<? or price >=?) ", "select sec_id, symbol, price, exchange from trade.securities  where (price >=? and price<?) and exchange =?"};
    protected static String[] delete = new String[]{"delete from trade.securities where (sec_id = ? or price = ? ) and tid = ?", "delete from trade.securities where (symbol= ? and exchange = ? ) and tid = ?", "delete from trade.securities where sec_id=?"};
    protected static int maxNumOfTries = 1;
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    protected static int maxLength = TestConfig.tab().intAt(SQLPrms.maxSymbolLength, 6);
    protected static int minLength = TestConfig.tab().intAt(SQLPrms.minSymbolLength, 1);
    protected static boolean isSingleSitePublisher = TestConfig.tab().booleanAt(SQLWanPrms.isSingleSitePublisher, true);
    protected static ArrayList<String> partitionKeys = null;
    boolean reproduce39418 = false;
    boolean reproduce51463 = false;
    protected static String rangePrice = "20";

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        this.insert(dConn, gConn, size, false);
    }

    @Override
    public void put(Connection dConn, Connection gConn, int size) {
        this.insert(dConn, gConn, size, true);
    }

    private void insert(Connection dConn, Connection gConn, int size, boolean isPut) {
        int[] sec_id = new int[size];
        String[] symbol = new String[size];
        String[] exchange = new String[size];
        BigDecimal[] price = new BigDecimal[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        this.getDataForInsert(sec_id, symbol, exchange, price, size);
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        int count = 0;
        if (dConn != null) {
            boolean success = this.insertToDerbyTable(dConn, sec_id, symbol, exchange, price, size, exceptionList);
            while (!success) {
                if (isWanTest && !isSingleSitePublisher) {
                    return;
                }
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the insert op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                exceptionList.clear();
                success = this.insertToDerbyTable(dConn, sec_id, symbol, exchange, price, size, exceptionList);
                ++count;
            }
            try {
                this.insertToGFETable(gConn, sec_id, symbol, exchange, price, size, exceptionList, isPut);
            }
            catch (TestException te) {
                if (te.getMessage().contains("Execute SQL statement failed with: 23505") && isHATest && SQLTest.isEdge) {
                    try {
                        this.checkTicket49605(dConn, gConn, "securities", sec_id[0], -1, null, null);
                    }
                    catch (TestException e) {
                        Log.getLogWriter().info("insert failed due to #49605 ", (Throwable)e);
                        Log.getLogWriter().info("retry this using put to work around #49605");
                        this.insertToGFETable(gConn, sec_id, symbol, exchange, price, size, exceptionList, true);
                    }
                }
                throw te;
            }
            if (!success) {
                this.rollback(dConn);
                Log.getLogWriter().info("rollback the derby operation due to gfxd failed to put with same duplicate key due to retry");
                return;
            }
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.insertToGFETable(gConn, sec_id, symbol, exchange, price, size, isPut);
        }
        if (SQLTest.setTx) {
            this.commit(gConn);
            if (dConn != null) {
                this.commit(dConn);
            }
            if (this.getNodeFailureFlag()) {
                return;
            }
        }
        if (hasCompanies) {
            TradeCompaniesDMLStmt companies = new TradeCompaniesDMLStmt();
            companies.insert(dConn, gConn, size, symbol, exchange);
            if (SQLTest.setTx && isHATest) {
                this.commit(gConn);
                if (dConn != null) {
                    this.commit(dConn);
                }
            } else {
                if (dConn != null) {
                    this.commit(dConn);
                }
                this.commit(gConn);
            }
        }
    }

    protected void getNonRepeatPK(int[] sec_id, Connection conn) {
        int maxSecId = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary);
        int size = sec_id.length;
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (size > maxSecId) {
            throw new TestException("test issue, not enough data in the test yet");
        }
        while (list.size() < size) {
            int num = rand.nextBoolean() ? rand.nextInt(maxSecId) + 1 : this.getSid(conn);
            if (list.contains(num)) continue;
            list.add(num);
        }
        for (int i = 0; i < size; ++i) {
            sec_id[i] = (Integer)list.get(i);
        }
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        int numOfNonUniqUpdate = 3;
        int whichUpdate = this.getWhichOne(numOfNonUniqUpdate, update.length);
        boolean useBatch = false;
        int maxsize = 10;
        if (!(whichUpdate != 0 && whichUpdate != 4 || !rand.nextBoolean() || alterTableDropColumn || testSecurity || setCriticalHeap)) {
            size = rand.nextInt(maxsize) + 1;
            useBatch = true;
        }
        int[] sec_id = new int[size];
        String[] symbol = new String[size];
        String[] exchange = new String[size];
        BigDecimal[] price = new BigDecimal[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        this.getDataForUpdate(gConn, sec_id, symbol, exchange, price, size);
        if (useBatch) {
            this.getNonRepeatPK(sec_id, gConn);
        }
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (dConn != null) {
            boolean success = false;
            success = useBatch ? this.updateDerbyTableUsingBatch(dConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList) : this.updateDerbyTable(dConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList);
            int count = 0;
            while (!success) {
                if (isWanTest && !isSingleSitePublisher) {
                    this.rollback(dConn);
                    return;
                }
                this.rollback(dConn);
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the update op in derby, will abort this operation in derby");
                    this.rollback(dConn);
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                exceptionList.clear();
                success = useBatch ? this.updateDerbyTableUsingBatch(dConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList) : this.updateDerbyTable(dConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList);
                ++count;
            }
            if (useBatch) {
                this.updateGfxdTableUsingBatch(gConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList);
            } else {
                this.updateGFETable(gConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList);
            }
            SQLHelper.handleMissedSQLException(exceptionList);
        } else if (useBatch) {
            this.updateGfxdTableUsingBatch(gConn, sec_id, symbol, exchange, price, size, whichUpdate);
        } else {
            this.updateGFETable(gConn, sec_id, symbol, exchange, price, size, whichUpdate);
        }
    }

    @Override
    public void delete(Connection dConn, Connection gConn) {
        int sec_id;
        int numOfNonUniqDelete = 1;
        int whichDelete = this.getWhichOne(numOfNonUniqDelete, delete.length);
        if (SQLTest.syncHAForOfflineTest && whichDelete == 0) {
            whichDelete = 1;
        }
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        String symbol = this.getSymbol();
        BigDecimal price = this.getPrice();
        String exchange = this.getExchange();
        int n = sec_id = rand.nextBoolean() ? this.getSid(gConn) : rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary));
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, sec_id, symbol, price, exchange, whichDelete, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the delete op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                exceptionList.clear();
                success = this.deleteFromDerbyTable(dConn, sec_id, symbol, price, exchange, whichDelete, exceptionList);
                ++count;
            }
            this.deleteFromGFETable(gConn, sec_id, symbol, price, exchange, whichDelete, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.deleteFromGFETable(gConn, sec_id, symbol, price, exchange, whichDelete);
        }
    }

    @Override
    public void query(Connection dConn, Connection gConn) {
        int numOfNonUniq = 4;
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        int sec_id = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary));
        String symbol = this.getSymbol();
        BigDecimal price = this.getPrice();
        String exchange = this.getExchange();
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        ResultSet discRS = null;
        ResultSet gfeRS = null;
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            try {
                discRS = TradeSecuritiesDMLStmt.query(dConn, whichQuery, sec_id, symbol, price, exchange, tid);
                if (discRS == null) {
                    Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                    if (!alterTableDropColumn || SQLTest.alterTableException.get() == null || !((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                        return;
                    }
                }
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exceptionList);
            }
            try {
                gfeRS = TradeSecuritiesDMLStmt.query(gConn, whichQuery, sec_id, symbol, price, exchange, tid);
                if (gfeRS == null) {
                    if (isHATest) {
                        Log.getLogWriter().info("Testing HA and did not get GFXD result set after retry");
                        return;
                    }
                    if (setCriticalHeap) {
                        Log.getLogWriter().info("got XCL54 and does not get query result");
                        return;
                    }
                    throw new TestException("Not able to get gfe result set after retry");
                }
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptionList);
            }
            SQLHelper.handleMissedSQLException(exceptionList);
            if (discRS == null || gfeRS == null) {
                return;
            }
            boolean success = ResultSetHelper.compareResultSets(discRS, gfeRS);
            if (!success) {
                Log.getLogWriter().info("Not able to compare results, continuing test");
            }
        } else {
            try {
                gfeRS = TradeSecuritiesDMLStmt.query(gConn, whichQuery, sec_id, symbol, price, exchange, tid);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && SQLTest.testSecurity) {
                    Log.getLogWriter().info("Got expected no SELECT permission, continuing test");
                    return;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X04")) {
                    Log.getLogWriter().info("Got expected column not found exception, continuing test");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            if (gfeRS != null) {
                ResultSetHelper.asList(gfeRS, false);
            } else if (isHATest) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            } else if (setCriticalHeap) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to XCL54");
            } else {
                throw new TestException("gfxd query returns null and not a HA test");
            }
        }
        SQLHelper.closeResultSet(gfeRS, gConn);
    }

    @Override
    public void populate(Connection dConn, Connection gConn) {
        int initSize = TestConfig.tab().intAt(SQLPrms.initSecuritiesSizePerThread, 20);
        this.populate(dConn, gConn, initSize);
    }

    protected void getDataForInsert(int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size) {
        int key = (int)SQLBB.getBB().getSharedCounters().add(SQLBB.tradeSecuritiesPrimary, (long)size);
        for (int i = 0; i < size; ++i) {
            int counter;
            sec_id[i] = counter = key - i;
            symbol[i] = this.getSymbol();
            exchange[i] = this.getExchange();
            price[i] = this.getPrice();
            if (i != 1) continue;
            price[i] = price[0];
        }
    }

    protected void getDataForUpdate(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size) {
        int key = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary);
        for (int i = 0; i < size; ++i) {
            sec_id[i] = rand.nextBoolean() ? rand.nextInt(key) + 1 : this.getSid(conn);
            symbol[i] = this.getSymbol();
            exchange[i] = this.getExchange();
            price[i] = this.getPrice();
        }
    }

    protected String getSymbol() {
        return this.getSymbol(maxLength);
    }

    protected String getSymbol(int maxLength) {
        return this.getSymbol(minLength, maxLength);
    }

    protected String getSymbol(int minLength, int maxLength) {
        int aVal = 97;
        int symbolLength = rand.nextInt(maxLength - minLength + 1) + minLength;
        char[] charArray = new char[symbolLength];
        for (int j = 0; j < symbolLength; ++j) {
            charArray[j] = (char)(rand.nextInt(26) + aVal);
        }
        if (testUniqueKeys || testWanUniqueness) {
            return new String(charArray) + TradeSecuritiesDMLStmt.getMyTid();
        }
        return new String(charArray);
    }

    @Override
    protected BigDecimal getPrice() {
        if (!this.reproduce39418) {
            return new BigDecimal(Double.toString((double)(rand.nextInt(10000) + 1) * 0.01));
        }
        return new BigDecimal((double)(rand.nextInt(10000) + 1) * 0.01);
    }

    protected String getExchange() {
        return exchanges[rand.nextInt(exchanges.length)];
    }

    protected boolean insertToDerbyTable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = TradeSecuritiesDMLStmt.getStmt(conn, insert);
        if (stmt == null) {
            return false;
        }
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                verifyRowCount.put(tid + "_insert" + i, 0);
                count = this.insertToTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid);
                verifyRowCount.put(tid + "_insert" + i, new Integer(count));
                Log.getLogWriter().info("Derby inserts " + verifyRowCount.get(tid + "_insert" + i) + " rows");
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                if (se.getSQLState().equals("23505") && isWanTest && !isSingleSitePublisher) {
                    Log.getLogWriter().info("get unique key constraint violation with multiple wan publishers, rollback the operation and continuing");
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        SQLHelper.handleSQLException(e);
                    }
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
                continue;
            }
            catch (IllegalArgumentException ie) {
                if (this.reproduce39418) {
                    Log.getLogWriter().info("derby gets the IllegalArgumentException: " + TestHelper.getStackTrace((Throwable)ie));
                    continue;
                }
                throw new TestException(TestHelper.getStackTrace((Throwable)ie));
            }
        }
        return true;
    }

    protected void insertToGFETable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, List<SQLException> exceptions, boolean isPut) {
        PreparedStatement stmt;
        boolean useSpecialInsert;
        boolean bl = useSpecialInsert = TradeSecuritiesDMLStmt.getMyTid() % 2 == 0 && size == 1;
        PreparedStatement preparedStatement = !useSpecialInsert ? TradeSecuritiesDMLStmt.getStmt(conn, isPut ? put : insert) : (stmt = TradeSecuritiesDMLStmt.getStmt(conn, TradeSecuritiesDMLStmt.getSpecialInsert(sec_id, symbol, exchange, price, isPut)));
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, isPut, useSpecialInsert);
                if (count == verifyRowCount.get(tid + "_insert" + i)) continue;
                String str = "Gfxd insert has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            catch (SQLException se) {
                if (isPut && se.getSQLState().equals("23505")) {
                    if (exceptions.size() == 0) {
                        if (isHATest) {
                            Log.getLogWriter().info("got expected 23505 due to HA retry on put with same unique key (the row should be written to gfxd) " + (isEdge ? " -- but possibly got ticket #49605 during HA retry" : ""));
                            continue;
                        }
                        throw new TestException("unexpected 23505 thrown during put dml: " + TestHelper.getStackTrace((Throwable)se));
                    }
                    Log.getLogWriter().info("Got expected 23505 during put, continuing test");
                    SQLHelper.handleGFGFXDException(se, exceptions);
                    continue;
                }
                if (isPut && se.getSQLState().equals("0A000")) {
                    if (exceptions.size() == 0) {
                        throw new TestException("unexpected 0A000 thrown during put dml: " + TestHelper.getStackTrace((Throwable)se));
                    }
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    int firstIndex = 0;
                    SQLException derbySe = exceptions.get(firstIndex);
                    if (derbySe == null || !derbySe.getSQLState().equals("23505")) continue;
                    if (!this.reproduce51463) {
                        Log.getLogWriter().info("got ticket #51463, continue for now");
                        exceptions.remove(firstIndex);
                        continue;
                    }
                    throw new TestException("Got ticket #51463: expected 23505 duplicate exception, but got 0A000");
                }
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected static String getSpecialInsert(int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, boolean isPut) {
        StringBuilder sb = new StringBuilder();
        sb.append(isPut ? specialput : specialinsert);
        sb.append("(").append(sec_id[0]).append(", '").append(symbol[0]).append("', ");
        sb.append(price[0]).append(", '").append(exchange[0]).append("', ");
        sb.append(TradeSecuritiesDMLStmt.getMyTid()).append(")");
        Log.getLogWriter().info(sb.toString());
        return sb.toString();
    }

    protected void insertToGFETable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, boolean isPut) {
        PreparedStatement stmt;
        boolean useSpecialInsert;
        boolean bl = useSpecialInsert = TradeSecuritiesDMLStmt.getMyTid() % 2 == 0 && size == 1;
        PreparedStatement preparedStatement = !useSpecialInsert ? TradeSecuritiesDMLStmt.getStmt(conn, isPut ? put : insert) : (stmt = TradeSecuritiesDMLStmt.getStmt(conn, TradeSecuritiesDMLStmt.getSpecialInsert(sec_id, symbol, exchange, price, isPut)));
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, isPut, useSpecialInsert);
                continue;
            }
            catch (SQLException se) {
                if ("23505".equals(se.getSQLState())) {
                    Log.getLogWriter().info("Got the expected exception due to unique constraint check, continuing tests");
                    continue;
                }
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && (se.getSQLState().equals("42802") || se.getSQLState().equals("42X14"))) {
                    Log.getLogWriter().info("Got expected column not found exception in insert, continuing test");
                    continue;
                }
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int sec_id, String symbol, String exchange, BigDecimal price, int tid) throws SQLException {
        return this.insertToTable(stmt, sec_id, symbol, exchange, price, tid, false, false);
    }

    protected int insertToTable(PreparedStatement stmt, int sec_id, String symbol, String exchange, BigDecimal price, int tid, boolean isPut, boolean useSpecialInsert) throws SQLException {
        String database;
        String txId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String driverName = stmt.getConnection().getMetaData().getDriverName();
        String string = database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - " + txId;
        if (!useSpecialInsert) {
            Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " on trade.securities with SEC_ID:" + sec_id + ",SYMBOL:" + symbol + ",PRICE:" + price + ",EXCHANGE:" + exchange + ",TID:" + tid);
            stmt.setInt(1, sec_id);
            stmt.setString(2, symbol);
            stmt.setBigDecimal(3, price);
            stmt.setString(4, exchange);
            stmt.setInt(5, tid);
        }
        int rowCount = stmt.executeUpdate();
        SQLWarning warning = stmt.getWarnings();
        Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows in trade.securities SEC_ID:" + sec_id + ",SYMBOL:" + symbol + ",PRICE:" + price + ",EXCHANGE:" + exchange + ",TID:" + tid);
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        if (driverName.toLowerCase().contains("gemfirexd") && isPut && !SQLTest.ticket49794fixed) {
            this.insertToSecuritiesFulldataset(stmt.getConnection(), sec_id, symbol, price, exchange, tid);
        }
        return rowCount;
    }

    protected void insertToSecuritiesFulldataset(Connection conn, int sec_id, String symbol, BigDecimal price, String exchange, int tid) {
        try {
            Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence deleting  the  row  from TRADE.SECURITIES_FULLDATASET with data SEC_ID:" + sec_id);
            conn.createStatement().execute("DELETE FROM TRADE.SECURITIES_FULLDATASET  WHERE  sec_id = " + sec_id);
            PreparedStatement preparedInsertStmt = conn.prepareStatement("insert into trade.SECURITIES_fulldataset values (?,?,?,?,?)");
            preparedInsertStmt.setInt(1, sec_id);
            preparedInsertStmt.setString(2, symbol);
            preparedInsertStmt.setBigDecimal(3, price);
            preparedInsertStmt.setString(4, exchange);
            preparedInsertStmt.setInt(5, tid);
            Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence inserting  the  row  into  TRADE.SECURITIES_FULLDATASET with data SEC_ID:" + sec_id + ",SYMBOL" + symbol + ",EXCHANGE:" + exchange + ",PRICE:" + price + ".TID:" + tid);
            preparedInsertStmt.executeUpdate();
        }
        catch (SQLException se) {
            Log.getLogWriter().info("Error while updating TRADE.SECURITIES_FULLDATASET table. It may cause Data inconsistency " + se.getMessage());
        }
    }

    protected boolean deleteFromDerbyTable(Connection dConn, int sec_id, String symbol, BigDecimal price, String exchange, int whichDelete, List<SQLException> exList) {
        PreparedStatement stmt = TradeSecuritiesDMLStmt.getStmt(dConn, delete[whichDelete]);
        if (stmt == null) {
            return false;
        }
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        int count = -1;
        try {
            verifyRowCount.put(tid + "_delete", 0);
            count = this.deleteFromTable(stmt, sec_id, symbol, exchange, price, tid, whichDelete);
            verifyRowCount.put(tid + "_delete", new Integer(count));
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void deleteFromGFETable(Connection dConn, int sec_id, String symbol, BigDecimal price, String exchange, int whichDelete, List<SQLException> exList) {
        PreparedStatement stmt = TradeSecuritiesDMLStmt.getStmt(dConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        int count = -1;
        try {
            count = this.deleteFromTable(stmt, sec_id, symbol, exchange, price, tid, whichDelete);
            if (count != verifyRowCount.get(tid + "_delete")) {
                String str = "Gfxd delete (securities) has different row count from that of derby derby deleted " + verifyRowCount.get(tid + "_delete") + " but gfxd deleted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void deleteFromGFETable(Connection dConn, int sec_id, String symbol, BigDecimal price, String exchange, int whichDelete) {
        PreparedStatement stmt = TradeSecuritiesDMLStmt.getStmt(dConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        try {
            this.deleteFromTable(stmt, sec_id, symbol, exchange, price, tid, whichDelete);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("detected delete caused the foreign key constraint violation, continuing test");
            }
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            if (alterTableDropColumn && (se.getSQLState().equals("42X14") || se.getSQLState().equals("42X04"))) {
                Log.getLogWriter().info("Got expected column not found exception in delete, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected int deleteFromTable(PreparedStatement stmt, int sec_id, String symbol, String exchange, BigDecimal price, int tid, int whichDelete) throws SQLException {
        String txId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - " + txId;
        String query = " QUERY : " + delete[whichDelete];
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting trade.securities with SEC_ID:" + sec_id + ",PRICE:" + price + ",TID:" + tid + query);
                stmt.setInt(1, sec_id);
                stmt.setBigDecimal(2, price);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.securities with SEC_ID:" + sec_id + ",PRICE:" + price + ",TID:" + tid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting trade.securities with SYMBOL:" + symbol + ",EXCHANGE:" + exchange + ",TID:" + tid + query);
                stmt.setString(1, symbol);
                stmt.setString(2, exchange);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.securities with SYMBOL:" + symbol + ",EXCHANGE:" + exchange + ",TID:" + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "deleting trade.securities with SEC_ID:" + sec_id + query);
                stmt.setInt(1, sec_id);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.securities with SEC_ID:" + sec_id + query);
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected boolean updateDerbyTable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate, List<SQLException> exceptions) {
        PreparedStatement stmt = null;
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        int count = -1;
        boolean[] unsupported = new boolean[1];
        stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, unsupported) : TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
        if (stmt == null) {
            if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                return true;
            }
            return unsupported[0];
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (stmt == null) continue;
                verifyRowCount.put(tid + "_update" + i, 0);
                count = this.updateTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, whichUpdate);
                verifyRowCount.put(tid + "_update" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                if (se.getSQLState().equals("23505") && isWanTest && !isSingleSitePublisher) {
                    Log.getLogWriter().info("get unique key constraint violation with multiple wan publishers, rollback the operation and continuing");
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        SQLHelper.handleSQLException(e);
                    }
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected boolean updateDerbyTableUsingBatch(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate, List<SQLException> exceptions) {
        PreparedStatement stmt = null;
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        boolean[] unsupported = new boolean[1];
        stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, unsupported) : TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
        if (stmt == null) {
            if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                return true;
            }
            return unsupported[0];
        }
        int[] counts = null;
        for (int i = 0; i < size; ++i) {
            if (stmt == null) continue;
            try {
                Log.getLogWriter().info(" Derby - batch updating trade.securities with PRICE:" + price[i] + " where SEC_ID:" + sec_id[i] + (whichUpdate == 0 ? ",TID: " + tid : "") + " QUERY: " + update[whichUpdate]);
                stmt.setBigDecimal(1, price[i]);
                stmt.setInt(2, sec_id[i]);
                if (whichUpdate == 0) {
                    stmt.setInt(3, tid);
                }
                stmt.addBatch();
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        if (stmt == null) {
            throw new TestException("could not add batch in derby, need to analyze and make test changes if necessary");
        }
        try {
            counts = stmt.executeBatch();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exceptions);
        }
        if (counts == null) {
            throw new TestException("could not execute batch in derby, need to analyze and make test changes if necessary");
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] == -3) {
                throw new TestException("derby failed to update a row in batch update");
            }
            verifyRowCount.put(tid + "_update" + i, 0);
            verifyRowCount.put(tid + "_update" + i, new Integer(counts[i]));
            Log.getLogWriter().info(" Derby - updated " + counts[i] + " rows in trade.securities with PRICE:" + price[i] + " where SEC_ID:" + sec_id[i] + (whichUpdate == 0 ? ",TID:" + tid : ""));
        }
        return true;
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, boolean[] unsupported) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys, unsupported);
    }

    protected void setPartitionKeys() {
        if (!isWanTest) {
            partitionKeys = (ArrayList)partitionMap.get((Object)"securitiesPartition");
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_securitiesPartition"));
        }
        Log.getLogWriter().info("partition keys are " + partitionKeys);
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys, boolean[] unsupported) {
        PreparedStatement stmt = null;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("price")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("symbol")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("symbol") || partitionKeys.contains("exchange")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("exchange")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                if (partitionKeys.contains("price")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 5: {
                if (partitionKeys.contains("symbol")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 6: {
                if (partitionKeys.contains("exchange")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected void updateGFETable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate, List<SQLException> exceptions) {
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        int count = 0;
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (stmt == null || (count = this.updateTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, whichUpdate)) == verifyRowCount.get(tid + "_update" + i)) continue;
                String str = "Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            catch (SQLException se) {
                int firstIndex;
                SQLException derbySe;
                if (exceptions.size() > 0 && (derbySe = exceptions.get(firstIndex = 0)).getSQLState().equals("23505") && hasCompanies && se.getSQLState().equals("23503")) {
                    SQLHelper.printSQLException(se);
                    Log.getLogWriter().info("allow update unique key to check foreign key reference first");
                    exceptions.remove(firstIndex);
                    return;
                }
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void updateGfxdTableUsingBatch(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate, List<SQLException> exceptions) {
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null) {
            return;
        }
        int[] counts = null;
        for (int i = 0; i < size; ++i) {
            try {
                Log.getLogWriter().info(" gemfirexd - batch Updating trade.securities with PRICE:" + price[i] + " where SEC_ID:" + sec_id[i] + (whichUpdate == 0 ? ",TID:" + tid : "") + update[whichUpdate]);
                stmt.setBigDecimal(1, price[i]);
                stmt.setInt(2, sec_id[i]);
                if (whichUpdate == 0) {
                    stmt.setInt(3, tid);
                }
                stmt.addBatch();
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
        try {
            counts = stmt.executeBatch();
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exceptions);
        }
        if (counts == null) {
            Log.getLogWriter().warning("Batch update failed in gfxd, will check if derby got same issue");
            return;
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] != -3) {
                Log.getLogWriter().info("gemfirexd - updated " + counts[i] + " rows in trade.securities table with PRICE:" + price[i] + " where SEC_ID:" + sec_id[i] + (whichUpdate == 0 ? ",TID:" + tid : "") + update[whichUpdate]);
                if (counts[i] == verifyRowCount.get(tid + "_update" + i)) continue;
                String str = "Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + counts[i];
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            Log.getLogWriter().warning("gfxd failed to update in batch update");
        }
    }

    protected void updateGFETable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate) {
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (stmt == null) continue;
                this.updateTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, whichUpdate);
                continue;
            }
            catch (SQLException se) {
                if ("23505".equals(se.getSQLState())) {
                    Log.getLogWriter().info("Got the expected exception due to unique constraint check");
                    continue;
                }
                if ("23503".equals(se.getSQLState())) {
                    Log.getLogWriter().info("Got the expected exception due to unique constraint check");
                    continue;
                }
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                if (hasCompanies && se.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("Got expected violation of foreign key constraint in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void updateGfxdTableUsingBatch(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate) {
        int tid = TradeSecuritiesDMLStmt.getMyTid();
        String[] query = new String[size];
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : TradeSecuritiesDMLStmt.getStmt(conn, update[whichUpdate]);
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null) {
            return;
        }
        int[] counts = null;
        for (int i = 0; i < size; ++i) {
            try {
                Log.getLogWriter().info("gemfirexd - updating trade.securities with SEC_ID:" + sec_id[i] + ",PRICE:" + price[i] + (whichUpdate == 0 ? ",TID:" + tid : "") + "QUERY: " + update[whichUpdate]);
                stmt.setBigDecimal(1, price[i]);
                stmt.setInt(2, sec_id[i]);
                query[i] = update[whichUpdate];
                if (whichUpdate == 0) {
                    stmt.setInt(3, tid);
                }
                stmt.addBatch();
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                if (hasCompanies && se.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("Got expected violation of foreign key constraint in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
        try {
            counts = stmt.executeBatch();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        if (counts == null) {
            if (SQLTest.setTx && !testUniqueKeys) {
                Log.getLogWriter().info("possibly got conflict exception");
                return;
            }
            if (SQLTest.setTx && isHATest) {
                Log.getLogWriter().info(" got node failure exception");
                return;
            }
            throw new TestException("Does not expect batch update to fail, but no updateCount[] returns");
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] != -3) {
                Log.getLogWriter().info("gemfirexd -  updated " + counts[i] + " rows in trade.securities with SEC_ID:" + sec_id[i] + "PRICE:" + price[i] + (whichUpdate == 0 ? "TID:" + tid : "") + " QUERY:" + query[i]);
                continue;
            }
            Log.getLogWriter().warning("gemfirexd -  failed to update in batch update in " + i + " update");
        }
    }

    protected int updateTable(PreparedStatement stmt, int sec_id, String symbol, String exchange, BigDecimal price, int tid, int whichUpdate) throws SQLException {
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + update[whichUpdate];
        String successStmt = "";
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.securities with PRICE:" + price + " where SEC_ID:" + sec_id + "TID:" + tid + query);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, sec_id);
                stmt.setInt(3, tid);
                successStmt = " rows in trade.securities with PRICE:" + price + " where SEC_ID:" + sec_id + "TID:" + tid + query;
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating trade.securities with SYMBOL:" + symbol + " where SEC_ID:" + sec_id + ",TID:" + tid + query);
                stmt.setString(1, symbol);
                stmt.setInt(2, sec_id);
                stmt.setInt(3, tid);
                successStmt = " rows in trade.securities  SYMBOL:" + symbol + " where SEC_ID:" + sec_id + ",TID:" + tid + query;
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updating trade.securities with SYMBOL:" + symbol + ",EXCHANGE:" + exchange + " where SEC_ID:" + sec_id + ",TID:" + tid + query);
                stmt.setString(1, symbol);
                stmt.setString(2, exchange);
                stmt.setInt(3, sec_id);
                stmt.setInt(4, tid);
                successStmt = " rows in trade.securities with SYMBOL:" + symbol + ",EXCHANGE:" + exchange + " where SEC_ID:" + sec_id + ",TID:" + tid + query;
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.securities with EXCHANGE:" + exchange + " where SEC_ID:" + sec_id + ",TID:" + tid + query);
                stmt.setString(1, exchange);
                stmt.setInt(2, sec_id);
                stmt.setInt(3, tid);
                successStmt = " rows in trade.securities with EXCHANGE:" + exchange + " where SEC_ID:" + sec_id + ",TID:" + tid + query;
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "updating trade.securities with PRICE:" + price + " where SEC_ID:" + sec_id + query);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, sec_id);
                successStmt = " rows in trade.securities with PRICE:" + price + " where SEC_ID:" + sec_id + query;
                break;
            }
            case 5: {
                Log.getLogWriter().info(database + "updating trade.securities with SYMBOL:" + symbol + " where SEC_ID:" + sec_id + query);
                stmt.setString(1, symbol);
                stmt.setInt(2, sec_id);
                successStmt = " rows in trade.securities with SYMBOL:" + symbol + " where SEC_ID:" + sec_id + query;
                break;
            }
            case 6: {
                Log.getLogWriter().info(database + "updating trade.securities with EXCHANGE:" + exchange + " where SEC_ID:" + sec_id + query);
                stmt.setString(1, exchange);
                stmt.setInt(2, sec_id);
                successStmt = " rows in trade.securities with EXCHANGE:" + exchange + " where SEC_ID:" + sec_id + query;
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + "updated " + rowCount + successStmt);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, int sec_id, String symbol, BigDecimal price, String exchange, int tid) {
        ResultSet rs;
        block4: {
            boolean[] success = new boolean[1];
            rs = null;
            try {
                rs = TradeSecuritiesDMLStmt.getQuery(conn, whichQuery, sec_id, symbol, price, exchange, tid, success);
                int count = 0;
                while (!success[0]) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                        return null;
                    }
                    ++count;
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    rs = TradeSecuritiesDMLStmt.getQuery(conn, whichQuery, sec_id, symbol, price, exchange, tid, success);
                }
            }
            catch (SQLException se) {
                if (SQLHelper.isAlterTableException(conn, se)) break block4;
                SQLHelper.handleSQLException(se);
            }
        }
        return rs;
    }

    protected static ResultSet query(Connection conn, int whichQuery, int sec_id, String symbol, BigDecimal price, String exchange, int tid) throws SQLException {
        boolean[] success = new boolean[1];
        ResultSet rs = TradeSecuritiesDMLStmt.getQuery(conn, whichQuery, sec_id, symbol, price, exchange, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = TradeSecuritiesDMLStmt.getQuery(conn, whichQuery, sec_id, symbol, price, exchange, tid, success);
        }
        return rs;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, int sec_id, String symbol, BigDecimal price, String exchange, int tid, boolean[] success) throws SQLException {
        BigDecimal price1 = null;
        if (price != null) {
            price1 = price.add(new BigDecimal(rangePrice));
        }
        return TradeSecuritiesDMLStmt.getQuery(conn, whichQuery, sec_id, symbol, price, price1, exchange, tid, success);
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, int sec_id, String symbol, BigDecimal price, BigDecimal price1, String exchange, int tid, boolean[] success) throws SQLException {
        ResultSet rs = null;
        success[0] = true;
        String txId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - " + txId;
        String query = " QUERY: " + select[whichQuery];
        try {
            PreparedStatement stmt = conn.prepareStatement(select[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.securities with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.securities with SYMBOL:" + symbol + ",TID:" + tid + query);
                    stmt.setInt(1, tid);
                    stmt.setString(2, symbol);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.securities with 1_PRICE:" + price + ",2_PRICE:" + price1 + ",TID:" + tid + query);
                    stmt.setBigDecimal(1, price);
                    stmt.setBigDecimal(2, price1);
                    stmt.setInt(3, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.securities with EXCHANGE:" + exchange + ",1_PRICE:" + price + ",2_PRICE:" + price1 + ",TID:" + tid + query);
                    stmt.setBigDecimal(1, price);
                    stmt.setBigDecimal(2, price1);
                    stmt.setString(3, exchange);
                    stmt.setInt(4, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.securities with SEC_ID:" + sec_id + query);
                    stmt.setInt(1, sec_id);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "querying trade.securities with SYMBOL:" + symbol + query);
                    stmt.setString(1, symbol);
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying trade.securities with 1_PRICE:" + price + ",2_PRICE:" + price1 + query);
                    stmt.setBigDecimal(1, price);
                    stmt.setBigDecimal(2, price1);
                    break;
                }
                case 7: {
                    Log.getLogWriter().info(database + "querying trade.securities with EXCHANGE:" + exchange + ",1_PRICE:" + price + ",2_PRICE:" + price1 + query);
                    stmt.setBigDecimal(1, price);
                    stmt.setBigDecimal(2, price1);
                    stmt.setString(3, exchange);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            throw se;
        }
        return rs;
    }

    static {
        if ((testUniqueKeys || testWanUniqueness) && maxLength > 7) {
            maxLength = 7;
        }
    }
}

