/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements;

import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.dmlStatements.TradePortfolioDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlutil.GFXDStructImpl;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class TradeSellOrdersDupDMLStmt
extends AbstractDMLStmt {
    protected static String[] update = new String[]{"update trade.sellordersdup set status = 'filled'  where sid = ? and ask<? and status = 'open' and tid = ? ", "update trade.sellordersdup set status = 'cancelled' where order_time >? and status = 'open' and tid =? ", "update trade.sellordersdup set ask = ? where cid = ? and sid= ? and status = 'open' and qty >? and tid =? ", "update trade.sellordersdup set ask = ? , qty=? where cid = ? and sid= ? and ask <? and status = 'open' and tid =? ", "update trade.sellordersdup set status = 'filled'  where sid = ? and ask<? and status = 'open' ", "update trade.sellordersdup set status = 'cancelled' where order_time <? and status = 'open'  ", "update trade.sellordersdup set ask = ? where cid = ? and sid= ? and status = 'open' and qty >? ", "update trade.sellordersdup set ask = ? , qty=? where cid = ? and sid= ? and ask <? and status = 'open'  "};
    protected static String[] select = new String[]{"select * from trade.sellordersdup where status = 'open' and tid = ?", "select cid, ask, sid from trade.sellordersdup where cid >? and tid = ?", "select oid, cid, ask from trade.sellordersdup where (ask<? or ask >=?) and tid =?", "select oid, sid, ask, status, cid from trade.sellordersdup  where status =? and cid =? and tid =?", "select oid, sid, ask, cid, status from trade.sellordersdup  where ((status =? and ask <?) OR (status =? and ask >?))  and cid IN (?, ?, ?, ?, ?) and tid =?", "select oid, sid, ask, cid, order_time, status from trade.sellordersdup  where (((order_time >? and ask <?) and (status =? and ask >?))  OR cid IN (?, ?, ?, ?, ?)) and tid =?", "select oid, cid, order_time, sid from trade.sellordersdup where (order_Time < ?) and tid =? ", "select * from  trade.sellordersdup where oid IN (?, ?, ?, ?, ?) and tid =?", "select * from trade.sellordersdup", "select cid, ask, sid from trade.sellordersdup where cid >? ", "select oid, sid from trade.sellordersdup where (ask<? or ask >=?) ", "select oid, sid, ask, status, cid from trade.sellordersdup  where status =? and cid =? ", "select oid, sid, ask, cid, status from trade.sellordersdup  where ((status =? and ask <?) OR (status =? and ask >?))  and cid IN (?, ?, ?, ?, ?) ", "select oid, sid, ask, cid, order_time, status from trade.sellordersdup  where ((order_time >? and ask <?) and (status =? and ask >?))  OR cid IN (?, ?, ?, ?, ?)", "select oid, cid, order_time, sid from trade.sellordersdup where (order_time < ?)", "select * from  trade.sellordersdup where oid IN (?, ?, ?, ?, ?)"};
    protected static String[] delete = new String[]{"delete from trade.sellordersdup where cid=? and sid=? and tid=?", "delete from trade.sellordersdup where oid=? and tid=?", "delete from trade.sellordersdup where status IN ('cancelled', 'filled') and tid=?", "delete from trade.sellordersdup where tid=?", "delete from trade.sellordersdup where cid=? and sid=?", "delete from trade.sellordersdup where oid=?", "delete from trade.sellordersdup where status IN ('cancelled', 'filled')", "delete from trade.sellordersdup"};
    protected static String[] statuses = new String[]{"cancelled", "open", "filled"};
    protected static String[] selectinto = new String[]{"insert into trade.sellordersdup (select * from trade.sellorders where tid = ? and oid > ?) ", "insert into trade.sellordersdup select * from trade.sellorders where tid = ? and oid > (select max(oid) from trade.sellordersdup where tid = ? ) "};
    protected static String[] putinto = new String[]{"put into trade.sellordersdup (select * from trade.sellorders where tid = ? and oid > ?) ", "put into trade.sellordersdup select * from trade.sellorders where tid = ? and oid > (select max(oid) from trade.sellordersdup where tid = ? ) "};
    protected static int maxNumOfTries = 1;
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    protected static boolean useDefaultValue = TestConfig.tab().booleanAt(SQLPrms.useDefaultValue, false);
    protected static ArrayList<String> partitionKeys = null;

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        this.insert(dConn, gConn, false);
    }

    @Override
    public void put(Connection dConn, Connection gConn, int size) {
        this.insert(dConn, gConn, true);
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        int[] sid = new int[size];
        BigDecimal[] ask = new BigDecimal[size];
        Timestamp[] orderTime = new Timestamp[size];
        int[] cid = new int[size];
        int[] qty = new int[size];
        BigDecimal[] ask2 = new BigDecimal[size];
        int[] whichUpdate = new int[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            if (rand.nextInt(numGettingDataFromDerby) == 1) {
                if (!this.getDataForUpdate(dConn, cid, sid, qty, orderTime, ask, ask2, whichUpdate, size)) {
                    Log.getLogWriter().info("not able to get the data for update, abort this operation");
                    return;
                }
            } else {
                this.getDataForUpdate(gConn, cid, sid, qty, orderTime, ask, ask2, whichUpdate, size);
            }
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            boolean success = this.updateDerbyTable(dConn, cid, sid, qty, orderTime, ask, ask2, whichUpdate, size, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.updateDerbyTable(dConn, cid, sid, qty, orderTime, ask, ask2, whichUpdate, size, exceptionList);
            }
            this.updateGFETable(gConn, cid, sid, qty, orderTime, ask, ask2, whichUpdate, size, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else if (this.getDataForUpdate(gConn, cid, sid, qty, orderTime, ask, ask2, whichUpdate, size)) {
            this.updateGFETable(gConn, cid, sid, qty, orderTime, ask, ask2, whichUpdate, size);
        }
    }

    @Override
    public void delete(Connection dConn, Connection gConn) {
        int numOfNonUniqDelete = delete.length / 2;
        int whichDelete = this.getWhichOne(numOfNonUniqDelete, delete.length);
        if (whichDelete == 3 && whichDelete != TradeSellOrdersDupDMLStmt.getMyTid()) {
            --whichDelete;
        }
        int size = 1;
        int[] cid = new int[size];
        int[] sid = new int[size];
        int[] oid = new int[size];
        for (int i = 0; i < size; ++i) {
            oid[i] = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSellOrdersPrimary));
        }
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        int availSize = dConn != null && rand.nextInt(numGettingDataFromDerby) == 1 ? this.getDataForDelete(dConn, cid, sid) : this.getDataForDelete(gConn, cid, sid);
        if (availSize == 0) {
            return;
        }
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, whichDelete, cid, sid, oid, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.deleteFromDerbyTable(dConn, whichDelete, cid, sid, oid, exceptionList);
            }
            this.deleteFromGFETable(gConn, whichDelete, cid, sid, oid, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.deleteFromGFETable(gConn, whichDelete, cid, sid, oid);
        }
    }

    @Override
    public void query(Connection dConn, Connection gConn) {
        int numOfNonUniq = select.length / 2;
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        String[] status = new String[2];
        BigDecimal[] ask = new BigDecimal[2];
        int[] cid = new int[5];
        int[] oid = new int[5];
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        Timestamp orderTime = this.getRandTime();
        this.getStatus(status);
        this.getAsk(ask);
        if (dConn != null) {
            this.getCids(dConn, cid);
        } else {
            this.getCids(gConn, cid);
        }
        this.getOids(oid);
        ResultSet discRS = null;
        ResultSet gfeRS = null;
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            try {
                discRS = TradeSellOrdersDupDMLStmt.query(dConn, whichQuery, status, ask, cid, oid, orderTime, tid);
                if (discRS == null) {
                    Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                    return;
                }
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exceptionList);
            }
            try {
                gfeRS = TradeSellOrdersDupDMLStmt.query(gConn, whichQuery, status, ask, cid, oid, orderTime, tid);
                if (gfeRS == null) {
                    if (isHATest) {
                        Log.getLogWriter().info("Testing HA and did not get GFXD result set after retry");
                        return;
                    }
                    throw new TestException("Not able to get gfe result set after retry");
                }
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptionList);
            }
            SQLHelper.handleMissedSQLException(exceptionList);
            if (discRS == null || gfeRS == null) {
                return;
            }
            boolean success = ResultSetHelper.compareResultSets(discRS, gfeRS);
            if (!success) {
                Log.getLogWriter().info("Not able to compare results");
            }
        } else {
            try {
                gfeRS = TradeSellOrdersDupDMLStmt.query(gConn, whichQuery, status, ask, cid, oid, orderTime, tid);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && SQLTest.testSecurity) {
                    Log.getLogWriter().info("Got expected no SELECT permission, continuing test");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            if (gfeRS != null) {
                ResultSetHelper.asList(gfeRS, false);
            }
        }
        SQLHelper.closeResultSet(gfeRS, gConn);
    }

    @Override
    public void populate(Connection dConn, Connection gConn) {
        int initSize = rand.nextInt(10) + 1;
        for (int i = 0; i < initSize; ++i) {
            int numCid = rand.nextInt(30) + 1;
            for (int j = 0; j < numCid; ++j) {
                if (setCriticalHeap) {
                    this.resetCanceledFlag();
                }
                this.insert(dConn, gConn, 1);
                if (dConn != null) {
                    this.commit(dConn);
                }
                this.commit(gConn);
            }
        }
    }

    private void insert(Connection dConn, Connection gConn, boolean isPut) {
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        int[] maxOid = new int[1];
        int whichOne = rand.nextInt(selectinto.length);
        boolean getData = this.getDataForInsert(gConn, maxOid);
        if (!getData) {
            Log.getLogWriter().info("does not get data, abort this op");
            return;
        }
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (dConn != null) {
            boolean success = this.insertToDerbyTable(dConn, maxOid[0], whichOne, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.insertToDerbyTable(dConn, maxOid[0], whichOne, exceptionList);
            }
            this.insertToGFETable(gConn, maxOid[0], whichOne, exceptionList, isPut);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.insertToGFETable(gConn, maxOid[0], whichOne, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getDataForInsert(Connection conn, int[] maxOid) {
        String sql = "select max (oid) as maxoid from trade.sellordersdup where tid = " + TradeSellOrdersDupDMLStmt.getMyTid();
        ResultSet rs = null;
        try {
            rs = conn.createStatement().executeQuery(sql);
            if (rs.next()) {
                maxOid[0] = rs.getInt("MAXOID");
                Log.getLogWriter().info("max oid by this thread is " + maxOid[0]);
            } else {
                maxOid[0] = 0;
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkGFXDException(conn, se)) {
                boolean bl = false;
                return bl;
            }
            SQLHelper.handleSQLException(se);
        }
        finally {
            SQLHelper.closeResultSet(rs, conn);
        }
        return true;
    }

    protected void getOids(int[] oid, int size) {
        int key = (int)SQLBB.getBB().getSharedCounters().add(SQLBB.tradeSellOrdersPrimary, (long)size);
        for (int i = 0; i < size; ++i) {
            oid[i] = key - size + 1 + i;
        }
    }

    protected int getSid(Connection regConn, int cid) {
        Connection conn = TradeSellOrdersDupDMLStmt.getAuthConn(regConn);
        int sid = 0;
        int max = 5;
        int n = rand.nextInt(max);
        if (testUniqueKeys) {
            ResultSet rs = null;
            try {
                int whichQuery = 0;
                rs = TradePortfolioDMLStmt.getQuery(conn, whichQuery, null, null, 0, 0, 0, cid, TradeSellOrdersDupDMLStmt.getMyTid());
                if (rs == null) {
                    return 0;
                }
                int temp = 0;
                while (rs.next()) {
                    if (temp == 0) {
                        sid = rs.getInt("SID");
                    }
                    if (n == temp) {
                        sid = rs.getInt("SID");
                        break;
                    }
                    ++temp;
                }
                rs.close();
            }
            catch (SQLException se) {
                if (!SQLHelper.checkGFXDException(conn, se)) {
                    return sid;
                }
                SQLHelper.handleSQLException(se);
            }
        } else {
            sid = this.getSid();
        }
        return sid;
    }

    protected boolean insertToDerbyTable(Connection conn, int maxOid, int whichOne, List<SQLException> exceptions) {
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        int count = -1;
        whichOne = 0;
        Log.getLogWriter().info(selectinto[whichOne]);
        PreparedStatement stmt = TradeSellOrdersDupDMLStmt.getStmt(conn, selectinto[whichOne]);
        if (stmt == null) {
            return false;
        }
        try {
            verifyRowCount.put(tid + "_insert", 0);
            count = this.selectIntoTable(stmt, maxOid, whichOne, tid, false);
            verifyRowCount.put(tid + "_insert", new Integer(count));
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exceptions);
        }
        return true;
    }

    protected void insertToGFETable(Connection conn, int maxOid, int whichOne, List<SQLException> exceptions, boolean isPut) {
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        int count = -1;
        whichOne = 0;
        PreparedStatement stmt = TradeSellOrdersDupDMLStmt.getStmt(conn, isPut ? putinto[whichOne] : selectinto[whichOne]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        try {
            count = this.selectIntoTable(stmt, maxOid, whichOne, tid, isPut);
            if (count != verifyRowCount.get(tid + "_insert")) {
                String str = "Gfxd select into has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert") + " but gfxd inserted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exceptions);
        }
    }

    protected void insertToGFETable(Connection conn, int maxOid, int whichOne, boolean isPut) {
        if (rand.nextInt(100) == 1) {
            int secondOne = 1;
            try {
                conn.prepareStatement(isPut ? putinto[secondOne] : selectinto[secondOne]);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("get expected unsupported exception for " + selectinto[secondOne]);
                }
                throw new TestException("does not get unsupported exception for " + selectinto[secondOne]);
            }
        }
        whichOne = 0;
        PreparedStatement stmt = TradeSellOrdersDupDMLStmt.getStmt(conn, isPut ? putinto[whichOne] : selectinto[whichOne]);
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        try {
            this.selectIntoTable(stmt, maxOid, whichOne, tid, isPut);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("detected the foreign key constraint violation, continuing test");
            }
            if (se.getSQLState().equals("42500") && testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected int selectIntoTable(PreparedStatement stmt, int maxOid, int whichOne, int tid, boolean isPut) throws SQLException {
        Log.getLogWriter().info((isPut ? putinto[whichOne] : selectinto[whichOne]) + " maxOid is " + maxOid + " tid is " + tid);
        stmt.setInt(1, tid);
        if (whichOne == 0) {
            stmt.setInt(2, maxOid);
        } else if (whichOne == 1) {
            stmt.setInt(2, tid);
        }
        int rowCount = stmt.executeUpdate();
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void getStatus(String[] status) {
        for (int i = 0; i < status.length; ++i) {
            status[i] = statuses[rand.nextInt(statuses.length)];
        }
    }

    protected void getAsk(BigDecimal[] ask) {
        for (int i = 0; i < ask.length; ++i) {
            ask[i] = this.getPrice();
        }
    }

    protected void getOids(int[] oid) {
        int startOid = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSellOrdersPrimary) + 1);
        for (int i = 0; i < oid.length; ++i) {
            oid[i] = startOid++;
        }
    }

    protected Timestamp getRandTime() {
        return new Timestamp(System.currentTimeMillis() - (long)rand.nextInt(180000));
    }

    protected boolean getDataForUpdate(Connection regConn, int[] cid, int[] sid, int[] qty, Timestamp[] orderTime, BigDecimal[] ask, BigDecimal[] ask2, int[] whichUpdate, int size) {
        Connection conn = TradeSellOrdersDupDMLStmt.getAuthConn(regConn);
        int numOfNonUniq = 4;
        if (!this.getDataFromResult(conn, cid, sid)) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            qty[i] = this.getQty();
            orderTime[i] = this.getRandTime();
            ask[i] = this.getPrice();
            ask2[i] = this.getPrice();
            whichUpdate[i] = this.getWhichUpdate(numOfNonUniq, update.length);
        }
        return true;
    }

    protected int getWhichUpdate(int numOfNonUniq, int total) {
        return this.getWhichOne(numOfNonUniq, total);
    }

    protected boolean getDataFromResult(Connection conn, int[] cid, int[] sid) {
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        if (!testUniqueKeys && tid != 0) {
            tid = rand.nextInt(tid);
        }
        return this.getDataFromResult(conn, cid, sid, tid);
    }

    protected boolean getDataFromResult(Connection conn, int[] cid, int[] sid, int tid) {
        int defaultCid = 0;
        int defaultSid = 0;
        int size = cid.length;
        int num = 20;
        int n = rand.nextInt(num);
        ResultSet rs = null;
        try {
            int whichQuery = 0;
            rs = TradeSellOrdersDupDMLStmt.getQuery(conn, whichQuery, null, null, null, null, null, tid);
            if (rs == null) {
                return false;
            }
            int i = 0;
            int temp = 0;
            while (rs.next() && i < size) {
                if (temp == 0) {
                    cid[i] = rs.getInt("CID");
                    sid[i] = rs.getInt("SID");
                } else if (n <= temp) {
                    cid[i] = rs.getInt("CID");
                    sid[i] = rs.getInt("SID");
                    ++i;
                }
                ++temp;
            }
            rs.close();
            while (i < size) {
                cid[i] = defaultCid;
                sid[i] = defaultSid;
                ++i;
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkGFXDException(conn, se)) {
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean updateDerbyTable(Connection conn, int[] cid, int[] sid, int[] qty, Timestamp[] orderTime, BigDecimal[] ask, BigDecimal[] ask2, int[] whichUpdate, int size, List<SQLException> exList) {
        PreparedStatement stmt = null;
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            block7: {
                stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i]) : TradeSellOrdersDupDMLStmt.getStmt(conn, update[whichUpdate[i]]);
                if (stmt == null) {
                    try {
                        conn.prepareStatement(update[whichUpdate[i]]);
                    }
                    catch (SQLException se) {
                        if (!se.getSQLState().equals("08006") && !se.getSQLState().equals("08003")) break block7;
                        return false;
                    }
                }
            }
            try {
                if (stmt == null) continue;
                verifyRowCount.put(tid + "_update" + i, 0);
                count = this.updateTable(stmt, cid[i], sid[i], qty[i], orderTime[i], ask[i], ask2[i], tid, whichUpdate[i]);
                verifyRowCount.put(tid + "_update" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exList);
            }
        }
        return true;
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys);
    }

    protected void setPartitionKeys() {
        if (!isWanTest) {
            partitionKeys = (ArrayList)partitionMap.get((Object)"sellordersPartition");
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_sellordersPartition"));
        }
        Log.getLogWriter().info("partition keys are " + partitionKeys);
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys) {
        PreparedStatement stmt = null;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("status")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSellOrdersDupDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("status")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSellOrdersDupDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("ask")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSellOrdersDupDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("ask") || partitionKeys.contains("qty")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSellOrdersDupDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                if (partitionKeys.contains("status")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSellOrdersDupDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 5: {
                if (partitionKeys.contains("status")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSellOrdersDupDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 6: {
                if (partitionKeys.contains("ask")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSellOrdersDupDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 7: {
                if (partitionKeys.contains("ask") || partitionKeys.contains("qty")) {
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeSellOrdersDupDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] qty, Timestamp[] orderTime, BigDecimal[] ask, BigDecimal[] ask2, int[] whichUpdate, int size, List<SQLException> exList) {
        PreparedStatement stmt = null;
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i]) : TradeSellOrdersDupDMLStmt.getStmt(conn, update[whichUpdate[i]]);
            if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
                SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
            try {
                if (stmt == null || (count = this.updateTable(stmt, cid[i], sid[i], qty[i], orderTime[i], ask[i], ask2[i], tid, whichUpdate[i])) == verifyRowCount.get(tid + "_update" + i)) continue;
                String str = "Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exList);
            }
        }
    }

    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] qty, Timestamp[] orderTime, BigDecimal[] ask, BigDecimal[] ask2, int[] whichUpdate, int size) {
        PreparedStatement stmt = null;
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i]) : TradeSellOrdersDupDMLStmt.getStmt(conn, update[whichUpdate[i]]);
            try {
                if (stmt == null) continue;
                this.updateTable(stmt, cid[i], sid[i], qty[i], orderTime[i], ask[i], ask2[i], tid, whichUpdate[i]);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int updateTable(PreparedStatement stmt, int cid, int sid, int qty, Timestamp orderTime, BigDecimal ask, BigDecimal ask2, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + update[whichUpdate];
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.sellordersdup  with SID:" + sid + ",ASK:" + ask + " where ,STATUS:open,TID:" + tid + query);
                stmt.setInt(1, sid);
                stmt.setBigDecimal(2, ask);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.sellordersdup SID:" + sid + ",ASK:" + ask + " where ,STATUS:open,TID:" + tid + ",STATUS:" + "open" + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating sellorders with STATUS:cancelled  where  ORDERTIME:" + orderTime + ",STATUS:" + "open" + ",TID: " + tid + query);
                stmt.setTimestamp(1, orderTime);
                stmt.setInt(2, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.sellordersdup  with STATUS:cancelled  where ORDERTIME:" + orderTime + ",STATUS:" + "open" + ",TID: " + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updating tarade.sellordersdup  with ASK:" + ask + " where CID:" + cid + ",STATUS:open,SID:" + sid + ",QTY:" + qty + ",TID:" + tid + query);
                stmt.setBigDecimal(1, ask);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                stmt.setInt(4, qty);
                stmt.setInt(5, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.sellordersdup with ASK:" + ask + " where CID:" + cid + ",STATUS:open,SID:" + sid + ",QTY:" + qty + ",TID:" + tid + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.sellordersdup  with ASK:" + ask + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",ASK:" + ask + ",STATUS:open,TID:" + tid + query);
                stmt.setBigDecimal(1, ask);
                stmt.setInt(2, qty);
                stmt.setInt(3, cid);
                stmt.setInt(4, sid);
                stmt.setBigDecimal(5, ask2);
                stmt.setInt(6, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.sellordersdup  with ASK:" + ask + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",ASK:" + ask + ",STATUS:open,TID:" + tid + query);
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "updating trade.sellordersdup  with STATUS:filled where SID:" + sid + " ASK: " + ask + query);
                stmt.setInt(1, sid);
                stmt.setBigDecimal(2, ask);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.sellordersdup  with STATUS:filled where SID:" + sid + " ASK: " + ask + query);
                break;
            }
            case 5: {
                Log.getLogWriter().info(database + "updating trade.sellordersdup  with STATUS:filled where ORDERTIME:" + orderTime + ",STATUS:open" + query);
                stmt.setTimestamp(1, orderTime);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.sellordersdup  with STATUS:filled where ORDERTIME:" + orderTime + ",STATUS:open" + query);
                break;
            }
            case 6: {
                Log.getLogWriter().info(database + "updating trade.sellordersdup with ASK:" + ask + " where CID:" + cid + ", sid: " + sid + ", qty: " + qty + query);
                stmt.setBigDecimal(1, ask);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                stmt.setInt(4, qty);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.sellordersdup with ASK:" + ask + " where CID:" + cid + ", sid: " + sid + ", qty: " + qty + query);
                break;
            }
            case 7: {
                Log.getLogWriter().info(database + "updating trade.sellordersdup with ASK: " + ask + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",ASK:" + ask2 + ",STATUS:open" + query);
                stmt.setBigDecimal(1, ask);
                stmt.setInt(2, qty);
                stmt.setInt(3, cid);
                stmt.setInt(4, sid);
                stmt.setBigDecimal(5, ask2);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.sellordersdup  with ASK: " + ask + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",ASK:" + ask2 + ",STATUS:open" + query);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, String[] status, BigDecimal[] ask, int[] cid, int[] oid, Timestamp orderTime, int tid) {
        boolean[] success = new boolean[1];
        int count = 0;
        ResultSet rs = null;
        try {
            rs = TradeSellOrdersDupDMLStmt.getQuery(conn, whichQuery, status, ask, cid, oid, orderTime, tid, success);
            while (!success[0]) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                    return null;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                MasterController.sleepForMs((int)(100 * rand.nextInt(10)));
                rs = TradeSellOrdersDupDMLStmt.getQuery(conn, whichQuery, status, ask, cid, oid, orderTime, tid, success);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected static ResultSet query(Connection conn, int whichQuery, String[] status, BigDecimal[] ask, int[] cid, int[] oid, Timestamp orderTime, int tid) throws SQLException {
        boolean[] success = new boolean[1];
        int count = 0;
        ResultSet rs = TradeSellOrdersDupDMLStmt.getQuery(conn, whichQuery, status, ask, cid, oid, orderTime, tid, success);
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                return null;
            }
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            ++count;
            MasterController.sleepForMs((int)(100 * rand.nextInt(10)));
            rs = TradeSellOrdersDupDMLStmt.getQuery(conn, whichQuery, status, ask, cid, oid, orderTime, tid, success);
        }
        return rs;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, String[] status, BigDecimal[] ask, int[] cid, int[] oid, Timestamp orderTime, int tid, boolean[] success) throws SQLException {
        ResultSet rs = null;
        success[0] = true;
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + select[whichQuery];
        try {
            PreparedStatement stmt = conn.prepareStatement(select[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with CID:" + cid[0] + ",TID: " + tid + query);
                    stmt.setInt(1, cid[0]);
                    stmt.setInt(2, tid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with 1_ASK:" + ask[0] + ",TID:" + tid + ",2_ASK:" + ask[1] + ",TID:" + tid + query);
                    stmt.setBigDecimal(1, ask[0]);
                    stmt.setBigDecimal(2, ask[1]);
                    stmt.setInt(3, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with STATUS:" + status[0] + ",CID:" + cid[0] + ",TID:" + tid + query);
                    stmt.setString(1, status[0]);
                    stmt.setInt(2, cid[0]);
                    stmt.setInt(3, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with 1_STATUS:" + status[0] + ",1_ASK:" + ask[0] + ",2_STATUS:" + status[1] + ",2_ASK:" + ask[1] + ",1_CID:" + cid[0] + ",2_CID:" + cid[1] + "3_CID:" + cid[2] + ",4_CID:" + cid[3] + "5_CID:" + cid[4] + " ,TID:" + tid + query);
                    stmt.setString(1, status[0]);
                    stmt.setBigDecimal(2, ask[0]);
                    stmt.setString(3, status[1]);
                    stmt.setBigDecimal(4, ask[1]);
                    stmt.setInt(5, cid[0]);
                    stmt.setInt(6, cid[1]);
                    stmt.setInt(7, cid[2]);
                    stmt.setInt(8, cid[3]);
                    stmt.setInt(9, cid[4]);
                    stmt.setInt(10, tid);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with ORDERTIME:" + orderTime + ",1_ASK:" + ask[0] + ",STATUS:" + status[1] + "2_ASK:" + ask[1] + ",1_CID:" + cid[0] + ",2_CID: " + cid[1] + "3_CID:" + cid[2] + ",4_CID:" + cid[3] + ",5_CID:" + cid[4] + ",TID:" + tid + query);
                    stmt.setTimestamp(1, orderTime);
                    stmt.setBigDecimal(2, ask[0]);
                    stmt.setString(3, status[1]);
                    stmt.setBigDecimal(4, ask[1]);
                    stmt.setInt(5, cid[0]);
                    stmt.setInt(6, cid[1]);
                    stmt.setInt(7, cid[2]);
                    stmt.setInt(8, cid[3]);
                    stmt.setInt(9, cid[4]);
                    stmt.setInt(10, tid);
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with ORDERTIME:" + orderTime + ",TID:" + tid + query);
                    stmt.setTimestamp(1, orderTime);
                    stmt.setInt(2, tid);
                    break;
                }
                case 7: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with 1_OID:" + oid[0] + ",2_OID:" + oid[1] + ",3_OID:" + oid[2] + ",4_OID:" + oid[3] + ",5_OID:" + oid[4] + query);
                    for (int i = 1; i < 6; ++i) {
                        stmt.setInt(i, oid[i - 1]);
                    }
                    stmt.setInt(6, tid);
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with CID:" + cid[0] + query);
                    stmt.setInt(1, cid[0]);
                    break;
                }
                case 10: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with 1_ASK:" + ask[0] + ",2_ASK:" + ask[1] + query);
                    stmt.setBigDecimal(1, ask[0]);
                    stmt.setBigDecimal(2, ask[1]);
                    break;
                }
                case 11: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with STATUS:" + status[0] + ",CID:" + cid[0] + query);
                    stmt.setString(1, status[0]);
                    stmt.setInt(2, cid[0]);
                    break;
                }
                case 12: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with 1_STATUS:" + status[0] + ",1_ASK:" + ask[0] + ":2_STATUS:" + status[1] + ",2_ASK:" + ask[1] + ",1_CID:" + cid[0] + ",2_CID:" + cid[1] + ",3_CID:" + cid[2] + ",4_CID:" + cid[3] + ",5_CID:" + cid[4] + query);
                    stmt.setString(1, status[0]);
                    stmt.setBigDecimal(2, ask[0]);
                    stmt.setString(3, status[1]);
                    stmt.setBigDecimal(4, ask[1]);
                    stmt.setInt(5, cid[0]);
                    stmt.setInt(6, cid[1]);
                    stmt.setInt(7, cid[2]);
                    stmt.setInt(8, cid[3]);
                    stmt.setInt(9, cid[4]);
                    break;
                }
                case 13: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with ORDERTIME:" + orderTime + ",1_ASK:" + ask[0] + ",STATUS:" + status[1] + ",2_ASK:" + ask[1] + ",1_CID:" + cid[0] + ",2_CID:" + cid[1] + ",3_CID:" + cid[2] + ",4_CID:" + cid[3] + ",5_CID:" + cid[4] + query);
                    stmt.setTimestamp(1, orderTime);
                    stmt.setBigDecimal(2, ask[0]);
                    stmt.setString(3, status[1]);
                    stmt.setBigDecimal(4, ask[1]);
                    stmt.setInt(5, cid[0]);
                    stmt.setInt(6, cid[1]);
                    stmt.setInt(7, cid[2]);
                    stmt.setInt(8, cid[3]);
                    stmt.setInt(9, cid[4]);
                    break;
                }
                case 14: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with ORDERTIME:" + orderTime + query);
                    stmt.setTimestamp(1, orderTime);
                    break;
                }
                case 15: {
                    Log.getLogWriter().info(database + "querying trade.sellordersdup with 1_OID:" + oid[0] + ",2_OID:" + oid[1] + ",3_OID:" + oid[2] + ",4_OID:" + oid[3] + ",5_OID:" + oid[4] + query);
                    for (int i = 1; i < 6; ++i) {
                        stmt.setInt(i, oid[i - 1]);
                    }
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            throw se;
        }
        return rs;
    }

    protected int getDataForDelete(Connection conn, int[] cid, int[] sid) {
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        if (!testUniqueKeys && tid != 0) {
            tid = rand.nextInt(tid);
        }
        return this.getDataForDelete(conn, cid, sid, tid);
    }

    protected int getDataForDelete(Connection regConn, int[] cid, int[] sid, int tid) {
        Connection conn = TradeSellOrdersDupDMLStmt.getAuthConn(regConn);
        int availSize = cid.length;
        int firstQuery = 0;
        ResultSet rs = null;
        int[] offset = new int[1];
        rs = TradeSellOrdersDupDMLStmt.getQuery(conn, firstQuery, null, null, null, null, null, tid);
        if (rs == null && SQLHelper.isDerbyConn(conn)) {
            Log.getLogWriter().info("Not able to get data for delete");
            return 0;
        }
        ArrayList result = (ArrayList)ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
        SQLHelper.closeResultSet(rs, conn);
        if (result == null) {
            Log.getLogWriter().info("did not get result set");
            return 0;
        }
        availSize = this.getAvailSize(result, cid.length, offset);
        for (int i = 0; i < availSize; ++i) {
            cid[i] = (Integer)((GFXDStructImpl)result.get(i + offset[0])).get("CID");
            sid[i] = (Integer)((GFXDStructImpl)result.get(i + offset[0])).get("SID");
        }
        return availSize;
    }

    protected boolean deleteFromDerbyTable(Connection dConn, int whichDelete, int[] cid, int[] sid, int[] oid, List<SQLException> exList) {
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        int count = -1;
        try {
            PreparedStatement stmt = dConn.prepareStatement(delete[whichDelete]);
            if (stmt == null) {
                return false;
            }
            for (int i = 0; i < cid.length; ++i) {
                verifyRowCount.put(tid + "_delete_" + i, 0);
                count = this.deleteFromTable(stmt, cid[i], sid[i], oid[i], tid, whichDelete);
                verifyRowCount.put(tid + "_delete_" + i, new Integer(count));
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void deleteFromGFETable(Connection gConn, int whichDelete, int[] cid, int[] sid, int[] oid, List<SQLException> exList) {
        PreparedStatement stmt = TradeSellOrdersDupDMLStmt.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete from gemfirexd, myTid is " + tid);
        try {
            for (int i = 0; i < cid.length; ++i) {
                count = this.deleteFromTable(stmt, cid[i], sid[i], oid[i], tid, whichDelete);
                if (count == verifyRowCount.get(tid + "_delete_" + i)) continue;
                String str = "Gfxd delete (sellordersdup) has different row count from that of derby derby deleted " + verifyRowCount.get(tid + "_delete_" + i) + " but gfxd deleted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void deleteFromGFETable(Connection gConn, int whichDelete, int[] cid, int[] sid, int[] oid) {
        PreparedStatement stmt = TradeSellOrdersDupDMLStmt.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        Log.getLogWriter().info("data will be used in the delete: none");
        int tid = TradeSellOrdersDupDMLStmt.getMyTid();
        Log.getLogWriter().info("delete from gemfirexd, myTid is " + tid);
        try {
            for (int i = 0; i < cid.length; ++i) {
                this.deleteFromTable(stmt, cid[i], sid[i], oid[i], tid, whichDelete);
            }
        }
        catch (SQLException se) {
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected int deleteFromTable(PreparedStatement stmt, int cid, int sid, int oid, int tid, int whichDelete) throws SQLException {
        Log.getLogWriter().info("delete statement is " + delete[whichDelete]);
        int rowCount = 0;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + delete[whichDelete];
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting trade.sellordersdup with CID:" + cid + ",SID:" + sid + ",TID:" + tid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting trade.sellordersdup with OID:" + oid + ",TID:" + tid + query);
                stmt.setInt(1, oid);
                stmt.setInt(2, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "deleting trade.sellordersdup with TID:" + tid + query);
                stmt.setInt(1, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "deleting trade.sellordersdup with TID:" + tid + query);
                stmt.setInt(1, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "deleting trade.sellordersdup with CID:" + cid + ",SID:" + sid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 5: {
                Log.getLogWriter().info(database + "deleting trade.sellordersdup with OID:" + oid + query);
                stmt.setInt(1, oid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 6: {
                Log.getLogWriter().info(database + "deleting trade.sellordersdup with no data" + query);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 7: {
                Log.getLogWriter().info(database + "deleting trade.sellordersdup with no data" + query);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }
}

