/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import hydra.gemfirexd.FabricServerPrms;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.dmlStatements.TradeBuyOrdersDMLStmt;
import sql.dmlStatements.TradeSellOrdersDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlutil.GFXDStructImpl;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class TradeTxHistoryDMLStmt
extends AbstractDMLStmt {
    protected static String insert = "insert into trade.txhistory values (?,?,?,?,?,?,?,?)";
    protected static String put = "put into trade.txhistory values (?,?,?,?,?,?,?,?)";
    protected static String[] update = new String[]{"update trade.txhistory set type = ?, oid=?  where sid = ? and cid=? and tid = ? ", "update trade.txhistory set qty = ?, cid=?  where  oid=? and tid =? ", "update trade.txhistory set type = ?, oid=?  where sid = ? and cid=?  ", "update trade.txhistory set qty = ?, cid=?  where  oid=?  "};
    protected static String[] select = new String[]{"select * from trade.txhistory where tid = ?", "select oid, cid, sid, type, tid from trade.txhistory where cid >? and sid <? and qty >? and orderTime<? and tid = ?", "select sid, count(*) from trade.txhistory  where cid>? and sid<? and tid =? GROUP BY sid HAVING count(*) >=1", "select cid, max(price) from trade.txhistory  where tid =? GROUP BY cid, type", "select cid, sum(qty*price) as amount from trade.txhistory  where sid<? and tid =? GROUP BY cid, type ORDER BY amount", "select * from trade.txhistory ", "select oid, cid, sid, type, tid from trade.txhistory where cid >? and sid <? and qty >? and orderTime<? ", "select sid, count(*) from trade.txhistory  where cid>? and sid<? GROUP BY sid HAVING count(*) >=1", "select cid, count(sid) from trade.txhistory GROUP BY cid, type", "select cid, sum(qty*price) as amount from trade.txhistory  where sid<? GROUP BY cid, type ORDER BY amount"};
    protected static String[] selectwoaggreate = new String[]{"select * from trade.txhistory where tid = ?", "select oid, cid, sid, type, tid from trade.txhistory where cid >? and sid <? and qty >? and orderTime<? and tid = ?", "select * from trade.txhistory  where cid>? and sid<? and tid =? order by sid", "select * from trade.txhistory  where tid =? order by cid, type", "select * from trade.txhistory  where sid<? and tid =? order BY cid", "select * from trade.txhistory ", "select oid, cid, sid, type, tid from trade.txhistory where cid >? and sid <? and qty >? and orderTime<? ", "select sid, count(*) from trade.txhistory  where cid>? and sid<? GROUP BY sid HAVING count(*) >=1", "select cid, count(sid) from trade.txhistory GROUP BY cid, type", "select cid, sum(qty*price) as amount from trade.txhistory  where sid<? GROUP BY cid, type ORDER BY amount"};
    protected static String[] delete = new String[]{"delete from trade.txhistory where cid=? and sid=? and tid=?", "delete from trade.txhistory where oid=? and (price <? or qty>?) and type = 'buy' and tid=?", "delete from trade.txhistory where oid=? and (price >? or qty<?) and cid >=? and ordertime <? and tid=?", "delete from trade.txhistory where (type ='buy' or qty<?) and price>? and tid=?", "delete from trade.txhistory where (type ='sell' or ordertime>?) and sid=? and cid <? and tid=?", "delete from trade.txhistory where cid=? and sid=? ", "delete from trade.txhistory where oid=? and (price <? or qty>?) and type = 'buy' ", "delete from trade.txhistory where oid=? and (price >? or qty<?) and cid >=? and ordertime <? ", "delete from trade.txhistory where (type ='buy' or qty<?) and price>? ", "delete from trade.txhistory where (type ='sell' or ordertime>?) and sid=? and cid <?"};
    public static int maxNumOfTries = 2;
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    protected static ArrayList<String> partitionKeys = null;

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        this.insert(dConn, gConn, size, false);
    }

    private void insert(Connection dConn, Connection gConn, int size, boolean isPut) {
        int[] cid = new int[size];
        int[] oid = new int[size];
        int[] sid = new int[size];
        int[] qty = new int[size];
        String[] type = new String[size];
        Timestamp[] time = new Timestamp[size];
        BigDecimal[] price = new BigDecimal[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            if (rand.nextInt(numGettingDataFromDerby) == 1) {
                if (!this.getDataForInsert(dConn, oid, cid, sid, qty, type, time, price, size)) {
                    Log.getLogWriter().info("Not able to get data for insert");
                    return;
                }
            } else {
                if (setCriticalHeap && !this.getDataForInsert(gConn, oid, cid, sid, qty, type, time, price, size)) {
                    Log.getLogWriter().info("Not able to get data for insert");
                    return;
                }
                this.getDataForInsert(gConn, oid, cid, sid, qty, type, time, price, size);
            }
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            boolean success = this.insertToDerbyTable(dConn, oid, cid, sid, qty, type, time, price, size, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.insertToDerbyTable(dConn, oid, cid, sid, qty, type, time, price, size, exceptionList);
            }
            this.insertToGFETable(gConn, oid, cid, sid, qty, type, time, price, size, exceptionList, isPut);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else if (this.getDataForInsert(gConn, oid, cid, sid, qty, type, time, price, size)) {
            this.insertToGFETable(gConn, oid, cid, sid, qty, type, time, price, size, isPut);
        }
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        int[] sid = new int[size];
        int[] cid = new int[size];
        int[] oid = new int[size];
        String[] type = new String[size];
        int[] qty = new int[size];
        int[] whichUpdate = new int[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (setCriticalHeap && !hasTx) {
            return;
        }
        if (dConn != null) {
            boolean getData = false;
            getData = rand.nextInt(numGettingDataFromDerby) == 1 ? this.getDataForUpdate(dConn, cid, sid, oid, qty, type, whichUpdate, size) : this.getDataForUpdate(gConn, cid, sid, oid, qty, type, whichUpdate, size);
            if (hasHdfs) {
                for (int id : cid) {
                    if (id != 0) continue;
                    Log.getLogWriter().info("do not update 0 for hdfs tests when fk was taken out due to #49452");
                    return;
                }
            }
            if (!getData) {
                Log.getLogWriter().info("Not able to get data for update");
                return;
            }
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            boolean success = this.updateDerbyTable(dConn, cid, sid, oid, qty, type, whichUpdate, size, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.updateDerbyTable(dConn, cid, sid, oid, qty, type, whichUpdate, size, exceptionList);
            }
            this.updateGFETable(gConn, cid, sid, oid, qty, type, whichUpdate, size, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.getDataForUpdate(gConn, cid, sid, oid, qty, type, whichUpdate, size);
            this.updateGFETable(gConn, cid, sid, oid, qty, type, whichUpdate, size);
        }
    }

    @Override
    public void delete(Connection dConn, Connection gConn) {
        int numOfNonUniqDelete = delete.length / 2;
        int whichDelete = this.getWhichOne(numOfNonUniqDelete, delete.length);
        if (setCriticalHeap && !hasTx) {
            return;
        }
        int size = 1;
        int[] cid = new int[size];
        int[] sid = new int[size];
        int[] oid = new int[size];
        int[] qty = new int[size];
        Timestamp[] time = new Timestamp[size];
        BigDecimal[] price = new BigDecimal[size];
        for (int i = 0; i < size; ++i) {
            oid[i] = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeBuyOrdersPrimary));
            qty[i] = this.getQty();
            price[i] = this.getPrice();
            time[i] = new Timestamp(System.currentTimeMillis() - (long)rand.nextInt(600000));
        }
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        int availSize = this.getDataForDelete(gConn, cid, sid);
        if (availSize == 0 || availSize == -1) {
            return;
        }
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, whichDelete, cid, sid, oid, price, qty, time, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish the operation in derby, abort this operation");
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.deleteFromDerbyTable(dConn, whichDelete, cid, sid, oid, price, qty, time, exceptionList);
            }
            this.deleteFromGFETable(gConn, whichDelete, cid, sid, oid, price, qty, time, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.deleteFromGFETable(gConn, whichDelete, cid, sid, oid, price, qty, time);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void query(Connection dConn, Connection gConn) {
        numOfNonUniq = TradeTxHistoryDMLStmt.select.length / 2;
        whichQuery = this.getWhichOne(numOfNonUniq, TradeTxHistoryDMLStmt.select.length);
        qty = this.getQty();
        cid = TradeTxHistoryDMLStmt.getCid();
        sid = this.getSid();
        tid = TradeTxHistoryDMLStmt.getMyTid();
        time = this.getRandTime();
        discRS = null;
        gfeRS = null;
        exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            try {
                discRS = TradeTxHistoryDMLStmt.query(dConn, whichQuery, qty, cid, sid, time, tid);
                if (discRS == null) {
                    Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                    return;
                }
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exceptionList);
            }
            try {
                gfeRS = TradeTxHistoryDMLStmt.query(gConn, whichQuery, qty, cid, sid, time, tid);
                if (gfeRS == null) {
                    if (TradeTxHistoryDMLStmt.isHATest) {
                        Log.getLogWriter().info("Testing HA and did not get GFXD result set after retry");
                        return;
                    }
                    if (TradeTxHistoryDMLStmt.setCriticalHeap) {
                        Log.getLogWriter().info("got XCL54 and does not get query result");
                        return;
                    }
                    throw new TestException("Not able to get gfe result set after retry");
                }
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptionList);
                return;
            }
            SQLHelper.handleMissedSQLException(exceptionList);
            if (discRS == null || gfeRS == null) {
                return;
            }
            success = true;
            try {
                if (TradeTxHistoryDMLStmt.useWriterForWriteThrough) {
                    success = ResultSetHelper.compareDuplicateResultSets(discRS, gfeRS);
                } else {
                    if (TradeTxHistoryDMLStmt.isHATest && SQLHelper.isThinClient(gConn)) {
                        Log.getLogWriter().info("could not compare results for table without primary key in HA test when using thin client driver due to the known issue of #44929");
                        return;
                    }
                    success = ResultSetHelper.compareResultSets(discRS, gfeRS);
                }
                if (success) ** GOTO lbl109
                Log.getLogWriter().info("Not able to compare results due to derby server error or #41471");
            }
            catch (TestException te) {
                if ((te.getMessage().contains("elements were missing") || te.getMessage().contains("unexpected elements")) && whichQuery >= 2 && whichQuery <= 4) {
                    TradeTxHistoryDMLStmt.dumpNoAggregateRs.set((Object)true);
                    try {
                        discRS = TradeTxHistoryDMLStmt.query(dConn, whichQuery, qty, cid, sid, time, tid);
                        derbyList = ResultSetHelper.asList(discRS, true);
                        if (derbyList != null) {
                            Log.getLogWriter().info("dump non-aggregate result from derby due to data mismatch:" + ResultSetHelper.listToString(derbyList));
                        } else {
                            Log.getLogWriter().info("not able to get derby results for dump");
                        }
                    }
                    catch (SQLException se) {
                        Log.getLogWriter().info("not able to get derby results for dump");
                    }
                    try {
                        gfeRS = TradeTxHistoryDMLStmt.query(gConn, whichQuery, qty, cid, sid, time, tid);
                        gfxdList = ResultSetHelper.asList(gfeRS, false);
                        if (gfxdList != null) {
                            Log.getLogWriter().info("dump non-aggregate result from gfxd due to data mismatch:" + ResultSetHelper.listToString(gfxdList));
                        } else {
                            Log.getLogWriter().info("not able to get gfxd results for dump");
                        }
                    }
                    catch (SQLException se) {
                        Log.getLogWriter().info("not able to get gfxd results for dump");
                    }
                    TradeTxHistoryDMLStmt.dumpNoAggregateRs.set((Object)false);
                    TradeTxHistoryDMLStmt.dumpQueryPlanRs.set((Object)true);
                    try {
                        gfeRS = TradeTxHistoryDMLStmt.query(gConn, whichQuery, qty, cid, sid, time, tid);
                        plan = new StringBuilder();
                        while (gfeRS.next()) {
                            plan.append(gfeRS.getString(1)).append('\n');
                        }
                        if (plan.length() > 0) {
                            Log.getLogWriter().info("dump query plan in gfxd due to data mismatch:" + plan);
                        } else {
                            Log.getLogWriter().info("no query plan in gfxd found");
                        }
                    }
                    catch (SQLException se) {
                        Log.getLogWriter().info("not able to get gfxd queryplan due to exception " + se.getSQLState(), (Throwable)se);
                    }
                    TradeTxHistoryDMLStmt.dumpQueryPlanRs.set((Object)false);
                }
                throw te;
            }
        } else {
            try {
                gfeRS = TradeTxHistoryDMLStmt.query(gConn, whichQuery, qty, cid, sid, time, tid);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && SQLTest.testSecurity) {
                    Log.getLogWriter().info("Got expected no SELECT permission, continuing test");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            if (gfeRS != null) {
                ResultSetHelper.asList(gfeRS, false);
            } else if (TradeTxHistoryDMLStmt.isHATest) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            } else if (TradeTxHistoryDMLStmt.setCriticalHeap) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to XCL54");
            } else {
                throw new TestException("gfxd query returns null and not a HA test");
            }
        }
lbl109:
        // 5 sources

        SQLHelper.closeResultSet(gfeRS, gConn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean getDataForInsert(Connection regConn, int[] oid, int[] cid, int[] sid, int[] qty, String[] type, Timestamp[] time, BigDecimal[] price, int size) {
        boolean[] getCanceled;
        Connection conn = TradeTxHistoryDMLStmt.getAuthConn(regConn);
        int whichQuery = 0;
        ResultSet bors = TradeBuyOrdersDMLStmt.getQuery(conn, whichQuery, null, null, 0, 0, 0, null, TradeTxHistoryDMLStmt.getMyTid());
        ArrayList bolist = (ArrayList)ResultSetHelper.asList(bors, SQLHelper.isDerbyConn(conn));
        ResultSet sors = TradeSellOrdersDMLStmt.getQuery(conn, whichQuery, null, null, null, null, null, TradeTxHistoryDMLStmt.getMyTid());
        ArrayList solist = (ArrayList)ResultSetHelper.asList(sors, SQLHelper.isDerbyConn(conn));
        SQLHelper.closeResultSet(bors, conn);
        SQLHelper.closeResultSet(sors, conn);
        if (setCriticalHeap && (getCanceled = (boolean[])SQLTest.getCanceled.get())[0]) {
            Log.getLogWriter().info("memory runs low -- no data will be return");
            return false;
        }
        if (bolist != null && solist != null) {
            if (solist.size() != 0 && bolist.size() != 0) {
                if (rand.nextInt() % 2 == 0) {
                    this.getDataForInsertFromSO(solist, oid, cid, sid, qty, type, time, price, size);
                    return true;
                } else {
                    this.getDataForInsertFromBO(bolist, oid, cid, sid, qty, type, time, price, size);
                }
                return true;
            } else if (solist.size() != 0) {
                this.getDataForInsertFromSO(solist, oid, cid, sid, qty, type, time, price, size);
                return true;
            } else {
                if (bolist.size() == 0) return false;
                this.getDataForInsertFromBO(bolist, oid, cid, sid, qty, type, time, price, size);
            }
            return true;
        } else if (bolist == null && solist != null) {
            if (solist.size() == 0) return false;
            this.getDataForInsertFromSO(solist, oid, cid, sid, qty, type, time, price, size);
            return true;
        } else {
            if (solist != null || bolist == null) return false;
            if (bolist.size() == 0) return false;
            this.getDataForInsertFromBO(bolist, oid, cid, sid, qty, type, time, price, size);
        }
        return true;
    }

    protected void getDataForInsertFromBO(ArrayList<Struct> bolist, int[] oid, int[] cid, int[] sid, int[] qty, String[] type, Timestamp[] time, BigDecimal[] price, int size) {
        for (int i = 0; i < size; ++i) {
            String[] fieldNames;
            type[i] = "buy";
            int index = rand.nextInt(bolist.size());
            GFXDStructImpl aRow = (GFXDStructImpl)bolist.get(index);
            for (String field : fieldNames = aRow.getFieldNames()) {
                if (field.equalsIgnoreCase("CID")) {
                    cid[i] = (Integer)aRow.get("CID");
                    continue;
                }
                if (field.equalsIgnoreCase("OID")) {
                    oid[i] = (Integer)aRow.get("OID");
                    continue;
                }
                if (field.equalsIgnoreCase("SID")) {
                    sid[i] = (Integer)aRow.get("SID");
                    continue;
                }
                if (field.equalsIgnoreCase("QTY")) {
                    qty[i] = (Integer)aRow.get("QTY");
                    continue;
                }
                if (field.equalsIgnoreCase("ORDERTIME")) {
                    if (rand.nextInt(10) == 1) continue;
                    time[i] = (Timestamp)aRow.get("ORDERTIME");
                    continue;
                }
                if (!field.equalsIgnoreCase("BID")) continue;
                price[i] = (BigDecimal)aRow.get("BID");
            }
        }
    }

    protected void getDataForInsertFromSO(ArrayList<Struct> solist, int[] oid, int[] cid, int[] sid, int[] qty, String[] type, Timestamp[] time, BigDecimal[] price, int size) {
        for (int i = 0; i < size; ++i) {
            String[] fieldNames;
            type[i] = "sell";
            int index = rand.nextInt(solist.size());
            GFXDStructImpl aRow = (GFXDStructImpl)solist.get(index);
            for (String field : fieldNames = aRow.getFieldNames()) {
                if (field.equalsIgnoreCase("CID")) {
                    cid[i] = (Integer)aRow.get("CID");
                    continue;
                }
                if (field.equalsIgnoreCase("OID")) {
                    oid[i] = (Integer)aRow.get("OID");
                    continue;
                }
                if (field.equalsIgnoreCase("SID")) {
                    sid[i] = (Integer)aRow.get("SID");
                    continue;
                }
                if (field.equalsIgnoreCase("QTY")) {
                    qty[i] = (Integer)aRow.get("QTY");
                    continue;
                }
                if (field.equalsIgnoreCase("ORDER_TIME")) {
                    if (rand.nextInt(10) == 1) continue;
                    time[i] = (Timestamp)aRow.get("ORDER_TIME");
                    continue;
                }
                if (!field.equalsIgnoreCase("ASK")) continue;
                price[i] = (BigDecimal)aRow.get("ASK");
            }
        }
    }

    protected boolean insertToDerbyTable(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String[] type, Timestamp[] time, BigDecimal[] price, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = TradeTxHistoryDMLStmt.getStmt(conn, insert);
        if (stmt == null) {
            return false;
        }
        int tid = TradeTxHistoryDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                verifyRowCount.put(tid + "_insert" + i, 0);
                count = this.insertToTable(stmt, oid[i], cid[i], sid[i], qty[i], type[i], time[i], price[i], tid);
                verifyRowCount.put(tid + "_insert" + i, count);
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected void insertToGFETable(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String[] type, Timestamp[] time, BigDecimal[] price, int size, List<SQLException> exceptions, boolean isPut) {
        PreparedStatement stmt = TradeTxHistoryDMLStmt.getStmt(conn, isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeTxHistoryDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, oid[i], cid[i], sid[i], qty[i], type[i], time[i], price[i], tid, isPut);
                if (count == verifyRowCount.get(tid + "_insert" + i)) continue;
                String str = "Gfxd insert has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            catch (SQLException se) {
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void insertToGFETable(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String[] type, Timestamp[] time, BigDecimal[] price, int size) {
        this.insertToGFETable(conn, oid, cid, sid, qty, type, time, price, size, false);
    }

    protected void insertToGFETable(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String[] type, Timestamp[] time, BigDecimal[] price, int size, boolean isPut) {
        PreparedStatement stmt = TradeTxHistoryDMLStmt.getStmt(conn, isPut ? put : insert);
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeTxHistoryDMLStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, oid[i], cid[i], sid[i], qty[i], type[i], time[i], price[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int oid, int cid, int sid, int qty, String type, Timestamp time, BigDecimal price, int tid) throws SQLException {
        return this.insertToTable(stmt, oid, cid, sid, qty, type, time, price, tid, false);
    }

    protected int insertToTable(PreparedStatement stmt, int oid, int cid, int sid, int qty, String type, Timestamp time, BigDecimal price, int tid, boolean isPut) throws SQLException {
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.txhistory with OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",TYPE:" + type + ",TIME:" + time + ",PRICE:" + price + ",TID:" + tid);
        String driverName = stmt.getConnection().getMetaData().getDriverName();
        stmt.setInt(1, cid);
        stmt.setInt(2, oid);
        stmt.setInt(3, sid);
        stmt.setInt(4, qty);
        stmt.setBigDecimal(5, price);
        if (time == null && alterTableDropColumn) {
            stmt.setNull(6, 93);
        } else if (testworkaroundFor51519 && time != null) {
            stmt.setTimestamp(6, time, TradeTxHistoryDMLStmt.getCal());
        } else {
            stmt.setTimestamp(6, time);
        }
        stmt.setString(7, type);
        stmt.setInt(8, tid);
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows into trade.txhistory OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",TYPE:" + type + ",TIME:" + time + ",PRICE:" + price + ",TID:" + tid);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        if (driverName.toLowerCase().contains("gemfirexd") && isPut && !SQLTest.ticket49794fixed) {
            this.insertToTxhistoryFulldataset(stmt.getConnection(), cid, oid, sid, qty, time, price, type, tid);
        }
        return rowCount;
    }

    protected void insertToTxhistoryFulldataset(Connection conn, int cid, int oid, int sid, int qty, Timestamp time, BigDecimal price, String type, int tid) {
        try {
            String selectStatement = "select count(*) FROM TRADE.TXHISTORY_FULLDATASET  WHERE cid = ? and oid = ?  and sid = ? and qty = ? and price = ? and  type = ? and tid = ?" + (time == null ? " and ordertime is null " : " and ordertime = ?");
            String insertStatement = "insert into trade.txhistory_FULLDATASET values (?,?,?,?,?,?,?,?)";
            PreparedStatement preparedSelectStmt = conn.prepareStatement(selectStatement);
            preparedSelectStmt.setInt(1, cid);
            preparedSelectStmt.setInt(2, oid);
            preparedSelectStmt.setInt(3, sid);
            preparedSelectStmt.setInt(4, qty);
            preparedSelectStmt.setBigDecimal(5, price);
            preparedSelectStmt.setString(6, type);
            preparedSelectStmt.setInt(7, tid);
            if (time != null) {
                if (testworkaroundFor51519) {
                    preparedSelectStmt.setTimestamp(8, time, TradeTxHistoryDMLStmt.getCal());
                } else {
                    preparedSelectStmt.setTimestamp(8, time);
                }
            }
            if (preparedSelectStmt.executeQuery().next()) {
                Log.getLogWriter().info(" Trigger behaviour is not defined for putDML (bug #49794 ) hence inserting  the  row  into  TRADE.TXHISTORY_FULLDATASET with data CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",ORDERTIME:" + time + ",OID:" + oid + ",TYPE: " + type + ",PRICE:" + price);
                PreparedStatement ps = conn.prepareStatement(insertStatement);
                ps.setInt(1, cid);
                ps.setInt(2, oid);
                ps.setInt(3, sid);
                ps.setInt(4, qty);
                ps.setBigDecimal(5, price);
                if (testworkaroundFor51519 && time != null) {
                    ps.setTimestamp(6, time, TradeTxHistoryDMLStmt.getCal());
                } else {
                    ps.setTimestamp(6, time);
                }
                ps.setString(7, type);
                ps.setInt(8, tid);
                ps.executeUpdate();
            }
        }
        catch (SQLException se) {
            Log.getLogWriter().info("Error while updating TXHISTORY_FULLDATASET table. It may cause Data inconsistency " + se.getMessage());
        }
    }

    protected Timestamp getRandTime() {
        return new Timestamp(System.currentTimeMillis() - (long)rand.nextInt(600000));
    }

    protected boolean getDataForUpdate(Connection regConn, int[] cid, int[] sid, int[] oid, int[] qty, String[] type, int[] whichUpdate, int size) {
        Connection conn = TradeTxHistoryDMLStmt.getAuthConn(regConn);
        int numOfNonUniq = update.length / 2;
        boolean success = this.getDataFromResult(conn, cid, sid, oid);
        if (!success) {
            return false;
        }
        int bo = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeBuyOrdersPrimary);
        int so = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSellOrdersPrimary);
        for (int i = 0; i < size; ++i) {
            qty[i] = this.getQty();
            type[i] = rand.nextInt() % 2 == 0 ? "buy" : "sell";
            whichUpdate[i] = this.getWhichOne(numOfNonUniq, update.length);
            if (setCriticalHeap && testUniqueKeys) {
                whichUpdate[i] = 1;
            }
            if (whichUpdate[i] % 2 == 1) {
                if (i != 0) {
                    oid[i] = oid[i - 1];
                    continue;
                }
                oid[i] = type[i].equals("buy") ? rand.nextInt(bo) : rand.nextInt(so);
                continue;
            }
            oid[i] = type[i].equals("buy") ? rand.nextInt(bo) : rand.nextInt(so);
        }
        return true;
    }

    protected boolean getDataFromResult(Connection conn, int[] cid, int[] sid, int[] oid) {
        int tid = TradeTxHistoryDMLStmt.getMyTid();
        if (!testUniqueKeys && tid != 0) {
            tid = rand.nextInt(tid);
        }
        return this.getDataFromResult(conn, cid, sid, oid, tid);
    }

    protected boolean getDataFromResult(Connection regConn, int[] cid, int[] sid, int[] oid, int tid) {
        int whichQuery;
        Connection conn = TradeTxHistoryDMLStmt.getAuthConn(regConn);
        ResultSet rs = TradeTxHistoryDMLStmt.getQuery(conn, whichQuery = 0, 0, 0, 0, null, tid);
        if (rs == null) {
            return false;
        }
        ArrayList rslist = (ArrayList)ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
        SQLHelper.closeResultSet(rs, conn);
        if (rslist == null || rslist.size() == 0) {
            return false;
        }
        this.getDataForUpdateFromRS(rslist, cid, sid, oid, cid.length);
        return true;
    }

    protected void getDataForUpdateFromRS(ArrayList<Struct> rslist, int[] cid, int[] sid, int[] oid, int size) {
        for (int i = 0; i < size; ++i) {
            int index = rand.nextInt(rslist.size());
            cid[i] = (Integer)((GFXDStructImpl)rslist.get(index)).get("CID");
            oid[i] = (Integer)((GFXDStructImpl)rslist.get(index)).get("OID");
        }
    }

    protected boolean updateDerbyTable(Connection conn, int[] cid, int[] sid, int[] oid, int[] qty, String[] type, int[] whichUpdate, int size, List<SQLException> exList) {
        PreparedStatement stmt = null;
        int tid = TradeTxHistoryDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            block7: {
                stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i]) : TradeTxHistoryDMLStmt.getStmt(conn, update[whichUpdate[i]]);
                if (stmt == null) {
                    try {
                        conn.prepareStatement(update[whichUpdate[i]]);
                    }
                    catch (SQLException se) {
                        if (!se.getSQLState().equals("08006") && !se.getSQLState().equals("08003")) break block7;
                        return false;
                    }
                }
            }
            try {
                if (stmt == null) continue;
                verifyRowCount.put(tid + "_update" + i, 0);
                count = this.updateTable(stmt, cid[i], sid[i], oid[i], qty[i], type[i], tid, whichUpdate[i]);
                verifyRowCount.put(tid + "_update" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exList);
            }
        }
        return true;
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys);
    }

    protected void setPartitionKeys() {
        if (!isWanTest) {
            partitionKeys = (ArrayList)partitionMap.get((Object)"txhistoryPartition");
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_txhistoryPartition"));
        }
        Log.getLogWriter().info("partition keys are " + partitionKeys);
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys) {
        PreparedStatement stmt = null;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("type") || partitionKeys.contains("oid")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeTxHistoryDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("qty") || partitionKeys.contains("cid")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeTxHistoryDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("type") || partitionKeys.contains("oid")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeTxHistoryDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("qty") || partitionKeys.contains("cid")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (SQLHelper.isDerbyConn(conn)) break;
                    stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                    break;
                }
                stmt = TradeTxHistoryDMLStmt.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] oid, int[] qty, String[] type, int[] whichUpdate, int size, List<SQLException> exList) {
        PreparedStatement stmt = null;
        int tid = TradeTxHistoryDMLStmt.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i]) : TradeTxHistoryDMLStmt.getStmt(conn, update[whichUpdate[i]]);
            if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
                SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
            if (setCriticalHeap && stmt == null) {
                return;
            }
            try {
                if (stmt == null || (count = this.updateTable(stmt, cid[i], sid[i], oid[i], qty[i], type[i], tid, whichUpdate[i])) == verifyRowCount.get(tid + "_update" + i)) continue;
                String str = "Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exList);
            }
        }
    }

    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] oid, int[] qty, String[] type, int[] whichUpdate, int size) {
        PreparedStatement stmt = null;
        int tid = TradeTxHistoryDMLStmt.getMyTid();
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i]) : TradeTxHistoryDMLStmt.getStmt(conn, update[whichUpdate[i]]);
            try {
                if (stmt == null) continue;
                this.updateTable(stmt, cid[i], sid[i], oid[i], qty[i], type[i], tid, whichUpdate[i]);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && (se.getSQLState().equals("42X14") || se.getSQLState().equals("42X04"))) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int updateTable(PreparedStatement stmt, int cid, int sid, int oid, int qty, String type, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + update[whichUpdate];
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.txhistory with TYPE:" + type + ",OID:" + oid + " where SID:" + sid + ",CID:" + cid + ",TID:" + tid + query);
                stmt.setString(1, type);
                stmt.setInt(2, oid);
                stmt.setInt(3, sid);
                stmt.setInt(4, cid);
                stmt.setInt(5, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.txhistory TYPE:" + type + ",OID:" + oid + " where SID:" + sid + ",CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating trade.txhistory with QTY:" + qty + ",CID:" + cid + " where OID:" + oid + ",TID:" + tid + query);
                stmt.setInt(1, qty);
                stmt.setInt(2, cid);
                stmt.setInt(3, oid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.txhistory QTY:" + qty + ",CID:" + cid + " where OID:" + oid + ",TID:" + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updating trade.txhistory with TYPE:" + type + ",OID:" + oid + " where SID:" + sid + ",CID:" + cid + ",TID:" + tid + query);
                stmt.setString(1, type);
                stmt.setInt(2, oid);
                stmt.setInt(3, sid);
                stmt.setInt(4, cid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.txhistory with TYPE:" + type + ",OID:" + oid + " where SID:" + sid + ",CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.txhistory with QTY:" + qty + ",CID:" + cid + " where OID:" + oid + ",TID:" + tid);
                stmt.setInt(1, qty);
                stmt.setInt(2, cid);
                stmt.setInt(3, oid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated  " + rowCount + " rows in trade.txhistory with QTY:" + qty + ",CID:" + cid + " where OID:" + oid + ",TID:" + tid);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, int qty, int cid, int sid, Timestamp orderTime, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        try {
            rs = TradeTxHistoryDMLStmt.getQuery(conn, whichQuery, qty, cid, sid, orderTime, tid, success);
            int count = 0;
            while (!success[0]) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                    return null;
                }
                ++count;
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                rs = TradeTxHistoryDMLStmt.getQuery(conn, whichQuery, qty, cid, sid, orderTime, tid, success);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected static ResultSet query(Connection conn, int whichQuery, int qty, int cid, int sid, Timestamp orderTime, int tid) throws SQLException {
        boolean[] success = new boolean[1];
        ResultSet rs = TradeTxHistoryDMLStmt.getQuery(conn, whichQuery, qty, cid, sid, orderTime, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = TradeTxHistoryDMLStmt.getQuery(conn, whichQuery, qty, cid, sid, orderTime, tid, success);
        }
        return rs;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, int qty, int cid, int sid, Timestamp orderTime, int tid, boolean[] success) throws SQLException {
        Boolean dumpResult = (Boolean)dumpNoAggregateRs.get();
        Boolean dumpQueryPlan = (Boolean)dumpQueryPlanRs.get();
        String sql = dumpResult != null && dumpResult != false ? selectwoaggreate[whichQuery] : (dumpQueryPlan != null && dumpQueryPlan != false ? "explain " + select[whichQuery] : select[whichQuery]);
        return TradeTxHistoryDMLStmt.getQuery(conn, whichQuery, qty, cid, sid, orderTime, tid, success, sql);
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, int qty, int cid, int sid, Timestamp orderTime, int tid, boolean[] success, String sql) throws SQLException {
        ResultSet rs = null;
        success[0] = true;
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + select[whichQuery];
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.txhistory with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.txhistory with CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",ORDERTIME:" + orderTime + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, sid);
                    stmt.setInt(3, qty);
                    if (testworkaroundFor51519 && orderTime != null) {
                        stmt.setTimestamp(4, orderTime, TradeTxHistoryDMLStmt.getCal());
                    } else {
                        stmt.setTimestamp(4, orderTime);
                    }
                    stmt.setInt(5, tid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.txhistory with CID:" + cid + ",SID:" + sid + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, sid);
                    stmt.setInt(3, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.txhistory with TID: " + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.txhistory with SID:" + sid + ",TID:" + tid + query);
                    stmt.setInt(1, sid);
                    stmt.setInt(2, tid);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "not executing any query in trade.txhistory");
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying trade.txhistory with CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",ORDERTIME:" + orderTime + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, sid);
                    stmt.setInt(3, qty);
                    if (testworkaroundFor51519 && orderTime != null) {
                        stmt.setTimestamp(4, orderTime, TradeTxHistoryDMLStmt.getCal());
                        break;
                    }
                    stmt.setTimestamp(4, orderTime);
                    break;
                }
                case 7: {
                    Log.getLogWriter().info(database + "querying trade.txhistory with CID:" + cid + ",SID:" + sid + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, sid);
                    break;
                }
                case 8: {
                    Log.getLogWriter().info(database + "not executing any query in trade.txhistory");
                    break;
                }
                case 9: {
                    Log.getLogWriter().info(database + "querying trade.txhistory with  SID:" + sid + ",TID:" + tid + query);
                    stmt.setInt(1, sid);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            throw se;
        }
        return rs;
    }

    protected int getDataForDelete(Connection regConn, int[] cid, int[] sid) {
        Connection conn = TradeTxHistoryDMLStmt.getAuthConn(regConn);
        int availSize = cid.length;
        int firstQuery = 0;
        ResultSet rs = null;
        int[] offset = new int[1];
        if (testUniqueKeys) {
            rs = TradeTxHistoryDMLStmt.getQuery(conn, firstQuery, 0, 0, 0, null, TradeTxHistoryDMLStmt.getMyTid());
            for (int count = 0; rs == null && count < maxNumOfTries; ++count) {
                MasterController.sleepForMs((int)(30 * rand.nextInt(10)));
                rs = TradeTxHistoryDMLStmt.getQuery(conn, firstQuery, 0, 0, 0, null, TradeTxHistoryDMLStmt.getMyTid());
            }
            ArrayList result = (ArrayList)ResultSetHelper.asList(rs, SQLHelper.isDerbyConn(conn));
            SQLHelper.closeResultSet(rs, conn);
            if (result == null) {
                Log.getLogWriter().info("Could not get result. abort this operations");
                return -1;
            }
            availSize = this.getAvailSize(result, cid.length, offset);
            for (int i = 0; i < availSize; ++i) {
                cid[i] = (Integer)((GFXDStructImpl)result.get(i + offset[0])).get("CID");
                sid[i] = (Integer)((GFXDStructImpl)result.get(i + offset[0])).get("SID");
            }
        } else {
            this.getCids(conn, cid);
            for (int i = 0; i < availSize; ++i) {
                sid[i] = this.getSid();
            }
        }
        return availSize;
    }

    protected boolean deleteFromDerbyTable(Connection dConn, int whichDelete, int[] cid, int[] sid, int[] oid, BigDecimal[] price, int[] qty, Timestamp[] time, List<SQLException> exList) {
        PreparedStatement stmt = TradeTxHistoryDMLStmt.getStmt(dConn, delete[whichDelete]);
        if (stmt == null) {
            return false;
        }
        int tid = TradeTxHistoryDMLStmt.getMyTid();
        int count = -1;
        try {
            for (int i = 0; i < cid.length; ++i) {
                verifyRowCount.put(tid + "_delete" + i, 0);
                count = this.deleteFromTable(stmt, cid[i], sid[i], oid[i], price[i], qty[i], time[i], tid, whichDelete);
                verifyRowCount.put(tid + "_delete" + i, new Integer(count));
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void deleteFromGFETable(Connection gConn, int whichDelete, int[] cid, int[] sid, int[] oid, BigDecimal[] price, int[] qty, Timestamp[] time, List<SQLException> exList) {
        PreparedStatement stmt = TradeTxHistoryDMLStmt.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeTxHistoryDMLStmt.getMyTid();
        int count = -1;
        try {
            for (int i = 0; i < cid.length; ++i) {
                count = this.deleteFromTable(stmt, cid[i], sid[i], oid[i], price[i], qty[i], time[i], tid, whichDelete);
                if (count == verifyRowCount.get(tid + "_delete" + i)) continue;
                String str = "Gfxd delete (txhistory) has different row count from that of derby derby deleted " + verifyRowCount.get(tid + "_delete" + i) + " but gfxd deleted " + count;
                if (failAtUpdateCount && !isHATest) {
                    throw new TestException(str);
                }
                Log.getLogWriter().warning(str);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void deleteFromGFETable(Connection gConn, int whichDelete, int[] cid, int[] sid, int[] oid, BigDecimal[] price, int[] qty, Timestamp[] time) {
        PreparedStatement stmt = TradeTxHistoryDMLStmt.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && SQLTest.setTx && isHATest) {
            Log.getLogWriter().info("prepare stmt failed due to node failure");
            return;
        }
        if (stmt == null) {
            throw new TestException("Does not expect statement to be null, but it is.");
        }
        int tid = TradeTxHistoryDMLStmt.getMyTid();
        try {
            for (int i = 0; i < cid.length; ++i) {
                this.deleteFromTable(stmt, cid[i], sid[i], oid[i], price[i], qty[i], time[i], tid, whichDelete);
            }
        }
        catch (SQLException se) {
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            if (alterTableDropColumn && (se.getSQLState().equals("42X14") || se.getSQLState().equals("42X04"))) {
                Log.getLogWriter().info("Got expected column not found exception in delete, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected int deleteFromTable(PreparedStatement stmt, int cid, int sid, int oid, BigDecimal price, int qty, Timestamp time, int tid, int whichDelete) throws SQLException {
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + delete[whichDelete];
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting trade.txhistory with CID:" + cid + ",SID:" + sid + ",TID:" + tid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + "rows in trade.txhistory CID:" + cid + ",SID:" + sid + ",TID:" + tid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting trade.txhistory with OID:" + oid + ",PRICE:" + price + ",QTY:" + qty + ",TID:" + tid + query);
                stmt.setInt(1, oid);
                stmt.setBigDecimal(2, price);
                stmt.setInt(3, qty);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.txhistory OID:" + oid + ",PRICE:" + price + ",QTY:" + qty + ",TID:" + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "deleting trade.txhistory with OID:" + oid + ",QTY:" + qty + ",PRICE:" + price + ",CID:" + cid + ",ORDERTIME:" + time + ",TID:" + tid + query);
                stmt.setInt(1, oid);
                stmt.setBigDecimal(2, price);
                stmt.setInt(3, qty);
                stmt.setInt(4, cid);
                if (testworkaroundFor51519 && time != null) {
                    stmt.setTimestamp(5, time, TradeTxHistoryDMLStmt.getCal());
                } else {
                    stmt.setTimestamp(5, time);
                }
                stmt.setInt(6, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + "rows  trade.txhistory OID:" + oid + ",QTY:" + qty + ",PRICE:" + price + ",CID:" + cid + ",ORDERTIME:" + time + ",TID:" + tid + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "deleting trade.txhistory with QTY:" + qty + ",PRICE:" + price + ",TID:" + tid + query);
                stmt.setInt(1, qty);
                stmt.setBigDecimal(2, price);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + "rows trade.txhistory  QTY:" + qty + ",PRICE:" + price + ",TID:" + tid + query);
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "deleting trade.txhistory with ORDERTIME:" + time + ",SID:" + sid + ",CID:" + cid + ",TID:" + tid + query);
                if (testworkaroundFor51519 && time != null) {
                    stmt.setTimestamp(1, time, TradeTxHistoryDMLStmt.getCal());
                } else {
                    stmt.setTimestamp(1, time);
                }
                stmt.setInt(2, sid);
                stmt.setInt(3, cid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows trade.txhistory ORDERTIME:" + time + ",SID:" + sid + ",CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 5: {
                Log.getLogWriter().info(database + "deleting trade.txhistory with CID:" + cid + ",SID:" + sid + query);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows trade.txhistory CID:" + cid + ",SID:" + sid + query);
                break;
            }
            case 6: {
                Log.getLogWriter().info(database + "deleting trade.txhistory with OID:" + oid + ",PRICE:" + price + ",QTY:" + qty + query);
                stmt.setInt(1, oid);
                stmt.setBigDecimal(2, price);
                stmt.setInt(3, qty);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows  trade.txhistory OID:" + oid + ",PRICE:" + price + ",QTY:" + qty + query);
                break;
            }
            case 7: {
                Log.getLogWriter().info(database + "deleting trade.txhistory with QTY:" + qty + ",PRICE:" + price + ",CID:" + cid + ",ORDERTIME:" + time + query);
                stmt.setInt(1, oid);
                stmt.setBigDecimal(2, price);
                stmt.setInt(3, qty);
                stmt.setInt(4, cid);
                if (testworkaroundFor51519 && time != null) {
                    stmt.setTimestamp(5, time, TradeTxHistoryDMLStmt.getCal());
                } else {
                    stmt.setTimestamp(5, time);
                }
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleting trade.txhistory with QTY:" + qty + ",PRICE:" + price + ",CID:" + cid + ",ORDERTIME:" + time + query);
                break;
            }
            case 8: {
                Log.getLogWriter().info(database + "deleting trade.txhistory with QTY:" + qty + ",PRICE:" + price + query);
                stmt.setInt(1, qty);
                stmt.setBigDecimal(2, price);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows trade.txhistory  QTY:" + qty + ",PRICE:" + price + query);
                break;
            }
            case 9: {
                Log.getLogWriter().info(database + "deleting trade.txhistory with ORDERTIME:" + time + ",SID:" + sid + ",CID:" + cid + query);
                if (testworkaroundFor51519 && time != null) {
                    stmt.setTimestamp(1, time, TradeTxHistoryDMLStmt.getCal());
                } else {
                    stmt.setTimestamp(1, time);
                }
                stmt.setInt(2, sid);
                stmt.setInt(3, cid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + "rows trade.txhistory ORDERTIME:" + time + ",SID:" + sid + ",CID:" + cid + query);
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    @Override
    public void populate(Connection dConn, Connection gConn) {
        boolean persistTable = TestConfig.tab().booleanAt(FabricServerPrms.persistTables, false);
        if (persistTable) {
            int initSize = 30;
            this.populate(dConn, gConn, initSize);
        } else {
            super.populate(dConn, gConn);
        }
    }

    @Override
    public void put(Connection dConn, Connection gConn, int size) {
        this.insert(dConn, gConn, size, true);
    }
}

