/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements.json;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.MasterController;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.dmlStatements.TradeBuyOrdersDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradeBuyOrderDMLStmtJson
extends TradeBuyOrdersDMLStmt {
    protected static String columns = "oid,cid,sid,qty,bid,ordertime,json_evalPath(json_details,'$..status') as status,tid";
    protected static String[] selectJSON = new String[]{"select " + columns + " from trade.buyorders where   json_evalPath(json_details,'$..status') = 'open' and tid = ?", "select cid, bid, cid, sid from trade.buyorders where  cast(json_evalPath(json_details,'$..cid') as integer) >? and cast(json_evalPath(json_details,'$..sid') as integer) <? and qty >? and orderTime<? and tid = ?", "select sid, count(*) from trade.buyorders  where status =? and tid =? GROUP BY sid HAVING count(*) >=1", "select cid , min( cast(json_evalPath(json_details,'$..qty') as integer)*bid) as smallest_order from trade.buyorders  where status =? and tid =? GROUP BY cid", "select cid, cast (avg( cast(json_evalPath(json_details,'$..qty') as integer)*bid) as decimal (30, 20)) as amount from trade.buyorders  where  cast(json_evalPath(json_details,'$..status') as varchar(10)) =? and tid =? GROUP BY cid ORDER BY amount", "select cid, max( qty*bid) as largest_order from trade.buyorders  where status =? and tid =?  GROUP BY cid HAVING max(qty*bid) > 2000 ORDER BY largest_order DESC, cid DESC ", "select cast(json_evalPath(b1.json_details,'$..oid') as integer) as oid, b1.cid, b1.sid, cast(json_evalPath(b1.json_details,'$..qty') as integer) as qty, b1.tid, cast(json_evalPath(b2.json_details,'$..oid') as integer) as oid2, b2.cid, b2.sid, cast(json_evalPath(b2.json_details,'$..qty') as integer) as qty2, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.tid = ? and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid", "select cid , tid, json_evalPath(json_evalPath (buyorder_json,'$..buyorder[?(@.status == open)]') , '$..[?(@.oid == ?)]' ), status from trade.customers where  json_evalattribute(json_evalPath (buyorder_json,'$..buyorder[?(@.status == open)]') , '$..[?(@.oid == ?)]' ) and tid = ?  order by cid", "select cid, bid, cid, sid from trade.buyorders where cid >?  and sid <? and qty >? and orderTime<?  ", "select sid, count(*) from trade.buyorders  where status =? GROUP BY sid HAVING count(*) >=1", "select cid,count(sid) from trade.buyorders  where status =? GROUP BY cid", "select cid, cast (avg(qty*bid) as decimal (30, 20)) as amount from trade.buyorders  where status =? GROUP BY cid ORDER BY amount", "select cid, max(qty*bid) as largest_order from trade.buyorders  where status =? GROUP BY cid HAVING max(qty*bid) > 20000 ORDER BY max(qty*bid), cid DESC ", "select b1.oid, b1.cid, b1.sid, b1.qty, b1.tid, b2.oid, b2.cid, b2.sid, b2.qty, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid"};
    protected static String[] selectwoaggreateJSON = new String[]{"select " + columns + "from trade.buyorders where  json_evalPath(json_details,'$..status')  = 'open' and tid = ?", "select cid, bid, cid, sid from trade.buyorders where cast(json_evalPath(json_details,'$..cid') as integer) >? and cast(json_evalPath(json_details,'$..sid') as integer) <? and qty >? and orderTime<? and tid = ?", "select" + columns + " from trade.buyorders  where json_evalPath(json_details,'$..status')  =? and tid =? order by sid", "select " + columns + " from trade.buyorders  where json_evalPath(json_details,'$..status') =? and tid =? order by cid", "select cid , ( json_evalPath(json_details,'$..qty') *bid) as totalAmt from trade.buyorders  where status =? and tid =? order by cid, oid, sid", "select " + columns + "  from trade.buyorders  where status =? and tid =? order by cid", "select b1.oid as oid, b1.cid, b1.sid, b1.qty as qty, b1.tid, b2.oid as oid2, b2.cid, b2.sid, b2.qty as qty2, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.tid = ? and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid", "select  " + columns + " from trade.buyorders", "select cid, bid, cid, sid from trade.buyorders where cid >?  and sid <? and qty >? and orderTime<?  ", "select sid, count(*) from trade.buyorders  where status =? GROUP BY sid HAVING count(*) >=1", "select cid,count(sid) from trade.buyorders  where status =? GROUP BY cid", "select cid, cast (avg(qty*bid) as decimal (30, 20)) as amount from trade.buyorders  where status =? GROUP BY cid ORDER BY amount", "select cid, max(qty*bid) as largest_order from trade.buyorders  where status =? GROUP BY cid HAVING max(qty*bid) > 20000 ORDER BY max(qty*bid), cid DESC ", "select b1.oid, b1.cid, b1.sid, b1.qty, b1.tid, b2.oid, b2.cid, b2.sid, b2.qty, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid"};
    protected static String[] select = new String[]{"select * from trade.buyorders where status = 'open' and tid = ?", "select cid, bid, cid, sid from trade.buyorders where cid >? and sid <? and qty >? and orderTime<? and tid = ?", "select sid, count(*) from trade.buyorders  where status =? and tid =? GROUP BY sid HAVING count(*) >=1", "select cid, min(qty*bid) as smallest_order from trade.buyorders  where status =? and tid =? GROUP BY cid", "select cid, cast (avg(qty*bid) as decimal (30, 20)) as amount from trade.buyorders  where status =? and tid =? GROUP BY cid ORDER BY amount", "select cid, max(qty*bid) as largest_order from trade.buyorders  where status =? and tid =?  GROUP BY cid HAVING max(qty*bid) > 2000 ORDER BY largest_order DESC, cid DESC ", "select b1.oid as oid, b1.cid, b1.sid, b1.qty as qty, b1.tid, b2.oid as oid2, b2.cid, b2.sid, b2.qty as qty2, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.tid = ? and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid", "select * from trade.buyorders", "select cid, bid, cid, sid from trade.buyorders where cid >?  and sid <? and qty >? and orderTime<?  ", "select sid, count(*) from trade.buyorders  where status =? GROUP BY sid HAVING count(*) >=1", "select cid,count(sid) from trade.buyorders  where status =? GROUP BY cid", "select cid, cast (avg(qty*bid) as decimal (30, 20)) as amount from trade.buyorders  where status =? GROUP BY cid ORDER BY amount", "select cid, max(qty*bid) as largest_order from trade.buyorders  where status =? GROUP BY cid HAVING max(qty*bid) > 20000 ORDER BY max(qty*bid), cid DESC ", "select b1.oid, b1.cid, b1.sid, b1.qty, b1.tid, b2.oid, b2.cid, b2.sid, b2.qty, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid"};
    protected static String[] selectwoaggreate = new String[]{"select * from trade.buyorders where status = 'open' and tid = ?", "select cid, bid, cid, sid from trade.buyorders where cid >? and sid <? and qty >? and orderTime<? and tid = ?", "select * from trade.buyorders  where status =? and tid =? order by sid", "select * from trade.buyorders  where status =? and tid =? order by cid", "select cid,  (qty*bid) as totalAmt  from trade.buyorders  where status =? and tid =? order by cid, oid, sid", "select * from trade.buyorders  where status =? and tid =? order by cid", "select b1.oid as oid, b1.cid, b1.sid, b1.qty as qty, b1.tid, b2.oid as oid2, b2.cid, b2.sid, b2.qty as qty2, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.tid = ? and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid", "select * from trade.buyorders", "select cid, bid, cid, sid from trade.buyorders where cid >?  and sid <? and qty >? and orderTime<?  ", "select sid, count(*) from trade.buyorders  where status =? GROUP BY sid HAVING count(*) >=1", "select cid,count(sid) from trade.buyorders  where status =? GROUP BY cid", "select cid, cast (avg(qty*bid) as decimal (30, 20)) as amount from trade.buyorders  where status =? GROUP BY cid ORDER BY amount", "select cid, max(qty*bid) as largest_order from trade.buyorders  where status =? GROUP BY cid HAVING max(qty*bid) > 20000 ORDER BY max(qty*bid), cid DESC ", "select b1.oid, b1.cid, b1.sid, b1.qty, b1.tid, b2.oid, b2.cid, b2.sid, b2.qty, b2.tid from trade.buyorders b1, trade.buyorders b2 where b1.cid = b2.cid and b1.sid = b2.sid and b1.qty < b2.qty and b1.oid < b2.oid"};
    protected static String insertJSON = "insert into trade.buyorders values (?,?,?,?,?,?,?,?,?)";
    protected static String putJSON = "put into trade.buyorders values (?,?,?,?,?,?,?,?,?)";
    protected static String[] updateJSON = new String[]{"update trade.buyorders set status = 'filled'  where sid = ? and bid>? and status = 'open' and tid = ? ", "update trade.buyorders set status = 'cancelled' where (ordertime >? or sid=?) and status = 'open' and tid =? ", "update trade.buyorders set bid = ? where cid = ? and sid= ? and status = 'open' and qty >? and tid =? ", "update trade.buyorders set bid = ? , qty=? where cid = ? and sid= ? and bid <? and status = 'open' and tid =? ", "update trade.buyorders set sid = ? where cid = ? and sid= ? and status = 'open' and tid =? ", "update trade.buyorders set status = 'filled'  where sid = ? and bid>? and status = 'open' ", "update trade.buyorders set status = 'cancelled' where (ordertime <? or sid=?) and status = 'open'  ", "update trade.buyorders set bid = ? where cid = ? and sid= ? and status = 'open' and qty >? ", "update trade.buyorders set bid = ? , qty=? where cid = ? and sid= ? and bid <? and status = 'open'  ", "update trade.buyorders set sid = ? where cid = ? and sid= ? and status = 'open'  "};
    protected static String[] deleteJSON = new String[]{"delete from trade.buyorders where cid=? and sid=? and tid=?", "delete from trade.buyorders where oid=? and (bid <? or qty>?) and tid=?", "delete from trade.buyorders where (status ='cancelled' or status = 'filled' or qty<?) and bid>? and tid=?", "delete from trade.buyorders where cid=? and sid=?", "delete from trade.buyorders where oid=? and (bid <? or qty>?) ", "delete from trade.buyorders where (status ='cancelled' or status = 'filled' or qty<?) and bid>?"};
    protected static String insert = "insert into trade.buyorders values (?,?,?,?,?,?,?,?)";
    protected static String put = "put into trade.buyorders values (?,?,?,?,?,?,?,?)";
    LinkedList<Integer> listOfOids = new LinkedList();

    @Override
    public void insert(Connection dConn, Connection gConn, int size, int[] cids, boolean isPut) {
        boolean usebatch = false;
        if (SQLTest.syncHAForOfflineTest) {
            usebatch = false;
            size = 1;
        }
        int[] cid = new int[size];
        for (int i = 0; i < size; ++i) {
            cid[i] = cids[0];
        }
        int[] oid = new int[size];
        int[] sid = new int[size];
        int[] qty = new int[size];
        String status = "open";
        Timestamp[] time = new Timestamp[size];
        BigDecimal[] bid = new BigDecimal[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success;
            if (gConn == null || rand.nextInt(numGettingDataFromDerby) == 1) {
                this.getDataForInsert(dConn, oid, cid, sid, qty, time, bid, size);
            } else {
                this.getDataForInsert(gConn, oid, cid, sid, qty, time, bid, size);
            }
            if (hasHdfs) {
                for (int id : sid) {
                    if (id != 0) continue;
                    Log.getLogWriter().info("do not insert 0 for hdfs tests when fk was taken out due to #49452");
                    return;
                }
            }
            if (usebatch) {
                for (int id : sid) {
                    if (id != 0) continue;
                    Log.getLogWriter().info("could not get enough valid sid for batching insert");
                    return;
                }
                success = this.insertToDerbyTableUsingBatch(dConn, oid, cid, sid, qty, status, time, bid, size, exceptionList);
            } else {
                success = this.insertToDerbyTable(dConn, oid, cid, sid, qty, status, time, bid, size, exceptionList);
            }
            if (!success) {
                Log.getLogWriter().info("Could not finish the op in derby, will abort this operation in derby");
                this.rollback(dConn);
                if (!alterTableDropColumn || SQLTest.alterTableException.get() == null || !((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                    return;
                }
            }
            if (gConn == null) {
                Log.getLogWriter().info("connection is null, must be a load test");
                return;
            }
            try {
                if (usebatch) {
                    this.insertToGfxdTableUsingBatch(gConn, oid, cid, sid, qty, status, time, bid, size, exceptionList, isPut);
                } else {
                    this.insertToGFETable(gConn, oid, cid, sid, qty, status, time, bid, size, exceptionList, isPut);
                }
            }
            catch (TestException te) {
                if (te.getMessage().contains("Execute SQL statement failed with: 23505") && isHATest && SQLTest.isEdge) {
                    try {
                        this.checkTicket49605(dConn, gConn, "buyorders");
                    }
                    catch (TestException e) {
                        Log.getLogWriter().info("insert failed due to #49605", (Throwable)e);
                        Log.getLogWriter().info("retry this using put to work around #49605");
                        if (usebatch) {
                            this.insertToGfxdTableUsingBatch(gConn, oid, cid, sid, qty, status, time, bid, size, exceptionList, true);
                        } else {
                            this.insertToGFETable(gConn, oid, cid, sid, qty, status, time, bid, size, exceptionList, true);
                        }
                        this.checkTicket49605(dConn, gConn, "buyorders");
                    }
                }
                throw te;
            }
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.getDataForInsert(gConn, oid, cid, sid, qty, time, bid, size);
            if (hasHdfs) {
                for (int id : sid) {
                    if (id != 0) continue;
                    Log.getLogWriter().info("do not insert 0 for hdfs tests when fk was taken out due to #49452");
                    return;
                }
            }
            this.insertToGFETable(gConn, oid, cid, sid, qty, status, time, bid, size, isPut);
        }
    }

    @Override
    protected void insertToGFETable(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String status, Timestamp[] time, BigDecimal[] bid, int size, List<SQLException> exceptions, boolean isPut) {
        PreparedStatement stmt = TradeBuyOrderDMLStmtJson.getStmt(conn, isPut ? putJSON : insertJSON);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeBuyOrderDMLStmtJson.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, oid[i], cid[i], sid[i], qty[i], status, time[i], bid[i], tid, isPut);
                if (count == (Integer)verifyRowCount.get(tid + "_insert" + i)) continue;
                Log.getLogWriter().info("Gfxd insert to buyorders has different row count from that of derby derby inserted " + (Integer)verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count);
                continue;
            }
            catch (SQLException se) {
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    @Override
    protected void insertToGFETable(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String status, Timestamp[] time, BigDecimal[] bid, int size, boolean isPut) {
        PreparedStatement stmt = SQLTest.hasJSON ? TradeBuyOrderDMLStmtJson.getStmt(conn, isPut ? putJSON : insertJSON) : TradeBuyOrderDMLStmtJson.getStmt(conn, isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeBuyOrderDMLStmtJson.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, oid[i], cid[i], sid[i], qty[i], status, time[i], bid[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("detected the foreign key constraint violation, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42802")) {
                    Log.getLogWriter().info("Got expected column not found exception in insert, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("23505") && isHATest && SQLTest.isEdge) {
                    Log.getLogWriter().info("detected pk constraint violation during insert -- relaxing due to #43571, continuing test");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    @Override
    protected void addBatchInsert(PreparedStatement stmt, int oid, int cid, int sid, int qty, String status, Timestamp time, BigDecimal bid, int tid, boolean isPut) throws SQLException {
        JSONObject json = new JSONObject();
        String jsonLog = "";
        if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
            json = this.getJSONObject(oid, cid, sid, qty, status, time, bid, tid);
            jsonLog = ",JSON_DETAILS: " + json.toJSONString();
        }
        Log.getLogWriter().info((SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ") + (isPut ? "putting " : "inserting ") + " into trade.buyorders with data OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",STATUS:" + status + ",TIME:" + time + ",BID:" + bid + ",TID:" + tid + jsonLog);
        stmt.setInt(1, oid);
        stmt.setInt(2, cid);
        stmt.setInt(3, sid);
        stmt.setInt(4, qty);
        stmt.setBigDecimal(5, bid);
        stmt.setTimestamp(6, time);
        stmt.setString(7, status);
        stmt.setInt(8, tid);
        if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
            Clob jsonClob = stmt.getConnection().createClob();
            jsonClob.setString(1L, json.toJSONString());
            stmt.setClob(9, jsonClob);
        }
        stmt.addBatch();
    }

    @Override
    protected void insertToGfxdTableUsingBatch(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String status, Timestamp[] time, BigDecimal[] bid, int size, List<SQLException> exceptions, boolean isPut) {
        PreparedStatement stmt = SQLTest.hasJSON ? TradeBuyOrderDMLStmtJson.getStmt(conn, isPut ? putJSON : insertJSON) : TradeBuyOrderDMLStmtJson.getStmt(conn, isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeBuyOrderDMLStmtJson.getMyTid();
        int[] counts = null;
        for (int i = 0; i < size; ++i) {
            try {
                this.addBatchInsert(stmt, oid[i], cid[i], sid[i], qty[i], status, time[i], bid[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
        try {
            counts = stmt.executeBatch();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] != -3) {
                JSONObject json = new JSONObject();
                String jsonLog = "";
                if (SQLTest.hasJSON) {
                    json = this.getJSONObject(oid[i], cid[i], sid[i], qty[i], status, time[i], bid[i], tid);
                    jsonLog = ",JSON_DETAILS: " + json.toJSONString();
                }
                Log.getLogWriter().info("gemfirexd - inserted" + counts[i] + " rows in trade.buyorders OID:" + oid[i] + ",CID:" + cid[i] + ",SID:" + sid[i] + ",QTY:" + qty[i] + ",STATUS:" + status + ",TIME:" + time[i] + ",BID:" + bid[i] + ",TID:" + tid + jsonLog);
                if (counts[i] == (Integer)verifyRowCount.get(tid + "_insert" + i)) continue;
                Log.getLogWriter().warning("gemfirexd insert to buyorders has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + counts[i]);
                continue;
            }
            Log.getLogWriter().warning("gfxd failed to update in batch update");
        }
    }

    @Override
    protected int insertToTable(PreparedStatement stmt, int oid, int cid, int sid, int qty, String status, Timestamp time, BigDecimal bid, int tid, boolean isPut) throws SQLException {
        SQLWarning warning;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd -  ";
        JSONObject json = new JSONObject();
        String jsonLog = "";
        if (!SQLHelper.isDerbyConn(stmt.getConnection())) {
            json = this.getJSONObject(oid, cid, sid, qty, status, time, bid, tid);
            jsonLog = ",JSON_DETAILS: " + json.toJSONString();
        }
        Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.buyorders with OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",STATUS:" + status + ",TIME:" + time + ",BID:" + bid + ",TID:" + tid + jsonLog);
        stmt.setInt(1, oid);
        stmt.setInt(2, cid);
        stmt.setInt(3, sid);
        stmt.setInt(4, qty);
        stmt.setBigDecimal(5, bid);
        stmt.setTimestamp(6, time);
        stmt.setString(7, status);
        stmt.setInt(8, tid);
        if (!SQLHelper.isDerbyConn(stmt.getConnection())) {
            Clob jsonClob = stmt.getConnection().createClob();
            jsonClob.setString(1L, json.toJSONString());
            stmt.setClob(9, jsonClob);
        }
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows in trade.buyorders with OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",STATUS:" + status + ",TIME:" + time + ",BID:" + bid + ",TID:" + tid + jsonLog);
        if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection()) && !SQLTest.hasTx && !setCriticalHeap) {
            this.insertUpdateCustomerJson(stmt.getConnection(), cid, json);
        }
        if ((warning = stmt.getWarnings()) != null) {
            SQLHelper.printSQLWarning(warning);
        }
        if (database.contains("gemfirexd") && isPut) {
            if (!SQLTest.ticket49794fixed) {
                this.insertToBuyordersFulldataset(stmt.getConnection(), oid, cid, sid, qty, bid, time, status, tid);
            }
            Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.buyorders with OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",STATUS:" + status + ",TIME:" + time + ",BID:" + bid + ",TID:" + tid + jsonLog);
            rowCount = stmt.executeUpdate();
            Log.getLogWriter().info(database + (isPut ? "put" : "inserted") + rowCount + " rows in trade.buyorders with OID:" + oid + ",CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",STATUS:" + status + ",TIME:" + time + ",BID:" + bid + ",TID:" + tid + jsonLog);
            warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        return rowCount;
    }

    @Override
    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys, boolean[] unsupported) {
        PreparedStatement stmt = null;
        String[] update = !SQLHelper.isDerbyConn(conn) ? updateJSON : TradeBuyOrderDMLStmtJson.update;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("status")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrderDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("status")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrderDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("bid")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrderDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("bid") || partitionKeys.contains("qty")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrderDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                if (partitionKeys.contains("sid")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrderDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 5: {
                if (partitionKeys.contains("status")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrderDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 6: {
                if (partitionKeys.contains("status")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrderDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 7: {
                if (partitionKeys.contains("bid")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrderDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 8: {
                if (partitionKeys.contains("bid") || partitionKeys.contains("qty")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrderDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 9: {
                if (partitionKeys.contains("sid")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeBuyOrderDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    @Override
    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] newSid, int[] qty, Timestamp[] orderTime, BigDecimal[] bid, BigDecimal[] bid2, int[] whichUpdate, int size, List<SQLException> exList) {
        PreparedStatement stmt = null;
        int tid = TradeBuyOrderDMLStmtJson.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i], null) : (SQLTest.hasJSON ? TradeBuyOrderDMLStmtJson.getStmt(conn, updateJSON[whichUpdate[i]]) : TradeBuyOrderDMLStmtJson.getStmt(conn, update[whichUpdate[i]]));
            if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
                SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
            if (setCriticalHeap && stmt == null) {
                return;
            }
            try {
                if (stmt == null || (count = this.updateTable(stmt, cid[i], sid[i], newSid[i], qty[i], orderTime[i], bid[i], bid2[i], tid, whichUpdate[i])) == (Integer)verifyRowCount.get(tid + "_update" + i)) continue;
                Log.getLogWriter().info("Gfxd update has different row count from that of derby derby updated " + (Integer)verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + count);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exList);
            }
        }
    }

    @Override
    protected void updateGFETable(Connection conn, int[] cid, int[] sid, int[] newSid, int[] qty, Timestamp[] orderTime, BigDecimal[] bid, BigDecimal[] bid2, int[] whichUpdate, int size) {
        PreparedStatement stmt = null;
        int tid = TradeBuyOrderDMLStmtJson.getMyTid();
        for (int i = 0; i < size; ++i) {
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i], null) : TradeBuyOrderDMLStmtJson.getStmt(conn, updateJSON[whichUpdate[i]]);
            try {
                if (stmt == null) continue;
                this.updateTable(stmt, cid[i], sid[i], newSid[i], qty[i], orderTime[i], bid[i], bid2[i], tid, whichUpdate[i]);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503") && (whichUpdate[i] == 4 || whichUpdate[i] == 9)) {
                    Log.getLogWriter().info("detected foreign key constraint violation during update, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && (se.getSQLState().equals("42X14") || se.getSQLState().equals("42X04"))) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    @Override
    protected int updateTable(PreparedStatement stmt, int cid, int sid, int newSid, int qty, Timestamp orderTime, BigDecimal bid, BigDecimal bid2, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + update[whichUpdate];
        if (!SQLHelper.isDerbyConn(stmt.getConnection())) {
            query = " QUERY: " + updateJSON[whichUpdate];
        }
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info(database + "updating trade.buyorders with STATUS:filled where SID:" + sid + ",BID:" + bid + ",STATUS:open,TID:" + tid + query);
                stmt.setInt(1, sid);
                stmt.setBigDecimal(2, bid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection()) && bid != null) {
                    this.updateBuyordersJson(stmt.getConnection(), " where sid = " + sid + " and bid> " + bid + " and status = 'filled' and tid = " + tid);
                }
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with STATUS:filled where SID:" + sid + ",BID:" + bid + ",STATUS:open,TID:" + tid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "updating trade.buyorders with STATUS:cancelled where ORDERTIME:" + orderTime + ",SID:" + sid + ",TID:" + tid + query);
                stmt.setTimestamp(1, orderTime);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    this.updateBuyordersJson(stmt.getConnection(), " where ( ordertime > '" + orderTime + "' or sid= " + sid + " ) and status = 'cancelled' and tid =" + tid);
                }
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders STATUS:cancelled where ORDERTIME:" + orderTime + ",SID:" + sid + ",TID:" + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "updating trade.buyorders with BID:" + bid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,QTY:" + qty + ",TID:" + tid + query);
                stmt.setBigDecimal(1, bid);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                stmt.setInt(4, qty);
                stmt.setInt(5, tid);
                rowCount = stmt.executeUpdate();
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection()) && bid != null) {
                    this.updateBuyordersJson(stmt.getConnection(), " where cid = " + cid + " and sid= " + sid + " and status = 'open' and qty > " + qty + " and tid = " + tid);
                }
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with BID:" + bid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,QTY:" + qty + ",TID:" + tid + query);
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "updating trade.buyorders with BID:" + bid + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",BID:" + bid2 + ",STATUS:open,TID:" + tid + query);
                stmt.setBigDecimal(1, bid);
                stmt.setInt(2, qty);
                stmt.setInt(3, cid);
                stmt.setInt(4, sid);
                stmt.setBigDecimal(5, bid2);
                stmt.setInt(6, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with BID:" + bid + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",BID:" + bid2 + ",STATUS:open,TID:" + tid + query);
                if (!(SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) || bid == null) break;
                this.updateBuyordersJson(stmt.getConnection(), " where cid = " + cid + " and sid= " + sid + "  and bid = " + bid + "  and status = 'open' and tid = " + tid);
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "updating trade.buyorders with SID:" + newSid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,TID: " + tid + query);
                stmt.setInt(1, newSid);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with SID:" + newSid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,TID: " + tid + query);
                if (!(SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection()))) break;
                this.updateBuyordersJson(stmt.getConnection(), " where cid = " + cid + " and sid= " + newSid + "  and status = 'open' and tid = " + tid);
                break;
            }
            case 5: {
                Log.getLogWriter().info(database + "updating trade.buyorders with STATUS:filled where SID:" + sid + ",BID:" + bid + ",STATUS:open" + query);
                stmt.setInt(1, sid);
                stmt.setBigDecimal(2, bid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with STATUS:filled where SID:" + sid + ",BID:" + bid + ",STATUS:open" + query);
                if (!(SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection()))) break;
                this.updateBuyordersJson(stmt.getConnection(), " where cid = " + cid + " and sid= " + sid + "  and bid > " + bid + "  and status = 'filled' ");
                break;
            }
            case 6: {
                Log.getLogWriter().info(database + "updating trade.buyorders with STATUS:cancelled where ORDERTIME:" + orderTime + ",SID:" + sid + ",STATUS:open" + query);
                stmt.setTimestamp(1, orderTime);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders  with STATUS:cancelled where ORDERTIME:" + orderTime + ",SID:" + sid + ",STATUS:open" + query);
                if (!(SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection()))) break;
                this.updateBuyordersJson(stmt.getConnection(), " where ordertime< '" + orderTime + "' and sid= " + sid + "  and status = 'cancelled'");
                break;
            }
            case 7: {
                Log.getLogWriter().info(database + "updating on trade.buyorders with BID:" + bid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,QTY:" + qty + query);
                stmt.setBigDecimal(1, bid);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                stmt.setInt(4, qty);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with BID:" + bid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open,QTY:" + qty + query);
                if (!(SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection()))) break;
                this.updateBuyordersJson(stmt.getConnection(), " where cid = " + cid + " and sid= " + sid + "  and status = 'open' and qty> " + qty);
                break;
            }
            case 8: {
                Log.getLogWriter().info(database + "updating trade.buyorders with BID:" + bid + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",BID:" + bid2 + ",STATUS:open" + query);
                stmt.setBigDecimal(1, bid);
                stmt.setInt(2, qty);
                stmt.setInt(3, cid);
                stmt.setInt(4, sid);
                stmt.setBigDecimal(5, bid2);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders with BID:" + bid + ",QTY:" + qty + " where CID:" + cid + ",SID:" + sid + ",BID:" + bid2 + ",STATUS:open" + query);
                if (!(SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection()))) break;
                this.updateBuyordersJson(stmt.getConnection(), " where cid = " + cid + " and sid= " + sid + "  and bid = " + bid + "  and status = 'open' ");
                break;
            }
            case 9: {
                Log.getLogWriter().info(database + "updating trade.buyorders with SID:" + newSid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open" + query);
                stmt.setInt(1, newSid);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.buyorders  with SID:" + newSid + " where CID:" + cid + ",SID:" + sid + ",STATUS:open" + query);
                if (!(SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection()))) break;
                this.updateBuyordersJson(stmt.getConnection(), " where cid = " + cid + " and sid= " + newSid + "  and status = 'open' ");
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, int oid, String status, BigDecimal bid, int qty, int cid, int sid, Timestamp orderTime, int tid, boolean[] success) throws SQLException {
        Boolean dumpResult = (Boolean)dumpNoAggregateRs.get();
        Boolean dumpQueryPlan = (Boolean)dumpQueryPlanRs.get();
        String sql = dumpResult != null && dumpResult.booleanValue() ? (!SQLHelper.isDerbyConn(conn) ? selectwoaggreateJSON[whichQuery] : selectwoaggreate[whichQuery]) : (dumpQueryPlan != null && dumpQueryPlan != false ? "explain " + (!SQLHelper.isDerbyConn(conn) ? selectJSON[whichQuery] : select[whichQuery]) : (!SQLHelper.isDerbyConn(conn) ? selectJSON[whichQuery] : select[whichQuery]));
        Log.getLogWriter().info("query selected is " + sql);
        return TradeBuyOrderDMLStmtJson.getQuery(conn, whichQuery, oid, status, bid, qty, cid, sid, orderTime, tid, success, sql);
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, int oid, String status, BigDecimal bid, int qty, int cid, int sid, Timestamp orderTime, int tid, boolean[] success, String sql) throws SQLException {
        ResultSet rs = null;
        success[0] = true;
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + select[whichQuery];
        if (!SQLHelper.isDerbyConn(conn)) {
            query = " QUERY: " + selectJSON[whichQuery];
        }
        int i = 1;
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with TID:" + tid + query);
                    stmt.setInt(i++, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with  CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",ORDERTIME:" + orderTime + ",TID:" + tid + query);
                    stmt.setInt(i++, cid);
                    stmt.setInt(i++, sid);
                    stmt.setInt(i++, qty);
                    stmt.setTimestamp(i++, orderTime);
                    stmt.setInt(i++, tid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + ",TID:" + tid + query);
                    stmt.setString(i++, status);
                    stmt.setInt(i++, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + ",TID:" + tid + query);
                    stmt.setString(i++, status);
                    stmt.setInt(i++, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + ",TID:" + tid + query);
                    stmt.setString(i++, status);
                    stmt.setInt(i++, tid);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + ",TID:" + tid + query);
                    stmt.setString(i++, status);
                    stmt.setInt(i++, tid);
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with TID:" + tid + query);
                    stmt.setInt(i++, tid);
                    break;
                }
                case 7: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with no data" + query);
                    break;
                }
                case 8: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with CID:" + cid + ",SID:" + sid + ",QTY:" + qty + ",ORDERTIME:" + orderTime + ",TID:" + tid + query);
                    stmt.setInt(i++, cid);
                    stmt.setInt(i++, sid);
                    stmt.setInt(i++, qty);
                    stmt.setTimestamp(i++, orderTime);
                    break;
                }
                case 9: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + query);
                    stmt.setString(i++, status);
                    break;
                }
                case 10: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + query);
                    stmt.setString(i++, status);
                    break;
                }
                case 11: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + query);
                    stmt.setString(i++, status);
                    break;
                }
                case 12: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:" + status + query);
                    stmt.setString(i++, status);
                    break;
                }
                case 13: {
                    Log.getLogWriter().info(database + "querying trade.buyorders with no data" + query);
                    break;
                }
                case 14: {
                    if (SQLHelper.isDerbyConn(conn)) {
                        Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:open, OID:" + oid + ",TID: " + tid + "select cid,tid,oid,status from trade.buyorders where status = 'open' and oid = ? and tid = ? order by cid ");
                        stmt = conn.prepareStatement("select cid,tid,oid,status from trade.buyorders where status = 'open' and oid = ? and tid = ? order by cid ");
                        stmt.setInt(1, oid);
                        stmt.setInt(2, tid);
                        break;
                    }
                    Log.getLogWriter().info(database + "querying trade.buyorders with STATUS:open, OID:" + oid + ",TID: " + tid + " select cid,tid,cast(json_evalPath(json_evalPath(buyorder_json, '$..buyorder[?(@.status = open)]'), '$..[?(@.oid = " + oid + ")].oid' ) as integer) as oid , cast(json_evalPath(json_evalPath(buyorder_json, '$..buyorder[?(@.status = open)]'), '$..[?(@.oid = " + oid + ")].status' ) as varchar(10)) from trade.customers where  tid = ? order by cid ");
                    stmt = conn.prepareStatement("select cid,tid,cast(json_evalPath(json_evalPath(buyorder_json, '$..buyorder[?(@.status = open)]'), '$..[?(@.oid = " + oid + ")].oid' ) as integer) as oid , cast(json_evalPath(json_evalPath(buyorder_json, '$..buyorder[?(@.status = open)]'), '$..[?(@.oid = " + oid + ")].status' ) as varchar(10)) as status from trade.customers where  tid = ? order by cid ");
                    stmt.setInt(1, tid);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            throw se;
        }
        return rs;
    }

    @Override
    protected boolean getDataFromResult(Connection conn, int[] cid, int[] sid, int tid) {
        int defaultCid = 0;
        int defaultSid = 0;
        int size = cid.length;
        boolean[] success = new boolean[1];
        int num = 20;
        int n = rand.nextInt(num);
        ResultSet rs = null;
        try {
            int whichQuery = 0;
            rs = TradeBuyOrderDMLStmtJson.getQuery(conn, whichQuery, 0, null, null, 0, 0, 0, null, tid, success);
            if (!success[0] || rs == null) {
                return false;
            }
            int i = 0;
            int temp = 0;
            while (rs.next() && i < size) {
                if (temp == 0) {
                    cid[i] = rs.getInt("CID");
                    sid[i] = rs.getInt("SID");
                } else if (n >= temp) {
                    cid[i] = rs.getInt("CID");
                    sid[i] = rs.getInt("SID");
                    ++i;
                }
                ++temp;
            }
            rs.close();
            while (i < size) {
                cid[i] = defaultCid;
                sid[i] = defaultSid;
                ++i;
            }
        }
        catch (SQLException se) {
            if (!SQLHelper.checkGFXDException(conn, se)) {
                return false;
            }
            if (SQLHelper.isAlterTableException(conn, se)) {
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void query(Connection dConn, Connection gConn) {
        Log.getLogWriter().info("in query 940");
        int numOfNonUniq = select.length / 2;
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        if (whichQuery == 6 || whichQuery == 13) {
            if (!SQLTest.testPartitionBy) {
                --whichQuery;
            } else {
                ArrayList partitionKey = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"buyordersPartition");
                if (!(partitionKey.size() == 1 && isTicket49116Fixed && (partitionKey.contains("cid") || partitionKey.contains("sid")) || partitionKey.size() == 0)) {
                    --whichQuery;
                }
            }
        }
        String status = statuses[rand.nextInt(statuses.length)];
        BigDecimal bid = this.getPrice();
        int[] oidArray = new int[10];
        this.getOids(oidArray, 1);
        int oid = oidArray[0];
        int qty = this.getQty();
        int cid = TradeBuyOrderDMLStmtJson.getCid();
        int sid = this.getSid();
        int tid = TradeBuyOrderDMLStmtJson.getMyTid();
        Timestamp orderTime = this.getRandTime();
        ResultSet discRS = null;
        ResultSet gfeRS = null;
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            try {
                Log.getLogWriter().info("calling json queries");
                discRS = TradeBuyOrderDMLStmtJson.query(dConn, whichQuery, oid, status, bid, qty, cid, sid, orderTime, tid);
                if (discRS == null) {
                    Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                    Log.getLogWriter().info("Could not finish the op in derby, will abort this operation in derby");
                    if (!alterTableDropColumn || SQLTest.alterTableException.get() == null || !((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                        return;
                    }
                }
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exceptionList);
            }
            try {
                gfeRS = TradeBuyOrderDMLStmtJson.query(gConn, whichQuery, oid, status, bid, qty, cid, sid, orderTime, tid);
                if (gfeRS == null) {
                    if (isHATest) {
                        Log.getLogWriter().info("Testing HA and did not get GFXD result set after retry");
                        return;
                    }
                    if (!setCriticalHeap) throw new TestException("Not able to get gfe result set after retry");
                    Log.getLogWriter().info("got XCL54 and does not get query result");
                    return;
                }
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptionList);
            }
            SQLHelper.handleMissedSQLException(exceptionList);
            if (discRS == null || gfeRS == null) {
                return;
            }
            boolean success = false;
            try {
                if (whichQuery == 5) {
                    success = ResultSetHelper.compareSortedResultSets(discRS, gfeRS);
                    if (!reproduce47943) {
                        return;
                    }
                    boolean logOrderByResult = true;
                    if (logOrderByResult) {
                        block52: {
                            try {
                                PreparedStatement sps = gConn.prepareStatement(select[5]);
                                sps.setString(1, status);
                                sps.setInt(2, tid);
                                gfeRS = sps.executeQuery();
                            }
                            catch (SQLException se) {
                                if (SQLHelper.checkGFXDException(gConn, se)) break block52;
                                Log.getLogWriter().info("Not able to dump result due to node failure");
                            }
                        }
                        List<Struct> gfxdList = ResultSetHelper.asList(gfeRS, false);
                        if (gfxdList != null) {
                            Log.getLogWriter().info("gemfirexd returns " + ResultSetHelper.listToString(gfxdList) + " QUERY : " + select[5]);
                        } else {
                            Log.getLogWriter().info("Not able to dump result due to node failure");
                        }
                    }
                    String offsetClause = " OFFSET 3 ROWS FETCH NEXT 2 ROWS ONLY";
                    String sql = select[5] + offsetClause;
                    try {
                        Log.getLogWriter().info("Derby - querying trade.buyorders QUERY: " + sql);
                        PreparedStatement dps = dConn.prepareStatement(sql);
                        dps.setString(1, status);
                        dps.setInt(2, tid);
                        discRS = dps.executeQuery();
                    }
                    catch (SQLException se) {
                        if (!SQLHelper.checkDerbyException(dConn, se)) {
                            Log.getLogWriter().info("Not able to get results due to node failure");
                            return;
                        }
                        SQLHelper.handleSQLException(se);
                    }
                    try {
                        Log.getLogWriter().info("gemfirexd - querying trade.buyorders QUERY: " + sql);
                        PreparedStatement sps = gConn.prepareStatement(sql);
                        sps.setString(1, status);
                        sps.setInt(2, tid);
                        gfeRS = sps.executeQuery();
                    }
                    catch (SQLException se) {
                        if (!SQLHelper.checkGFXDException(gConn, se)) {
                            Log.getLogWriter().info("Not able to get gfxd results due to node failure");
                            return;
                        }
                        SQLHelper.handleSQLException(se);
                    }
                    List<Struct> derbyList = ResultSetHelper.asList(discRS, true);
                    List<Struct> gfxdList = ResultSetHelper.asList(gfeRS, false);
                    if (derbyList != null && gfxdList != null) {
                        ResultSetHelper.compareResultSets(derbyList, gfxdList);
                    }
                } else {
                    success = ResultSetHelper.compareResultSets(discRS, gfeRS);
                }
                if (success) return;
                Log.getLogWriter().info("Not able to compare results due to derby server error");
                return;
            }
            catch (TestException te) {
                if (!te.getMessage().contains("elements were missing") && !te.getMessage().contains("unexpected elements") || whichQuery < 2 || whichQuery > 5) throw te;
                dumpNoAggregateRs.set((Object)true);
                try {
                    discRS = TradeBuyOrderDMLStmtJson.query(dConn, whichQuery, status, bid, qty, cid, sid, orderTime, tid);
                    List<Struct> derbyList = ResultSetHelper.asList(discRS, true);
                    if (derbyList != null) {
                        Log.getLogWriter().info("dump non-aggregate result from derby due to data mismatch:" + ResultSetHelper.listToString(derbyList));
                    } else {
                        Log.getLogWriter().info("not able to get derby results for dump");
                    }
                }
                catch (SQLException se) {
                    Log.getLogWriter().info("not able to get derby results for dump");
                }
                try {
                    gfeRS = TradeBuyOrderDMLStmtJson.query(gConn, whichQuery, status, bid, qty, cid, sid, orderTime, tid);
                    List<Struct> gfxdList = ResultSetHelper.asList(gfeRS, false);
                    if (gfxdList != null) {
                        Log.getLogWriter().info("dump non-aggregate result from gfxd due to data mismatch:" + ResultSetHelper.listToString(gfxdList));
                    } else {
                        Log.getLogWriter().info("not able to get gfxd results for dump");
                    }
                }
                catch (SQLException se) {
                    Log.getLogWriter().info("not able to get gfxd results for dump");
                }
                dumpNoAggregateRs.set((Object)false);
                dumpQueryPlanRs.set((Object)true);
                try {
                    gfeRS = TradeBuyOrderDMLStmtJson.query(gConn, whichQuery, status, bid, qty, cid, sid, orderTime, tid);
                    StringBuilder plan = new StringBuilder();
                    while (gfeRS.next()) {
                        plan.append(gfeRS.getString(1)).append('\n');
                    }
                    if (plan.length() > 0) {
                        Log.getLogWriter().info("dump query plan in gfxd due to data mismatch:" + plan);
                    } else {
                        Log.getLogWriter().info("no query plan in gfxd found");
                    }
                }
                catch (SQLException se) {
                    Log.getLogWriter().info("not able to get gfxd queryplan due to exception " + se.getSQLState(), (Throwable)se);
                }
                dumpQueryPlanRs.set((Object)false);
                throw te;
            }
        }
        try {
            gfeRS = TradeBuyOrderDMLStmtJson.query(gConn, whichQuery, status, bid, qty, cid, sid, orderTime, tid);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("42502") && SQLTest.testSecurity) {
                Log.getLogWriter().info("Got expected no SELECT permission, continuing test");
                return;
            }
            if (alterTableDropColumn && se.getSQLState().equals("42X04")) {
                Log.getLogWriter().info("Got expected column not found exception, continuing test");
                return;
            }
            SQLHelper.handleSQLException(se);
        }
        if (gfeRS != null) {
            ResultSetHelper.asList(gfeRS, false);
            return;
        } else if (isHATest) {
            Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            return;
        } else {
            if (!setCriticalHeap) throw new TestException("gfxd query returns null and not a HA test");
            Log.getLogWriter().info("could not get gfxd query results after retry due to XCL54");
        }
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, int oid, String status, BigDecimal bid, int qty, int cid, int sid, Timestamp orderTime, int tid) {
        ResultSet rs;
        block4: {
            boolean[] success = new boolean[1];
            rs = null;
            try {
                rs = TradeBuyOrderDMLStmtJson.getQuery(conn, whichQuery, oid, status, bid, qty, cid, sid, orderTime, tid, success);
                int count = 0;
                while (!success[0]) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                        return null;
                    }
                    ++count;
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    rs = TradeBuyOrderDMLStmtJson.getQuery(conn, whichQuery, oid, status, bid, qty, cid, sid, orderTime, tid, success);
                }
            }
            catch (SQLException se) {
                if (SQLHelper.isAlterTableException(conn, se)) break block4;
                SQLHelper.handleSQLException(se);
            }
        }
        return rs;
    }

    protected static ResultSet query(Connection conn, int whichQuery, int oid, String status, BigDecimal bid, int qty, int cid, int sid, Timestamp orderTime, int tid) throws SQLException {
        boolean[] success = new boolean[1];
        ResultSet rs = TradeBuyOrderDMLStmtJson.getQuery(conn, whichQuery, oid, status, bid, qty, cid, sid, orderTime, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = TradeBuyOrderDMLStmtJson.getQuery(conn, whichQuery, oid, status, bid, qty, cid, sid, orderTime, tid, success);
        }
        return rs;
    }

    @Override
    protected int deleteFromTable(PreparedStatement stmt, int cid, int sid, int oid, BigDecimal bid, int qty, int tid, int whichDelete) throws SQLException {
        SQLWarning warning;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + delete[whichDelete];
        if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
            query = " QUERY: " + deleteJSON[whichDelete];
        }
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with CID:" + cid + ",SID:" + sid + ",TID:" + tid + query);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    this.populateOids(stmt.getConnection(), "select oid from trade.buyorders  where cid=" + cid + " and sid=" + sid + " and tid=" + tid);
                }
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders CID:" + cid + ",SID:" + sid + ",TID:" + tid + query);
                if (!SQLTest.hasJSON || SQLHelper.isDerbyConn(stmt.getConnection()) || setCriticalHeap) break;
                this.deleteCustomerJson(stmt.getConnection());
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with OID:" + oid + ",BID:" + bid + ",QTY:" + qty + ",TID:" + tid + query);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    this.populateOids(stmt.getConnection(), "select oid from trade.buyorders  where oid= " + oid + " and (bid < " + bid + " or qty> " + qty + ") and tid=" + tid);
                }
                stmt.setInt(1, oid);
                stmt.setBigDecimal(2, bid);
                stmt.setInt(3, qty);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders OID:" + oid + ",BID:" + bid + ",QTY:" + qty + ",TID:" + tid + query);
                if (!SQLTest.hasJSON || SQLHelper.isDerbyConn(stmt.getConnection()) || setCriticalHeap) break;
                this.deleteCustomerJson(stmt.getConnection());
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with QTY:" + qty + ",BID:" + bid + ",TID:" + tid + query);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    this.populateOids(stmt.getConnection(), "select oid from trade.buyorders   where (status ='cancelled' or status = 'filled' or qty< " + qty + ") and bid>" + bid + " and tid= " + tid);
                }
                stmt.setInt(1, qty);
                stmt.setBigDecimal(2, bid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders QTY:" + qty + ",BID:" + bid + ",TID:" + tid + query);
                if (!SQLTest.hasJSON || SQLHelper.isDerbyConn(stmt.getConnection()) || setCriticalHeap) break;
                this.deleteCustomerJson(stmt.getConnection());
                break;
            }
            case 3: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with CID:" + cid + ",SID:" + sid + query);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    this.populateOids(stmt.getConnection(), "select oid from trade.buyorders  where cid=" + cid + " and sid=" + sid);
                }
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders CID:" + cid + ",SID:" + sid + query);
                if (!SQLTest.hasJSON || SQLHelper.isDerbyConn(stmt.getConnection()) || setCriticalHeap) break;
                this.deleteCustomerJson(stmt.getConnection());
                break;
            }
            case 4: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with OID:" + oid + ",BID:" + bid + ",QTY:" + qty + query);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    this.populateOids(stmt.getConnection(), "select oid from trade.buyorders  where oid= " + oid + " and (bid < " + bid + " or qty> " + qty + ")");
                }
                stmt.setInt(1, oid);
                stmt.setBigDecimal(2, bid);
                stmt.setInt(3, qty);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders OID:" + oid + ",BID:" + bid + ",QTY:" + qty + query);
                if (!SQLTest.hasJSON || SQLHelper.isDerbyConn(stmt.getConnection()) || setCriticalHeap) break;
                this.deleteCustomerJson(stmt.getConnection());
                break;
            }
            case 5: {
                Log.getLogWriter().info(database + "deleting trade.buyorders with QTY:" + qty + ",BID:" + bid + query);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    this.populateOids(stmt.getConnection(), "select oid from trade.buyorders   where (status ='cancelled' or status = 'filled' or qty< " + qty + ") and bid>" + bid);
                }
                stmt.setInt(1, qty);
                stmt.setBigDecimal(2, bid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.buyorders QTY:" + qty + ",BID:" + bid + query);
                if (!SQLTest.hasJSON || SQLHelper.isDerbyConn(stmt.getConnection()) || setCriticalHeap) break;
                this.deleteCustomerJson(stmt.getConnection());
                break;
            }
            default: {
                throw new TestException(database + "incorrect delete statement, should not happen");
            }
        }
        if ((warning = stmt.getWarnings()) != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    private JSONObject getJSONObject(int oid, int cid, int sid, int qty, String status, Timestamp time, BigDecimal bid, int tid) {
        JSONObject json = new JSONObject();
        json.put((Object)"oid", (Object)oid);
        json.put((Object)"cid", (Object)cid);
        json.put((Object)"sid", (Object)sid);
        json.put((Object)"qty", (Object)qty);
        json.put((Object)"status", (Object)status);
        json.put((Object)"time", (Object)time.getTime());
        json.put((Object)"bid", (Object)bid);
        json.put((Object)"tid", (Object)tid);
        return json;
    }

    private void updateBuyordersJson(Connection conn, String whereClause) throws SQLException {
        String query = "select cid,sid,qty,status,ordertime,bid,tid , oid , json_details  from trade.buyorders " + whereClause;
        Log.getLogWriter().info("Executing ... " + query);
        String oids = "";
        String jsonDetails = "";
        String sep = System.getProperty("line.separator");
        try {
            List<List<Object>> list = this.executeQueryGetList(conn, query);
            for (List<Object> obj : list) {
                JSONObject json = new JSONObject();
                json.put((Object)"cid", obj.get(0));
                json.put((Object)"oid", obj.get(7));
                json.put((Object)"sid", obj.get(1));
                json.put((Object)"qty", obj.get(2));
                json.put((Object)"status", obj.get(3));
                json.put((Object)"time", obj.get(4));
                json.put((Object)"bid", obj.get(5));
                json.put((Object)"tid", obj.get(6));
                JSONObject existingJson = null;
                if ((String)obj.get(8) != null) {
                    existingJson = (JSONObject)new JSONParser().parse((String)obj.get(8));
                }
                if (existingJson != null && existingJson.get((Object)"sid") == json.get((Object)"sid") && existingJson.get((Object)"qty") == json.get((Object)"qty") && existingJson.get((Object)"status").equals(json.get((Object)"status"))) continue;
                oids = oids + obj.get(7) + " ,";
                jsonDetails = jsonDetails + json.toJSONString() + sep + " ";
                conn.createStatement().executeUpdate(" update trade.buyorders set json_details = '" + json.toJSONString() + "' where oid = " + obj.get(7));
                if (SQLTest.hasTx || setCriticalHeap) continue;
                this.insertUpdateCustomerJson(conn, (Integer)obj.get(0), json);
            }
            if (!oids.equals("")) {
                Log.getLogWriter().info("updated customers and buyorders with OIDList: " + oids.substring(0, oids.length() - 2) + " respective updated JSON_DETAILS:" + jsonDetails.substring(0, jsonDetails.length() - 2));
            }
        }
        catch (SQLException se) {
            conn.rollback();
            throw se;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    protected void insertUpdateCustomerJson(Connection conn, int cid, JSONObject json) {
        if (!SQLTest.hasJSON || SQLHelper.isDerbyConn(conn)) {
            return;
        }
        String jsonBuyorder = null;
        JSONParser parser = new JSONParser();
        JSONArray jsonBuyorderArray = new JSONArray();
        JSONObject jsonBuyorderObject = new JSONObject();
        List<String> list = this.executeQuery(conn, "select buyorder_json from trade.customers where cid = " + cid);
        try {
            if (list.size() > 0) {
                jsonBuyorder = list.get(0);
            }
            if (jsonBuyorder != null) {
                jsonBuyorderObject = (JSONObject)parser.parse(jsonBuyorder);
                jsonBuyorderArray = (JSONArray)jsonBuyorderObject.get((Object)"buyorder");
            }
            if (jsonBuyorderArray != null) {
                this.deleteElementFromJsonArray(jsonBuyorderArray, (Integer)json.get((Object)"oid"));
            }
            jsonBuyorderArray.add((Object)json);
            if (!SQLTest.hasTx) {
                this.updateCustomerWithNewArray(conn, cid, jsonBuyorderObject, jsonBuyorderArray);
            }
        }
        catch (ParseException pe) {
            throw new TestException("Adding " + jsonBuyorderObject.toJSONString() + " to trade.customers" + "current Object is " + json.toJSONString() + "Exception: " + TestHelper.getStackTrace((Throwable)pe));
        }
    }

    protected void deleteCustomerJson(Connection conn) {
        if (!SQLTest.hasJSON || SQLHelper.isDerbyConn(conn)) {
            return;
        }
        String jsonBuyorder = null;
        JSONParser parser = new JSONParser();
        JSONArray jsonBuyorderArray = new JSONArray();
        JSONObject jsonBuyorderObject = new JSONObject();
        try {
            Iterator i$ = this.listOfOids.iterator();
            while (i$.hasNext()) {
                int oid = (Integer)i$.next();
                String query = "select cid , buyorder_json from trade.customers where json_evalPath(json_details, '$..buyorder[?(@.oid==" + oid + ")]' ) is not null " + " and json_evalPath(json_details, '$..buyorder[?(@.oid==" + oid + ")]' ) != ''";
                Log.getLogWriter().info("executing ..." + query);
                List<String> list = this.executeQuery(conn, query);
                Iterator<String> i$2 = list.iterator();
                while (i$2.hasNext()) {
                    String jsonString;
                    jsonBuyorder = jsonString = i$2.next();
                    jsonBuyorderObject = (JSONObject)parser.parse(jsonBuyorder);
                    jsonBuyorderArray = (JSONArray)jsonBuyorderObject.get((Object)"buyorder");
                    this.deleteElementFromJsonArray(jsonBuyorderArray, oid);
                }
            }
        }
        catch (ParseException pe) {
            throw new TestException("Exception: " + TestHelper.getStackTrace((Throwable)pe));
        }
    }

    private void deleteElementFromJsonArray(JSONArray jsonBuyorderArray, int oid) {
        for (int currElement = 0; currElement < jsonBuyorderArray.size(); ++currElement) {
            JSONObject jsonBuyorderCurrentObject = (JSONObject)jsonBuyorderArray.get(currElement);
            int currentOid = ((Long)jsonBuyorderCurrentObject.get((Object)"oid")).intValue();
            if (currentOid != oid) continue;
            jsonBuyorderArray.remove(currElement);
            break;
        }
    }

    private List<String> executeQuery(Connection conn, String query) {
        List<String> list = null;
        try {
            ResultSet rs = conn.createStatement().executeQuery(query);
            list = ResultSetHelper.getJsonAsList(conn, rs);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().info("Retrying the operation ");
                list = this.executeQuery(conn, query);
            }
            throw new TestException(TestHelper.getStackTrace((Throwable)se));
        }
        return list;
    }

    private List<List<Object>> executeQueryGetList(Connection conn, String query) throws SQLException {
        List<List<Object>> finalList = new ArrayList<List<Object>>();
        ArrayList<Object> list = null;
        try {
            ResultSet rs = conn.createStatement().executeQuery(query);
            while (rs.next()) {
                list = new ArrayList<Object>();
                list.add(rs.getInt(1));
                list.add(rs.getInt(2));
                list.add(rs.getInt(3));
                list.add(rs.getString(4));
                list.add(rs.getTimestamp(5).getTime());
                list.add(rs.getBigDecimal(6));
                list.add(rs.getInt(7));
                list.add(rs.getInt(8));
                list.add(rs.getString(9));
                finalList.add(list);
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().info("Retrying the operation ");
                finalList = this.executeQueryGetList(conn, query);
            }
            throw se;
        }
        return finalList;
    }

    private void updateCustomerWithNewArray(Connection conn, int cid, JSONObject jsonBuyorderObject, JSONArray jsonBuyorderArray) {
        jsonBuyorderObject.put((Object)"buyorder", (Object)jsonBuyorderArray);
        Log.getLogWriter().info("updating trade.customers for CID:" + cid + "  with buyorder_json:" + jsonBuyorderObject.toJSONString());
        String stmt = "update trade.customers set buyorder_json = ? where cid = " + cid;
        try {
            PreparedStatement ps = conn.prepareStatement(stmt);
            ps.setObject(1, jsonBuyorderObject.toJSONString());
            ps.execute();
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().info("Retrying the operation ");
                this.updateCustomerWithNewArray(conn, cid, jsonBuyorderObject, jsonBuyorderArray);
            }
            throw new TestException(TestHelper.getStackTrace((Throwable)se));
        }
    }

    private void populateOids(Connection conn, String query) throws SQLException {
        try {
            this.listOfOids.clear();
            ResultSet rs = conn.createStatement().executeQuery(query);
            while (rs.next()) {
                this.listOfOids.add(rs.getInt(1));
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                Log.getLogWriter().info("Retrying the operation ");
                this.populateOids(conn, query);
            }
            throw se;
        }
    }
}

