/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements.json;

import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.dmlStatements.json.TradeNetworthDMLStmtJson;
import sql.security.SQLSecurityTest;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradeCustomersDMLStmtJson
extends AbstractDMLStmt {
    protected static String insert = "insert into trade.customers (cid, cust_name, since, addr, tid) values (?,?,?,?,?)";
    protected static String put = "put into trade.customers values (?,?,?,?,?)";
    protected static String s_insert = "insert into trade.customers values ";
    protected static String s_put = "put into trade.customers values ";
    protected static String insertWithDefault = "insert into trade.customers (cust_name, since, addr, tid) values (?,?,?,?)";
    protected static String putWithDefault = "put into trade.customers (cust_name, since, addr, tid) values (?,?,?,?)";
    protected static String insertWithNullDefault = "insert into trade.customers (cid, cust_name, since, tid) values (?,?,?,?)";
    protected static String putWithNullDefault = "put into trade.customers (cid, cust_name, since, tid) values (?,?,?,?)";
    protected static String[] update = new String[]{"update trade.customers set cid = ? where cid=? and tid = ? ", "update trade.customers set cust_name = ? , addr = ? where cid=? and tid =?", "update trade.customers set cust_name = ? , addr = ? where cid=? and tid =? ", "update trade.customers set cust_name = ?, since =? where cid=? and tid =? "};
    protected static String[] select = new String[]{"select * from trade.customers where tid = ?", "select cid, since, cust_name from trade.customers where tid=? and cid >?", "select cid, since, addr, cust_name from trade.customers where (tid<? or cid <=?) and since >? and tid = ?", "select cid, addr, since, cust_name from trade.customers where (cid >? or since <?) and tid = ?", "select max(rtrim(addr)) as maxaddr from trade.customers where addr < 'kj' and tid=? ", "select cid, since, cust_name from trade.customers where tid =? and cust_name like ? union select cid, since, cust_name from trade.customers where tid =? and cust_name like ? "};
    protected static String[] delete = new String[]{"delete from trade.customers where (cust_name = ? or cid = ? ) and tid = ?", "delete from trade.customers where cid=?", "delete from trade.customers where cid=?"};
    protected static String insertWithDefaultJSON = "insert into trade.customers (cust_name, since, addr, tid,json_details) values (?,?,?,?,?)";
    protected static String putWithDefaultJSON = "put into trade.customers (cust_name, since, addr, tid,json_details) values (?,?,?,?,?)";
    protected static String insertWithNullDefaultJSON = "insert into trade.customers (cid, cust_name, since, tid,json_details,networth_json) values (?,?,?,?,?,null)";
    protected static String putWithNullDefaultJSON = "put into trade.customers (cid, cust_name, since, tid,json_details,networth_json) values (?,?,?,?,?,null)";
    protected static String insertJSON = "insert into trade.customers (cid, cust_name, since, addr, tid,json_details , networth_json, buyorder_json ) values (?,?,?,?,?,?,null,null)";
    protected static String putJSON = "put into trade.customers values (?,?,?,?,?,?,null,null)";
    protected static String[] selectJSON = new String[]{"select cid, cust_name, since, addr, tid from trade.customers where cast(json_evalPath(json_details, 'tid')  as integer) = ?", "select cid, cast(json_evalPath(json_details, 'since')  as date) as since , cust_name from trade.customers where cast(json_evalPath(json_details, 'tid')  as integer)=? and cast(json_evalPath(json_details, 'cid')  as integer) >?", "select cid, since, addr, cust_name from trade.customers where (tid<? or cast(json_evalPath(json_details, 'cid')  as integer) <=?) and cast(json_evalPath(json_details, 'since')  as date)  >? and cast(json_evalPath(json_details, 'tid')  as integer) = ?", "select cast(json_evalPath(json_details, 'cid')  as integer) as cid , cast(json_evalPath(json_details, 'addr')  as varchar(100)) as addr, since, cust_name from trade.customers where (cid >? or since <?) and tid = ?", "select max(rtrim(cast(json_evalPath(json_details, 'addr')  as varchar(100)))) as maxAddr from trade.customers where cast(json_evalPath(json_details, 'addr')  as varchar(100)) < 'kj' and tid=? ", "select cast(json_evalPath(json_details, 'cid')  as integer) as cid, cast(json_evalPath(json_details, 'since')  as date) as since, cast(json_evalPath(json_details, 'cust_name')  as varchar(100)) as cust_name from trade.customers where cast(json_evalPath(json_details, 'tid')  as integer) =? and cast(json_evalPath(json_details, 'cust_name')  as varchar(100)) like ? union select cid, since, cast(json_evalPath(json_details, 'cust_name') as varchar(100)) as cust_name  from trade.customers where cast(json_evalPath(json_details, 'tid')  as integer) =? and cast(json_evalPath(json_details, 'cust_name')  as varchar(100)) like ? "};
    protected static String[] deleteJSON = new String[]{"delete from trade.customers where (cast(json_evalPath(json_details, 'cust_name')  as varchar(100)) = ? or cast(json_evalPath(json_details, 'cid')  as integer) = ? ) and tid = ?", "delete from trade.customers where cast(json_evalPath(json_details, 'cid')  as integer)=?", "delete from trade.customers where cid=?"};
    protected static String[] updateJSON = new String[]{"update trade.customers set cid = ? , json_details = ? where cast(json_evalPath(json_details, 'cid')  as integer) =? and tid = ? ", "update trade.customers set cust_name = ? , addr = ?  , json_details = ? where cast(json_evalPath(json_details, 'cid')  as integer)=? and cast(json_evalPath(json_details, 'tid')  as integer) =?", "update trade.customers set cust_name = ? , addr = ? , json_details = ? where cid=? and tid =? ", "update trade.customers set cust_name = ?, since =? , json_details = ? where cast(json_evalPath(json_details, 'cid')  as integer)  =? and tid =? "};
    protected static int maxNumOfTries = 1;
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    protected static ArrayList<String> partitionKeys = null;
    protected boolean generateIdAlways = SQLTest.generateIdAlways;
    protected boolean generateDefaultId = SQLTest.generateDefaultId;
    protected boolean batchPreparedStmt = TestConfig.tab().booleanAt(SQLPrms.batchPreparedStmt, true);
    protected static boolean disableUpdateStatement48248 = SQLTest.disableUpdateStatement48248;

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        if (hasNetworth) {
            this.insert(dConn, gConn, size, true);
        } else {
            this.insert(dConn, gConn, size, false);
        }
    }

    protected void insert(Connection dConn, Connection gConn, int size, boolean insertNetworth) {
        boolean usePreparedStatementForBatch;
        int[] cid = new int[size];
        String[] cust_name = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        boolean success = false;
        this.getDataForInsert(cid, cust_name, since, addr, size);
        boolean executeBatch = !testSecurity && rand.nextBoolean() || SQLTest.populateWithbatch;
        boolean bl = usePreparedStatementForBatch = this.batchPreparedStmt && rand.nextBoolean();
        if (dConn != null && !useWriterForWriteThrough) {
            if (!this.generateDefaultId && !this.generateIdAlways) {
                try {
                    int count = 0;
                    while (!success) {
                        if (count >= maxNumOfTries) {
                            Log.getLogWriter().info("Could not finish insert into derby, abort this operation");
                            this.rollback(dConn);
                            if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                            return;
                        }
                        MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                        exList.clear();
                        success = executeBatch ? (usePreparedStatementForBatch ? this.insertPreparedBatchToDerbyTable(dConn, cid, cust_name, since, size, exList) : this.insertBatchToDerbyTable(dConn, cid, cust_name, since, addr, size, exList)) : this.insertToDerbyTable(dConn, cid, cust_name, since, addr, size, exList);
                        ++count;
                    }
                    try {
                        if (executeBatch) {
                            if (usePreparedStatementForBatch) {
                                this.insertPreparedBatchToGFETable(gConn, cid, cust_name, since, size, exList);
                            } else {
                                this.insertBatchToGFETable(gConn, cid, cust_name, since, addr, size, exList);
                            }
                        } else {
                            this.insertToGFETable(gConn, cid, cust_name, since, addr, size, exList);
                        }
                    }
                    catch (TestException te) {
                        if (te.getMessage().contains("Execute SQL statement failed with: 23505") && isHATest && SQLTest.isEdge) {
                            try {
                                this.checkTicket49605(dConn, gConn, "customers", cid[0], -1, null, null);
                            }
                            catch (TestException e) {
                                Log.getLogWriter().info("insert failed due to #49605 ", (Throwable)e);
                                Log.getLogWriter().info("retry this using put to work around #49605");
                                if (executeBatch) {
                                    if (usePreparedStatementForBatch) {
                                        this.insertPreparedBatchToGFETable(gConn, cid, cust_name, since, size, exList, true);
                                    } else {
                                        this.insertBatchToGFETable(gConn, cid, cust_name, since, addr, size, exList, true);
                                    }
                                } else {
                                    this.insertToGFETable(gConn, cid, cust_name, since, addr, size, exList, true);
                                }
                                this.checkTicket49605(dConn, gConn, "customers", cid[0], -1, null, null);
                            }
                        }
                        throw te;
                    }
                    SQLHelper.handleMissedSQLException(exList);
                    this.commit(gConn);
                    this.commit(dConn);
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    throw new TestException("insert to trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
                }
            }
            if (this.generateIdAlways) {
                try {
                    this.insertToGfxdTableGenerateId(gConn, cid, cust_name, since, addr, size);
                    int count = 0;
                    while (!success) {
                        if (count >= maxNumOfTries) {
                            Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                            boolean deleted = this.removeCidFromGfxd(gConn, cid);
                            while (!deleted) {
                                this.removeCidFromGfxd(gConn, cid);
                            }
                            return;
                        }
                        MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                        exList.clear();
                        success = executeBatch ? this.insertBatchToDerbyTable(dConn, cid, cust_name, since, addr, size, exList) : this.insertToDerbyTable(dConn, cid, cust_name, since, addr, size, exList);
                        ++count;
                    }
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    throw new TestException("insert to trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
                }
            } else {
                try {
                    this.insertToGfxdTableGenerateId(gConn, cust_name, since, addr, size);
                    String sql = "select max(cid) cid from trade.customers where tid = " + TradeCustomersDMLStmtJson.getMyTid();
                    boolean gotCid = this.getGeneratedCid(gConn, cid, sql);
                    while (!gotCid) {
                        gotCid = this.getGeneratedCid(gConn, cid, sql);
                    }
                    int count = 0;
                    while (!success) {
                        if (count >= maxNumOfTries) {
                            Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                            boolean deleted = this.removeCidFromGfxd(gConn, cid);
                            while (!deleted) {
                                this.removeCidFromGfxd(gConn, cid);
                            }
                            return;
                        }
                        MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                        exList.clear();
                        success = executeBatch ? this.insertBatchToDerbyTable(dConn, cid, cust_name, since, addr, size, exList) : this.insertToDerbyTable(dConn, cid, cust_name, since, addr, size, exList);
                        ++count;
                    }
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    throw new TestException("insert to trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
                }
            }
        } else {
            try {
                if (this.generateIdAlways || this.generateDefaultId) {
                    this.insertToGfxdTableGenerateId(gConn, cust_name, since, addr, size);
                } else {
                    this.insertToGFETable(gConn, cid, cust_name, since, addr, size);
                }
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException("insert to gfe trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
            }
        }
        if (insertNetworth) {
            TradeNetworthDMLStmtJson networth = new TradeNetworthDMLStmtJson();
            String sql = null;
            if (this.generateIdAlways) {
                sql = "select cid from trade.customers where tid = " + TradeCustomersDMLStmtJson.getMyTid() + " and cid not in (select cid from trade.networth where tid = " + TradeCustomersDMLStmtJson.getMyTid() + ")";
                boolean gotCid = this.getGeneratedCid(gConn, cid, sql);
                while (!gotCid) {
                    gotCid = this.getGeneratedCid(gConn, cid, sql);
                }
            } else if (this.generateDefaultId) {
                sql = "select max(cid) cid from trade.customers where tid = " + TradeCustomersDMLStmtJson.getMyTid();
                boolean gotCid = this.getGeneratedCid(gConn, cid, sql);
                while (!gotCid) {
                    gotCid = this.getGeneratedCid(gConn, cid, sql);
                }
            }
            networth.insert(dConn, gConn, size, cid);
            if (dConn != null) {
                this.commit(dConn);
            }
            this.commit(gConn);
        }
    }

    private boolean insertPreparedBatchToDerbyTable(Connection conn, int[] cid, String[] cust_name, Date[] since, int size, List<SQLException> exList) throws SQLException {
        int[] counts;
        int tid;
        block10: {
            PreparedStatement stmt = TradeCustomersDMLStmtJson.getStmt(conn, insertWithNullDefault);
            if (stmt == null) {
                return false;
            }
            tid = TradeCustomersDMLStmtJson.getMyTid();
            counts = null;
            for (int i = 0; i < size; ++i) {
                try {
                    stmt.setInt(1, cid[i]);
                    stmt.setString(2, cust_name[i]);
                    stmt.setDate(3, since[i]);
                    stmt.setInt(4, tid);
                    stmt.addBatch();
                    Log.getLogWriter().info("Derby - batch insert into trade.customers with CID:" + cid[i] + ",CUST_NAME:" + cust_name[i] + ",SINCE:" + since[i] + ",ADDR:NULL" + ",TID:" + tid);
                    continue;
                }
                catch (SQLException se) {
                    if (!SQLHelper.checkDerbyException(conn, se)) {
                        return false;
                    }
                    SQLHelper.handleDerbySQLException(se, exList);
                }
            }
            try {
                counts = stmt.executeBatch();
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exList);
                if (!(se instanceof BatchUpdateException)) break block10;
                counts = ((BatchUpdateException)se).getUpdateCounts();
            }
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] != -3) {
                Log.getLogWriter().info("Derby - batch inserted into trade.customers CID:" + cid[i] + ",CUST_NAME:" + cust_name[i] + ",SINCE:" + since[i] + ",ADDR:NULL" + ",TID:" + tid);
            }
            verifyRowCount.put(tid + "_insert" + i, 0);
            verifyRowCount.put(tid + "_insert" + i, new Integer(counts[i]));
        }
        return true;
    }

    private void insertPreparedBatchToGFETable(Connection conn, int[] cid, String[] cust_name, Date[] since, int size, List<SQLException> exList) throws SQLException {
        this.insertPreparedBatchToGFETable(conn, cid, cust_name, since, size, exList, false);
    }

    private void insertPreparedBatchToGFETable(Connection conn, int[] cid, String[] cust_name, Date[] since, int size, List<SQLException> exList, boolean isPut) throws SQLException {
        int[] counts;
        int tid;
        block12: {
            String json = "";
            PreparedStatement stmt = !SQLTest.hasJSON ? TradeCustomersDMLStmtJson.getStmt(conn, isPut ? putWithNullDefault : insertWithNullDefault) : TradeCustomersDMLStmtJson.getStmt(conn, isPut ? putWithNullDefaultJSON : insertWithNullDefaultJSON);
            if (SQLTest.testSecurity && stmt == null) {
                SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
            if (setCriticalHeap && stmt == null && ((boolean[])SQLTest.getCanceled.get())[0]) {
                Log.getLogWriter().info("prepare stmt failed due to XCL54");
                return;
            }
            if (stmt == null && alterTableDropColumn) {
                Log.getLogWriter().info("prepare stmt failed due to missing column");
                return;
            }
            tid = TradeCustomersDMLStmtJson.getMyTid();
            counts = null;
            for (int i = 0; i < size; ++i) {
                try {
                    if (SQLTest.hasJSON) {
                        json = this.getJSON(cid[i], tid, since[i], cust_name[i], null);
                    }
                    stmt.setInt(1, cid[i]);
                    stmt.setString(2, cust_name[i]);
                    stmt.setDate(3, since[i]);
                    stmt.setInt(4, tid);
                    if (SQLTest.hasJSON) {
                        stmt.setObject(5, json);
                    }
                    stmt.addBatch();
                    Log.getLogWriter().info("gemfirexd - " + (isPut ? "putting" : "inserting") + " into trade.customers CID:" + cid[i] + ",CUST_NAME:" + cust_name[i] + ",SINCE:" + since[i] + ",ADDR:NULL" + ",TID:" + tid + (SQLTest.hasJSON ? ",JSON_DETAILS: " + json : " "));
                    continue;
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
            }
            try {
                counts = stmt.executeBatch();
                if (counts == null) {
                    throw new TestException("gemfirexd -  execute batch succeeded but not return an array of update counts");
                }
                if (counts.length < 1) {
                    throw new TestException("gemfirexd - execute batch succeeded but returned zero length array of update counts");
                }
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                SQLHelper.handleGFGFXDException(se, exList);
                if (!(se instanceof BatchUpdateException)) break block12;
                counts = ((BatchUpdateException)se).getUpdateCounts();
            }
        }
        this.verifyAndLog(cid, cust_name, since, isPut, tid, counts);
    }

    protected boolean removeCidFromGfxd(Connection gConn, int[] cids) {
        String sql = "delete from trade.customers where cid=?";
        try {
            PreparedStatement stmt = gConn.prepareStatement(sql);
            for (int cid : cids) {
                Log.getLogWriter().info("gemfirexd - deleting trade.customer with CID:" + cid);
                stmt.setInt(1, cid);
                int rowCount = stmt.executeUpdate();
                Log.getLogWriter().info("gemfirexd - deleted " + rowCount + " from trade.customer with CID:" + cid);
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01")) {
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    protected boolean getGeneratedCid(Connection conn, int[] cid, String sql) {
        try {
            Log.getLogWriter().info(sql);
            ResultSet rs = conn.createStatement().executeQuery(sql);
            if (rs.next()) {
                cid[0] = rs.getInt("CID");
                Log.getLogWriter().info("Generated id is " + cid[0]);
            }
            if (rs.next() && (RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK") || this.generateDefaultId && !this.generateIdAlways)) {
                throw new TestException("In init task, query result from the query " + sql + " should get only one result but it gets more rows -- another row is " + rs.getInt("CID"));
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Z01")) {
                return false;
            }
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        int[] cid = new int[size];
        int[] newCid = new int[size];
        String[] cust_name = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        int[] whichUpdate = new int[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null && !useWriterForWriteThrough) {
            if (rand.nextInt(numGettingDataFromDerby) == 1) {
                this.getDataForUpdate(dConn, newCid, cid, cust_name, since, addr, whichUpdate, size);
            } else {
                this.getDataForUpdate(gConn, newCid, cid, cust_name, since, addr, whichUpdate, size);
            }
            int count = 0;
            boolean success = this.updateDerbyTable(dConn, newCid, cid, cust_name, since, addr, whichUpdate, size, exceptionList);
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not get the lock to finish update in derby, abort this operation");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                exceptionList.clear();
                success = this.updateDerbyTable(dConn, newCid, cid, cust_name, since, addr, whichUpdate, size, exceptionList);
                ++count;
            }
            this.updateGFETable(gConn, newCid, cid, cust_name, since, addr, whichUpdate, size, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.getDataForUpdate(gConn, newCid, cid, cust_name, since, addr, whichUpdate, size);
            this.updateGFETable(gConn, newCid, cid, cust_name, since, addr, whichUpdate, size);
        }
    }

    @Override
    public void delete(Connection dConn, Connection gConn) {
        String cust_name = "name" + rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary));
        int cid = dConn != null && !useWriterForWriteThrough && rand.nextInt(numGettingDataFromDerby) == 1 ? TradeCustomersDMLStmtJson.getCid(dConn) : TradeCustomersDMLStmtJson.getCid(gConn);
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        int numOfNonUniqDelete = 1;
        int whichDelete = this.getWhichOne(numOfNonUniqDelete, delete.length);
        if (SQLTest.syncHAForOfflineTest && whichDelete == 0) {
            whichDelete = 1;
        }
        if (dConn != null && !useWriterForWriteThrough) {
            boolean success = this.deleteFromDerbyTable(dConn, cid, cust_name, whichDelete, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.deleteFromDerbyTable(dConn, cid, cust_name, whichDelete, exList);
            }
            this.deleteFromGFETable(gConn, cid, cust_name, whichDelete, exList);
            SQLHelper.handleMissedSQLException(exList);
        } else {
            this.deleteFromGFETable(gConn, cid, cust_name, whichDelete);
        }
    }

    @Override
    public void query(Connection dConn, Connection gConn) {
        int whichQuery = rand.nextInt(select.length);
        int cid = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary));
        Date since = TradeCustomersDMLStmtJson.getSince();
        ResultSet discRS = null;
        ResultSet gfeRS = null;
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            try {
                discRS = this.query(dConn, whichQuery, cid, since);
                if (discRS == null) {
                    Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                    Log.getLogWriter().info("Could not finish the op in derby, will abort this operation in derby");
                    if (!alterTableDropColumn || SQLTest.alterTableException.get() == null || !((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                        return;
                    }
                }
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exceptionList);
            }
            try {
                gfeRS = this.query(gConn, whichQuery, cid, since);
                if (gfeRS == null) {
                    if (isHATest) {
                        Log.getLogWriter().info("Testing HA and did not get GFXD result set");
                        return;
                    }
                    if (setCriticalHeap) {
                        Log.getLogWriter().info("got XCL54 and does not get query result");
                        return;
                    }
                    throw new TestException("Not able to get gfe result set after retry");
                }
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptionList);
            }
            SQLHelper.handleMissedSQLException(exceptionList);
            if (discRS == null || gfeRS == null) {
                return;
            }
            boolean success = ResultSetHelper.compareResultSets(discRS, gfeRS);
            if (!success) {
                Log.getLogWriter().info("Not able to compare results due to derby server error");
            }
        } else {
            try {
                gfeRS = this.query(gConn, whichQuery, cid, since);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && SQLTest.testSecurity) {
                    Log.getLogWriter().info("Got expected no SELECT permission, continuing test");
                    return;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X04")) {
                    Log.getLogWriter().info("Got expected column not found exception, continuing test");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            if (gfeRS != null) {
                ResultSetHelper.asList(gfeRS, false);
            } else if (isHATest) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            } else if (setCriticalHeap) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to XCL54");
            } else {
                throw new TestException("gfxd query returns null and not a HA test");
            }
        }
    }

    @Override
    public void populate(Connection dConn, Connection gConn) {
        int batchSize;
        int size = TestConfig.tab().intAt(SQLPrms.initCustomersSizePerThread, 100);
        int n = batchSize = SQLTest.populateWithbatch ? 5000 : 1;
        if (!this.generateDefaultId && !this.generateIdAlways && rand.nextBoolean()) {
            this.populate(dConn, gConn, size);
        } else {
            for (int i = 0; i < size; i += batchSize) {
                Log.getLogWriter().info("executing batch insert for " + i);
                this.insert(dConn, gConn, batchSize);
                Log.getLogWriter().info("executed batch insert for " + i);
            }
        }
    }

    @Override
    public void populate(Connection dConn, Connection gConn, int initSize) {
        this.insert(dConn, gConn, initSize);
        this.commit(gConn);
        Log.getLogWriter().info("gemfirexd committed");
        if (dConn != null) {
            this.commit(dConn);
            Log.getLogWriter().info("derby committed");
        }
    }

    protected void getRandomExistingPrimaryKeys(int[] cid, int size) {
        int key = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary);
        if (key < size) {
            size = key;
        }
        for (int i = 0; i < size; ++i) {
            cid[i] = rand.nextInt(key) + 1;
        }
    }

    protected boolean updateDerbyTable(Connection conn, int[] newCid, int[] cid, String[] cust_name, Date[] since, String[] addr, int[] whichUpdate, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = null;
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        int count = -1;
        boolean[] unsupported = new boolean[1];
        for (int i = 0; i < size; ++i) {
            if (whichUpdate[i] == 0) {
                Log.getLogWriter().info("this update primary key/partiton key case in gfe, do not update");
            }
            if ((stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i], unsupported) : TradeCustomersDMLStmtJson.getStmt(conn, update[whichUpdate[i]])) == null) {
                if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                    return true;
                }
                return unsupported[0];
            }
            try {
                if (stmt == null) continue;
                verifyRowCount.put(tid + "_update" + i, 0);
                count = this.updateTable(stmt, newCid[i], cid[i], cust_name[i], since[i], addr[i], tid, whichUpdate[i]);
                verifyRowCount.put(tid + "_update" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    Log.getLogWriter().info("detected the deadlock, will try it again");
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, boolean[] unsupported) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys, unsupported);
    }

    protected void setPartitionKeys() {
        if (!isWanTest) {
            partitionKeys = (ArrayList)partitionMap.get((Object)"customersPartition");
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_customersPartition"));
        }
        Log.getLogWriter().info("partition keys are " + partitionKeys);
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys, boolean[] unsupported) {
        PreparedStatement stmt = null;
        String[] update = TradeCustomersDMLStmtJson.update;
        if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(conn)) {
            update = updateJSON;
        }
        switch (whichUpdate) {
            case 0: {
                break;
            }
            case 1: {
                if (partitionKeys.contains("cust_name")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeCustomersDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("cust_name") || partitionKeys.contains("addr")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeCustomersDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("cust_name") || partitionKeys.contains("since")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeCustomersDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected void updateGFETable(Connection conn, int[] newCid, int[] cid, String[] cust_name, Date[] since, String[] addr, int[] whichUpdate, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = null;
        Statement s = this.getStmt(conn);
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            if (whichUpdate[i] == 0) {
                Log.getLogWriter().info("Updating gemfirexd on primary key, expect exception thrown here");
                Log.getLogWriter().info("update partition key statement is " + update[whichUpdate[i]]);
                stmt = this.getUnsupportedStmt(conn, update[whichUpdate[i]]);
                if (!SQLTest.testSecurity || stmt != null || SQLSecurityTest.prepareStmtException.get() == null) continue;
                return;
            }
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i], null) : (SQLTest.hasJSON && !SQLHelper.isDerbyConn(conn) ? TradeCustomersDMLStmtJson.getStmt(conn, updateJSON[whichUpdate[i]]) : TradeCustomersDMLStmtJson.getStmt(conn, update[whichUpdate[i]]));
            if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
                SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
            if (setCriticalHeap && stmt == null && ((boolean[])SQLTest.getCanceled.get())[0]) {
                Log.getLogWriter().info("prepare stmt failed due to XCL54");
                return;
            }
            try {
                if (stmt == null || (count = rand.nextBoolean() ? this.updateTable(s, newCid[i], cid[i], cust_name[i], since[i], addr[i], tid, whichUpdate[i]) : this.updateTable(stmt, newCid[i], cid[i], cust_name[i], since[i], addr[i], tid, whichUpdate[i])) == verifyRowCount.get(tid + "_update" + i)) continue;
                Log.getLogWriter().info("Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + count);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void updateGFETable(Connection conn, int[] newCid, int[] cid, String[] cust_name, Date[] since, String[] addr, int[] whichUpdate, int size) {
        PreparedStatement stmt = null;
        Statement s = this.getStmt(conn);
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        for (int i = 0; i < size; ++i) {
            if (whichUpdate[i] == 0) {
                stmt = this.getUnsupportedStmt(conn, update[whichUpdate[i]]);
                continue;
            }
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i], null) : TradeCustomersDMLStmtJson.getStmt(conn, update[whichUpdate[i]]);
            try {
                if (stmt == null) continue;
                if (rand.nextBoolean() && !disableUpdateStatement48248) {
                    this.updateTable(s, newCid[i], cid[i], cust_name[i], since[i], addr[i], tid, whichUpdate[i]);
                    continue;
                }
                this.updateTable(stmt, newCid[i], cid[i], cust_name[i], since[i], addr[i], tid, whichUpdate[i]);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int updateTable(PreparedStatement stmt, int newCid, int cid, String cust_name, Date since, String addr, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + update[whichUpdate];
        String jsonString = "";
        String jsonLog = "";
        HashMap map = new HashMap();
        if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
            map = (HashMap)this.getCurrentRowOfUpdate(stmt.getConnection(), cid);
            query = " QUERY: " + updateJSON[whichUpdate];
        }
        int i = 1;
        switch (whichUpdate) {
            case 0: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    jsonString = this.getJSON(newCid, tid, (Date)map.get("since"), (String)map.get("cust_name"), (String)map.get("addr"));
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                Log.getLogWriter().info(database + "updating trade.customers with CID:" + newCid + jsonLog + " where CID:" + cid + query);
                stmt.setInt(i++, newCid);
                stmt.setInt(i++, cid);
                stmt.setInt(i++, RemoteTestModule.getCurrentThread().getThreadId());
                break;
            }
            case 1: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    jsonString = this.getJSON(cid, tid, (Date)map.get("since"), cust_name, addr);
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                Log.getLogWriter().info(database + "updating trade.customers with CUSTNAME:" + cust_name + ",ADDR:" + addr + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                stmt.setString(i++, cust_name);
                stmt.setString(i++, addr);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    stmt.setObject(i++, jsonString);
                }
                stmt.setInt(i++, cid);
                stmt.setInt(i++, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in  trade.customers CUSTNAME:" + cust_name + ",ADDR:" + addr + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 2: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    jsonString = this.getJSON(cid, tid, (Date)map.get("since"), cust_name, addr);
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                Log.getLogWriter().info(database + "updating trade.customers with CUSTNAME:" + cust_name + ",ADDR:" + addr + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                stmt.setString(i++, cust_name);
                stmt.setString(i++, addr);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    stmt.setObject(i++, jsonString);
                }
                stmt.setInt(i++, cid);
                stmt.setInt(i++, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in  trade.customers with CUSTNAME:" + cust_name + ",ADDR:" + addr + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 3: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    jsonString = this.getJSON(cid, tid, since, cust_name, (String)map.get("addr"));
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                Log.getLogWriter().info(database + "updating trade.customers with CUSTNAME:" + cust_name + ",SINCE:" + since + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                stmt.setString(i++, cust_name);
                stmt.setDate(i++, since);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    stmt.setObject(i++, jsonString);
                }
                stmt.setInt(i++, cid);
                stmt.setInt(i++, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " in  trade.customers CUSTNAME:" + cust_name + ",SINCE:" + since + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int updateTable(Statement stmt, int newCid, int cid, String cust_name, Date since, String addr, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = "";
        String jsonString = "";
        String jsonLog = "";
        HashMap map = new HashMap();
        if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
            map = (HashMap)this.getCurrentRowOfUpdate(stmt.getConnection(), cid);
            query = " QUERY: " + updateJSON[whichUpdate];
        } else {
            query = " QUERY: " + update[whichUpdate];
        }
        switch (whichUpdate) {
            case 0: {
                break;
            }
            case 1: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    jsonString = this.getJSON(cid, tid, (Date)map.get("since"), cust_name, addr);
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                Log.getLogWriter().info(database + "updating trade.customers with CUST_NAME:" + cust_name + ",ADDR:" + addr + jsonLog + "where CID:" + cid + ",TID:" + tid + query);
                rowCount = stmt.executeUpdate("update trade.customers set cust_name ='" + cust_name + "' , addr ='" + addr + (SQLTest.hasJSON ? "' , json_details = '" + jsonString : "") + "' where cid=" + cid + " and tid =" + tid);
                Log.getLogWriter().info(database + "updated " + rowCount + " in trade.customers CUST_NAME:" + cust_name + ",ADDR:" + addr + jsonLog + "where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 2: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    jsonString = this.getJSON(cid, tid, (Date)map.get("since"), cust_name, addr);
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                Log.getLogWriter().info(database + "updating trade.customers with CUST_NAME:" + cust_name + ",ADDR:" + addr + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                rowCount = stmt.executeUpdate("update trade.customers set cust_name ='" + cust_name + "' , addr ='" + addr + (SQLTest.hasJSON ? "' , json_details = '" + jsonString : "") + "' where cid=" + cid + " and tid =" + tid);
                Log.getLogWriter().info(database + "updated " + rowCount + "in trade.customers  CUST_NAME:" + cust_name + ",ADDR:" + addr + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 3: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    jsonString = this.getJSON(cid, tid, since, cust_name, (String)map.get("addr"));
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                Log.getLogWriter().info(database + "updating trade.customers with CUST_NAME:" + cust_name + ",SINCE:" + since + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                rowCount = stmt.executeUpdate("update trade.customers set cust_name ='" + cust_name + "' , since ='" + since + (SQLTest.hasJSON ? "' , json_details = '" + jsonString : "") + "' where cid=" + cid + " and tid =" + tid);
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.customers CUST_NAME:" + cust_name + ",SINCE:" + since + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void getDataForUpdate(Connection conn, int[] newCid, int[] cid, String[] cust_name, Date[] since, String[] addr, int[] whichUpdate, int size) {
        this.getPrimaryKeysForUpdate(newCid, size);
        int maxVarCharLength = 100;
        int data = 100;
        for (int i = 0; i < size; ++i) {
            cid[i] = whichUpdate[i] == 0 ? TradeCustomersDMLStmtJson.getCid(conn) : (i % 2 == 0 ? TradeCustomersDMLStmtJson.getCid(conn) : TradeCustomersDMLStmtJson.getCid());
            cust_name[i] = i % 3 == 0 ? "name" + rand.nextInt(data) : this.getRandVarChar(maxVarCharLength - 20);
            addr[i] = i % 2 == 0 ? "address is " + cust_name[i] : this.getRandVarChar(maxVarCharLength);
            since[i] = TradeCustomersDMLStmtJson.getSince();
            whichUpdate[i] = rand.nextInt(update.length);
        }
    }

    protected void getDataForUpdate(String[] cust_name, Date[] since, String[] addr, int size) {
        int data = 1000;
        if (!randomData) {
            for (int i = 0; i < size; ++i) {
                String temp = cust_name[i];
                if (temp.indexOf(95) != -1) {
                    cust_name[i] = temp.substring(0, temp.indexOf(95) + 1) + (Integer.parseInt(temp.substring(temp.indexOf(95) + 1)) + 1);
                } else {
                    int n = i;
                    cust_name[n] = cust_name[n] + "_1";
                }
                temp = addr[i];
                if (temp.indexOf(95) != -1) {
                    addr[i] = temp.substring(0, temp.indexOf(95) + 1) + (Integer.parseInt(temp.substring(temp.indexOf(95) + 1)) + 1);
                    continue;
                }
                int n = i;
                addr[n] = addr[n] + "_1";
            }
        } else {
            for (int i = 0; i < size; ++i) {
                cust_name[i] = "name" + rand.nextInt(data);
                addr[i] = "address is " + cust_name[i];
                since[i] = TradeCustomersDMLStmtJson.getSince();
            }
        }
    }

    protected void getPrimaryKeysForUpdate(int[] cid, int size) {
        int key = (int)SQLBB.getBB().getSharedCounters().add(SQLBB.tradeCustomersPrimary, (long)size);
        for (int i = 0; i < size; ++i) {
            cid[i] = key - i;
        }
    }

    protected boolean deleteFromDerbyTable(Connection dConn, int cid, String cust_name, int whichDelete, List<SQLException> exList) {
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        int count = -1;
        PreparedStatement stmt = TradeCustomersDMLStmtJson.getStmt(dConn, delete[whichDelete]);
        if (stmt == null) {
            return false;
        }
        try {
            verifyRowCount.put(tid + "_delete", 0);
            count = this.deleteFromTable(stmt, cid, cust_name, tid, whichDelete);
            verifyRowCount.put(tid + "_delete", new Integer(count));
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void deleteFromGFETable(Connection gConn, int cid, String cust_name, int whichDelete, List<SQLException> exList) {
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        int count = -1;
        PreparedStatement stmt = TradeCustomersDMLStmtJson.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null && ((boolean[])SQLTest.getCanceled.get())[0]) {
            Log.getLogWriter().info("prepare stmt for delete failed due to XCL54");
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        try {
            count = this.deleteFromTable(stmt, cid, cust_name, tid, whichDelete);
            if (count != verifyRowCount.get(tid + "_delete")) {
                Log.getLogWriter().info("Gfxd delete (customers) has different row count from that of derby derby deleted " + verifyRowCount.get(tid + "_delete") + " but gfxd deleted " + count);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void deleteFromGFETable(Connection gConn, int cid, String cust_name, int whichDelete) {
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        PreparedStatement stmt = TradeCustomersDMLStmtJson.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null && ((boolean[])SQLTest.getCanceled.get())[0]) {
            Log.getLogWriter().info("prepare stmt failed due to XCL54");
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        try {
            this.deleteFromTable(stmt, cid, cust_name, tid, whichDelete);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("detected the foreign key constraint violation, continuing test");
            }
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                Log.getLogWriter().info("Got expected column not found exception in delete, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected int deleteFromTable(PreparedStatement stmt, int cid, String cust_name, int tid, int whichDelete) throws SQLException {
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String successString = "";
        String query = SQLTest.hasJSON ? " QUERY: " + deleteJSON[whichDelete] : " QUERY: " + delete[whichDelete];
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting trade.customers with CUST_NAME:" + cust_name + ",CID:" + cid + ",TID:" + tid + query);
                stmt.setString(1, cust_name);
                stmt.setInt(2, cid);
                stmt.setInt(3, tid);
                successString = " rows in trade.customers CUST_NAME:" + cust_name + ",CID:" + cid + ",TID:" + tid + query;
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting trade.customers with CID:" + cid + ",TID:" + tid + query);
                stmt.setInt(1, cid);
                successString = " rows in trade.customers CID:" + cid + ",TID:" + tid + query;
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "deleting trade.customers with CID:" + cid + query);
                stmt.setInt(1, cid);
                successString = " rows in trade.customers CID:" + cid + query;
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + "deleted " + rowCount + successString);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected boolean insertToDerbyTable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = TradeCustomersDMLStmtJson.getStmt(conn, insert);
        if (stmt == null) {
            return false;
        }
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], tid);
                verifyRowCount.put(tid + "_insert" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected boolean insertBatchToDerbyTable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, List<SQLException> exceptions) throws SQLException {
        int[] counts;
        int tid;
        block9: {
            Statement stmt = conn.createStatement();
            tid = TradeCustomersDMLStmtJson.getMyTid();
            counts = null;
            for (int i = 0; i < size; ++i) {
                try {
                    stmt.addBatch("insert into trade.customers values (" + cid[i] + ", '" + cust_name[i] + "','" + since[i] + "','" + addr[i] + "'," + tid + ")");
                    Log.getLogWriter().info("Derby - batch inserting into trade.customers with CID:" + cid[i] + ",CUSTNAME:" + cust_name[i] + ",SINCE:" + since[i] + ",ADDR:" + addr[i] + ",TID:" + tid);
                    continue;
                }
                catch (SQLException se) {
                    if (!SQLHelper.checkDerbyException(conn, se)) {
                        return false;
                    }
                    SQLHelper.handleDerbySQLException(se, exceptions);
                }
            }
            try {
                counts = stmt.executeBatch();
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
                if (!(se instanceof BatchUpdateException)) break block9;
                counts = ((BatchUpdateException)se).getUpdateCounts();
            }
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] != -3) {
                Log.getLogWriter().info("Derby - batch inserted into trade.customers with CID:" + cid[i] + ",CUSTNAME:" + cust_name[i] + ",SINCE:" + since[i] + ",ADDR:" + addr[i] + ",TID:" + tid);
            }
            verifyRowCount.put(tid + "_insert" + i, 0);
            verifyRowCount.put(tid + "_insert" + i, new Integer(counts[i]));
        }
        return true;
    }

    protected void insertToGFETable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, List<SQLException> exceptions) throws SQLException {
        this.insertToGFETable(conn, cid, cust_name, since, addr, size, exceptions, false);
    }

    protected void insertToGFETable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, List<SQLException> exceptions, boolean isPut) throws SQLException {
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        PreparedStatement stmt = SQLTest.hasJSON ? TradeCustomersDMLStmtJson.getStmt(conn, isPut ? putJSON : insertJSON) : TradeCustomersDMLStmtJson.getStmt(conn, isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null && ((boolean[])SQLTest.getCanceled.get())[0]) {
            Log.getLogWriter().info("prepare stmt failed due to XCL54");
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = isPut ? this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], tid, isPut) : this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], tid);
                if (count == verifyRowCount.get(tid + "_insert" + i)) continue;
                Log.getLogWriter().info("Gfxd " + (isPut ? "put" : "insert") + " has different row count from that of derby " + "derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd " + (isPut ? "put" : "inserted") + "  " + count);
                continue;
            }
            catch (SQLException se) {
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void insertBatchToGFETable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, List<SQLException> exceptions) throws SQLException {
        this.insertBatchToGFETable(conn, cid, cust_name, since, addr, size, exceptions, false);
    }

    protected void insertBatchToGFETable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, List<SQLException> exceptions, boolean isPut) throws SQLException {
        int[] counts;
        int tid;
        block9: {
            Statement stmt = conn.createStatement();
            tid = TradeCustomersDMLStmtJson.getMyTid();
            counts = null;
            String jsonLog = "";
            String jsonText = "";
            for (int i = 0; i < size; ++i) {
                try {
                    if (SQLTest.hasJSON) {
                        jsonText = this.getJSON(cid[i], tid, since[i], cust_name[i], addr[i]);
                        jsonLog = " ,JSON_DETAILS: " + jsonText;
                    }
                    stmt.addBatch((isPut ? "put" : "insert") + " into trade.customers values (" + cid[i] + ", '" + cust_name[i] + "' , '" + since[i] + "' , '" + addr[i] + "'," + tid + (SQLTest.hasJSON ? ",'" + jsonText + "' , null,null" : "") + ")");
                    Log.getLogWriter().info("gemfire - batch " + (isPut ? "Putting" : "Inserting") + " into trade.customers CID:" + cid[i] + ",CUST_NAME:" + cust_name[i] + ",SINCE:" + since[i] + ",ADDR:" + addr[i] + ",TID:" + tid + jsonLog);
                    continue;
                }
                catch (SQLException se) {
                    if (isPut && se.getSQLState().equals("0A000")) {
                        Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                        continue;
                    }
                    SQLHelper.handleGFGFXDException(se, exceptions);
                }
            }
            try {
                counts = stmt.executeBatch();
                if (counts == null) {
                    throw new TestException("gfxd statement executebatch succeeded but not return an array of update counts");
                }
                if (counts.length < 1) {
                    throw new TestException("gfxd statement executebatch succeeded but returned zeor length array of update counts");
                }
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                SQLHelper.handleGFGFXDException(se, exceptions);
                if (!(se instanceof BatchUpdateException)) break block9;
                counts = ((BatchUpdateException)se).getUpdateCounts();
            }
        }
        this.verifyAndLog(cid, cust_name, since, isPut, tid, counts);
    }

    private void verifyAndLog(int[] cid, String[] cust_name, Date[] since, boolean isPut, int tid, int[] counts) {
        String json = "";
        for (int i = 0; i < counts.length; ++i) {
            if (SQLTest.hasJSON) {
                json = this.getJSON(cid[i], tid, since[i], cust_name[i], "");
                json = ",JSON_DETAILS:" + json;
            }
            if (counts[i] != -3) {
                Log.getLogWriter().info("gemfirexd -  " + (isPut ? "put" : "inserted ") + " into trade.customers CID:" + cid[i] + ".CUST_NAME:" + cust_name[i] + ",SINCE:" + since[i] + ",ADDR:null" + ",TID:" + tid + json);
            }
            if (counts[i] == verifyRowCount.get(tid + "_insert" + i)) continue;
            Log.getLogWriter().info("gemfirexd -  " + (isPut ? "put" : "insert") + " has different row count from that of derby " + "derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd " + (isPut ? "put" : "inserted") + " " + counts[i]);
        }
    }

    protected void insertToGfxdTableGenerateId(Connection conn, String[] cust_name, Date[] since, String[] addr, int size) throws SQLException {
        this.insertToGfxdTableGenerateId(conn, cust_name, since, addr, size, false);
    }

    protected void insertToGfxdTableGenerateId(Connection conn, String[] cust_name, Date[] since, String[] addr, int size, boolean isPut) throws SQLException {
        PreparedStatement stmt = SQLTest.hasJSON ? TradeCustomersDMLStmtJson.getStmt(conn, isPut ? putWithDefaultJSON : insertWithDefaultJSON) : TradeCustomersDMLStmtJson.getStmt(conn, isPut ? putWithDefault : insertWithDefault);
        if (setCriticalHeap && stmt == null && ((boolean[])SQLTest.getCanceled.get())[0]) {
            Log.getLogWriter().info("prepare stmt failed due to XCL54");
            return;
        }
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, cust_name[i], since[i], addr[i], tid);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, String cust_name, Date since, String addr, int tid) throws SQLException {
        return this.insertToTable(stmt, cust_name, since, addr, tid, false);
    }

    protected int insertToTable(PreparedStatement stmt, String cust_name, Date since, String addr, int tid, boolean isPut) throws SQLException {
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.customers with CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid);
        stmt.setString(1, cust_name);
        stmt.setDate(2, since);
        stmt.setString(3, addr);
        stmt.setInt(4, tid);
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + (isPut ? "put" : "inserted") + rowCount + " rows into trade.customers CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        if (database.contains("gemfirexd") && isPut) {
            Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.customers with CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid);
            rowCount = stmt.executeUpdate();
            Log.getLogWriter().info(database + (isPut ? "put" : "inserted") + rowCount + " rows into trade.customers CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid);
            warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        return rowCount;
    }

    protected void insertToGfxdTableGenerateId(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size) throws SQLException {
        this.insertToGfxdTableGenerateId(conn, cid, cust_name, since, addr, size, false);
    }

    protected void insertToGfxdTableGenerateId(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, boolean isPut) throws SQLException {
        PreparedStatement stmt = SQLTest.hasJSON ? TradeCustomersDMLStmtJson.getGeneratedKeysStmt(conn, isPut ? putWithDefaultJSON : insertWithDefaultJSON) : TradeCustomersDMLStmtJson.getGeneratedKeysStmt(conn, isPut ? putWithDefault : insertWithDefault);
        if (setCriticalHeap && stmt == null && ((boolean[])SQLTest.getCanceled.get())[0]) {
            Log.getLogWriter().info("prepare stmt failed due to XCL54");
            return;
        }
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                int key;
                cid[i] = key = this.insertToTableGeneratedIdAlways(stmt, cust_name[i], since[i], addr[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected static PreparedStatement getGeneratedKeysStmt(Connection conn, String sql) {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql, 1);
        }
        catch (SQLException se) {
            if (SQLTest.testSecurity && (se.getSQLState().equals("42500") || se.getSQLState().equals("42502") || se.getSQLState().equals("25502"))) {
                SQLHelper.printSQLException(se);
                SQLSecurityTest.prepareStmtException.set((Object)se);
            }
            if (!SQLHelper.checkDerbyException(conn, se)) {
                if (SQLTest.hasTx) {
                    SQLDistTxTest.rollbackGfxdTx.set((Object)true);
                    Log.getLogWriter().info("force gfxd to rollback operations as well");
                }
            }
            SQLHelper.handleSQLException(se);
        }
        return stmt;
    }

    protected int insertToTableGeneratedIdAlways(PreparedStatement stmt, String cust_name, Date since, String addr, int tid) throws SQLException {
        return this.insertToTableGeneratedIdAlways(stmt, cust_name, since, addr, tid, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int insertToTableGeneratedIdAlways(PreparedStatement stmt, String cust_name, Date since, String addr, int tid, boolean isPut) throws SQLException {
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        Log.getLogWriter().info(database + (isPut ? "inserting" : "putting") + " into table trade.customers with GENERATEDID:NA" + ",CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid);
        int generatedId = -1;
        stmt.setString(1, cust_name);
        stmt.setDate(2, since);
        stmt.setString(3, addr);
        stmt.setInt(4, tid);
        int rowCount = stmt.executeUpdate();
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        if (rowCount != 1) throw new TestException("does not " + (isPut ? "put" : "insert") + " into table using generated id always" + " in the test");
        ResultSet rs = stmt.getGeneratedKeys();
        if (!rs.next()) throw new TestException("does not get generated key in the test");
        generatedId = rs.getInt(1);
        if (SQLTest.hasJSON) {
            String jsonUpdate = "update trade.customers set json_details = ? where cid = " + generatedId;
            PreparedStatement prepareStmt = stmt.getConnection().prepareStatement(jsonUpdate);
            prepareStmt.setString(1, this.getJSON(generatedId, tid, since, cust_name, addr));
            prepareStmt.execute();
        }
        Log.getLogWriter().info(database + (isPut ? "inserted" : "put") + rowCount + " rows into table trade.customers with GENERATEDID:" + generatedId + ",CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + (SQLTest.hasJSON ? ",JSON_DETAILS : " + this.getJSON(generatedId, tid, since, cust_name, addr) : " "));
        return generatedId;
    }

    protected void insertToGFETable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size) throws SQLException {
        this.insertToGFETable(conn, cid, cust_name, since, addr, size, false);
    }

    protected void insertToGFETable(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, boolean isPut) throws SQLException {
        PreparedStatement stmt = SQLTest.hasJSON ? TradeCustomersDMLStmtJson.getStmt(conn, isPut ? putJSON : insertJSON) : TradeCustomersDMLStmtJson.getStmt(conn, isPut ? put : insert);
        if (setCriticalHeap && stmt == null && ((boolean[])SQLTest.getCanceled.get())[0]) {
            Log.getLogWriter().info("prepare stmt failed due to XCL54");
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42802")) {
                    Log.getLogWriter().info("Got expected column not found exception in " + (isPut ? "put" : "insert") + ", continuing test");
                    continue;
                }
                if (se.getSQLState().equals("23505") && isHATest && SQLTest.isEdge) {
                    Log.getLogWriter().info("detected pk constraint violation during " + (isPut ? "put" : "insert") + " -- relaxing due to #43571, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42X14") && alterTableDropColumn) {
                    SQLHelper.printSQLException(se);
                    Log.getLogWriter().info("got expected alter table exception, continuing test");
                    continue;
                }
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int cid, String cust_name, Date since, String addr, int tid) throws SQLException {
        return this.insertToTable(stmt, cid, cust_name, since, addr, tid, false);
    }

    protected int insertToTable(PreparedStatement stmt, int cid, String cust_name, Date since, String addr, int tid, boolean isPut) throws SQLException {
        String driverName;
        String transactionId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - " + transactionId + " ";
        String jsonDetails = " ";
        String jsonLog = "";
        if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
            jsonDetails = cid > 100 && cid < 120 && !this.generateDefaultId ? this.getJSON(cid, tid, since, null, addr) : this.getJSON(cid, tid, since, cust_name, addr);
            jsonLog = ",JSON_DETAILS: " + jsonDetails;
        }
        Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.customers with " + "CID:" + cid + ",CUSTNAME:" + (cid > 100 && cid < 120 && !this.generateDefaultId ? "null" : cust_name) + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + jsonLog);
        stmt.setInt(1, cid);
        if (cid > 100 && cid < 120 && !this.generateDefaultId) {
            stmt.setString(2, null);
        } else {
            stmt.setString(2, cust_name);
        }
        stmt.setDate(3, since);
        stmt.setString(4, addr);
        stmt.setInt(5, tid);
        if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
            stmt.setString(6, jsonDetails);
        }
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows into trade.customers " + "CID:" + cid + ",CUSTNAME:" + (cid > 100 && cid < 120 && !this.generateDefaultId ? "null" : cust_name) + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + jsonLog);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        if ((driverName = stmt.getConnection().getMetaData().getDriverName()).toLowerCase().contains("gemfirexd") && isPut) {
            if (!SQLTest.ticket49794fixed) {
                this.insertToCustomersFulldataset(stmt.getConnection(), cid, cust_name, since, addr, tid);
            }
            Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.customers with " + "CID:" + cid + ",CUSTNAME:" + (cid > 100 && cid < 120 && !this.generateDefaultId ? "null" : cust_name) + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + jsonLog);
            rowCount = stmt.executeUpdate();
            Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows into trade.customers " + "CID:" + cid + ",CUSTNAME:" + (cid > 100 && cid < 120 && !this.generateDefaultId ? "null" : cust_name) + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid + jsonLog);
            warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        return rowCount;
    }

    protected void insertToCustomersFulldataset(Connection conn, int cid, String cust_name, Date since, String addr, int tid) {
        try {
            Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence deleting  the  row  from TRADE.CUSTOMERS_FULLDATASET with data CID:" + cid);
            conn.createStatement().execute("DELETE FROM TRADE.CUSTOMERS_FULLDATASET  WHERE  cid = " + cid);
            PreparedStatement preparedInsertStmt = conn.prepareStatement("insert into trade.CUSTOMERS_fulldataset values (?,?,?,?,?)");
            preparedInsertStmt.setInt(1, cid);
            if (cid > 100 && cid < 120 && !this.generateDefaultId) {
                preparedInsertStmt.setString(2, null);
            } else {
                preparedInsertStmt.setString(2, cust_name);
            }
            preparedInsertStmt.setDate(3, since);
            preparedInsertStmt.setString(4, addr);
            preparedInsertStmt.setInt(5, tid);
            Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence inserting  the  row  into  TRADE.CUSTOMERS_FULLDATASET with data CID:" + cid + ",CUSTNAME:" + cust_name + ",SINCE:" + since + ",ADDR:" + addr + ",TID:" + tid);
            preparedInsertStmt.executeUpdate();
        }
        catch (SQLException se) {
            Log.getLogWriter().info("Error while updating TRADE.CUSTOMERS_FULLDATASET table. It may cause Data inconsistency " + se.getMessage());
        }
    }

    protected void getDataForInsert(int[] cid, String[] cust_name, Date[] since, String[] addr, int size) {
        int key = (int)SQLBB.getBB().getSharedCounters().add(SQLBB.tradeCustomersPrimary, (long)size);
        int data = 1000;
        for (int i = 0; i < size; ++i) {
            int counter;
            cid[i] = counter = key - i;
            if (!randomData) {
                cust_name[i] = "name" + counter;
                addr[i] = "address is " + cust_name[i];
                since[i] = TradeCustomersDMLStmtJson.getSince();
                continue;
            }
            cust_name[i] = "name" + rand.nextInt(data);
            addr[i] = "address is " + cust_name[i];
            since[i] = TradeCustomersDMLStmtJson.getSince();
        }
    }

    protected ResultSet getResultSetForUniqKeys(Connection conn) {
        int cid = 0;
        Date since = TradeCustomersDMLStmtJson.getSince();
        ResultSet rs = this.getQuery(conn, 0, cid, since);
        return rs;
    }

    public ResultSet getQuery(Connection conn, int whichQuery, int cid, Date since) {
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        return TradeCustomersDMLStmtJson.getQuery(conn, whichQuery, cid, since, tid);
    }

    private ResultSet query(Connection conn, int whichQuery, int cid, Date since) throws SQLException {
        int tid = TradeCustomersDMLStmtJson.getMyTid();
        return TradeCustomersDMLStmtJson.query(conn, whichQuery, cid, since, tid);
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, int cid, Date since, int tid) {
        ResultSet rs;
        block5: {
            boolean[] success = new boolean[1];
            rs = null;
            try {
                rs = TradeCustomersDMLStmtJson.getQuery(conn, whichQuery, cid, since, tid, success);
                int count = 0;
                while (!success[0]) {
                    if (count >= maxNumOfTries) {
                        if (SQLHelper.isDerbyConn(conn)) {
                            Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                        }
                        return null;
                    }
                    ++count;
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    rs = TradeCustomersDMLStmtJson.getQuery(conn, whichQuery, cid, since, tid, success);
                }
            }
            catch (SQLException se) {
                if (SQLHelper.isAlterTableException(conn, se)) break block5;
                SQLHelper.handleSQLException(se);
            }
        }
        return rs;
    }

    protected static ResultSet query(Connection conn, int whichQuery, int cid, Date since, int tid) throws SQLException {
        boolean[] success = new boolean[1];
        ResultSet rs = TradeCustomersDMLStmtJson.getQuery(conn, whichQuery, cid, since, tid, success);
        Log.getLogWriter().info("success is " + success[0]);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                if (SQLHelper.isDerbyConn(conn)) {
                    Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                }
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = TradeCustomersDMLStmtJson.getQuery(conn, whichQuery, cid, since, tid, success);
        }
        return rs;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, int cid, Date since, int tid, boolean[] success) throws SQLException {
        ResultSet rs = null;
        success[0] = true;
        String transactionId = (Integer)SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - " + transactionId + " ";
        String query = " QUERY: " + (SQLTest.hasJSON && !SQLHelper.isDerbyConn(conn) ? selectJSON[whichQuery] : select[whichQuery]);
        try {
            PreparedStatement stmt = SQLTest.hasJSON && !SQLHelper.isDerbyConn(conn) ? conn.prepareStatement(selectJSON[whichQuery]) : conn.prepareStatement(select[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.customers with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.customers with CID:" + cid + ",TID:" + tid + query);
                    stmt.setInt(1, tid);
                    stmt.setInt(2, cid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.customers with CID:" + cid + ",SINCE: " + since + ",TID:" + tid + query);
                    stmt.setInt(1, tid);
                    stmt.setInt(2, cid);
                    stmt.setDate(3, since);
                    stmt.setInt(4, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.customers with CID:" + cid + "SINCE:" + since + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setDate(2, since);
                    stmt.setInt(3, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.customers with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 5: {
                    String custName = TradeCustomersDMLStmtJson.getUnionCustNameWildcard(cid);
                    String custName2 = TradeCustomersDMLStmtJson.getUnionCustNameWildcard(cid + 2);
                    stmt.setInt(1, tid);
                    stmt.setString(2, custName);
                    stmt.setInt(3, tid);
                    stmt.setString(4, custName2);
                    Log.getLogWriter().info(database + "querying trade.customers with TID:" + tid + ",1_CUSTNAME:" + custName + ",2_CUSTNAME:" + custName2 + query);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            throw se;
        }
        return rs;
    }

    protected static String getUnionCustNameWildcard(int i) {
        return "%me%" + digits[i % 10] + "%";
    }

    @Override
    public void put(Connection dConn, Connection gConn, int size) {
        if (hasNetworth) {
            this.put(dConn, gConn, size, true);
        } else {
            this.put(dConn, gConn, size, false);
        }
    }

    protected void put(Connection dConn, Connection gConn, int size, boolean insertNetworth) {
        boolean usePreparedStatementForBatch;
        int[] cid = new int[size];
        String[] cust_name = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        boolean success = false;
        this.getDataForInsert(cid, cust_name, since, addr, size);
        boolean executeBatch = !testSecurity && rand.nextBoolean();
        boolean bl = usePreparedStatementForBatch = this.batchPreparedStmt && rand.nextBoolean();
        if (dConn != null && !useWriterForWriteThrough) {
            if (!this.generateDefaultId && !this.generateIdAlways) {
                try {
                    int count = 0;
                    while (!success) {
                        if (count >= maxNumOfTries) {
                            Log.getLogWriter().info("Could not finish insert into derby, abort this operation");
                            this.rollback(dConn);
                            if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                            return;
                        }
                        MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                        exList.clear();
                        success = executeBatch ? (usePreparedStatementForBatch ? this.insertPreparedBatchToDerbyTable(dConn, cid, cust_name, since, size, exList) : this.insertBatchToDerbyTable(dConn, cid, cust_name, since, addr, size, exList)) : this.insertToDerbyTable(dConn, cid, cust_name, since, addr, size, exList);
                        ++count;
                    }
                    try {
                        if (executeBatch) {
                            if (usePreparedStatementForBatch) {
                                this.insertPreparedBatchToGFETable(gConn, cid, cust_name, since, size, exList, true);
                            } else {
                                this.insertBatchToGFETable(gConn, cid, cust_name, since, addr, size, exList, true);
                            }
                        } else {
                            this.insertToGFETable(gConn, cid, cust_name, since, addr, size, exList, true);
                        }
                    }
                    catch (TestException te) {
                        if (te.getMessage().contains("Execute SQL statement failed with: 23505") && isHATest && SQLTest.isEdge) {
                            try {
                                this.checkTicket49605(dConn, gConn, "customers", cid[0], -1, null, null);
                            }
                            catch (TestException e) {
                                Log.getLogWriter().info("insert failed due to #49605", (Throwable)te);
                                this.deleteRow(dConn, gConn, "buyorders", cid[0], -1, null, null);
                            }
                        }
                        throw te;
                    }
                    SQLHelper.handleMissedSQLException(exList);
                    this.commit(gConn);
                    this.commit(dConn);
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    throw new TestException("put to trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
                }
            }
            if (this.generateIdAlways) {
                try {
                    this.insertToGfxdTableGenerateId(gConn, cid, cust_name, since, addr, size, true);
                    int count = 0;
                    while (!success) {
                        if (count >= maxNumOfTries) {
                            Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                            boolean deleted = this.removeCidFromGfxd(gConn, cid);
                            while (!deleted) {
                                this.removeCidFromGfxd(gConn, cid);
                            }
                            return;
                        }
                        MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                        exList.clear();
                        success = executeBatch ? this.insertBatchToDerbyTable(dConn, cid, cust_name, since, addr, size, exList) : this.insertToDerbyTable(dConn, cid, cust_name, since, addr, size, exList);
                        ++count;
                    }
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    throw new TestException("insert to trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
                }
            } else {
                try {
                    this.insertToGfxdTableGenerateId(gConn, cust_name, since, addr, size, true);
                    String sql = "select max(cid) cid from trade.customers where tid = " + TradeCustomersDMLStmtJson.getMyTid();
                    boolean gotCid = this.getGeneratedCid(gConn, cid, sql);
                    while (!gotCid) {
                        gotCid = this.getGeneratedCid(gConn, cid, sql);
                    }
                    int count = 0;
                    while (!success) {
                        if (count >= maxNumOfTries) {
                            Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                            boolean deleted = this.removeCidFromGfxd(gConn, cid);
                            while (!deleted) {
                                this.removeCidFromGfxd(gConn, cid);
                            }
                            return;
                        }
                        MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                        exList.clear();
                        success = executeBatch ? this.insertBatchToDerbyTable(dConn, cid, cust_name, since, addr, size, exList) : this.insertToDerbyTable(dConn, cid, cust_name, since, addr, size, exList);
                        ++count;
                    }
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    throw new TestException("insert to trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
                }
            }
        } else {
            try {
                if (this.generateIdAlways || this.generateDefaultId) {
                    this.insertToGfxdTableGenerateId(gConn, cust_name, since, addr, size, true);
                } else {
                    this.insertToGFETable(gConn, cid, cust_name, since, addr, size, true);
                }
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException("insert to gfe trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
            }
        }
        if (insertNetworth) {
            TradeNetworthDMLStmtJson networth = new TradeNetworthDMLStmtJson();
            String sql = null;
            if (this.generateIdAlways) {
                sql = "select cid from trade.customers where tid = " + TradeCustomersDMLStmtJson.getMyTid() + " and cid not in (select cid from trade.networth where tid = " + TradeCustomersDMLStmtJson.getMyTid() + ")";
                boolean gotCid = this.getGeneratedCid(gConn, cid, sql);
                while (!gotCid) {
                    gotCid = this.getGeneratedCid(gConn, cid, sql);
                }
            } else if (this.generateDefaultId) {
                sql = "select max(cid) cid from trade.customers where tid = " + TradeCustomersDMLStmtJson.getMyTid();
                boolean gotCid = this.getGeneratedCid(gConn, cid, sql);
                while (!gotCid) {
                    gotCid = this.getGeneratedCid(gConn, cid, sql);
                }
            }
            networth.insert(dConn, gConn, size, cid);
            if (dConn != null) {
                this.commit(dConn);
            }
            this.commit(gConn);
        }
    }

    protected String getJSON(int cid, int tid, Date since, String cust_name, String addr) {
        if (!SQLTest.hasJSON) {
            return " ";
        }
        JSONObject json = new JSONObject();
        try {
            json.put("cid", cid);
            if (cust_name == null) {
                json.put("cust_name", JSONObject.NULL);
            } else {
                json.put("cust_name", (Object)cust_name);
            }
            if (addr == null) {
                json.put("addr", JSONObject.NULL);
            } else {
                json.put("addr", (Object)addr);
            }
            json.put("since", (Object)since);
            json.put("tid", tid);
        }
        catch (JSONException je) {
            throw new TestException(TestHelper.getStackTrace((Throwable)je));
        }
        return json.toString();
    }

    protected Map<String, Object> getCurrentRowOfUpdate(Connection conn, int cid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String query = "select cust_name ,  addr , since ,tid from trade.customers where cid = " + cid;
        try {
            ResultSet rs = conn.createStatement().executeQuery(query);
            if (rs.next()) {
                map.put("cid", cid);
                map.put("cust_name", rs.getString(1));
                map.put("addr", rs.getString(2));
                map.put("since", rs.getDate(3));
                map.put("tid", rs.getString(4));
            } else {
                map.put("cid", cid);
                map.put("cust_name", null);
                map.put("addr", null);
                map.put("since", null);
                map.put("tid", null);
            }
        }
        catch (SQLException se) {
            throw new TestException(TestHelper.getStackTrace((Throwable)se));
        }
        return map;
    }
}

