/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements.json;

import hydra.Log;
import hydra.MasterController;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradeNetworthDMLStmtJson
extends AbstractDMLStmt {
    protected static String insert = "insert into trade.networth (cid , cash , securities , loanlimit , availloan ,  tid )   values (?,?,?,?,?,?)";
    protected static String put = "put into trade.networth (cid , cash , securities , loanlimit , availloan ,  tid )  values (?,?,?,?,?,?)";
    protected static String[] update = new String[]{"update trade.networth set availloan=availloan-? where cid = ? and tid= ?", "update trade.networth set securities=? where cid = ?  and tid= ?", "update trade.networth set cash=cash-? where cid = ? and tid= ?", "update trade.networth set loanLimit=? where  tid= ? and securities > ?", "update trade.networth set availloan=availloan-? where cid = ? ", "update trade.networth set securities=? where cid = ?  ", "update trade.networth set cash=cash-? where cid = ? ", "update trade.networth set loanLimit=? where securities > ? "};
    protected static String[] select = new String[]{"select * from trade.networth where tid = ?", "select cid, (cash + securities - (loanLimit - availloan))as networth from trade.networth where tid = ? order by networth desc, cid", "select cid, loanlimit, availloan from trade.networth where (loanlimit >? and loanlimit-availloan <= ?) and tid=? ", "select cid, cash, securities from trade.networth where (cash<? or securities >=?) and tid =?", "select * from trade.networth where (cash > loanLimit - availloan) and tid =?", "select cash, securities, loanlimit, cid, availloan from trade.networth where (cash <=securities or cash > loanLimit - availloan) and tid =?", "select securities, cash, availloan, loanlimit, cid, availloan from trade.networth where (availloan >=securities or cash > loanLimit - availloan) and tid = ?", "select * from trade.networth", "select cid, (cash + securities - (loanLimit - availloan)) as networth from trade.networth", "select cid, loanlimit, availloan from trade.networth where (loanlimit >? and loanlimit-availloan <= ?)", "select cid, cash, securities from trade.networth where (cash<? or securities >=?) ", "select * from trade.networth where (cash > loanLimit - availloan)", "select cash, securities, loanlimit, cid, availloan from trade.networth where (cash <=securities or cash > loanLimit - availloan)", "select securities, cash, availloan, loanlimit, cid, availloan from trade.networth where (availloan >=securities or cash > loanLimit - availloan)"};
    protected static String[] delete = new String[]{"delete from trade.networth where cid = ?", "delete from trade.networth where cid=?"};
    protected static String insertJSON = "insert into trade.networth (cid , cash , securities , loanlimit , availloan ,  tid , json_details )   values (?,?,?,?,?,?,?)";
    protected static String putJSON = "put into trade.networth (cid , cash , securities , loanlimit , availloan ,  tid ,json_details )  values (?,?,?,?,?,?,?)";
    protected static String[] selectJSON = new String[]{"select cast(json_evalPath(json_details, '$..networth.cid')  as integer) as cid ,  cash , securities ,   cast(json_evalPath(json_details, '$..networth.loanlimit')  as integer) as loanlimit, availloan  ,  cast(json_evalPath(json_details, '$..networth.tid')  as integer) as tid from trade.networth where tid = ?", "select cid, (cash + securities - ( cast(json_evalPath(json_details, '$..networth.loanlimit')  as integer)  - availloan  )) as networth from trade.networth where tid = ? order by networth desc, cid", "select cid, loanlimit, availloan from trade.networth where (loanlimit >? and cast(json_evalPath(json_details, '$..networth[0].loanlimit')  as integer) -availloan <= ?) and tid=? ", "select cast ( json_evalPath(trade.customers.networth_json ,'$..networth[-1:].cid') as Integer)  as cid , cash, securities from trade.networth , trade.customers  where trade.customers.cid = trade.networth.cid and (cash<? or securities >=?)  and cast(json_evalPath(trade.networth.json_details, '$..networth.tid')  as integer)  =?", "select cast(json_evalPath(trade.customers.networth_json , '$..networth[0].cid') as integer)  as cid, cash,securities,loanlimit, availloan , trade.networth.tid as tid from trade.networth , trade.customers where trade.networth.cid = trade.customers.cid and (cash > cast(json_evalPath(trade.networth.json_details, '$..networth.loanlimit')  as integer)  - availloan ) and trade.networth.tid =?", "select cash, securities, loanlimit, cid, availloan from trade.networth where (cash <=securities or cash  > ( loanLimit - availloan) ) and tid =?", "select securities, cash, availloan, loanlimit, cid, availloan from trade.networth where (availloan >=securities or cash > loanLimit - availloan) and tid = ?", "select cast(json_evalPath(json_details, '$..networth.cid')  as integer) as cid ,  cash , securities ,   cast(json_evalPath(json_details, '$..networth.loanlimit')  as integer) as loanlimit, availloan  ,  cast(json_evalPath(json_details, '$..networth.tid')  as integer) as tid from trade.networth", "select cid, (cash + securities - ( cast(json_evalPath(json_details, '$..networth.loanlimit')  as integer)  - availloan  )) as networth from trade.networth  order by networth desc, cid", "select cid, loanlimit, availloan from trade.networth where (loanlimit >? and cast(json_evalPath(json_details, '$..networth[0].loanlimit')  as integer) -availloan <= ?)  ", "select cast ( json_evalPath(json_details ,'$..networth[-1:].cid') as Integer)  as cid , cash, securities from trade.networth where (cash<? or securities >=?)", "select cast(json_evalPath(json_details , '$..networth[0].cid') as integer)  as cid, cash,securities,loanlimit, availloan , trade.networth.tid as tid from trade.networth where (cash > loanLimit - availloan)", "select cash, securities, loanlimit, cid, availloan from trade.networth where (cash <=securities or cash  > ( loanLimit - availloan) )", "select securities, cash, availloan, loanlimit, cid, availloan from trade.networth where (availloan >=securities or cash > loanLimit - availloan) "};
    protected static String[] updateJSON = new String[]{"update trade.networth set availloan=availloan-? , json_details = ? where json_evalPath(json_details, '$..networth[?(@.cid == -- && @.tid == -- )]') is not null", "update trade.networth set securities=? , json_details = ? where json_evalPath(json_details, '$..networth[?(@.cid == -- && @.tid == -- )]') is not null", "update trade.networth set cash=cash-? , json_details = ? where json_evalPath(json_details, '$..networth[?(@.cid == -- && @.tid == -- )]') is not null", "update trade.networth set loanLimit=? , json_details = ? where tid = ?and  securities > ? ", "update trade.networth set availloan=availloan-?  , json_details = ? where cast(json_evalPath(json_details, '$..networth.cid')  as integer)  = ? ", "update trade.networth set securities=? ,  json_details = ? where cast(json_evalPath(json_details, '$..networth.cid')  as integer)  = ?  ", "update trade.networth set cash=cash-? , json_details = ? where cid = ? ", "update trade.networth set loanLimit=? , json_details = ? where securities > ? "};
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    protected static int maxNumOfTries = 2;
    protected static int[] loanLimits = new int[]{1000, 2000, 5000, 10000, 20000, 50000, 100000, 1000000, Integer.MAX_VALUE};
    protected static int numOfNonUniqUpdate = 4;
    protected static int numOfNonUniq = 7;
    protected static ArrayList<String> partitionKeys = null;
    protected static boolean hasTx = SQLTest.hasTx;

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
    }

    @Override
    public void put(Connection dConn, Connection gConn, int size) {
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        int[] whichUpdate = new int[size];
        int[] cid = new int[size];
        BigDecimal[] availLoanDelta = new BigDecimal[size];
        BigDecimal[] sec = new BigDecimal[size];
        BigDecimal[] cashDelta = new BigDecimal[size];
        int[] newLoanLimit = new int[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            if (rand.nextInt(numGettingDataFromDerby) == 1) {
                this.getDataForUpdate(dConn, cid, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate, size);
            } else {
                this.getDataForUpdate(gConn, cid, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate, size);
            }
            boolean success = this.updateDerbyTable(dConn, cid, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate, size, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the update op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.updateDerbyTable(dConn, cid, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate, size, exceptionList);
            }
            this.updateGFETable(gConn, cid, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate, size, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.getDataForUpdate(gConn, cid, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate, size);
            this.updateGFETable(gConn, cid, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate, size);
        }
    }

    @Override
    public void delete(Connection dConn, Connection gConn) {
        int numOfNonUniqDelete = delete.length / 2;
        int whichDelete = this.getWhichOne(numOfNonUniqDelete, delete.length);
        int cid = dConn != null && rand.nextInt(numGettingDataFromDerby) == 1 ? TradeNetworthDMLStmtJson.getCid(dConn) : TradeNetworthDMLStmtJson.getCid(gConn);
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, whichDelete, cid, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the delete op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                success = this.deleteFromDerbyTable(dConn, whichDelete, cid, exceptionList);
            }
            this.deleteFromGFETable(gConn, whichDelete, cid, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.deleteFromGFETable(gConn, whichDelete, cid);
        }
    }

    @Override
    public void query(Connection dConn, Connection gConn) {
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        int cash = 100000;
        int sec = 100000;
        int tid = TradeNetworthDMLStmtJson.getMyTid();
        int loanLimit = loanLimits[rand.nextInt(loanLimits.length)];
        BigDecimal loanAmount = new BigDecimal(Integer.toString(rand.nextInt(loanLimit)));
        BigDecimal queryCash = new BigDecimal(Integer.toString(rand.nextInt(cash)));
        BigDecimal querySec = new BigDecimal(Integer.toString(rand.nextInt(sec)));
        ResultSet discRS = null;
        ResultSet gfeRS = null;
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            try {
                discRS = TradeNetworthDMLStmtJson.query(dConn, whichQuery, queryCash, querySec, loanLimit, loanAmount, tid);
                if (discRS == null) {
                    Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                    if (!alterTableDropColumn || SQLTest.alterTableException.get() == null || !((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                        return;
                    }
                }
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exceptionList);
            }
            try {
                gfeRS = TradeNetworthDMLStmtJson.query(gConn, whichQuery, queryCash, querySec, loanLimit, loanAmount, tid);
                if (gfeRS == null) {
                    if (isHATest) {
                        Log.getLogWriter().info("Testing HA and did not get GFXD result set after retry");
                        return;
                    }
                    if (setCriticalHeap) {
                        Log.getLogWriter().info("got XCL54 and does not get query result");
                        return;
                    }
                    throw new TestException("Not able to get gfe result set after retry");
                }
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptionList);
            }
            SQLHelper.handleMissedSQLException(exceptionList);
            if (discRS == null || gfeRS == null) {
                return;
            }
            boolean success = false;
            success = whichQuery == 1 ? ResultSetHelper.compareSortedResultSets(discRS, gfeRS) : ResultSetHelper.compareResultSets(discRS, gfeRS);
            if (!success) {
                Log.getLogWriter().info("Not able to compare results due to derby server error");
            }
        } else {
            try {
                gfeRS = TradeNetworthDMLStmtJson.query(gConn, whichQuery, queryCash, querySec, loanLimit, loanAmount, tid);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && SQLTest.testSecurity) {
                    Log.getLogWriter().info("Got expected no SELECT permission, continuing test");
                    return;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X04")) {
                    Log.getLogWriter().info("Got expected column not found exception, continuing test");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            if (gfeRS != null) {
                ResultSetHelper.asList(gfeRS, false);
            } else if (isHATest) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            } else if (setCriticalHeap) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to XCL54");
            } else {
                throw new TestException("gfxd query returns null and not a HA test");
            }
        }
    }

    protected void getDataForInsert(BigDecimal[] cash, int[] loanLimit, BigDecimal[] availLoan, int size) {
        int minStart = 1000;
        int maxStart = 100000;
        int numLimits = loanLimits.length;
        int start = rand.nextInt(maxStart - minStart + 1) + minStart;
        for (int i = 0; i < size; ++i) {
            cash[i] = new BigDecimal(Integer.toString(rand.nextInt(start)));
            loanLimit[i] = loanLimits[rand.nextInt(numLimits)];
            availLoan[i] = new BigDecimal(Integer.toString(loanLimit[i]));
        }
    }

    public void insert(Connection dConn, Connection gConn, int size, int[] cid) {
        BigDecimal[] cash = new BigDecimal[size];
        int[] loanLimit = new int[size];
        BigDecimal[] availLoan = new BigDecimal[size];
        this.getDataForInsert(cash, loanLimit, availLoan, size);
        BigDecimal securities = new BigDecimal(Integer.toString(0));
        ArrayList<SQLException> exList = new ArrayList<SQLException>();
        if (dConn != null) {
            boolean success = this.insertToDerbyTable(dConn, cid, cash, securities, loanLimit, availLoan, size, exList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the insert op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                ++count;
                exList.clear();
                success = this.insertToDerbyTable(dConn, cid, cash, securities, loanLimit, availLoan, size, exList);
            }
            try {
                this.insertToGFETable(gConn, cid, cash, securities, loanLimit, availLoan, size, exList);
            }
            catch (TestException te) {
                if (te.getMessage().contains("Execute SQL statement failed with: 23505") && isHATest && SQLTest.isEdge) {
                    try {
                        this.checkTicket49605(dConn, gConn, "customers", cid[0], -1, null, null);
                    }
                    catch (TestException e) {
                        Log.getLogWriter().info("insert failed due to #49605 ", (Throwable)e);
                        Log.getLogWriter().info("retry this using put to work around #49605");
                        this.insertToGFETable(gConn, cid, cash, securities, loanLimit, availLoan, size, exList, true);
                        this.checkTicket49605(dConn, gConn, "customers", cid[0], -1, null, null);
                    }
                }
                throw te;
            }
            SQLHelper.handleMissedSQLException(exList);
        } else {
            this.insertToGFETable(gConn, cid, cash, securities, loanLimit, availLoan, size);
        }
    }

    public void insertTx(Connection dConn, Connection gConn, int size, int[] cid) {
        Log.getLogWriter().info("Needs to be implemented");
    }

    protected boolean insertToDerbyTable(Connection conn, int[] cid, BigDecimal[] cash, BigDecimal securities, int[] loanLimit, BigDecimal[] availLoan, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = TradeNetworthDMLStmtJson.getStmt(conn, insert);
        if (stmt == null) {
            return false;
        }
        int tid = TradeNetworthDMLStmtJson.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                verifyRowCount.put(tid + "_insert" + i, 0);
                count = this.insertToTable(stmt, cid[i], cash[i], securities, loanLimit[i], availLoan[i], tid);
                verifyRowCount.put(tid + "_insert" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected void insertToGFETable(Connection conn, int[] cid, BigDecimal[] cash, BigDecimal securities, int[] loanLimit, BigDecimal[] availLoan, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = SQLTest.hasJSON ? TradeNetworthDMLStmtJson.getStmt(conn, insertJSON) : TradeNetworthDMLStmtJson.getStmt(conn, insert);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeNetworthDMLStmtJson.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, cid[i], cash[i], securities, loanLimit[i], availLoan[i], tid);
                if (count == verifyRowCount.get(tid + "_insert" + i)) continue;
                Log.getLogWriter().info("Gfxd insert has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void insertToGFETable(Connection conn, int[] cid, BigDecimal[] cash, BigDecimal securities, int[] loanLimit, BigDecimal[] availLoan, int size, List<SQLException> exceptions, boolean isPut) {
        PreparedStatement stmt = SQLTest.hasJSON ? TradeNetworthDMLStmtJson.getStmt(conn, isPut ? putJSON : insertJSON) : TradeNetworthDMLStmtJson.getStmt(conn, isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeNetworthDMLStmtJson.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, cid[i], cash[i], securities, loanLimit[i], availLoan[i], tid, isPut);
                if (count == verifyRowCount.get(tid + "_insert" + i)) continue;
                Log.getLogWriter().info("Gfxd insert has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void insertToGFETable(Connection conn, int[] cid, BigDecimal[] cash, BigDecimal securities, int[] loanLimit, BigDecimal[] availLoan, int size) {
        PreparedStatement stmt = SQLTest.hasJSON ? TradeNetworthDMLStmtJson.getStmt(conn, insertJSON) : TradeNetworthDMLStmtJson.getStmt(conn, insert);
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeNetworthDMLStmtJson.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, cid[i], cash[i], securities, loanLimit[i], availLoan[i], tid);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("detected foreign key constraint violation during insert, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42802")) {
                    Log.getLogWriter().info("Got expected column not found exception in insert, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("23505") && isHATest && SQLTest.isEdge) {
                    Log.getLogWriter().info("detected pk constraint violation during insert -- relaxing due to #43571, continuing test");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int cid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan, int tid) throws SQLException {
        return this.insertToTable(stmt, cid, cash, securities, loanLimit, availLoan, tid, false);
    }

    protected int insertToTable(PreparedStatement stmt, int cid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan, int tid, boolean isPut) throws SQLException {
        String jsonLog = "";
        String jsontext = "";
        if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
            jsontext = this.getJSON(cid, cash, securities, loanLimit, availLoan, tid);
            jsonLog = ", JSON_DETAILS: " + jsontext;
        }
        String txid = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - " + txid + " ";
        Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.networth with CID:" + cid + ",CASH:" + cash + ":SECURITIES," + securities + ",LOANLIMIT:" + loanLimit + ",AVAILLOAN:" + availLoan + ",TID:" + tid + jsonLog);
        stmt.setInt(1, cid);
        stmt.setBigDecimal(2, cash);
        stmt.setBigDecimal(3, securities);
        stmt.setInt(4, loanLimit);
        stmt.setBigDecimal(5, availLoan);
        stmt.setInt(6, tid);
        if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
            stmt.setObject(7, jsontext);
        }
        int rowCount = stmt.executeUpdate();
        if (!SQLTest.hasTx && !setCriticalHeap) {
            this.updateJSONToCustomer(stmt.getConnection(), cid, this.getJSONObject(cid, cash, securities, loanLimit, availLoan, tid));
        }
        Log.getLogWriter().info(database + (isPut ? "put" : "inserted ") + rowCount + " rows in trade.networth CID:" + cid + ",CASH:" + cash + ":SECURITIES," + securities + ",LOANLIMIT:" + loanLimit + ",AVAILLOAN:" + availLoan + ",TID:" + tid + jsonLog);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        if (database.contains("gemfirexd") && isPut) {
            if (!SQLTest.ticket49794fixed) {
                String deleteStatement = "DELETE FROM TRADE.NETWORTH_FULLDATASET  WHERE  cid = " + cid;
                String insertStatement = " INSERT INTO TRADE.NETWORTH_FULLDATASET  VALUES ( " + cid + " ,  " + cash + " ,  " + securities + "," + loanLimit + " ,  " + availLoan + "," + tid + ")";
                Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence deleting  the  row  from TRADE.NETWORTH_FULLDATASET with data CID:" + cid);
                stmt.getConnection().createStatement().execute(deleteStatement);
                Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence inserting  the  row  into  TRADE.NETWORTH_FULLDATASET with data CID:" + cid + ",CASH:" + cash + ",SECURITIES:" + securities + " ,LOANLIMIT:" + loanLimit + " ,AVAILLOAN:" + availLoan + ",TID:" + tid);
                stmt.getConnection().createStatement().execute(insertStatement);
            }
            Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " into trade.networth with CID:" + cid + ",CASH:" + cash + ":SECURITIES," + securities + ",LOANLIMIT:" + loanLimit + ",AVAILLOAN:" + availLoan + ",TID:" + tid);
            rowCount = stmt.executeUpdate();
            Log.getLogWriter().info(database + (isPut ? "put" : "inserted ") + rowCount + " rows in trade.networth CID:" + cid + ",CASH:" + cash + ":SECURITIES," + securities + ",LOANLIMIT:" + loanLimit + ",AVAILLOAN:" + availLoan + ",TID:" + tid);
            warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        return rowCount;
    }

    protected void getDataForUpdate(Connection conn, int[] cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, int[] whichUpdate, int size) {
        int maxAvailLimitDelta = 10000;
        int maxCashDelta = 10000;
        int maxSec = 1000000;
        for (int i = 0; i < size; ++i) {
            cid[i] = testUniqueKeys || testWanUniqueness ? TradeNetworthDMLStmtJson.getCid(conn) : rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary)) + 1;
            availLoanDelta[i] = new BigDecimal(Double.toString((double)rand.nextInt(maxAvailLimitDelta * 100 + 1) * 0.01));
            sec[i] = new BigDecimal(Double.toString((double)rand.nextInt(maxSec * 100 + 1) * 0.01));
            cashDelta[i] = new BigDecimal(Double.toString((double)rand.nextInt(maxCashDelta * 100 + 1) * 0.01));
            newLoanLimit[i] = loanLimits[rand.nextInt(loanLimits.length)];
            whichUpdate[i] = this.getWhichOne(numOfNonUniqUpdate, update.length);
            if ((!SQLTest.testSecurity || whichUpdate[i] != 3 || hasTx) && (!setCriticalHeap || whichUpdate[i] != 3)) continue;
            int n = i;
            whichUpdate[n] = whichUpdate[n] - 1;
        }
    }

    protected boolean updateDerbyTable(Connection conn, int[] cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, int[] whichUpdate, int size, List<SQLException> exList) {
        PreparedStatement stmt = null;
        int tid = TradeNetworthDMLStmtJson.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            if (isHATest && (whichUpdate[i] == 0 || whichUpdate[i] == 2)) continue;
            boolean[] unsupported = new boolean[1];
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i], unsupported) : TradeNetworthDMLStmtJson.getStmt(conn, update[whichUpdate[i]]);
            if (stmt == null) {
                if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                    return true;
                }
                return unsupported[0];
            }
            try {
                if (stmt == null) continue;
                verifyRowCount.put(tid + "_update" + i, 0);
                count = this.updateTable(stmt, cid[i], availLoanDelta[i], sec[i], cashDelta[i], newLoanLimit[i], tid, whichUpdate[i]);
                verifyRowCount.put(tid + "_update" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    Log.getLogWriter().info("detected the deadlock, will try it again");
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exList);
            }
        }
        return true;
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, boolean[] unsupported) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys, unsupported);
    }

    protected void setPartitionKeys() {
        if (!isWanTest) {
            partitionKeys = (ArrayList)partitionMap.get((Object)"networthPartition");
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_networthPartition"));
        }
        Log.getLogWriter().info("partition keys are " + partitionKeys);
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys, boolean[] unsupported) {
        PreparedStatement stmt = null;
        String[] update = TradeNetworthDMLStmtJson.update;
        if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(conn)) {
            update = updateJSON;
        }
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("availloan")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeNetworthDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("securities")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeNetworthDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("cash")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeNetworthDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("loanLimit")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeNetworthDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                if (partitionKeys.contains("availloan")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeNetworthDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 5: {
                if (partitionKeys.contains("securities")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeNetworthDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 6: {
                if (partitionKeys.contains("cash")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeNetworthDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 7: {
                if (partitionKeys.contains("loanLimit")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeNetworthDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected void updateGFETable(Connection conn, int[] cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, int[] whichUpdate, int size, List<SQLException> exList) {
        PreparedStatement stmt = null;
        int tid = TradeNetworthDMLStmtJson.getMyTid();
        int count = -2;
        for (int i = 0; i < size; ++i) {
            if (isHATest && (whichUpdate[i] == 0 || whichUpdate[i] == 2)) continue;
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i], null) : TradeNetworthDMLStmtJson.getStmt(conn, SQLTest.hasJSON ? updateJSON[whichUpdate[i]] : update[whichUpdate[i]]);
            if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
                SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
                SQLSecurityTest.prepareStmtException.set(null);
                return;
            }
            if (setCriticalHeap && stmt == null) {
                return;
            }
            try {
                if (stmt == null || (count = this.updateTable(stmt, cid[i], availLoanDelta[i], sec[i], cashDelta[i], newLoanLimit[i], tid, whichUpdate[i])) == verifyRowCount.get(tid + "_update" + i)) continue;
                Log.getLogWriter().info("Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + count);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exList);
            }
        }
    }

    protected void updateGFETable(Connection conn, int[] cid, BigDecimal[] availLoanDelta, BigDecimal[] sec, BigDecimal[] cashDelta, int[] newLoanLimit, int[] whichUpdate, int size) {
        PreparedStatement stmt = null;
        int tid = TradeNetworthDMLStmtJson.getMyTid();
        for (int i = 0; i < size; ++i) {
            if (isHATest && whichUpdate[i] % 2 == 0) continue;
            stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate[i], null) : TradeNetworthDMLStmtJson.getStmt(conn, update[whichUpdate[i]]);
            try {
                if (stmt == null) continue;
                this.updateTable(stmt, cid[i], availLoanDelta[i], sec[i], cashDelta[i], newLoanLimit[i], tid, whichUpdate[i]);
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23513")) {
                    Log.getLogWriter().info("detected the constraint check violation, continuing test");
                    continue;
                }
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && (se.getSQLState().equals("42X14") || se.getSQLState().equals("42X04"))) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int updateTable(PreparedStatement stmt, int cid, BigDecimal availLoanDelta, BigDecimal sec, BigDecimal cashDelta, int newLoanLimit, int tid, int whichUpdate) throws SQLException {
        SQLWarning warning;
        int rowCount = 0;
        String txid = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - " + txid + " ";
        String query = " QUERY: " + update[whichUpdate];
        String jsonString = "";
        String jsonLog = "";
        JSONObject json = new JSONObject();
        HashMap map = new HashMap();
        if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
            map = (HashMap)this.getCurrentRowOfUpdate(stmt.getConnection(), cid);
            query = " QUERY: " + updateJSON[whichUpdate];
        }
        int i = 1;
        switch (whichUpdate) {
            case 0: {
                String jsonQuery;
                if (!SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSONObject(cid, (BigDecimal)map.get("cash"), (BigDecimal)map.get("securities"), (Integer)map.get("loanlimit"), ((BigDecimal)map.get("availloan")).subtract(availLoanDelta), (Integer)map.get("tid"));
                    jsonString = json.toJSONString();
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                    jsonQuery = updateJSON[whichUpdate].replaceFirst("--", Integer.toString(cid));
                    jsonQuery = jsonQuery.replaceFirst("--", Integer.toString(tid));
                    stmt = stmt.getConnection().prepareStatement(jsonQuery);
                }
                Log.getLogWriter().info(database + "updating trade.networth with AVAILLOAN:(availLoan-" + availLoanDelta + ")  " + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                stmt.setBigDecimal(i++, availLoanDelta);
                if (!SQLHelper.isDerbyConn(stmt.getConnection())) {
                    stmt.setString(i++, jsonString);
                } else {
                    stmt.setInt(i++, cid);
                    stmt.setInt(i++, tid);
                }
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.networth  AVAILLOAN:(availLoan-" + availLoanDelta + ") " + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 1: {
                String jsonQuery;
                if (!SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSONObject(cid, (BigDecimal)map.get("cash"), sec, (Integer)map.get("loanlimit"), (BigDecimal)map.get("availloan"), (Integer)map.get("tid"));
                    jsonString = json.toJSONString();
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                    jsonQuery = updateJSON[whichUpdate].replaceFirst("--", Integer.toString(cid));
                    jsonQuery = jsonQuery.replaceFirst("--", Integer.toString(tid));
                    stmt = stmt.getConnection().prepareStatement(jsonQuery);
                }
                Log.getLogWriter().info(database + "updating trade.networth with SECURITIES:" + sec + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                stmt.setBigDecimal(i++, sec);
                if (!SQLHelper.isDerbyConn(stmt.getConnection())) {
                    stmt.setString(i++, jsonString);
                } else {
                    stmt.setInt(i++, cid);
                    stmt.setInt(i++, tid);
                }
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.networth SECURITIES:" + sec + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 2: {
                String jsonQuery;
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSONObject(cid, ((BigDecimal)map.get("cash")).subtract(cashDelta), (BigDecimal)map.get("securities"), (Integer)map.get("loanlimit"), (BigDecimal)map.get("availloan"), (Integer)map.get("tid"));
                    jsonString = json.toJSONString();
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                    jsonQuery = updateJSON[whichUpdate].replaceFirst("--", Integer.toString(cid));
                    jsonQuery = jsonQuery.replaceFirst("--", Integer.toString(tid));
                    stmt = stmt.getConnection().prepareStatement(jsonQuery);
                }
                Log.getLogWriter().info(database + "updating trade.networth with CASH:(cash-" + cashDelta + ") " + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                stmt.setBigDecimal(i++, cashDelta);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    stmt.setObject(i++, jsonString);
                } else {
                    stmt.setInt(i++, cid);
                    stmt.setInt(i++, tid);
                }
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.networth CASH:(cash-" + cashDelta + ") " + jsonLog + " where CID:" + cid + ",TID:" + tid + query);
                break;
            }
            case 3: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSONObject(cid, (BigDecimal)map.get("cash"), (BigDecimal)map.get("securities"), newLoanLimit, (BigDecimal)map.get("availloan"), (Integer)map.get("tid"));
                    jsonString = json.toJSONString();
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                if (!hasTx || SQLTest.hasJSON) {
                    Log.getLogWriter().info(database + "updating trade.networth multiple rows -- will not execute due to limitation " + "when exception is thrown due to constraint check, some rows are updated already" + query);
                    break;
                }
                Log.getLogWriter().info(database + "updating trade.networth with LOANLIMIT:" + newLoanLimit + jsonLog + " where SECURITIES:" + sec + ",TID:" + tid + query);
                stmt.setInt(i++, newLoanLimit);
                if (!SQLHelper.isDerbyConn(stmt.getConnection())) {
                    stmt.setObject(i++, jsonString);
                }
                stmt.setInt(i++, tid);
                stmt.setBigDecimal(i++, sec);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.networth LOANLIMIT:" + newLoanLimit + jsonLog + " where SECURITIES:" + sec + ",TID:" + tid + query);
                break;
            }
            case 4: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSONObject(cid, (BigDecimal)map.get("cash"), (BigDecimal)map.get("securities"), (Integer)map.get("loanlimit"), ((BigDecimal)map.get("availloan")).subtract(availLoanDelta), (Integer)map.get("tid"));
                    jsonString = json.toJSONString();
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                Log.getLogWriter().info(database + "updating trade.networth with AVAILLOAN:(availLoan- " + availLoanDelta + ") " + jsonLog + " where CID:" + cid + query);
                stmt.setBigDecimal(i++, availLoanDelta);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    stmt.setString(i++, jsonString);
                }
                stmt.setInt(i++, cid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.networth AVAILLOAN:(availLoan- " + availLoanDelta + ") " + jsonLog + " where CID:" + cid + query);
                break;
            }
            case 5: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSONObject(cid, (BigDecimal)map.get("cash"), sec, (Integer)map.get("loanlimit"), (BigDecimal)map.get("availloan"), (Integer)map.get("tid"));
                    jsonString = json.toJSONString();
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                Log.getLogWriter().info(database + "updating trade.networth with SECURITIES = " + sec + jsonLog + " where CID:" + cid + query);
                stmt.setBigDecimal(i++, sec);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    stmt.setString(i++, jsonString);
                }
                stmt.setInt(i++, cid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.networth SECURITIES = " + sec + jsonLog + " where CID:" + cid + query);
                break;
            }
            case 6: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSONObject(cid, ((BigDecimal)map.get("cash")).subtract(cashDelta), (BigDecimal)map.get("securities"), (Integer)map.get("loanlimit"), (BigDecimal)map.get("availloan"), (Integer)map.get("tid"));
                    jsonString = json.toJSONString();
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                Log.getLogWriter().info(database + "updating trade.networth with CASH:(cash- " + cashDelta + ") " + jsonLog + " where CID:" + cid + query);
                stmt.setBigDecimal(i++, cashDelta);
                if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    stmt.setString(i++, jsonString);
                }
                stmt.setInt(i++, cid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.networth CASH:(cash- " + cashDelta + ") " + jsonLog + " where CID:" + cid + query);
                break;
            }
            case 7: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSONObject(cid, (BigDecimal)map.get("cash"), (BigDecimal)map.get("securities"), newLoanLimit, (BigDecimal)map.get("availloan"), (Integer)map.get("tid"));
                    jsonString = json.toJSONString();
                    jsonLog = ",JSON_DETAILS: " + jsonString;
                }
                if (!(SQLTest.hasAsyncDBSync || isSerial || SQLTest.hasJSON)) {
                    Log.getLogWriter().info(database + "updating trade.networth  LOANLIMIT:" + newLoanLimit + jsonLog + " where SECURITIES:" + sec + query);
                    stmt.setInt(i++, newLoanLimit);
                    if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection())) {
                        stmt.setString(i++, jsonString);
                    }
                    stmt.setBigDecimal(i++, sec);
                    rowCount = stmt.executeUpdate();
                    Log.getLogWriter().info(database + "updated " + rowCount + " rows in trade.networth LOANLIMIT:" + newLoanLimit + jsonLog + " where SECURITIES:" + sec + query);
                    break;
                }
                Log.getLogWriter().info(database + "update multiple rows in trade.networth -- will not execute due to limitation: " + "when exception is thrown due to constraint check, some rows are updated already" + query);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection()) && !SQLTest.hasTx) {
            this.updateJSONToCustomer(stmt.getConnection(), cid, json);
        }
        if ((warning = stmt.getWarnings()) != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, BigDecimal cash, BigDecimal sec, int loanLimit, BigDecimal loanAmount, int tid) {
        ResultSet rs;
        block4: {
            boolean[] success = new boolean[1];
            rs = null;
            try {
                rs = TradeNetworthDMLStmtJson.getQuery(conn, whichQuery, cash, sec, loanLimit, loanAmount, tid, success);
                int count = 0;
                while (!success[0]) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                        return null;
                    }
                    ++count;
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    rs = TradeNetworthDMLStmtJson.getQuery(conn, whichQuery, cash, sec, loanLimit, loanAmount, tid, success);
                }
            }
            catch (SQLException se) {
                if (SQLHelper.isAlterTableException(conn, se)) break block4;
                SQLHelper.handleSQLException(se);
            }
        }
        return rs;
    }

    protected static ResultSet query(Connection conn, int whichQuery, BigDecimal cash, BigDecimal sec, int loanLimit, BigDecimal loanAmount, int tid) throws SQLException {
        boolean[] success = new boolean[1];
        ResultSet rs = TradeNetworthDMLStmtJson.getQuery(conn, whichQuery, cash, sec, loanLimit, loanAmount, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = TradeNetworthDMLStmtJson.getQuery(conn, whichQuery, cash, sec, loanLimit, loanAmount, tid, success);
        }
        return rs;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, BigDecimal cash, BigDecimal sec, int loanLimit, BigDecimal loanAmount, int tid, boolean[] success) throws SQLException {
        String database;
        ResultSet rs = null;
        success[0] = true;
        String string = database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
        if ((SQLTest.hasHdfs || SQLTest.hasTx || setCriticalHeap) && (whichQuery == 3 || whichQuery == 4)) {
            whichQuery = 5;
        }
        String query = " QUERY: " + select[whichQuery];
        if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(conn)) {
            query = " QUERY: " + selectJSON[whichQuery];
        }
        try {
            PreparedStatement stmt = SQLTest.hasJSON && !SQLHelper.isDerbyConn(conn) ? conn.prepareStatement(selectJSON[whichQuery]) : conn.prepareStatement(select[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.networth with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.networth with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.networth with LOANLIMIT:" + loanLimit + ",LOANAMOUNT:" + loanAmount + ",TID:" + tid + query);
                    stmt.setInt(1, loanLimit);
                    stmt.setBigDecimal(2, loanAmount);
                    stmt.setInt(3, tid);
                    break;
                }
                case 3: {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        String jsonQuery = selectJSON[whichQuery];
                        Log.getLogWriter().info(database + "querying trade.networth with CASH:" + cash + ",SECURITIES:" + sec + ",TID:" + tid + jsonQuery);
                        stmt.setBigDecimal(1, cash);
                        stmt.setBigDecimal(2, sec);
                        stmt.setInt(3, tid);
                        break;
                    }
                    Log.getLogWriter().info(database + "querying trade.networth with CASH:" + cash + ",SECURITIES:" + sec + ",TID:" + tid + query);
                    stmt.setBigDecimal(1, cash);
                    stmt.setBigDecimal(2, sec);
                    stmt.setInt(3, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.networth with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "querying trade.networth with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying trade.networth with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 7: {
                    Log.getLogWriter().info(database + "querying: " + query);
                    break;
                }
                case 8: {
                    Log.getLogWriter().info(database + "querying: " + query);
                    break;
                }
                case 9: {
                    Log.getLogWriter().info(database + "querying trade.networth with LOANLIMIT:" + loanLimit + ",LOANAMOUNT:" + loanAmount + query);
                    stmt.setInt(1, loanLimit);
                    stmt.setBigDecimal(2, loanAmount);
                    break;
                }
                case 10: {
                    Log.getLogWriter().info(database + "querying trade.networth with CASH:" + cash + ",SECURITIES:" + sec + query);
                    stmt.setBigDecimal(1, cash);
                    stmt.setBigDecimal(2, sec);
                    break;
                }
                case 11: {
                    Log.getLogWriter().info(database + "querying: " + query);
                    break;
                }
                case 12: {
                    Log.getLogWriter().info(database + "querying: " + query);
                    break;
                }
                case 13: {
                    Log.getLogWriter().info(database + "querying: " + query);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            throw se;
        }
        return rs;
    }

    protected boolean deleteFromDerbyTable(Connection dConn, int whichDelete, int cid, List<SQLException> exList) {
        PreparedStatement stmt = TradeNetworthDMLStmtJson.getStmt(dConn, delete[whichDelete]);
        if (stmt == null) {
            return false;
        }
        int tid = TradeNetworthDMLStmtJson.getMyTid();
        int count = -1;
        try {
            verifyRowCount.put(tid + "_delete", 0);
            count = this.deleteFromTable(stmt, cid, tid, whichDelete);
            verifyRowCount.put(tid + "_delete", new Integer(count));
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void deleteFromGFETable(Connection gConn, int whichDelete, int cid, List<SQLException> exList) {
        PreparedStatement stmt = TradeNetworthDMLStmtJson.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeNetworthDMLStmtJson.getMyTid();
        int count = -1;
        try {
            count = this.deleteFromTable(stmt, cid, tid, whichDelete);
            if (count != verifyRowCount.get(tid + "_delete")) {
                Log.getLogWriter().info("Gfxd delete (networth) has different row count from that of derby derby deleted " + verifyRowCount.get(tid + "_delete") + " but gfxd deleted " + count);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void deleteFromGFETable(Connection gConn, int whichDelete, int cid) {
        PreparedStatement stmt = TradeNetworthDMLStmtJson.getStmt(gConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeNetworthDMLStmtJson.getMyTid();
        try {
            this.deleteFromTable(stmt, cid, tid, whichDelete);
        }
        catch (SQLException se) {
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                Log.getLogWriter().info("Got expected column not found exception in delete, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected int deleteFromTable(PreparedStatement stmt, int cid, int tid, int whichDelete) throws SQLException {
        SQLWarning warning;
        String database = SQLHelper.isDerbyConn(stmt.getConnection()) ? "Derby - " : "gemfirexd - ";
        String query = " QUERY: " + delete[whichDelete];
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting trade.networth with CID:" + cid + query);
                stmt.setInt(1, cid);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting trade.networth with CID:" + cid + query);
                stmt.setInt(1, cid);
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.networth with CID:" + cid + query);
        if (SQLTest.hasJSON && !SQLHelper.isDerbyConn(stmt.getConnection()) && !SQLTest.hasTx && !setCriticalHeap) {
            this.updateJSONToCustomer(stmt.getConnection(), cid, null);
        }
        if ((warning = stmt.getWarnings()) != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    private void updateJSONToCustomer(Connection conn, int cid, JSONObject json) {
        if (!SQLTest.hasJSON || SQLHelper.isDerbyConn(conn)) {
            return;
        }
        String jsonString = null;
        try {
            if (json != null) {
                jsonString = json.toJSONString();
            }
            Log.getLogWriter().info("updating trade.customers with NETWORTH_JSON:" + jsonString + " where CID:" + cid);
            String stmt = "update trade.customers set networth_json = ? where cid = " + cid;
            PreparedStatement ps = conn.prepareStatement(stmt);
            ps.setObject(1, jsonString);
            ps.execute();
        }
        catch (SQLException se) {
            throw new TestException("Adding " + jsonString + " to trade.customers" + "Exception: " + TestHelper.getStackTrace((Throwable)se));
        }
    }

    private String getJSON(int cid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan, int tid) {
        return this.getJSONObject(cid, cash, securities, loanLimit, availLoan, tid).toJSONString();
    }

    private JSONObject getJSONObject(int cid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan, int tid) {
        JSONArray json = new JSONArray();
        JSONObject arrayObj = new JSONObject();
        arrayObj.put((Object)"cid", (Object)cid);
        arrayObj.put((Object)"cash", (Object)cash);
        arrayObj.put((Object)"securities", (Object)securities);
        arrayObj.put((Object)"loanlimit", (Object)loanLimit);
        arrayObj.put((Object)"availloan", (Object)availLoan);
        arrayObj.put((Object)"tid", (Object)tid);
        json.add((Object)arrayObj);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"networth", (Object)json);
        return jsonObj;
    }

    private Map<String, Object> getCurrentRowOfUpdate(Connection conn, int cid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String query = "select cash, securities, loanlimit,availloan,tid from trade.networth where cid = " + cid;
        try {
            ResultSet rs = conn.createStatement().executeQuery(query);
            if (rs.next()) {
                map.put("cid", cid);
                map.put("cash", rs.getBigDecimal(1));
                map.put("securities", rs.getBigDecimal(2));
                map.put("loanlimit", rs.getInt(3));
                map.put("availloan", rs.getBigDecimal(4));
                map.put("tid", rs.getInt(5));
            } else {
                map.put("cid", cid);
                map.put("cash", new BigDecimal(0));
                map.put("securities", new BigDecimal(0));
                map.put("loanlimit", 0);
                map.put("availloan", new BigDecimal(0));
                map.put("tid", 0);
            }
        }
        catch (SQLException se) {
            throw new TestException(TestHelper.getStackTrace((Throwable)se));
        }
        return map;
    }

    protected static enum Operation {
        INSERT,
        UPDATE,
        DELETE;

    }
}

