/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements.json;

import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.simple.JSONObject;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.AbstractDMLStmt;
import sql.dmlStatements.TradeCompaniesDMLStmt;
import sql.security.SQLSecurityTest;
import sql.sqlTx.SQLDistTxTest;
import sql.sqlutil.ResultSetHelper;
import sql.wan.SQLWanPrms;
import util.TestException;
import util.TestHelper;

public class TradeSecuritiesDMLStmtJson
extends AbstractDMLStmt {
    private static boolean reproduceTicket48725 = true;
    protected static boolean addSecidInProjection = TestConfig.tab().booleanAt(SQLPrms.addSecidInProjection, false);
    protected static String insert = "insert into trade.securities (sec_id, symbol, price, exchange, tid )values (?,?,?,?,?)";
    protected static String put = "put into trade.securities (sec_id, symbol, price, exchange, tid )values (?,?,?,?,?)";
    protected static String[] update = new String[]{"update trade.securities set price = ? where sec_id = ? and tid = ? ", "update trade.securities set symbol = ? where sec_id = ? and tid = ?", "update trade.securities set symbol = ?, exchange =? where sec_id = ? and tid = ?", "update trade.securities set exchange =? where sec_id = ? and tid = ?", "update trade.securities set price = ? where sec_id = ?", "update trade.securities set symbol = ? where sec_id = ? ", "update trade.securities set exchange =? where sec_id = ? "};
    protected static String[] select = new String[]{"select sec_id, symbol, price, exchange, tid from trade.securities where tid = ?", reproduceTicket48725 ? "select cast(avg( distinct price) as decimal (30, 20)) as avg_distinct_price from trade.securities where tid=? and symbol >?" : "select cast(avg( price) as decimal (30, 20)) as avg_price from trade.securities where tid=? and symbol >?", "select " + (addSecidInProjection ? "sec_id, " : "") + "price, symbol, exchange from trade.securities where (price<? or price >=?) and tid =?", "select sec_id, symbol, price, exchange from trade.securities  where (price >=? and price<?) and exchange =? and tid =?", "select sec_id, symbol, price, exchange, tid from trade.securities where sec_id = ?", "select sec_id, price, symbol from trade.securities where symbol >?", "select price, symbol, exchange from trade.securities where (price<? or price >=?) ", "select sec_id, symbol, price, exchange from trade.securities  where (price >=? and price<?) and exchange =?"};
    protected static String[] delete = new String[]{"delete from trade.securities where (sec_id = ? or price = ? ) and tid = ?", "delete from trade.securities where (symbol= ? and exchange = ? ) and tid = ?", "delete from trade.securities where sec_id=?"};
    protected static String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
    protected static String insertJSON = "insert into trade.securities (sec_id, symbol, price, exchange, tid, json_details )values (?,?,?,?,?,?)";
    protected static String putJSON = "put into trade.securities (sec_id, symbol, price, exchange, tid, json_details )values (?,?,?,?,?,?)";
    protected static String[] selectJSON = new String[]{"select  cast(json_evalPath(json_details, 'sec_id') as integer) as sec_id, cast(json_evalPath(json_details, 'symbol') as varchar(10) ) as symbol, price , cast(json_evalPath(json_details, 'exchange') as varchar(10) as exchange,  cast(json_evalPath(json_details, 'tid') as integer)  as tid from trade.securities where tid = ?", reproduceTicket48725 ? "select cast(avg( distinct (price)) as decimal (30, 20)) as avg_distinct_price from trade.securities where tid=? and cast(json_evalPath(json_details, 'symbol') as varchar(10)) > ?" : "select cast(avg( price as decimal (30, 20)) as avg_price from trade.securities where tid=? and and cast(json_evalPath(json_details, 'symbol') as varchar(10)) > ?", "select " + (addSecidInProjection ? "cast(json_evalPath(json_details, 'sec_id')  as integer) as sec_id, " : "") + " price, cast(json_evalPath(json_details, 'symbol') as varchar(10)) as symbol, exchange  from trade.securities where (price<? or price >=?) and tid =?", "select sec_id, symbol, price, cast(json_evalPath(json_details, 'exchange') as varchar(10)) as exchange from trade.securities  where (price >=? and price<?) and cast(json_evalPath(json_details, 'exchange') as varchar(10)) =? and cast(json_evalPath(json_details, 'tid') as integer) =?", "select sec_id,  symbol, price, exchange ,   tid from trade.securities where sec_id = ?", "select sec_id,  price , symbol  from trade.securities where symbol >?", "select price ,  cast(json_evalPath(json_details, 'symbol') as varchar(10)) as symbol  ,  exchange   from trade.securities where (price<? or price >=?) ", "select sec_id,  symbol,  price, cast(json_evalPath(json_details, 'exchange') as varchar(10)) as exchange from trade.securities  where (price >=? and price<?) and cast(json_evalPath(json_details, 'exchange') as varchar(10)) =?"};
    protected static String[] updateJSON = new String[]{"update trade.securities set price = ? , json_details  = ? where  sec_id = ?  and tid =?  ", "update trade.securities set symbol = ? ,  json_details  = ? where (cast(json_evalPath(json_details, 'sec_id')  as integer)) = ? and cast(json_evalPath(json_details, 'tid')  as integer) = ?", "update trade.securities set symbol = ?, exchange =? , json_details = ? where cast(json_evalPath(json_details, 'sec_id')  as integer) = ? and tid = ?", "update trade.securities set exchange =? , json_details = ? where sec_id = ? and tid = ?", "update trade.securities set price = ? ,json_details = ? where cast(json_evalPath(json_details, 'sec_id')  as integer) = ?", "update trade.securities set symbol = ? ,json_details = ? where cast(json_evalPath(json_details, 'sec_id')  as integer) = ? ", "update trade.securities set exchange =? ,json_details = ? where sec_id = ? "};
    protected static String[] deleteJSON = new String[]{"delete from trade.securities where cast(json_evalPath(json_details, 'sec_id')  as integer)  = ? or price = ? ) and tid = ?", "delete from trade.securities where (symbol= ? and exchange = ? ) and cast(json_evalPath(json_details, 'tid')  as integer) = ?", "delete from trade.securities where sec_id=?"};
    protected static int maxNumOfTries = 1;
    protected static ConcurrentHashMap<String, Integer> verifyRowCount = new ConcurrentHashMap();
    protected static int maxLength = TestConfig.tab().intAt(SQLPrms.maxSymbolLength, 6);
    protected static int minLength = TestConfig.tab().intAt(SQLPrms.minSymbolLength, 1);
    protected static boolean isSingleSitePublisher = TestConfig.tab().booleanAt(SQLWanPrms.isSingleSitePublisher, true);
    protected static ArrayList<String> partitionKeys = null;
    boolean reproduce39418 = false;
    protected static String rangePrice = "20";

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        this.insert(dConn, gConn, size, false);
    }

    @Override
    public void put(Connection dConn, Connection gConn, int size) {
        this.insert(dConn, gConn, size, true);
    }

    private void insert(Connection dConn, Connection gConn, int size, boolean isPut) {
        int[] sec_id = new int[size];
        String[] symbol = new String[size];
        String[] exchange = new String[size];
        BigDecimal[] price = new BigDecimal[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        this.getDataForInsert(sec_id, symbol, exchange, price, size);
        int count = 0;
        if (dConn != null) {
            boolean success = this.insertToDerbyTable(dConn, sec_id, symbol, exchange, price, size, exceptionList);
            while (!success) {
                if (isWanTest && !isSingleSitePublisher) {
                    return;
                }
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the insert op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                exceptionList.clear();
                success = this.insertToDerbyTable(dConn, sec_id, symbol, exchange, price, size, exceptionList);
                ++count;
            }
            try {
                this.insertToGFETable(gConn, sec_id, symbol, exchange, price, size, exceptionList, isPut);
            }
            catch (TestException te) {
                if (te.getMessage().contains("Execute SQL statement failed with: 23505") && isHATest && SQLTest.isEdge) {
                    try {
                        this.checkTicket49605(dConn, gConn, "securities", sec_id[0], -1, null, null);
                    }
                    catch (TestException e) {
                        Log.getLogWriter().info("insert failed due to #49605 ", (Throwable)e);
                        Log.getLogWriter().info("retry this using put to work around #49605");
                        this.insertToGFETable(gConn, sec_id, symbol, exchange, price, size, exceptionList, true);
                    }
                }
                throw te;
            }
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.insertToGFETable(gConn, sec_id, symbol, exchange, price, size, isPut);
        }
        if (hasCompanies) {
            TradeCompaniesDMLStmt companies = new TradeCompaniesDMLStmt();
            companies.insert(dConn, gConn, size, symbol, exchange);
            if (dConn != null) {
                this.commit(dConn);
            }
            this.commit(gConn);
        }
    }

    protected void getNonRepeatPK(int[] sec_id, Connection conn) {
        int maxSecId = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary);
        int size = sec_id.length;
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (size > maxSecId) {
            throw new TestException("test issue, not enough data in the test yet");
        }
        while (list.size() < size) {
            int num = rand.nextBoolean() ? rand.nextInt(maxSecId) + 1 : this.getSid(conn);
            if (list.contains(num)) continue;
            list.add(num);
        }
        for (int i = 0; i < size; ++i) {
            sec_id[i] = (Integer)list.get(i);
        }
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        int numOfNonUniqUpdate = 3;
        int whichUpdate = this.getWhichOne(numOfNonUniqUpdate, update.length);
        boolean useBatch = false;
        int maxsize = 10;
        if (!(whichUpdate != 0 && whichUpdate != 4 || !rand.nextBoolean() || alterTableDropColumn || testSecurity || setCriticalHeap)) {
            size = rand.nextInt(maxsize) + 1;
            useBatch = true;
        }
        int[] sec_id = new int[size];
        String[] symbol = new String[size];
        String[] exchange = new String[size];
        BigDecimal[] price = new BigDecimal[size];
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        this.getDataForUpdate(gConn, sec_id, symbol, exchange, price, size);
        if (useBatch) {
            this.getNonRepeatPK(sec_id, gConn);
        }
        if (dConn != null) {
            boolean success = false;
            success = useBatch ? this.updateDerbyTableUsingBatch(dConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList) : this.updateDerbyTable(dConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList);
            int count = 0;
            while (!success) {
                if (isWanTest && !isSingleSitePublisher) {
                    this.rollback(dConn);
                    return;
                }
                this.rollback(dConn);
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the update op in derby, will abort this operation in derby");
                    this.rollback(dConn);
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                exceptionList.clear();
                success = useBatch ? this.updateDerbyTableUsingBatch(dConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList) : this.updateDerbyTable(dConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList);
                ++count;
            }
            if (useBatch) {
                this.updateGfxdTableUsingBatch(gConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList);
            } else {
                this.updateGFETable(gConn, sec_id, symbol, exchange, price, size, whichUpdate, exceptionList);
            }
            SQLHelper.handleMissedSQLException(exceptionList);
        } else if (useBatch) {
            this.updateGfxdTableUsingBatch(gConn, sec_id, symbol, exchange, price, size, whichUpdate);
        } else {
            this.updateGFETable(gConn, sec_id, symbol, exchange, price, size, whichUpdate);
        }
    }

    @Override
    public void delete(Connection dConn, Connection gConn) {
        int sec_id;
        int numOfNonUniqDelete = 1;
        int whichDelete = this.getWhichOne(numOfNonUniqDelete, delete.length);
        if (SQLTest.syncHAForOfflineTest && whichDelete == 0) {
            whichDelete = 1;
        }
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        String symbol = this.getSymbol();
        BigDecimal price = this.getPrice();
        String exchange = this.getExchange();
        int n = sec_id = rand.nextBoolean() ? this.getSid(gConn) : rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary));
        if (dConn != null) {
            boolean success = this.deleteFromDerbyTable(dConn, sec_id, symbol, price, exchange, whichDelete, exceptionList);
            int count = 0;
            while (!success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the delete op in derby, will abort this operation in derby");
                    if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) break;
                    return;
                }
                MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                exceptionList.clear();
                success = this.deleteFromDerbyTable(dConn, sec_id, symbol, price, exchange, whichDelete, exceptionList);
                ++count;
            }
            this.deleteFromGFETable(gConn, sec_id, symbol, price, exchange, whichDelete, exceptionList);
            SQLHelper.handleMissedSQLException(exceptionList);
        } else {
            this.deleteFromGFETable(gConn, sec_id, symbol, price, exchange, whichDelete);
        }
    }

    @Override
    public void query(Connection dConn, Connection gConn) {
        int numOfNonUniq = 4;
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        int sec_id = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary));
        String symbol = this.getSymbol();
        BigDecimal price = this.getPrice();
        String exchange = this.getExchange();
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        ResultSet discRS = null;
        ResultSet gfeRS = null;
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        if (dConn != null) {
            try {
                discRS = TradeSecuritiesDMLStmtJson.query(dConn, whichQuery, sec_id, symbol, price, exchange, tid);
                if (discRS == null) {
                    Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                    if (!alterTableDropColumn || SQLTest.alterTableException.get() == null || !((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                        return;
                    }
                }
            }
            catch (SQLException se) {
                SQLHelper.handleDerbySQLException(se, exceptionList);
            }
            try {
                gfeRS = TradeSecuritiesDMLStmtJson.query(gConn, whichQuery, sec_id, symbol, price, exchange, tid);
                if (gfeRS == null) {
                    if (isHATest) {
                        Log.getLogWriter().info("Testing HA and did not get GFXD result set after retry");
                        return;
                    }
                    if (setCriticalHeap) {
                        Log.getLogWriter().info("got XCL54 and does not get query result");
                        return;
                    }
                    throw new TestException("Not able to get gfe result set after retry");
                }
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptionList);
            }
            SQLHelper.handleMissedSQLException(exceptionList);
            if (discRS == null || gfeRS == null) {
                return;
            }
            boolean success = ResultSetHelper.compareResultSets(discRS, gfeRS);
            if (!success) {
                Log.getLogWriter().info("Not able to compare results, continuing test");
            }
        } else {
            try {
                gfeRS = TradeSecuritiesDMLStmtJson.query(gConn, whichQuery, sec_id, symbol, price, exchange, tid);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && SQLTest.testSecurity) {
                    Log.getLogWriter().info("Got expected no SELECT permission, continuing test");
                    return;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X04")) {
                    Log.getLogWriter().info("Got expected column not found exception, continuing test");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            if (gfeRS != null) {
                ResultSetHelper.asList(gfeRS, false);
            } else if (isHATest) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            } else if (setCriticalHeap) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to XCL54");
            } else {
                throw new TestException("gfxd query returns null and not a HA test");
            }
        }
    }

    @Override
    public void populate(Connection dConn, Connection gConn) {
        int initSize = TestConfig.tab().intAt(SQLPrms.initSecuritiesSizePerThread, 20);
        this.populate(dConn, gConn, initSize);
    }

    protected void getDataForInsert(int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size) {
        int key = (int)SQLBB.getBB().getSharedCounters().add(SQLBB.tradeSecuritiesPrimary, (long)size);
        for (int i = 0; i < size; ++i) {
            int counter;
            sec_id[i] = counter = key - i;
            symbol[i] = this.getSymbol();
            exchange[i] = this.getExchange();
            price[i] = this.getPrice();
            if (i != 1) continue;
            price[i] = price[0];
        }
    }

    protected void getDataForUpdate(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size) {
        int key = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary);
        for (int i = 0; i < size; ++i) {
            sec_id[i] = rand.nextBoolean() ? rand.nextInt(key) + 1 : this.getSid(conn);
            symbol[i] = this.getSymbol();
            exchange[i] = this.getExchange();
            price[i] = this.getPrice();
        }
    }

    protected String getSymbol() {
        return this.getSymbol(maxLength);
    }

    protected String getSymbol(int maxLength) {
        return this.getSymbol(minLength, maxLength);
    }

    protected String getSymbol(int minLength, int maxLength) {
        int aVal = 97;
        int symbolLength = rand.nextInt(maxLength - minLength + 1) + minLength;
        char[] charArray = new char[symbolLength];
        for (int j = 0; j < symbolLength; ++j) {
            charArray[j] = (char)(rand.nextInt(26) + aVal);
        }
        if (testUniqueKeys || testWanUniqueness) {
            return new String(charArray) + TradeSecuritiesDMLStmtJson.getMyTid();
        }
        return new String(charArray);
    }

    @Override
    protected BigDecimal getPrice() {
        if (!this.reproduce39418) {
            return new BigDecimal(Double.toString((double)(rand.nextInt(10000) + 1) * 0.01));
        }
        return new BigDecimal((double)(rand.nextInt(10000) + 1) * 0.01);
    }

    protected String getExchange() {
        return exchanges[rand.nextInt(exchanges.length)];
    }

    protected boolean insertToDerbyTable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, List<SQLException> exceptions) {
        PreparedStatement stmt = TradeSecuritiesDMLStmtJson.getStmt(conn, insert);
        if (stmt == null) {
            return false;
        }
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                verifyRowCount.put(tid + "_insert" + i, 0);
                count = this.insertToTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid);
                verifyRowCount.put(tid + "_insert" + i, new Integer(count));
                Log.getLogWriter().info("Derby inserts " + verifyRowCount.get(tid + "_insert" + i) + " rows");
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                if (se.getSQLState().equals("23505") && isWanTest && !isSingleSitePublisher) {
                    Log.getLogWriter().info("get unique key constraint violation with multiple wan publishers, rollback the operation and continuing");
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        SQLHelper.handleSQLException(e);
                    }
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
                continue;
            }
            catch (IllegalArgumentException ie) {
                if (this.reproduce39418) {
                    Log.getLogWriter().info("derby gets the IllegalArgumentException: " + TestHelper.getStackTrace((Throwable)ie));
                    continue;
                }
                throw new TestException(TestHelper.getStackTrace((Throwable)ie));
            }
        }
        return true;
    }

    protected void insertToGFETable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, List<SQLException> exceptions, boolean isPut) {
        PreparedStatement stmt = SQLTest.hasJSON ? TradeSecuritiesDMLStmtJson.getStmt(conn, isPut ? putJSON : insertJSON) : TradeSecuritiesDMLStmtJson.getStmt(conn, isPut ? put : insert);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        int count = -1;
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, isPut);
                if (count == verifyRowCount.get(tid + "_insert" + i)) continue;
                Log.getLogWriter().info("Gfxd insert has different row count from that of derby derby inserted " + verifyRowCount.get(tid + "_insert" + i) + " but gfxd inserted " + count);
                continue;
            }
            catch (SQLException se) {
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void insertToGFETable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, boolean isPut) {
        PreparedStatement stmt = SQLTest.hasJSON ? TradeSecuritiesDMLStmtJson.getStmt(conn, isPut ? putJSON : insertJSON) : TradeSecuritiesDMLStmtJson.getStmt(conn, isPut ? put : insert);
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, isPut);
                continue;
            }
            catch (SQLException se) {
                if ("23505".equals(se.getSQLState())) {
                    Log.getLogWriter().info("Got the expected exception due to unique constraint check, continuing tests");
                    continue;
                }
                if (se.getSQLState().equals("42500") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && (se.getSQLState().equals("42802") || se.getSQLState().equals("42X14"))) {
                    Log.getLogWriter().info("Got expected column not found exception in insert, continuing test");
                    continue;
                }
                if (isPut && se.getSQLState().equals("0A000")) {
                    Log.getLogWriter().info("Got expected Feature not Supported Exception during put, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected int insertToTable(PreparedStatement stmt, int sec_id, String symbol, String exchange, BigDecimal price, int tid) throws SQLException {
        return this.insertToTable(stmt, sec_id, symbol, exchange, price, tid, false);
    }

    protected int insertToTable(PreparedStatement stmt, int sec_id, String symbol, String exchange, BigDecimal price, int tid, boolean isPut) throws SQLException {
        boolean isDerbyConn = SQLHelper.isDerbyConn(stmt.getConnection());
        String txId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String driverName = stmt.getConnection().getMetaData().getDriverName();
        String database = isDerbyConn ? "Derby - " : "gemfirexd - " + txId;
        String json = this.getJSON(sec_id, symbol, exchange, price, tid);
        Log.getLogWriter().info(database + (isPut ? "putting" : "inserting") + " on trade.securities with SEC_ID:" + sec_id + ",SYMBOL:" + symbol + ",PRICE:" + price + ",EXCHANGE:" + exchange + ",TID:" + tid + (!isDerbyConn && SQLTest.hasJSON ? ", JSON: " + json : " "));
        stmt.setInt(1, sec_id);
        stmt.setString(2, symbol);
        stmt.setBigDecimal(3, price);
        stmt.setString(4, exchange);
        stmt.setInt(5, tid);
        if (!isDerbyConn && SQLTest.hasJSON) {
            stmt.setString(6, json);
        }
        int rowCount = stmt.executeUpdate();
        SQLWarning warning = stmt.getWarnings();
        Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows in trade.securities SEC_ID:" + sec_id + ",SYMBOL:" + symbol + ",PRICE:" + price + ",EXCHANGE:" + exchange + ",TID:" + tid + (!isDerbyConn && SQLTest.hasJSON ? ", JSON: " + json : " "));
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        if (driverName.toLowerCase().contains("gemfirexd") && isPut) {
            if (!SQLTest.ticket49794fixed) {
                this.insertToSecuritiesFulldataset(stmt.getConnection(), sec_id, symbol, price, exchange, tid);
            }
            Log.getLogWriter().info(database + (isPut ? "putting " : "inserting ") + " in trade.securities with SEC_ID:" + sec_id + ",SYMBOL:" + symbol + ",PRICE:" + price + ",EXCHANGE:" + exchange + ",TID:" + tid + (!isDerbyConn && SQLTest.hasJSON ? ", JSON: " + json : " "));
            rowCount = stmt.executeUpdate();
            Log.getLogWriter().info(database + (isPut ? "put " : "inserted ") + rowCount + " rows in trade.securities SEC_ID:" + sec_id + ",SYMBOL:" + symbol + ",PRICE:" + price + ",EXCHANGE:" + exchange + ",TID:" + tid + (!isDerbyConn && SQLTest.hasJSON ? ", JSON: " + json : " "));
            warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        return rowCount;
    }

    protected void insertToSecuritiesFulldataset(Connection conn, int sec_id, String symbol, BigDecimal price, String exchange, int tid) {
        try {
            Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence deleting  the  row  from TRADE.SECURITIES_FULLDATASET with data SEC_ID:" + sec_id);
            conn.createStatement().execute("DELETE FROM TRADE.SECURITIES_FULLDATASET  WHERE  sec_id = " + sec_id);
            PreparedStatement preparedInsertStmt = conn.prepareStatement("insert into trade.SECURITIES_fulldataset values (?,?,?,?,?)");
            preparedInsertStmt.setInt(1, sec_id);
            preparedInsertStmt.setString(2, symbol);
            preparedInsertStmt.setBigDecimal(3, price);
            preparedInsertStmt.setString(4, exchange);
            preparedInsertStmt.setInt(5, tid);
            Log.getLogWriter().info(" Trigger behaviour is not defined for putDML hence inserting  the  row  into  TRADE.SECURITIES_FULLDATASET with data SEC_ID:" + sec_id + ",SYMBOL" + symbol + ",EXCHANGE:" + exchange + ",PRICE:" + price + ".TID:" + tid);
            preparedInsertStmt.executeUpdate();
        }
        catch (SQLException se) {
            Log.getLogWriter().info("Error while updating TRADE.SECURITIES_FULLDATASET table. It may cause Data inconsistency " + se.getMessage());
        }
    }

    protected boolean deleteFromDerbyTable(Connection dConn, int sec_id, String symbol, BigDecimal price, String exchange, int whichDelete, List<SQLException> exList) {
        PreparedStatement stmt = TradeSecuritiesDMLStmtJson.getStmt(dConn, delete[whichDelete]);
        if (stmt == null) {
            return false;
        }
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        int count = -1;
        try {
            verifyRowCount.put(tid + "_delete", 0);
            count = this.deleteFromTable(stmt, sec_id, symbol, exchange, price, tid, whichDelete);
            verifyRowCount.put(tid + "_delete", new Integer(count));
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dConn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return true;
    }

    protected void deleteFromGFETable(Connection dConn, int sec_id, String symbol, BigDecimal price, String exchange, int whichDelete, List<SQLException> exList) {
        PreparedStatement stmt = TradeSecuritiesDMLStmtJson.getStmt(dConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exList);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        int count = -1;
        try {
            count = this.deleteFromTable(stmt, sec_id, symbol, exchange, price, tid, whichDelete);
            if (count != verifyRowCount.get(tid + "_delete")) {
                Log.getLogWriter().info("Gfxd delete (securities) has different row count from that of derby derby deleted " + verifyRowCount.get(tid + "_delete") + " but gfxd deleted " + count);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exList);
        }
    }

    protected void deleteFromGFETable(Connection dConn, int sec_id, String symbol, BigDecimal price, String exchange, int whichDelete) {
        PreparedStatement stmt = TradeSecuritiesDMLStmtJson.getStmt(dConn, delete[whichDelete]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        try {
            this.deleteFromTable(stmt, sec_id, symbol, exchange, price, tid, whichDelete);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("23503")) {
                Log.getLogWriter().info("detected delete caused the foreign key constraint violation, continuing test");
            }
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            }
            if (alterTableDropColumn && (se.getSQLState().equals("42X14") || se.getSQLState().equals("42X04"))) {
                Log.getLogWriter().info("Got expected column not found exception in delete, continuing test");
            }
            SQLHelper.handleSQLException(se);
        }
    }

    protected int deleteFromTable(PreparedStatement stmt, int sec_id, String symbol, String exchange, BigDecimal price, int tid, int whichDelete) throws SQLException {
        String txId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        boolean isDerbyConn = SQLHelper.isDerbyConn(stmt.getConnection());
        String database = isDerbyConn ? "Derby - " : "gemfirexd - " + txId;
        String query = " QUERY : " + (SQLTest.hasJSON && !isDerbyConn ? deleteJSON[whichDelete] : delete[whichDelete]);
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info(database + "deleting trade.securities with SEC_ID:" + sec_id + ",PRICE:" + price + ",TID:" + tid + query);
                stmt.setInt(1, sec_id);
                stmt.setBigDecimal(2, price);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.securities with SEC_ID:" + sec_id + ",PRICE:" + price + ",TID:" + tid + query);
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "deleting trade.securities with SYMBOL:" + symbol + ",EXCHANGE:" + exchange + ",TID:" + tid + query);
                stmt.setString(1, symbol);
                stmt.setString(2, exchange);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.securities with SYMBOL:" + symbol + ",EXCHANGE:" + exchange + ",TID:" + tid + query);
                break;
            }
            case 2: {
                Log.getLogWriter().info(database + "deleting trade.securities with SEC_ID:" + sec_id + query);
                stmt.setInt(1, sec_id);
                rowCount = stmt.executeUpdate();
                Log.getLogWriter().info(database + "deleted " + rowCount + " rows in trade.securities with SEC_ID:" + sec_id + query);
                break;
            }
            default: {
                throw new TestException("incorrect delete statement, should not happen");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected boolean updateDerbyTable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate, List<SQLException> exceptions) {
        PreparedStatement stmt = null;
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        int count = -1;
        boolean[] unsupported = new boolean[1];
        stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, unsupported) : TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]);
        if (stmt == null) {
            if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                return true;
            }
            return unsupported[0];
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (stmt == null) continue;
                verifyRowCount.put(tid + "_update" + i, 0);
                count = this.updateTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, whichUpdate);
                verifyRowCount.put(tid + "_update" + i, new Integer(count));
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                if (se.getSQLState().equals("23505") && isWanTest && !isSingleSitePublisher) {
                    Log.getLogWriter().info("get unique key constraint violation with multiple wan publishers, rollback the operation and continuing");
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        SQLHelper.handleSQLException(e);
                    }
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        return true;
    }

    protected boolean updateDerbyTableUsingBatch(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate, List<SQLException> exceptions) {
        PreparedStatement stmt = null;
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        boolean[] unsupported = new boolean[1];
        stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, unsupported) : TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]);
        if (stmt == null) {
            if (alterTableDropColumn && SQLTest.alterTableException.get() != null && ((Boolean)SQLTest.alterTableException.get()).booleanValue()) {
                return true;
            }
            return unsupported[0];
        }
        int[] counts = null;
        for (int i = 0; i < size; ++i) {
            if (stmt == null) continue;
            try {
                Log.getLogWriter().info(" Derby - batch updating trade.securities with PRICE:" + price[i] + " where SEC_ID:" + sec_id[i] + (whichUpdate == 0 ? ",TID: " + tid : "") + " QUERY: " + update[whichUpdate]);
                stmt.setBigDecimal(1, price[i]);
                stmt.setInt(2, sec_id[i]);
                if (whichUpdate == 0) {
                    stmt.setInt(3, tid);
                }
                stmt.addBatch();
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbySQLException(se, exceptions);
            }
        }
        try {
            counts = stmt.executeBatch();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            SQLHelper.handleDerbySQLException(se, exceptions);
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] == -3) {
                throw new TestException("derby failed to update a row in batch update");
            }
            verifyRowCount.put(tid + "_update" + i, 0);
            verifyRowCount.put(tid + "_update" + i, new Integer(counts[i]));
            Log.getLogWriter().info(" Derby - updated " + counts[i] + " rows in trade.securities with PRICE:" + price[i] + " where SEC_ID:" + sec_id[i] + (whichUpdate == 0 ? ",TID:" + tid : ""));
        }
        return true;
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, boolean[] unsupported) {
        if (partitionKeys == null) {
            this.setPartitionKeys();
        }
        return this.getCorrectStmt(conn, whichUpdate, partitionKeys, unsupported);
    }

    protected void setPartitionKeys() {
        if (!isWanTest) {
            partitionKeys = (ArrayList)partitionMap.get((Object)"securitiesPartition");
        } else {
            int myWanSite = this.getMyWanSite();
            partitionKeys = (ArrayList)wanPartitionMap.get((Object)(myWanSite + "_securitiesPartition"));
        }
        Log.getLogWriter().info("partition keys are " + partitionKeys);
    }

    protected PreparedStatement getCorrectStmt(Connection conn, int whichUpdate, ArrayList<String> partitionKeys, boolean[] unsupported) {
        PreparedStatement stmt = null;
        String[] update = SQLTest.hasJSON && !SQLHelper.isDerbyConn(conn) ? updateJSON : TradeSecuritiesDMLStmtJson.update;
        switch (whichUpdate) {
            case 0: {
                if (partitionKeys.contains("price")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 1: {
                if (partitionKeys.contains("symbol")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 2: {
                if (partitionKeys.contains("symbol") || partitionKeys.contains("exchange")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 3: {
                if (partitionKeys.contains("exchange")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 4: {
                if (partitionKeys.contains("price")) {
                    Log.getLogWriter().info("Will update gemfirexd on partition key");
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 5: {
                if (partitionKeys.contains("symbol")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            case 6: {
                if (partitionKeys.contains("exchange")) {
                    if (!SQLHelper.isDerbyConn(conn)) {
                        stmt = this.getUnsupportedStmt(conn, update[whichUpdate]);
                        break;
                    }
                    unsupported[0] = true;
                    break;
                }
                stmt = TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]);
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        return stmt;
    }

    protected void updateGFETable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate, List<SQLException> exceptions) {
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        int count = 0;
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : (SQLTest.hasJSON ? TradeSecuritiesDMLStmtJson.getStmt(conn, updateJSON[whichUpdate]) : TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]));
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (stmt == null || (count = this.updateTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, whichUpdate)) == verifyRowCount.get(tid + "_update" + i)) continue;
                Log.getLogWriter().info("Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + count);
                continue;
            }
            catch (SQLException se) {
                int firstIndex;
                SQLException derbySe;
                if (exceptions.size() > 0 && (derbySe = exceptions.get(firstIndex = 0)).getSQLState().equals("23505") && hasCompanies && se.getSQLState().equals("23503")) {
                    SQLHelper.printSQLException(se);
                    Log.getLogWriter().info("allow update unique key to check foreign key reference first");
                    exceptions.remove(firstIndex);
                    return;
                }
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
    }

    protected void updateGfxdTableUsingBatch(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate, List<SQLException> exceptions) {
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]);
        if (SQLTest.testSecurity && stmt == null && SQLSecurityTest.prepareStmtException.get() != null) {
            SQLHelper.handleGFGFXDException((SQLException)SQLSecurityTest.prepareStmtException.get(), exceptions);
            SQLSecurityTest.prepareStmtException.set(null);
            return;
        }
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null) {
            return;
        }
        int[] counts = null;
        for (int i = 0; i < size; ++i) {
            try {
                String json = "";
                String jsonLog = ",JSON_DETAILS:";
                if (SQLTest.hasJSON) {
                    json = this.getJSON(sec_id[i], symbol[i], exchange[i], price[i], tid);
                    jsonLog = jsonLog + json + " ";
                }
                Log.getLogWriter().info(" gemfirexd - batch Updating trade.securities with PRICE:" + price[i] + jsonLog + " where SEC_ID:" + sec_id[i] + (whichUpdate == 0 ? ",TID:" + tid : "") + update[whichUpdate]);
                int param = 1;
                stmt.setBigDecimal(param++, price[i]);
                if (SQLTest.hasJSON) {
                    stmt.setString(param++, json);
                }
                stmt.setInt(param++, sec_id[i]);
                if (whichUpdate == 0) {
                    stmt.setInt(param++, tid);
                }
                stmt.addBatch();
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFGFXDException(se, exceptions);
            }
        }
        try {
            counts = stmt.executeBatch();
        }
        catch (SQLException se) {
            SQLHelper.handleGFGFXDException(se, exceptions);
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] != -3) {
                Log.getLogWriter().info("gemfirexd - updated " + counts[i] + " rows in trade.securities table with PRICE:" + price[i] + " where SEC_ID:" + sec_id[i] + (whichUpdate == 0 ? ",TID:" + tid : "") + update[whichUpdate]);
                if (counts[i] == verifyRowCount.get(tid + "_update" + i)) continue;
                Log.getLogWriter().warning("Gfxd update has different row count from that of derby derby updated " + verifyRowCount.get(tid + "_update" + i) + " but gfxd updated " + counts[i]);
                continue;
            }
            Log.getLogWriter().warning("gfxd failed to update in batch update");
        }
    }

    protected void updateGFETable(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate) {
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : TradeSecuritiesDMLStmtJson.getStmt(conn, update[whichUpdate]);
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (stmt == null) continue;
                this.updateTable(stmt, sec_id[i], symbol[i], exchange[i], price[i], tid, whichUpdate);
                continue;
            }
            catch (SQLException se) {
                if ("23505".equals(se.getSQLState())) {
                    Log.getLogWriter().info("Got the expected exception due to unique constraint check");
                    continue;
                }
                if ("23503".equals(se.getSQLState())) {
                    Log.getLogWriter().info("Got the expected exception due to unique constraint check");
                    continue;
                }
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                if (hasCompanies && se.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("Got expected violation of foreign key constraint in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void updateGfxdTableUsingBatch(Connection conn, int[] sec_id, String[] symbol, String[] exchange, BigDecimal[] price, int size, int whichUpdate) {
        int tid = TradeSecuritiesDMLStmtJson.getMyTid();
        String[] query = new String[size];
        PreparedStatement stmt = SQLTest.testPartitionBy ? this.getCorrectStmt(conn, whichUpdate, null) : TradeSecuritiesDMLStmtJson.getStmt(conn, updateJSON[whichUpdate]);
        if (setCriticalHeap && stmt == null) {
            return;
        }
        if (stmt == null && alterTableDropColumn) {
            Log.getLogWriter().info("prepare stmt failed due to missing column");
            return;
        }
        if (stmt == null) {
            return;
        }
        int[] counts = null;
        for (int i = 0; i < size; ++i) {
            try {
                Log.getLogWriter().info("gemfirexd - updating trade.securities with SEC_ID:" + sec_id[i] + ",PRICE:" + price[i] + (whichUpdate == 0 ? ",TID:" + tid : "") + "QUERY: " + updateJSON[whichUpdate]);
                HashMap map = (HashMap)this.getCurrentRowOfUpdate(stmt.getConnection(), sec_id[i]);
                String json = this.getJSON(sec_id[i], (String)map.get("symbol"), (String)map.get("exchange"), price[i], tid);
                stmt.setBigDecimal(1, price[i]);
                stmt.setString(2, json);
                stmt.setInt(3, sec_id[i]);
                query[i] = update[whichUpdate];
                if (whichUpdate == 0) {
                    stmt.setInt(4, tid);
                }
                stmt.addBatch();
                continue;
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && testSecurity) {
                    Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
                    continue;
                }
                if (alterTableDropColumn && se.getSQLState().equals("42X14")) {
                    Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
                    continue;
                }
                if (hasCompanies && se.getSQLState().equals("23503")) {
                    Log.getLogWriter().info("Got expected violation of foreign key constraint in update, continuing test");
                    continue;
                }
                SQLHelper.handleSQLException(se);
            }
        }
        try {
            counts = stmt.executeBatch();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] != -3) {
                Log.getLogWriter().info("gemfirexd -  updated " + counts[i] + " rows in trade.securities with SEC_ID:" + sec_id[i] + "PRICE:" + price[i] + (whichUpdate == 0 ? "TID:" + tid : "") + " QUERY:" + query[i]);
                continue;
            }
            Log.getLogWriter().warning("gemfirexd -  failed to update in batch update in " + i + " update");
        }
    }

    protected int updateTable(PreparedStatement stmt, int sec_id, String symbol, String exchange, BigDecimal price, int tid, int whichUpdate) throws SQLException {
        boolean isDerbyConn = SQLHelper.isDerbyConn(stmt.getConnection());
        String database = isDerbyConn ? "Derby - " : "gemfirexd - ";
        String jsonString = "";
        String json = "";
        String query = " QUERY: " + (SQLTest.hasJSON && !isDerbyConn ? updateJSON[whichUpdate] : update[whichUpdate]);
        String successStmt = "";
        int i = 1;
        if (!isDerbyConn && SQLTest.hasJSON) {
            json = this.getJSON(sec_id, symbol, exchange, price, tid);
        }
        HashMap map = new HashMap();
        if (SQLTest.hasJSON & !isDerbyConn) {
            map = (HashMap)this.getCurrentRowOfUpdate(stmt.getConnection(), sec_id);
            query = " QUERY: " + updateJSON[whichUpdate];
        }
        switch (whichUpdate) {
            case 0: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSON(sec_id, (String)map.get("symbol"), (String)map.get("exchange"), price, tid);
                    jsonString = ",JSON_DETAILS: " + json;
                }
                Log.getLogWriter().info(database + "updating trade.securities with PRICE:" + price + jsonString + " where SEC_ID:" + sec_id + "TID:" + tid + query);
                stmt.setBigDecimal(i++, price);
                if (!isDerbyConn && SQLTest.hasJSON) {
                    stmt.setObject(i++, json);
                }
                stmt.setInt(i++, sec_id);
                stmt.setInt(i++, tid);
                successStmt = " rows in trade.securities with PRICE:" + price + jsonString + " where SEC_ID:" + sec_id + "TID:" + tid + query;
                break;
            }
            case 1: {
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSON(sec_id, symbol, (String)map.get("exchange"), (BigDecimal)map.get("price"), tid);
                    jsonString = ",JSON_DETAILS: " + json;
                }
                Log.getLogWriter().info(database + "updating trade.securities with SYMBOL:" + symbol + jsonString + " where SEC_ID:" + sec_id + ",TID:" + tid + query);
                stmt.setString(i++, symbol);
                if (!isDerbyConn && SQLTest.hasJSON) {
                    stmt.setObject(i++, json);
                }
                stmt.setInt(i++, sec_id);
                stmt.setInt(i++, tid);
                successStmt = " rows in trade.securities  SYMBOL:" + symbol + jsonString + " where SEC_ID:" + sec_id + ",TID:" + tid + query;
                break;
            }
            case 2: {
                Clob jsonClob;
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSON(sec_id, symbol, exchange, (BigDecimal)map.get("price"), tid);
                    jsonString = ",JSON_DETAILS: " + json;
                }
                Log.getLogWriter().info(database + "updating trade.securities with SYMBOL:" + symbol + ",EXCHANGE:" + exchange + jsonString + " where SEC_ID:" + sec_id + ",TID:" + tid + query);
                stmt.setString(i++, symbol);
                stmt.setString(i++, exchange);
                if (!isDerbyConn && SQLTest.hasJSON) {
                    jsonClob = stmt.getConnection().createClob();
                    jsonClob.setString(1L, json);
                    stmt.setClob(i++, jsonClob);
                }
                stmt.setInt(i++, sec_id);
                stmt.setInt(i++, tid);
                successStmt = " rows in trade.securities with SYMBOL:" + symbol + ",EXCHANGE:" + exchange + jsonString + " where SEC_ID:" + sec_id + ",TID:" + tid + query;
                break;
            }
            case 3: {
                Clob jsonClob;
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSON(sec_id, (String)map.get("symbol"), exchange, (BigDecimal)map.get("price"), tid);
                    jsonString = ",JSON_DETAILS: " + json;
                }
                Log.getLogWriter().info(database + "updating trade.securities with EXCHANGE:" + exchange + jsonString + " where SEC_ID:" + sec_id + ",TID:" + tid + query);
                stmt.setString(i++, exchange);
                if (!isDerbyConn && SQLTest.hasJSON) {
                    jsonClob = stmt.getConnection().createClob();
                    jsonClob.setString(1L, json);
                    stmt.setClob(i++, jsonClob);
                }
                stmt.setInt(i++, sec_id);
                stmt.setInt(i++, tid);
                successStmt = " rows in trade.securities with EXCHANGE:" + exchange + jsonString + " where SEC_ID:" + sec_id + ",TID:" + tid + query;
                break;
            }
            case 4: {
                Clob jsonClob;
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSON(sec_id, (String)map.get("symbol"), (String)map.get("exchange"), price, tid);
                    jsonString = ",JSON_DETAILS: " + json;
                }
                Log.getLogWriter().info(database + "updating trade.securities with PRICE:" + price + jsonString + " where SEC_ID:" + sec_id + query);
                stmt.setBigDecimal(i++, price);
                if (!isDerbyConn && SQLTest.hasJSON) {
                    jsonClob = stmt.getConnection().createClob();
                    jsonClob.setString(1L, json);
                    stmt.setClob(i++, jsonClob);
                }
                stmt.setInt(i++, sec_id);
                successStmt = " rows in trade.securities with PRICE:" + price + jsonString + " where SEC_ID:" + sec_id + query;
                break;
            }
            case 5: {
                Clob jsonClob;
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSON(sec_id, symbol, (String)map.get("exchange"), (BigDecimal)map.get("price"), tid);
                    jsonString = ",JSON_DETAILS: " + json;
                }
                Log.getLogWriter().info(database + "updating trade.securities with SYMBOL:" + symbol + jsonString + " where SEC_ID:" + sec_id + query);
                stmt.setString(i++, symbol);
                if (!isDerbyConn && SQLTest.hasJSON) {
                    jsonClob = stmt.getConnection().createClob();
                    jsonClob.setString(1L, json);
                    stmt.setClob(i++, jsonClob);
                }
                stmt.setInt(i++, sec_id);
                successStmt = " rows in trade.securities with SYMBOL:" + symbol + jsonString + " where SEC_ID:" + sec_id + query;
                break;
            }
            case 6: {
                Clob jsonClob;
                if (SQLTest.hasJSON & !SQLHelper.isDerbyConn(stmt.getConnection())) {
                    json = this.getJSON(sec_id, (String)map.get("symbol"), exchange, (BigDecimal)map.get("price"), tid);
                    jsonString = ",JSON_DETAILS: " + json;
                }
                Log.getLogWriter().info(database + "updating trade.securities with EXCHANGE:" + exchange + jsonString + " where SEC_ID:" + sec_id + query);
                stmt.setString(i++, exchange);
                if (!isDerbyConn && SQLTest.hasJSON) {
                    jsonClob = stmt.getConnection().createClob();
                    jsonClob.setString(1L, json);
                    stmt.setClob(i++, jsonClob);
                }
                stmt.setInt(i++, sec_id);
                successStmt = " rows in trade.securities with EXCHANGE:" + exchange + jsonString + " where SEC_ID:" + sec_id + query;
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        int rowCount = stmt.executeUpdate();
        Log.getLogWriter().info(database + "updated " + rowCount + successStmt);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    public static ResultSet getQuery(Connection conn, int whichQuery, int sec_id, String symbol, BigDecimal price, String exchange, int tid) {
        ResultSet rs;
        block4: {
            boolean[] success = new boolean[1];
            rs = null;
            try {
                rs = TradeSecuritiesDMLStmtJson.getQuery(conn, whichQuery, sec_id, symbol, price, exchange, tid, success);
                int count = 0;
                while (!success[0]) {
                    if (count >= maxNumOfTries) {
                        Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                        return null;
                    }
                    ++count;
                    MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
                    rs = TradeSecuritiesDMLStmtJson.getQuery(conn, whichQuery, sec_id, symbol, price, exchange, tid, success);
                }
            }
            catch (SQLException se) {
                if (SQLHelper.isAlterTableException(conn, se)) break block4;
                SQLHelper.handleSQLException(se);
            }
        }
        return rs;
    }

    protected static ResultSet query(Connection conn, int whichQuery, int sec_id, String symbol, BigDecimal price, String exchange, int tid) throws SQLException {
        boolean[] success = new boolean[1];
        ResultSet rs = TradeSecuritiesDMLStmtJson.getQuery(conn, whichQuery, sec_id, symbol, price, exchange, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)rand.nextInt(retrySleepMs));
            rs = TradeSecuritiesDMLStmtJson.getQuery(conn, whichQuery, sec_id, symbol, price, exchange, tid, success);
        }
        return rs;
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, int sec_id, String symbol, BigDecimal price, String exchange, int tid, boolean[] success) throws SQLException {
        BigDecimal price1 = null;
        if (price != null) {
            price1 = price.add(new BigDecimal(rangePrice));
        }
        return TradeSecuritiesDMLStmtJson.getQuery(conn, whichQuery, sec_id, symbol, price, price1, exchange, tid, success);
    }

    protected static ResultSet getQuery(Connection conn, int whichQuery, int sec_id, String symbol, BigDecimal price, BigDecimal price1, String exchange, int tid, boolean[] success) throws SQLException {
        ResultSet rs = null;
        success[0] = true;
        String txId = SQLDistTxTest.curTxId.get() == null ? "" : "TXID:" + (Integer)SQLDistTxTest.curTxId.get() + " ";
        String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - " + txId;
        String query = " QUERY: " + (SQLTest.hasJSON && !SQLHelper.isDerbyConn(conn) ? selectJSON[whichQuery] : select[whichQuery]);
        try {
            PreparedStatement stmt = conn.prepareStatement(select[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "querying trade.securities with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "querying trade.securities with SYMBOL:" + symbol + ",TID:" + tid + query);
                    stmt.setInt(1, tid);
                    stmt.setString(2, symbol);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "querying trade.securities with 1_PRICE:" + price + ",2_PRICE:" + price1 + ",TID:" + tid + query);
                    stmt.setBigDecimal(1, price);
                    stmt.setBigDecimal(2, price1);
                    stmt.setInt(3, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "querying trade.securities with EXCHANGE:" + exchange + ",1_PRICE:" + price + ",2_PRICE:" + price1 + ",TID:" + tid + query);
                    stmt.setBigDecimal(1, price);
                    stmt.setBigDecimal(2, price1);
                    stmt.setString(3, exchange);
                    stmt.setInt(4, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "querying trade.securities with SEC_ID:" + sec_id + query);
                    stmt.setInt(1, sec_id);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "querying trade.securities with SYMBOL:" + symbol + query);
                    stmt.setString(1, symbol);
                    break;
                }
                case 6: {
                    Log.getLogWriter().info(database + "querying trade.securities with 1_PRICE:" + price + ",2_PRICE:" + price1 + query);
                    stmt.setBigDecimal(1, price);
                    stmt.setBigDecimal(2, price1);
                    break;
                }
                case 7: {
                    Log.getLogWriter().info(database + "querying trade.securities with EXCHANGE:" + exchange + ",1_PRICE:" + price + ",2_PRICE:" + price1 + query);
                    stmt.setBigDecimal(1, price);
                    stmt.setBigDecimal(2, price1);
                    stmt.setString(3, exchange);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (!SQLHelper.checkGFXDException(conn, se)) {
                success[0] = false;
            }
            throw se;
        }
        return rs;
    }

    protected String getJSON(int sec_id, String symbol, String exchange, BigDecimal price, int tid) {
        JSONObject json = new JSONObject();
        if (SQLTest.hasJSON) {
            json.put((Object)"sec_id", (Object)sec_id);
            json.put((Object)"symbol", (Object)symbol);
            json.put((Object)"exchange", (Object)exchange);
            json.put((Object)"price", (Object)price);
            json.put((Object)"tid", (Object)tid);
            return json.toJSONString();
        }
        return null;
    }

    protected Map<String, Object> getCurrentRowOfUpdate(Connection conn, int sec_id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String query = "select symbol, price, exchange, tid from trade.securities where sec_id = " + sec_id;
        try {
            ResultSet rs = conn.createStatement().executeQuery(query);
            if (rs.next()) {
                map.put("sec_id", sec_id);
                map.put("symbol", rs.getString(1));
                map.put("price", rs.getBigDecimal(2));
                map.put("exchange", rs.getString(3));
                map.put("tid", rs.getInt(4));
            } else {
                map.put("sec_id", sec_id);
                map.put("symbol", " ");
                map.put("price", new BigDecimal(0));
                map.put("exchange", " ");
                map.put("tid", 0);
            }
        }
        catch (SQLException se) {
            throw new TestException(TestHelper.getStackTrace((Throwable)se));
        }
        return map;
    }

    static {
        if ((testUniqueKeys || testWanUniqueness) && maxLength > 7) {
            maxLength = 7;
        }
    }
}

