/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlStatements.writer;

import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import sql.dmlStatements.TradePortfolioDMLStmt;

public class TradePortfolioWriterDMLStmt
extends TradePortfolioDMLStmt {
    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        int cid = 0;
        cid = TradePortfolioWriterDMLStmt.getCid(gConn);
        if (cid != 0) {
            this.insert(dConn, gConn, size, cid, false);
        }
    }

    @Override
    public void put(Connection dConn, Connection gConn, int size) {
        int cid = 0;
        cid = TradePortfolioWriterDMLStmt.getCid(gConn);
        if (cid != 0) {
            this.insert(dConn, gConn, size, cid, true);
        }
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size, int cid, boolean isPut) {
        int[] sid = new int[size];
        int[] qty = new int[size];
        BigDecimal[] sub = new BigDecimal[size];
        BigDecimal[] price = new BigDecimal[size];
        int availSize = 0;
        availSize = this.getDataFromResultSet(gConn, sid, qty, sub, price, size);
        this.insertToGFETable(gConn, cid, sid, qty, sub, availSize, isPut);
    }

    @Override
    public void update(Connection dConn, Connection gConn, int size) {
        int numOfNonUniqUpdate = 6;
        int whichUpdate = this.getWhichOne(numOfNonUniqUpdate, update.length);
        int[] cid = new int[size];
        int[] sid = new int[size];
        int[] newCid = new int[size];
        int[] newSid = new int[size];
        int[] qty = new int[size];
        int[] availQty = new int[size];
        BigDecimal[] sub = new BigDecimal[size];
        BigDecimal[] price = new BigDecimal[size];
        if (isHATest && (whichUpdate == 0 || whichUpdate == 1)) {
            Log.getLogWriter().info("avoid x=x+1 in HA test for now, do not execute this update");
            return;
        }
        int availSize = this.getDataForUpdate(gConn, cid, sid, qty, availQty, sub, newCid, newSid, price, size);
        this.updateGFETable(gConn, cid, sid, qty, availQty, sub, newCid, newSid, price, availSize, whichUpdate);
    }

    @Override
    public void delete(Connection dConn, Connection gConn) {
        int numOfNonUniqDelete = delete.length / 2;
        int whichDelete = this.getWhichOne(numOfNonUniqDelete, delete.length);
        int[] cid = new int[1];
        int[] sid = new int[1];
        int availSize = this.getDataForDelete(gConn, cid, sid, cid.length);
        if (availSize == 0) {
            return;
        }
        this.deleteFromGFETable(gConn, whichDelete, cid, sid);
    }
}

