/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlTxStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.dmlStatements.TradeBuyOrdersDMLStmt;
import sql.dmlTxStatements.DMLTxStmtIF;
import sql.sqlTx.SQLDerbyTxBB;
import sql.sqlutil.GFXDTxHelper;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradeBuyOrdersDMLTxStmt
extends TradeBuyOrdersDMLStmt
implements DMLTxStmtIF {
    String[] updateByCidRange = new String[]{"update trade.buyorders set bid = ? where cid = ? and oid= ? and status = 'open' ", "update trade.buyorders set sid = ? , qty=? where cid = ? and oid= ? and bid <? and status = 'open'  ", "update trade.buyorders set status = 'filled'  where cid>? and cid<? and sid = ? and bid<? and status = 'open' ", "update trade.buyorders set status = 'cancelled' where cid>? and cid<? and ordertime <? and status = 'open'  "};
    int updateByCidRangeSingleRowStmt = 2;
    String[] updateByTidList = new String[]{"update trade.buyorders set bid = ? where oid= ? and status = 'open' and tid=? ", "update trade.buyorders set cid = ? , qty=? where oid= ? and bid <? and status = 'open' and tid =? ", "update trade.buyorders set status = 'filled'  where sid = ? and bid<? and status = 'open' and (tid =? or tid=? )", "update trade.buyorders set status = 'cancelled' where ordertime <? and status = 'open' and tid =? "};
    int updateByTidListSingleRowStmt = 2;
    String[] deleteByCidRange = new String[]{"delete from trade.buyorders where cid=? and oid=? and bid <?", "delete from trade.buyorders where cid>? and cid<? and status IN ('cancelled', 'filled')"};
    int deleteByCidRangeSingleRowStmt = 1;
    String[] deleteByTidList = new String[]{"delete from trade.buyorders where oid=? and tid=? and bid <?", "delete from trade.buyorders where oid>? and oid<? and status IN ('cancelled', 'filled') and tid=? "};
    int deleteByTidListSingleRowStmt = 1;
    public static final int insertToDerbyTable = 1;
    public static final int updateToDerbyTableCidRangeTx = 2;
    public static final int updateToDerbyTableTidListTx = 3;
    public static final int deleteToDerbyTableCidRangeTx = 4;
    public static final int deleteToDerbyTableTidListTx = 5;

    @Override
    public void deleteTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        boolean opFailed;
        int oid2;
        int oid1;
        int oid;
        int cid2;
        BigDecimal bid;
        int whichDelete;
        int txId;
        HashMap<String, Integer> keys;
        int[] tid;
        int[] cid;
        block17: {
            int size = 1;
            cid = new int[size];
            tid = new int[size];
            keys = new HashMap<String, Integer>();
            txId = modifiedKeys.get(thisTxId);
            whichDelete = this.getWhichTxDelete();
            bid = new BigDecimal(Double.toString((double)(rand.nextInt(10000) + 1) * 0.01));
            this.getCidAndTid(gConn, txId, cid, tid);
            cid2 = cid[0] + cidRangeForTxOp;
            oid = 0;
            if (byTidList) {
                oid = this.getOidByTid(gConn, tid[0]);
            } else if (byCidRange) {
                oid = this.getOidByCid(gConn, cid[0]);
            }
            oid1 = oid;
            oid2 = oid1 + 20;
            opFailed = false;
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeDelete(gConn, keys, whichDelete, cid[0], cid2, oid, bid, txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.deleteToGFXDTableCidRangeTx(gConn, cid[0], cid2, oid, bid, whichDelete);
                    break block17;
                }
                if (!byTidList) break block17;
                try {
                    this.getKeysForTidListDelete(gConn, keys, whichDelete, oid1, oid2, oid, bid, tid[0], txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.deleteToGFXDTableTidListTx(gConn, oid1, oid2, oid, bid, whichDelete, tid[0]);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn != null && byCidRange) {
                    if (!GFXDTxHelper.isColocatedCid(TradeBuyOrdersDMLTxStmt.getTableName(), txId, cid[0])) {
                        Log.getLogWriter().info("got expected non colocated exception, continuing testing");
                        return;
                    }
                    throw new TestException("got unexpected non colocated exception, keys are colocated\n" + TestHelper.getStackTrace((Throwable)se));
                }
                opFailed = true;
                sExList.add(se);
            }
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.putAll(keys);
        }
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{6, 4, cid[0], cid2, oid, bid, whichDelete};
            } else if (byTidList) {
                data = new Object[]{6, 5, oid1, oid2, oid, bid, whichDelete, tid[0]};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    protected void getKeysForCidRangeDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int cid, int cid2, int oid, BigDecimal bid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select oid from trade.buyorders where cid=" + cid + " and oid=" + oid + " and bid <" + bid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("oid: " + oid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + oid, txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select oid from trade.buyorders where cid>" + cid + " and cid<" + cid2 + " and status IN ('cancelled', 'filled')";
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availOid = rs.getInt("OID");
                    Log.getLogWriter().info("oid: " + availOid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + availOid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void getKeysForTidListDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int oid1, int oid2, int oid, BigDecimal bid, int tid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select oid from trade.buyorders where oid = " + oid + " and tid=" + tid + " and bid<" + bid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("oid: " + oid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + oid, txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select oid from trade.buyorders where oid>" + oid1 + " and oid<" + oid2 + " and status IN ('cancelled', 'filled') and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availOid = rs.getInt("OID");
                    Log.getLogWriter().info("oid: " + availOid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + availOid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void deleteToGFXDTableCidRangeTx(Connection conn, int cid, int cid2, int oid, BigDecimal bid, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradeBuyOrdersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete buyorders table in gemfirexd, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        count = this.deleteToTableCidRangeTx(stmt, cid, cid2, oid, bid, whichDelete);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected boolean deleteToDerbyTableCidRangeTx(Connection conn, int cid, int cid2, int oid, BigDecimal bid, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradeBuyOrdersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete buyorders table in derby, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        try {
            count = this.deleteToTableCidRangeTx(stmt, cid, cid2, oid, bid, whichDelete);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected int deleteToTableCidRangeTx(PreparedStatement stmt, int cid, int cid2, int oid, BigDecimal bid, int whichDelete) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("deleting from buyorders table for cid: " + cid + " and oid: " + oid + " and bid<" + bid);
                stmt.setInt(1, cid);
                stmt.setInt(2, oid);
                stmt.setBigDecimal(3, bid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("deleting from buyorders table for cid> " + cid + " to cid< " + cid2 + " and status IN ('cancelled', 'filled')");
                stmt.setInt(1, cid);
                stmt.setInt(2, cid2);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void deleteToGFXDTableTidListTx(Connection conn, int oid1, int oid2, int oid, BigDecimal bid, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete buyorders table in gemfirexd, myTid is " + TradeBuyOrdersDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        count = this.deleteToTableTidListTx(stmt, oid1, oid2, oid, bid, whichDelete, tid);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected boolean deleteToDerbyTableTidListTx(Connection conn, int oid1, int oid2, int oid, BigDecimal bid, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete buyorders table in derby, myTid is " + TradeBuyOrdersDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        try {
            count = this.deleteToTableTidListTx(stmt, oid1, oid2, oid, bid, whichDelete, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected int deleteToTableTidListTx(PreparedStatement stmt, int oid1, int oid2, int oid, BigDecimal bid, int whichDelete, int tid) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("deleting from buyorders for oid: " + oid + " and tid: " + tid + " and bid<" + bid);
                stmt.setInt(1, oid);
                stmt.setInt(2, tid);
                stmt.setBigDecimal(3, bid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("deleting from buyorders for oid > " + oid1 + " oid < " + oid2 + " and status IN ('cancelled', 'filled') and tid: " + tid);
                stmt.setInt(1, oid1);
                stmt.setInt(2, oid2);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong delete sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    @Override
    public String getMyTableName() {
        return TradeBuyOrdersDMLTxStmt.getTableName();
    }

    public static String getTableName() {
        return "buyorders";
    }

    @Override
    public void insertTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        int size = 1;
        int[] oid = new int[size];
        int[] sid = new int[size];
        int[] qty = new int[size];
        int[] cid = new int[size];
        int[] tid = new int[size];
        String status = "open";
        Timestamp[] time = new Timestamp[size];
        BigDecimal[] bid = new BigDecimal[size];
        int txId = modifiedKeys.get(thisTxId);
        this.getCidAndTid(gConn, txId, cid, tid);
        this.getDataForInsert(gConn, oid, cid, sid, qty, time, bid, size);
        boolean opFailed = false;
        try {
            this.insertToGFXDTable(gConn, oid[0], cid[0], sid[0], qty[0], status, time[0], bid[0]);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z04")) {
                throw new TestException("got unexpected non colocated exception, keys are colocated" + TestHelper.getStackTrace((Throwable)se));
            }
            opFailed = true;
            sExList.add(se);
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + oid[0], txId);
        }
        if (dConn != null) {
            Object[] data = new Object[]{6, 1, oid[0], cid[0], sid[0], qty[0], status, time[0], bid[0]};
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    protected void insertToGFXDTable(Connection conn, int oid, int cid, int sid, int qty, String status, Timestamp time, BigDecimal bid) throws SQLException {
        PreparedStatement stmt = TradeBuyOrdersDMLTxStmt.getStmt(conn, insert);
        int tid = TradeBuyOrdersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        count = this.insertToTable(stmt, oid, cid, sid, qty, status, time, bid, tid);
        Log.getLogWriter().info("gfxd inserts " + count + " record");
    }

    protected boolean insertToDerbyTable(Connection conn, int oid, int cid, int sid, int qty, String status, Timestamp time, BigDecimal bid) throws SQLException {
        PreparedStatement stmt = TradeBuyOrdersDMLTxStmt.getStmt(conn, insert);
        int tid = TradeBuyOrdersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into derby, myTid is " + tid);
        try {
            count = this.insertToTable(stmt, oid, cid, sid, qty, status, time, bid, tid);
            Log.getLogWriter().info("derby inserts " + count + " record");
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            throw se;
        }
        return true;
    }

    protected void getCidAndTid(Connection gConn, int txId, int[] cid, int[] tid) {
        if (byTidList) {
            tid[0] = GFXDTxHelper.getColocatedTid(TradeBuyOrdersDMLTxStmt.getTableName(), TradeBuyOrdersDMLTxStmt.getMyTid());
            cid[0] = TradeBuyOrdersDMLTxStmt.getCid();
        }
        if (byCidRange) {
            Object txIdCid = SQLBB.getBB().getSharedMap().get((Object)(cid_txId + txId));
            cid[0] = GFXDTxHelper.getColocatedCid(TradeBuyOrdersDMLTxStmt.getTableName(), (Integer)txIdCid);
            tid[0] = TradeBuyOrdersDMLTxStmt.getMyTid();
        }
    }

    @Override
    public void populateTx(Connection dConn, Connection gConn) {
        int size = 20;
        this.populateTx(dConn, gConn, size);
    }

    public void populateTx(Connection dConn, Connection gConn, int initSize) {
        this.insert(dConn, gConn, initSize);
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        for (int i = 0; i < size; ++i) {
            int randSize = rand.nextInt(size) + 1;
            this.insertRows(dConn, gConn, randSize, TradeBuyOrdersDMLTxStmt.getCid());
        }
    }

    public void insertRows(Connection dConn, Connection gConn, int size, int cid) {
        int[] oid = new int[size];
        int[] sid = new int[size];
        int[] qty = new int[size];
        String status = "open";
        Timestamp[] time = new Timestamp[size];
        BigDecimal[] bid = new BigDecimal[size];
        boolean success = false;
        this.getDataForInsert(gConn, oid, cid, sid, qty, time, bid, size);
        SQLException derbySe = null;
        SQLException gfxdSe = null;
        if (dConn != null) {
            block24: {
                try {
                    this.insertBatchToGFXDTable(gConn, oid, cid, sid, qty, status, time, bid);
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    gfxdSe = se;
                }
                try {
                    success = this.insertBatchToDerbyTable(dConn, oid, cid, sid, qty, status, time, bid);
                    int count = 0;
                    while (!success) {
                        if (count >= maxNumOfTries) {
                            Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                            throw new TestException("Could not get the lock to finish insert into derby");
                        }
                        success = this.insertBatchToDerbyTable(dConn, oid, cid, sid, qty, status, time, bid);
                        ++count;
                    }
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    derbySe = se;
                }
                try {
                    try {
                        Log.getLogWriter().info("gfxd committing the operation");
                        gConn.commit();
                        Log.getLogWriter().info("gfxd committed the operation");
                    }
                    catch (SQLException se) {
                        SQLHelper.printSQLException(se);
                        if (se.getSQLState().equals("X0Z05")) {
                            if (derbySe != null && SQLHelper.isSameRootSQLException(derbySe.getSQLState(), se) && derbySe.getSQLState().equals("23503")) {
                                Log.getLogWriter().warning("got foreign key check violation and masked as in doubt transaction exception -- which is bug# 41898 ");
                                gConn.rollback();
                                dConn.rollback();
                                return;
                            }
                            break block24;
                        }
                        SQLHelper.handleSQLException(se);
                    }
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
            }
            try {
                Log.getLogWriter().info("derby committing the operation");
                dConn.commit();
                Log.getLogWriter().info("derby committed the operation");
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                derbySe = se;
            }
            SQLHelper.compareExceptions(derbySe, gfxdSe);
        } else {
            try {
                this.insertBatchToGFXDTable(gConn, oid, cid, sid, qty, status, time, bid);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23505")) {
                    Log.getLogWriter().info("got expected gfxd duplicate primary key exception, continue testing");
                }
                if (se.getSQLState().equalsIgnoreCase("XJ208")) {
                    Log.getLogWriter().info("got expected gfxd batch update exception due to fk constraint, continue testing");
                }
                SQLHelper.handleSQLException(se);
            }
            try {
                gConn.commit();
                Log.getLogWriter().info("gfxd committed the operation");
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("X0Z05")) {
                    if (SQLHelper.isSameRootSQLException("23503", se)) {
                        Log.getLogWriter().warning("got foreign key check violation and masked as in doubt transaction exception -- which is bug# 41898 ");
                    }
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void getDataForInsert(Connection gConn, int[] oid, int cid, int[] sid, int[] qty, Timestamp[] time, BigDecimal[] bid, int size) {
        this.getOids(oid, size);
        for (int i = 0; i < size; ++i) {
            qty[i] = this.getQty(this.initMaxQty / 2);
            time[i] = new Timestamp(System.currentTimeMillis());
            bid[i] = new BigDecimal(Double.toString((double)(rand.nextInt(10000) + 1) * 0.01));
            sid[i] = this.getSid();
        }
    }

    protected void insertBatchToGFXDTable(Connection conn, int[] oid, int cid, int[] sid, int[] qty, String status, Timestamp[] time, BigDecimal[] bid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        int tid = TradeBuyOrdersDMLTxStmt.getMyTid();
        int[] counts = null;
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        int size = oid.length;
        for (int i = 0; i < size; ++i) {
            Log.getLogWriter().info("inserting into table trade.buyorders oid is " + oid[i] + " cid is " + cid + " sid is " + sid[i] + " qty is " + qty[i] + " status is " + status + " time is " + time[i] + " bid is " + bid[i] + " tid is " + tid);
            stmt.setInt(1, oid[i]);
            stmt.setInt(2, cid);
            stmt.setInt(3, sid[i]);
            stmt.setInt(4, qty[i]);
            stmt.setBigDecimal(5, bid[i]);
            stmt.setTimestamp(6, time[i]);
            stmt.setString(7, status);
            stmt.setInt(8, tid);
            stmt.addBatch();
        }
        counts = stmt.executeBatch();
        Log.getLogWriter().info("gfxd inserts " + counts.length + " record");
    }

    protected boolean insertBatchToDerbyTable(Connection conn, int[] oid, int cid, int[] sid, int[] qty, String status, Timestamp[] time, BigDecimal[] bid) throws SQLException {
        try {
            PreparedStatement stmt = conn.prepareStatement(insert);
            int tid = TradeBuyOrdersDMLTxStmt.getMyTid();
            int[] counts = null;
            Log.getLogWriter().info("Insert into derby, myTid is " + tid);
            int size = oid.length;
            for (int i = 0; i < size; ++i) {
                Log.getLogWriter().info("inserting into table trade.buyorders oid is " + oid[i] + " cid is " + cid + " sid is " + sid[i] + " qty is " + qty[i] + " status is " + status + " time is " + time[i] + " bid is " + bid[i] + " tid is " + tid);
                stmt.setInt(1, oid[i]);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid[i]);
                stmt.setInt(4, qty[i]);
                stmt.setBigDecimal(5, bid[i]);
                stmt.setTimestamp(6, time[i]);
                stmt.setString(7, status);
                stmt.setInt(8, tid);
                stmt.addBatch();
            }
            counts = stmt.executeBatch();
            Log.getLogWriter().info("gfxd inserts " + counts.length + " record");
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            throw se;
        }
        return true;
    }

    @Override
    public void queryTx(Connection dConn, Connection gConn) {
    }

    @Override
    public void updateTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        boolean opFailed;
        int largeCid;
        int smallCid;
        HashMap<String, Integer> keys;
        int oid;
        int tid2;
        int whichUpdate;
        int sid;
        int qty;
        Timestamp orderTime;
        BigDecimal bid;
        int tid;
        int cid;
        int txId;
        block22: {
            txId = modifiedKeys.get(thisTxId);
            int[] cids = new int[1];
            int[] tids = new int[1];
            this.getCidAndTid(gConn, txId, cids, tids);
            cid = cids[0];
            tid = tids[0];
            bid = this.getPrice();
            orderTime = this.getRandTime();
            qty = this.getQty();
            sid = this.getSid();
            whichUpdate = this.getWhichTxUpdate();
            tid2 = 0;
            if (byTidList) {
                tid2 = GFXDTxHelper.getColocatedTid(TradeBuyOrdersDMLTxStmt.getTableName(), TradeBuyOrdersDMLTxStmt.getMyTid());
            }
            oid = 0;
            if (byTidList) {
                oid = this.getOidByTid(gConn, tid);
            } else if (byCidRange) {
                oid = this.getOidByCid(gConn, cid);
            }
            keys = new HashMap<String, Integer>();
            smallCid = 0;
            largeCid = 0;
            if (byCidRange) {
                smallCid = GFXDTxHelper.getRangeEnds(TradeBuyOrdersDMLTxStmt.getTableName(), cid)[0];
                largeCid = GFXDTxHelper.getRangeEnds(TradeBuyOrdersDMLTxStmt.getTableName(), cid)[1];
            }
            opFailed = false;
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeUpdate(gConn, keys, whichUpdate, cid, sid, oid, bid, orderTime, smallCid, largeCid, txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.updateToGFXDTableCidRangeTx(gConn, cid, sid, oid, bid, qty, orderTime, smallCid, largeCid, whichUpdate);
                    break block22;
                }
                if (!byTidList) break block22;
                try {
                    this.getKeysForTidListUpdate(gConn, keys, whichUpdate, cid, sid, oid, bid, orderTime, tid, tid2, txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.updateToGFXDTableTidListTx(gConn, cid, sid, oid, bid, qty, orderTime, whichUpdate, tid, tid2);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn != null && byCidRange) {
                    if (!GFXDTxHelper.isColocatedCid(TradeBuyOrdersDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().info("got expected non colocated exception, continuing testing");
                        return;
                    }
                    throw new TestException("got unexpected non colocated exception, keys are colocated" + TestHelper.getStackTrace((Throwable)se));
                }
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn == null && byCidRange) {
                    if (GFXDTxHelper.isColocatedCid(TradeBuyOrdersDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().warning("should not get non colocated exception here");
                    }
                    return;
                }
                if (se.getSQLState().equalsIgnoreCase("23513")) {
                    opFailed = true;
                    sExList.add(se);
                }
                SQLHelper.handleSQLException(se);
            }
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.putAll(keys);
        }
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{6, 2, cid, sid, oid, bid, qty, orderTime, smallCid, largeCid, whichUpdate};
            } else if (byTidList) {
                data = new Object[]{6, 3, cid, sid, oid, bid, qty, orderTime, whichUpdate, tid, tid2};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    protected void getKeysForCidRangeUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, int sid, int oid, BigDecimal bid, Timestamp orderTime, int smallCid, int largeCid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: {
                sql = "select oid from trade.buyorders where cid=" + cid + " and oid=" + oid + " and status='open'";
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("oid: " + oid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select oid from trade.buyorders where cid=" + cid + " and oid=" + oid + " and bid<" + bid + " and status='open'";
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("oid: " + oid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select oid from trade.buyorders where cid>" + smallCid + " and cid<" + largeCid + " and sid = " + sid + " and bid<" + bid + " and status='open'";
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availOid = rs.getInt("OID");
                    Log.getLogWriter().info("oid: " + availOid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + availOid, txId);
                }
                rs.close();
                break;
            }
            case 3: {
                sql = "select oid from trade.buyorders where cid>? and cid<? and ordertime< ? and status='open'";
                PreparedStatement ps = conn.prepareStatement(sql);
                ps.setInt(1, smallCid);
                ps.setInt(2, largeCid);
                ps.setTimestamp(3, orderTime);
                rs = ps.executeQuery();
                while (rs.next()) {
                    int availOid = rs.getInt("OID");
                    Log.getLogWriter().info("oid: " + availOid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + availOid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void getKeysForTidListUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, int sid, int oid, BigDecimal bid, Timestamp orderTime, int tid, int tid2, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: {
                sql = "select oid from trade.buyorders where oid=" + oid + " and status='open' and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("oid: " + oid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select oid from trade.buyorders where oid=" + oid + " and bid<" + bid + " and status='open' and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("oid: " + oid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select oid from trade.buyorders where sid=" + sid + " and bid<" + bid + " and status='open' and (tid=" + tid + " or tid=" + tid2 + ")";
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availOid = rs.getInt("OID");
                    Log.getLogWriter().info("oid: " + availOid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + availOid, txId);
                }
                rs.close();
                break;
            }
            case 3: {
                sql = "select oid from trade.buyorders where ordertime< ? and status='open' and tid =? ";
                PreparedStatement ps = conn.prepareStatement(sql);
                ps.setTimestamp(1, orderTime);
                ps.setInt(2, tid);
                rs = ps.executeQuery();
                while (rs.next()) {
                    int availOid = rs.getInt("OID");
                    Log.getLogWriter().info("oid: " + availOid + " exists for update");
                    keys.put(TradeBuyOrdersDMLTxStmt.getTableName() + "_" + availOid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void updateToGFXDTableCidRangeTx(Connection conn, int cid, int sid, int oid, BigDecimal bid, int qty, Timestamp orderTime, int smallCid, int largeCid, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int tid = TradeBuyOrdersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("update buyorders table in gemfirexd, myTid is " + tid);
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        count = this.updateToTableCidRangeTx(stmt, cid, sid, oid, bid, qty, orderTime, smallCid, largeCid, whichUpdate);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableCidRangeTx(Connection conn, int cid, int sid, int oid, BigDecimal bid, int qty, Timestamp orderTime, int smallCid, int largeCid, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int tid = TradeBuyOrdersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("update buyorders table in derby, myTid is " + tid);
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        try {
            count = this.updateToTableCidRangeTx(stmt, cid, sid, oid, bid, qty, orderTime, smallCid, largeCid, whichUpdate);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected int updateToTableCidRangeTx(PreparedStatement stmt, int cid, int sid, int oid, BigDecimal bid, int qty, Timestamp orderTime, int smallCid, int largeCid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating buyorders table bid to " + bid + " for cid: " + cid + " and oid: " + oid + " and status = 'open'");
                stmt.setBigDecimal(1, bid);
                stmt.setInt(2, cid);
                stmt.setInt(3, oid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating buyorders table sid to " + sid + " and  qty to " + qty + " for cid: " + cid + " and oid: " + oid + " and bid < " + bid + " and status = 'open'");
                stmt.setInt(1, sid);
                stmt.setInt(2, qty);
                stmt.setInt(3, cid);
                stmt.setInt(4, oid);
                stmt.setBigDecimal(5, bid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating buyorders table status to 'filled' for cid: " + smallCid + " to " + largeCid + " and sid: " + sid + " and ask < " + bid + " and status = 'open'");
                stmt.setInt(1, smallCid);
                stmt.setInt(2, largeCid);
                stmt.setInt(3, sid);
                stmt.setBigDecimal(4, bid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info("updating buyorders table status to 'cancelled' for cid: " + smallCid + " to " + largeCid + " and ordertime < '" + orderTime + "' and status = 'open'");
                stmt.setInt(1, smallCid);
                stmt.setInt(2, largeCid);
                stmt.setTimestamp(3, orderTime);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void updateToGFXDTableTidListTx(Connection conn, int cid, int sid, int oid, BigDecimal bid, int qty, Timestamp orderTime, int whichUpdate, int tid, int tid2) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update buyorders table in gemfirexd, myTid is " + TradeBuyOrdersDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        count = this.updateToTableTidListTx(stmt, cid, sid, oid, bid, qty, orderTime, whichUpdate, tid, tid2);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableTidListTx(Connection conn, int cid, int sid, int oid, BigDecimal bid, int qty, Timestamp orderTime, int whichUpdate, int tid, int tid2) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update buyorder table in derby, myTid is " + TradeBuyOrdersDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        try {
            count = this.updateToTableTidListTx(stmt, cid, sid, oid, bid, qty, orderTime, whichUpdate, tid, tid2);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected int updateToTableTidListTx(PreparedStatement stmt, int cid, int sid, int oid, BigDecimal bid, int qty, Timestamp orderTime, int whichUpdate, int tid, int tid2) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating buyorders table bid to " + bid + " for  oid: " + oid + " and status = 'open' and tid=" + tid);
                stmt.setBigDecimal(1, bid);
                stmt.setInt(2, oid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating buyorders table cid to " + cid + " and  qty to " + qty + " for oid: " + oid + " and bid < " + bid + " and status = 'open' and tid=" + tid);
                stmt.setInt(1, cid);
                stmt.setInt(2, qty);
                stmt.setInt(3, oid);
                stmt.setBigDecimal(4, bid);
                stmt.setInt(5, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating buyorders table status to 'filled' for sid: " + sid + " and bid < " + bid + " and status = 'open' " + "and (tid=" + tid + " or tid=" + tid2 + ")");
                stmt.setInt(1, sid);
                stmt.setBigDecimal(2, bid);
                stmt.setInt(3, tid);
                stmt.setInt(4, tid2);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info("updating buyorders table status to 'cancelled' for ordertime < '" + orderTime + "' and status = 'open' and tid=" + tid);
                stmt.setTimestamp(1, orderTime);
                stmt.setInt(2, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int getOidByCid(Connection gConn, int cid) {
        ResultSet rs = null;
        List<Struct> result = null;
        try {
            String sql = "select oid from trade.buyorders where status = 'open' and cid= " + cid;
            rs = gConn.createStatement().executeQuery(sql);
            result = ResultSetHelper.asList(rs, false);
            return this.getOid(result);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            return 0;
        }
    }

    protected int getOidByTid(Connection gConn, int tid) {
        ResultSet rs = null;
        List<Struct> result = null;
        try {
            String sql = "select oid from trade.buyorders where status = 'open' and tid= " + tid;
            rs = gConn.createStatement().executeQuery(sql);
            result = ResultSetHelper.asList(rs, false);
            return this.getOid(result);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            return 0;
        }
    }

    protected int getOid(List<Struct> result) {
        if (result == null || result.size() == 0) {
            return 0;
        }
        int whichOne = rand.nextInt(result.size());
        return (Integer)result.get(whichOne).getFieldValues()[0];
    }

    protected int getWhichTxUpdate() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.updateByCidRange.length);
        }
        if (byCidRange && singleRowTx) {
            return rand.nextInt(this.updateByCidRangeSingleRowStmt);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.updateByTidList.length);
        }
        if (byTidList && singleRowTx) {
            return rand.nextInt(this.updateByTidListSingleRowStmt);
        }
        return -1;
    }

    protected int getWhichTxDelete() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.deleteByCidRange.length);
        }
        if (byCidRange && singleRowTx) {
            return rand.nextInt(this.deleteByCidRangeSingleRowStmt);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.deleteByTidList.length);
        }
        if (byTidList && singleRowTx) {
            return rand.nextInt(this.deleteByTidListSingleRowStmt);
        }
        return -1;
    }

    @Override
    public void performDerbyTxOps(Connection dConn, Object[] data, ArrayList<SQLException> dExList) {
        boolean success = true;
        try {
            switch ((Integer)data[1]) {
                case 1: {
                    success = this.insertToDerbyTable(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (Integer)data[5], (String)data[6], (Timestamp)data[7], (BigDecimal)data[8]);
                    break;
                }
                case 2: {
                    success = this.updateToDerbyTableCidRangeTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (BigDecimal)data[5], (Integer)data[6], (Timestamp)data[7], (Integer)data[8], (Integer)data[9], (Integer)data[10]);
                    break;
                }
                case 3: {
                    success = this.updateToDerbyTableTidListTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (BigDecimal)data[5], (Integer)data[6], (Timestamp)data[7], (Integer)data[8], (Integer)data[9], (Integer)data[10]);
                    break;
                }
                case 4: {
                    success = this.deleteToDerbyTableCidRangeTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (BigDecimal)data[5], (Integer)data[6]);
                    break;
                }
                case 5: {
                    success = this.deleteToDerbyTableTidListTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (BigDecimal)data[5], (Integer)data[6], (Integer)data[7]);
                    break;
                }
                default: {
                    throw new TestException("wrong derby tx ops");
                }
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            dExList.add(se);
            return;
        }
        if (!success) {
            throw new TestException("Only one thread performing derby ops, should not fail");
        }
        dExList.add(null);
    }
}

