/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlTxStatements;

import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.TradeCustomersDMLStmt;
import sql.dmlStatements.TradeNetworthDMLStmt;
import sql.dmlTxStatements.DMLTxStmtIF;
import sql.dmlTxStatements.TradeNetworthDMLTxStmt;
import sql.sqlTx.SQLDerbyTxBB;
import sql.sqlutil.GFXDTxHelper;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradeCustomersDMLTxStmt
extends TradeCustomersDMLStmt
implements DMLTxStmtIF {
    String[] updateByCidRange = new String[]{"update trade.customers set cust_name = ? , addr = ? where cid=? ", "update trade.customers set cust_name = ?,  since= ? where cid=? ", "update trade.customers set addr=? where cid>? and cid <?  "};
    int updateByCidRangeSingleRowStmt = 2;
    String[] updateByTidList = new String[]{"update trade.customers set addr = ? where cid=? and tid=? ", "update trade.customers set cust_name = ?, since= ? where cid=? and tid=?", "update trade.customers set addr=? where since <? and tid=? ", "update trade.customers set since=? where cid>? and cid<? and tid=? "};
    int updateByTidListSingleRowStmt = 2;
    String[] deleteByCidRange = new String[]{"delete from trade.customers where cid=?", "delete from trade.customers where  cid > ? and cid < ? "};
    int deleteByCidRangeSingleRowStmt = 1;
    String[] deleteByTidList = new String[]{"delete from trade.customers where cid=? and tid=? ", "delete from trade.customers where (cust_name > ? or cid < ? ) and tid = ?"};
    int deleteByTidListSingleRowStmt = 1;
    public static final int insertToDerbyTable = 1;
    public static final int updateToDerbyTableCidRangeTx = 2;
    public static final int updateToDerbyTableTidListTx = 3;
    public static final int deleteToDerbyTableCidRangeTx = 4;
    public static final int deleteToDerbyTableTidListTx = 5;

    @Override
    public void deleteTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        boolean opFailed;
        int cid2;
        int cid;
        int tid;
        int txId;
        int whichDelete;
        HashMap<String, Integer> keys;
        String cust_name;
        block18: {
            int custNameLength = 20;
            cust_name = this.getRandVarChar(custNameLength);
            keys = new HashMap<String, Integer>();
            whichDelete = this.getWhichTxDelete();
            txId = modifiedKeys.get(thisTxId);
            tid = this.getTxColocatedTid();
            cid = this.getTxColocatedCid(gConn, tid, txId);
            cid2 = cid + cidRangeForTxOp;
            opFailed = false;
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeDelete(gConn, keys, whichDelete, cid, cid2, txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.deleteToGFXDTableCidRangeTx(gConn, cid, cid2, whichDelete);
                    break block18;
                }
                if (!byTidList) break block18;
                try {
                    this.getKeysForTidListDelete(gConn, keys, whichDelete, cid, cust_name, tid, txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.deleteToGFXDTableTidListTx(gConn, cid, cust_name, whichDelete, tid);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn != null && byCidRange) {
                    if (!GFXDTxHelper.isColocatedCid(TradeCustomersDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().info("got expected non colocated exception, continuing testing");
                        return;
                    }
                    throw new TestException("got unexpected non colocated exception, keys are colocated\n" + TestHelper.getStackTrace((Throwable)se));
                }
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn == null && byCidRange) {
                    if (GFXDTxHelper.isColocatedCid(TradeCustomersDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().warning("should not get non colocated exception here");
                    }
                    return;
                }
                opFailed = true;
                sExList.add(se);
            }
        }
        if (modifiedKeys.size() > 1 && byCidRange && dConn != null && !GFXDTxHelper.isColocatedCid(TradeCustomersDMLTxStmt.getTableName(), txId, cid)) {
            Set<String> modkeys = modifiedKeys.keySet();
            StringBuffer str = new StringBuffer();
            str.append("The inserted cid is " + cid);
            str.append(", it is not colocated with following cid in this tx: \n");
            for (String key : modkeys) {
                if (key.equalsIgnoreCase(thisTxId)) continue;
                str.append(key + ",\t");
            }
            throw new TestException("Did not get the expected non colocated exception\n" + str.toString());
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.putAll(keys);
        }
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{1, 4, cid, cid2, whichDelete};
            } else if (byTidList) {
                data = new Object[]{1, 5, cid, cust_name, whichDelete, tid};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    @Override
    public void queryTx(Connection dConn, Connection gConn) {
    }

    @Override
    public void updateTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        int cid2;
        int cid;
        int tid;
        int txId;
        int whichUpdate;
        HashMap<String, Integer> keys;
        String addr;
        Date since;
        String cust_name;
        block17: {
            int custNameLength = 20;
            int addrLength = 40;
            cust_name = this.getRandVarChar(custNameLength);
            since = TradeCustomersDMLTxStmt.getSince();
            addr = this.getRandVarChar(addrLength);
            keys = new HashMap<String, Integer>();
            whichUpdate = this.getWhichTxUpdate();
            txId = modifiedKeys.get(thisTxId);
            tid = this.getTxColocatedTid();
            cid = this.getTxColocatedCid(gConn, tid, txId);
            cid2 = cid + cidRangeForTxOp;
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeUpdate(gConn, keys, whichUpdate, cid, cid2, txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.updateToGFXDTableCidRangeTx(gConn, cid, cid2, cust_name, since, addr, whichUpdate);
                    break block17;
                }
                if (!byTidList) break block17;
                try {
                    this.getKeysForTidListUpdate(gConn, keys, whichUpdate, cid, cid2, since, tid, txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.updateToGFXDTableTidListTx(gConn, cid, cid2, cust_name, since, addr, whichUpdate, tid);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn != null && byCidRange) {
                    if (!GFXDTxHelper.isColocatedCid(TradeCustomersDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().info("got expected non colocated exception, continuing testing");
                        return;
                    }
                    throw new TestException("got unexpected non colocated exception, keys are colocated" + TestHelper.getStackTrace((Throwable)se));
                }
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn == null && byCidRange) {
                    if (GFXDTxHelper.isColocatedCid(TradeCustomersDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().warning("should not get non colocated exception here");
                    }
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
        }
        if (modifiedKeys.size() > 1 && byCidRange && dConn != null && !GFXDTxHelper.isColocatedCid(TradeCustomersDMLTxStmt.getTableName(), txId, cid)) {
            Set<String> modkeys = modifiedKeys.keySet();
            StringBuffer str = new StringBuffer();
            str.append("The inserted cid is " + cid);
            str.append(", it is not colocated with following cid in this tx: \n");
            for (String key : modkeys) {
                if (key.equalsIgnoreCase(thisTxId)) continue;
                str.append(key + ",\t");
            }
            throw new TestException("Did not get the expected non colocated exception\n" + str.toString());
        }
        sExList.add(null);
        modifiedKeys.putAll(keys);
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{1, 2, cid, cid2, cust_name, since, addr, whichUpdate};
            } else if (byTidList) {
                data = new Object[]{1, 3, cid, cid2, cust_name, since, addr, whichUpdate, tid};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    protected void updateToGFXDTableCidRangeTx(Connection conn, int cid, int cid2, String cust_name, Date since, String addr, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int tid = TradeCustomersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("update customers table in gemfirexd, myTid is " + tid);
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        count = this.updateToTableCidRangeTx(stmt, cid, cid2, cust_name, since, addr, whichUpdate);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableCidRangeTx(Connection conn, int cid, int cid2, String cust_name, Date since, String addr, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int tid = TradeCustomersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("update customers table in derby, myTid is " + tid);
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        try {
            count = this.updateToTableCidRangeTx(stmt, cid, cid2, cust_name, since, addr, whichUpdate);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected void getKeysForCidRangeUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, int cid2, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: 
            case 1: {
                sql = "select cid from trade.customers where cid=" + cid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " exists for update");
                    keys.put(TradeCustomersDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select cid from trade.customers where cid>" + cid + " and cid<" + cid2;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info("cid: " + availCid + " exists for update");
                    keys.put(TradeCustomersDMLTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void getKeysForTidListUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, int cid2, Date since, int tid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: 
            case 1: {
                sql = "select cid from trade.customers where cid=" + cid + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " exists for update");
                    keys.put(TradeCustomersDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select cid from trade.customers where since<'" + since + "' and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info("cid: " + availCid + " exists for update");
                    keys.put(TradeCustomersDMLTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            case 3: {
                sql = "select cid from trade.customers where cid>" + cid + " and cid<" + cid2 + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info("cid: " + availCid + " exists for update");
                    keys.put(TradeCustomersDMLTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void getKeysForCidRangeDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int cid, int cid2, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select cid from trade.customers where cid=" + cid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " exists for update");
                    keys.put(TradeCustomersDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select cid from trade.customers where cid>" + cid + " and cid<" + cid2;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info("cid: " + availCid + " exists for update");
                    keys.put(TradeCustomersDMLTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void getKeysForTidListDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int cid, String cust_name, int tid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select cid from trade.customers where cid=" + cid + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " exists for update");
                    keys.put(TradeCustomersDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select cid from trade.customers where (cust_name >'" + cust_name + "' and cid<" + cid + ") and tid = " + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info("cid: " + availCid + " exists for update");
                    keys.put(TradeCustomersDMLTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void updateToGFXDTableTidListTx(Connection conn, int cid, int cid2, String cust_name, Date since, String addr, int whichUpdate, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update customers table in gemfirexd, myTid is " + TradeCustomersDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        count = this.updateToTableTidListTx(stmt, cid, cid2, cust_name, since, addr, whichUpdate, tid);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableTidListTx(Connection conn, int cid, int cid2, String cust_name, Date since, String addr, int whichUpdate, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update customers table in derby, myTid is " + TradeCustomersDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        try {
            count = this.updateToTableTidListTx(stmt, cid, cid2, cust_name, since, addr, whichUpdate, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected int updateToTableCidRangeTx(PreparedStatement stmt, int cid, int cid2, String cust_name, Date since, String addr, int whichUpdate) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating cust_name to " + cust_name + ", addr to " + addr + ", for cid: " + cid);
                stmt.setString(1, cust_name);
                stmt.setString(2, addr);
                stmt.setInt(3, cid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating cust_name to " + cust_name + ", since to " + since + ", for cid: " + cid);
                stmt.setString(1, cust_name);
                stmt.setDate(2, since);
                stmt.setInt(3, cid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating addr to " + addr + ", for cid: " + cid + " to " + cid2);
                stmt.setString(1, addr);
                stmt.setInt(2, cid);
                stmt.setInt(3, cid2);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int updateToTableTidListTx(PreparedStatement stmt, int cid, int cid2, String cust_name, Date since, String addr, int whichUpdate, int tid) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating addr to " + addr + ", for cid: " + cid + " and tid: " + tid);
                stmt.setString(1, addr);
                stmt.setInt(2, cid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating cust_name to " + cust_name + ", since to " + since + ", for cid: " + cid + " and tid: " + tid);
                stmt.setString(1, cust_name);
                stmt.setDate(2, since);
                stmt.setInt(3, cid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating addr to " + addr + ", for since< " + since + " and tid: " + tid);
                stmt.setString(1, addr);
                stmt.setDate(2, since);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info("updating since to " + since + ", for cid> " + cid + " and cid< " + cid2 + " and tid: " + tid);
                stmt.setDate(1, since);
                stmt.setInt(2, cid);
                stmt.setInt(3, cid2);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int getWhichTxUpdate() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.updateByCidRange.length);
        }
        if (byCidRange && singleRowTx) {
            return rand.nextInt(this.updateByCidRangeSingleRowStmt);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.updateByTidList.length);
        }
        if (byTidList && singleRowTx) {
            return rand.nextInt(this.updateByTidListSingleRowStmt);
        }
        return -1;
    }

    protected int getWhichTxDelete() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.deleteByCidRange.length);
        }
        if (byCidRange && singleRowTx) {
            return rand.nextInt(this.deleteByCidRangeSingleRowStmt);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.deleteByTidList.length);
        }
        if (byTidList && singleRowTx) {
            return rand.nextInt(this.deleteByTidListSingleRowStmt);
        }
        return -1;
    }

    protected void deleteToGFXDTableCidRangeTx(Connection conn, int cid, int cid2, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradeCustomersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete customers table in gemfirexd, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        count = this.deleteToTableCidRangeTx(stmt, cid, cid2, whichDelete);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected int deleteToTableCidRangeTx(PreparedStatement stmt, int cid, int cid2, int whichDelete) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("delete from customers for cid: " + cid);
                stmt.setInt(1, cid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("delete customers for cid> " + cid + " and cid< " + cid2);
                stmt.setInt(1, cid);
                stmt.setInt(2, cid2);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong delete sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected boolean deleteToDerbyTableCidRangeTx(Connection conn, int cid, int cid2, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradeCustomersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete customers table in derby, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        try {
            count = this.deleteToTableCidRangeTx(stmt, cid, cid2, whichDelete);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected void deleteToGFXDTableTidListTx(Connection conn, int cid, String cust_name, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete customers table in gemfirexd, myTid is " + TradeCustomersDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        count = this.deleteToTableTidListTx(stmt, cid, cust_name, whichDelete, tid);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected boolean deleteToDerbyTableTidListTx(Connection conn, int cid, String cust_name, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete customers table in derby, myTid is " + TradeCustomersDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        try {
            count = this.deleteToTableTidListTx(stmt, cid, cust_name, whichDelete, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected int deleteToTableTidListTx(PreparedStatement stmt, int cid, String cust_name, int whichDelete, int tid) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("delete from customers for cid: " + cid + " and tid: " + tid);
                stmt.setInt(1, cid);
                stmt.setInt(2, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("delete from customers for cust_name>'" + cust_name + "'and " + "cid< " + cid + " and tid: " + tid);
                stmt.setString(1, cust_name);
                stmt.setInt(2, cid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong delete sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    @Override
    public void populate(Connection dConn, Connection gConn, int initSize) {
        this.insert(dConn, gConn, initSize);
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        int i;
        int[] cid = new int[size];
        String[] cust_name = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        boolean success = false;
        this.getDataForInsert(cid, cust_name, since, addr, size);
        SQLException derbySe = null;
        SQLException gfxdSe = null;
        if (dConn != null) {
            for (i = 0; i < cid.length; ++i) {
                try {
                    this.insertToGFXDTable(gConn, cid[i], cust_name[i], since[i], addr[i]);
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    gfxdSe = se;
                }
                try {
                    success = this.insertToDerbyTable(dConn, cid[i], cust_name[i], since[i], addr[i]);
                    int count = 0;
                    while (!success) {
                        if (count >= maxNumOfTries) {
                            Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                            gConn.rollback();
                            dConn.rollback();
                            break;
                        }
                        success = this.insertToDerbyTable(dConn, cid[i], cust_name[i], since[i], addr[i]);
                        ++count;
                    }
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    derbySe = se;
                }
                SQLHelper.compareExceptions(derbySe, gfxdSe);
                derbySe = null;
                gfxdSe = null;
                try {
                    gConn.commit();
                    Log.getLogWriter().info("gfxd committed the operation");
                    dConn.commit();
                    Log.getLogWriter().info("derby committed the operation");
                    continue;
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
            }
        } else {
            for (i = 0; i < cid.length; ++i) {
                try {
                    this.insertToGFXDTable(gConn, cid[i], cust_name[i], since[i], addr[i]);
                    gConn.commit();
                    Log.getLogWriter().info("gfxd committed the operation");
                    continue;
                }
                catch (SQLException se) {
                    Log.getLogWriter().info("in inserting a single record in customers and op failed");
                    SQLHelper.handleSQLException(se);
                }
            }
        }
        if (hasNetworth) {
            Log.getLogWriter().info("inserting into networth table");
            TradeNetworthDMLTxStmt networthTx = new TradeNetworthDMLTxStmt();
            networthTx.insert(dConn, gConn, size, cid);
        }
    }

    protected boolean insertToDerbyTable(Connection conn, int cid, String cust_name, Date since, String addr) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        int tid = TradeCustomersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into derby, myTid is " + tid);
        try {
            count = this.insertToTable(stmt, cid, cust_name, since, addr, tid);
            Log.getLogWriter().info("derby inserts " + count + " record");
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            throw se;
        }
        return true;
    }

    protected void insertToGFXDTable(Connection conn, int cid, String cust_name, Date since, String addr) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        int tid = TradeCustomersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        count = this.insertToTable(stmt, cid, cust_name, since, addr, tid);
        Log.getLogWriter().info("gfxd inserts " + count + " record");
    }

    public void populateTx(Connection dConn, Connection gConn, int initSize) {
        this.populate(dConn, gConn, initSize);
    }

    public void insertTx(Connection dConn, Connection gConn, int size) {
        int[] cid = new int[size];
        String[] cust_name = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        this.getDataForInsert(cid, cust_name, since, addr, size);
        this.insertCustTx(dConn, gConn, cid, cust_name, since, addr);
    }

    @Override
    public void insertTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        int size = 1;
        int[] cid = new int[size];
        String[] cust_name = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        this.getDataForInsert(cid, cust_name, since, addr, size);
        int txId = modifiedKeys.get(thisTxId);
        try {
            this.insertToGFXDTable(gConn, cid[0], cust_name[0], since[0], addr[0]);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn != null && byCidRange) {
                if (!GFXDTxHelper.isColocatedCid(TradeCustomersDMLTxStmt.getTableName(), txId, cid[0])) {
                    Log.getLogWriter().info("got expected non colocated exception, continuing testing");
                    return;
                }
                throw new TestException("got unexpected non colocated exception, keys are colocated" + TestHelper.getStackTrace((Throwable)se));
            }
            if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn == null && byCidRange) {
                if (GFXDTxHelper.isColocatedCid(TradeCustomersDMLTxStmt.getTableName(), txId, cid[0])) {
                    Log.getLogWriter().warning("should not get non colocated exception here");
                }
                return;
            }
            SQLHelper.handleSQLException(se);
        }
        if (modifiedKeys.size() == 1) {
            SQLBB.getBB().getSharedMap().put((Object)("cid_txId_" + txId), (Object)cid[0]);
        } else if (modifiedKeys.size() > 1 && byCidRange && dConn != null && !GFXDTxHelper.isColocatedCid(TradeCustomersDMLTxStmt.getTableName(), txId, cid[0])) {
            Set<String> keys = modifiedKeys.keySet();
            StringBuffer str = new StringBuffer();
            str.append("The inserted cid is " + cid[0]);
            str.append(", it is not colocated with following cid in this tx: \n");
            for (String key : keys) {
                if (key.equalsIgnoreCase(thisTxId)) continue;
                str.append(key + ",\t");
            }
            throw new TestException("Did not get the expected non colocated exception\n" + str.toString());
        }
        sExList.add(null);
        modifiedKeys.put(TradeCustomersDMLTxStmt.getTableName() + "_" + cid[0], txId);
        if (dConn != null) {
            Object[] data = new Object[]{1, 1, cid[0], cust_name[0], since[0], addr[0]};
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
        TradeNetworthDMLTxStmt networthTx = new TradeNetworthDMLTxStmt();
        networthTx.insertTx(dConn, gConn, modifiedKeys, dExList, sExList, cid[0]);
    }

    private void insertCustTx(Connection dConn, Connection gConn, int[] cid, String[] cust_name, Date[] since, String[] addr) {
        ArrayList<SQLException> derbyExList = new ArrayList<SQLException>();
        ArrayList<SQLException> gfxdExList = new ArrayList<SQLException>();
        boolean success = false;
        int size = cid.length;
        boolean executeBatch = false;
        if (dConn != null) {
            boolean expectFailure;
            block24: {
                try {
                    if (executeBatch) {
                        this.insertBatchToGFETableTx(gConn, cid, cust_name, since, addr, size, gfxdExList);
                    } else {
                        this.insertToGFETableTx(gConn, cid, cust_name, since, addr, size, gfxdExList);
                    }
                    success = executeBatch ? this.insertBatchToDerbyTableTx(dConn, cid, cust_name, since, addr, size, derbyExList) : this.insertToDerbyTableTx(dConn, cid, cust_name, since, addr, size, derbyExList);
                    int count = 0;
                    while (!success) {
                        if (count >= maxNumOfTries) {
                            Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                            dConn.rollback();
                            gConn.rollback();
                            return;
                        }
                        derbyExList.clear();
                        success = executeBatch ? this.insertBatchToDerbyTable(dConn, cid, cust_name, since, addr, size, derbyExList) : this.insertToDerbyTable(dConn, cid, cust_name, since, addr, size, derbyExList);
                        ++count;
                    }
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    throw new TestException("insert to trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
                }
                ArrayList<SQLException> gfxdExListCopy = new ArrayList<SQLException>(gfxdExList);
                SQLHelper.removeSameExceptions(gfxdExListCopy, derbyExList);
                SQLHelper.removeSameExceptions(derbyExList, gfxdExList);
                if (!gfxdExListCopy.isEmpty()) {
                    Log.getLogWriter().warning("gfxd has following additional exceptions");
                    for (SQLException gfxd : gfxdExListCopy) {
                        SQLHelper.printSQLException(gfxd);
                    }
                }
                expectFailure = false;
                TradeCustomersDMLTxStmt.getLock();
                try {
                    Log.getLogWriter().info("committing gfxd inserts");
                    gConn.commit();
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    if (!se.getSQLState().equalsIgnoreCase("X0Z02")) break block24;
                    expectFailure = true;
                    if (derbyExList.isEmpty()) {
                        throw new TestException("Got commit conflict exception, but derby does not have any exception");
                    }
                    SQLException derbySe = (SQLException)derbyExList.get(0);
                    if (derbySe.getSQLState().equalsIgnoreCase("23505")) {
                        try {
                            dConn.rollback();
                        }
                        catch (SQLException dse) {
                            SQLHelper.handleSQLException(dse);
                        }
                        derbyExList.remove(0);
                    }
                    SQLHelper.printSQLException(derbySe);
                    throw new TestException("Got commit conflict exception, but derby does not get the expected exception");
                }
            }
            if (!expectFailure) {
                try {
                    Log.getLogWriter().info("committing derby inserts");
                    dConn.commit();
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
            }
            this.releaseLock();
            if (!derbyExList.isEmpty()) {
                Log.getLogWriter().warning("derby has following additional exceptions");
                for (SQLException derby : derbyExList) {
                    SQLHelper.printSQLException(derby);
                }
            }
        } else {
            try {
                this.insertToGFETableTx(gConn, cid, cust_name, since, addr, size);
                gConn.commit();
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                throw new TestException("insert to gfe trade.customers fails\n" + TestHelper.getStackTrace((Throwable)se));
            }
        }
        if (hasNetworth) {
            Log.getLogWriter().info("inserting into networth table");
            TradeNetworthDMLStmt networth = new TradeNetworthDMLStmt();
            networth.insertTx(dConn, gConn, size, cid);
        }
    }

    protected boolean insertToDerbyTableTx(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, List<SQLException> exceptions) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        int tid = TradeCustomersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into derby, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            try {
                count = this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], tid);
                if (count == (Integer)verifyRowCount.get(tid + "_insert" + i)) continue;
                Log.getLogWriter().info("Derby insert has different row count from that of gfxd, gfxd inserted " + (Integer)verifyRowCount.get(tid + "_insert" + i) + " but derby inserted " + count);
                continue;
            }
            catch (SQLException se) {
                if (!SQLHelper.checkDerbyException(conn, se)) {
                    return false;
                }
                SQLHelper.handleDerbyTxSQLException(se, exceptions);
            }
        }
        return true;
    }

    protected boolean insertBatchToDerbyTableTx(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, List<SQLException> exceptions) throws SQLException {
        return true;
    }

    protected void insertToGFETableTx(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, List<SQLException> exceptions) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        int tid = TradeCustomersDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            try {
                verifyRowCount.put(tid + "_insert" + i, 0);
                count = this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], tid);
                verifyRowCount.put(tid + "_insert" + i, new Integer(count));
                Log.getLogWriter().info("gfxd inserts " + verifyRowCount.get(tid + "_insert" + i) + " rows");
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleGFETxSQLException(se, exceptions);
            }
        }
    }

    protected void insertBatchToGFETableTx(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size, List exceptions) throws SQLException {
        Log.getLogWriter().info("Needs to be implemented");
    }

    protected void insertToGFETableTx(Connection conn, int[] cid, String[] cust_name, Date[] since, String[] addr, int size) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        int tid = TradeCustomersDMLTxStmt.getMyTid();
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            try {
                this.insertToTable(stmt, cid[i], cust_name[i], since[i], addr[i], tid);
                continue;
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    @Override
    public void populateTx(Connection dConn, Connection gConn) {
        int size = TestConfig.tab().intAt(SQLPrms.initCustomersSizePerThread, 100);
        this.populateTx(dConn, gConn, size);
    }

    public void insertCustomersTxConflict(Connection dConn, Connection gConn, int size) {
        size = 3;
        int[] cid = new int[size];
        String[] cust_name = new String[size];
        Date[] since = new Date[size];
        String[] addr = new String[size];
        ArrayList derbyExList = new ArrayList();
        ArrayList gfxdExList = new ArrayList();
        boolean success = false;
        this.getDataForInsert(cid, cust_name, since, addr, size);
        if (TradeCustomersDMLTxStmt.getMyTid() % 3 == 0) {
            cid[0] = 701;
            cust_name[0] = "newName1";
            cid[1] = 702;
            cust_name[1] = "newName1";
            cid[2] = 703;
            cust_name[2] = "newName1";
        }
        if (TradeCustomersDMLTxStmt.getMyTid() % 3 == 1) {
            cid[0] = 9999;
            cust_name[0] = "newName1";
            cid[1] = 9998;
            cust_name[1] = "newName1";
            cid[2] = 9997;
            cust_name[2] = "newName1";
        }
        this.insertCustTx(dConn, gConn, cid, cust_name, since, addr);
    }

    public void updateCustomersTxConflict(Connection dConn, Connection gConn, int size) {
        block19: {
            boolean expectFailure;
            block18: {
                block17: {
                    if (dConn == null) {
                        return;
                    }
                    boolean firstSql = rand.nextBoolean();
                    String updateSql = firstSql ? "update trade.customers set cust_name =?  where cid=1" : "update trade.customers set addr =?  where cid=1";
                    int maxVarCharLength = 10;
                    String field = this.getRandVarChar(maxVarCharLength) + "update";
                    PreparedStatement dStmt = null;
                    PreparedStatement gStmt = null;
                    ArrayList partitionKeys = (ArrayList)partitionMap.get((Object)"customersPartition");
                    Log.getLogWriter().info("update statement is " + updateSql);
                    if (dConn != null) {
                        dStmt = firstSql && SQLTest.testPartitionBy && partitionKeys.contains("cust_name") ? null : TradeCustomersDMLTxStmt.getStmt(dConn, updateSql);
                    }
                    if ((gStmt = firstSql && SQLTest.testPartitionBy && partitionKeys.contains("cust_name") ? this.getUnsupportedStmt(gConn, updateSql) : TradeCustomersDMLTxStmt.getStmt(gConn, updateSql)) == null) {
                        return;
                    }
                    int count = 0;
                    try {
                        gStmt.setString(1, field);
                        count = gStmt.executeUpdate();
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    Log.getLogWriter().info("wait for 5 seconds in updateCustTxInitTask, so that only one update operation will succeed");
                    MasterController.sleepForMs((int)5000);
                    try {
                        dStmt.setString(1, field);
                        count = dStmt.executeUpdate();
                    }
                    catch (SQLException se) {
                        if (SQLHelper.checkDerbyException(dConn, se)) break block17;
                        Log.getLogWriter().info("lock timeout, rollback the operations");
                        try {
                            dConn.rollback();
                            gConn.rollback();
                            return;
                        }
                        catch (SQLException e) {
                            SQLHelper.handleSQLException(e);
                        }
                    }
                }
                expectFailure = false;
                TradeCustomersDMLTxStmt.getLock();
                try {
                    gConn.commit();
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    if (!se.getSQLState().equalsIgnoreCase("X0Z02")) break block18;
                    expectFailure = true;
                }
            }
            try {
                if (expectFailure) {
                    dConn.rollback();
                    if (SQLBB.getBB().getSharedMap().get((Object)"custUpdateTxInitTask") == null) {
                        Log.getLogWriter().warning("update failed, but no successful update yet, wait for 1 sec");
                        MasterController.sleepForMs((int)1000);
                        if (SQLBB.getBB().getSharedMap().get((Object)"custUpdateTxInitTask") == null) {
                            throw new TestException("after wait for 1 sec, update failed, but there is no successful update");
                        }
                    }
                    break block19;
                }
                dConn.commit();
                if (SQLBB.getBB().getSharedMap().get((Object)"custUpdateTxInitTask") == null) {
                    SQLBB.getBB().getSharedMap().put((Object)"custUpdateTxInitTask", (Object)true);
                    break block19;
                }
                throw new TestException("in custUpdateTxInitTask, more than one update on same record are successfuly");
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
        this.releaseLock();
    }

    public void updateCustomersTxScatter(Connection dConn, Connection gConn) {
        String name = null;
        String name2 = null;
        String updateScatter1 = "update trade.customers set cust_name = 'newName1'  where cust_name='";
        String updateScatter2 = "update trade.customers set cust_name = 'newName2'  where cust_name='";
        String updateScatter3 = "update trade.customers set cust_name = 'newName3'  where cust_name='newName1'";
        String select = "select * from trade.customers";
        String selectName = "select cust_name from trade.customers";
        try {
            ResultSet rsName = gConn.createStatement().executeQuery(selectName);
            if (rsName.next()) {
                name = rsName.getString(1);
                Log.getLogWriter().info("name is " + name);
            }
            if (rsName.next()) {
                name2 = rsName.getString(1);
                Log.getLogWriter().info("name2 is " + name2);
            }
            gConn.createStatement().executeUpdate(updateScatter1 + name + "'");
            Log.getLogWriter().info("execute update statement: " + updateScatter1 + name + "'");
            ResultSet rs = gConn.createStatement().executeQuery(select);
            String result = ResultSetHelper.listToString(ResultSetHelper.asList(rs, false));
            Log.getLogWriter().info("results are : " + result);
            gConn.createStatement().executeUpdate(updateScatter2 + name2 + "'");
            Log.getLogWriter().info("execute update statement: " + updateScatter2 + name2 + "'");
            ResultSet rs2 = gConn.createStatement().executeQuery(select);
            String result2 = ResultSetHelper.listToString(ResultSetHelper.asList(rs2, false));
            Log.getLogWriter().info("results after second update within tx are : " + result2);
            gConn.createStatement().executeUpdate(updateScatter3);
            Log.getLogWriter().info("execute update statement: " + updateScatter3);
            ResultSet rs3 = gConn.createStatement().executeQuery(select);
            String result3 = ResultSetHelper.listToString(ResultSetHelper.asList(rs3, false));
            Log.getLogWriter().info("results after third update within tx are : " + result3);
            gConn.commit();
            ResultSet rs4 = gConn.createStatement().executeQuery(select);
            String result4 = ResultSetHelper.listToString(ResultSetHelper.asList(rs4, false));
            Log.getLogWriter().info("results after commit are : " + result4);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static String getTableName() {
        return "customers";
    }

    @Override
    public String getMyTableName() {
        return TradeCustomersDMLTxStmt.getTableName();
    }

    protected int getTxColocatedTid() {
        int tid = -1;
        if (byTidList) {
            tid = GFXDTxHelper.getColocatedTid(TradeCustomersDMLTxStmt.getTableName(), TradeCustomersDMLTxStmt.getMyTid());
        }
        return tid;
    }

    protected int getTxColocatedCid(Connection gConn, int tid, int txId) {
        int cid = -1;
        if (byTidList) {
            cid = this.getCidByList(gConn, tid);
        } else if (byCidRange) {
            Object txIdCid = SQLBB.getBB().getSharedMap().get((Object)(cid_txId + txId));
            cid = GFXDTxHelper.getColocatedCid(TradeCustomersDMLTxStmt.getTableName(), (Integer)txIdCid);
        }
        return cid;
    }

    protected int getCidByList(Connection conn, int tid) {
        String sql = "select * from trade.customers where tid = ?";
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setInt(1, tid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkGFXDException(conn, se)) {
                return 0;
            }
            SQLHelper.handleSQLException(se);
        }
        return 0;
    }

    @Override
    public void performDerbyTxOps(Connection dConn, Object[] data, ArrayList<SQLException> dExList) {
        boolean success = true;
        try {
            switch ((Integer)data[1]) {
                case 1: {
                    success = this.insertToDerbyTable(dConn, (Integer)data[2], (String)data[3], (Date)data[4], (String)data[5]);
                    break;
                }
                case 2: {
                    success = this.updateToDerbyTableCidRangeTx(dConn, (Integer)data[2], (Integer)data[3], (String)data[4], (Date)data[5], (String)data[6], (Integer)data[7]);
                    break;
                }
                case 3: {
                    success = this.updateToDerbyTableTidListTx(dConn, (Integer)data[2], (Integer)data[3], (String)data[4], (Date)data[5], (String)data[6], (Integer)data[7], (Integer)data[8]);
                    break;
                }
                case 4: {
                    success = this.deleteToDerbyTableCidRangeTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4]);
                    break;
                }
                case 5: {
                    success = this.deleteToDerbyTableTidListTx(dConn, (Integer)data[2], (String)data[3], (Integer)data[4], (Integer)data[5]);
                    break;
                }
                default: {
                    throw new TestException("wrong derby tx ops");
                }
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            dExList.add(se);
            return;
        }
        if (!success) {
            throw new TestException("Only one thread performing derby ops, should not fail");
        }
        dExList.add(null);
    }
}

