/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlTxStatements;

import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import sql.SQLBB;
import sql.SQLHelper;
import sql.dmlStatements.TradeNetworthDMLStmt;
import sql.dmlTxStatements.DMLTxStmtIF;
import sql.sqlTx.SQLDerbyTxBB;
import sql.sqlutil.GFXDTxHelper;
import util.TestException;
import util.TestHelper;

public class TradeNetworthDMLTxStmt
extends TradeNetworthDMLStmt
implements DMLTxStmtIF {
    String[] updateByCidRange = new String[]{"update trade.networth set availloan=availloan-? where cid = ? ", "update trade.networth set securities=? where cid = ?  ", "update trade.networth set cash=cash-? where cid = ? ", "update trade.networth set loanLimit=? where cid>? and cid < ? "};
    int updateByCidRangeSingleRowStmt = 3;
    String[] updateByTidList = new String[]{"update trade.networth set availloan=availloan-? where cid = ? and tid= ?", "update trade.networth set securities=? where cid = ?  and tid= ?", "update trade.networth set cash=cash-? where cid = ? and tid= ?", "update trade.networth set loanLimit=? where securities > ? and tid = ?"};
    int updateByTidListSingleRowStmt = 3;
    String[] deleteByCidRange = new String[]{"delete from trade.networth where cid=?", "delete from trade.networth where cid > ? and cid < ? "};
    int deleteByCidRangeSingleRowStmt = 1;
    String[] deleteByTidList = new String[]{"delete from trade.networth where cid=? and tid=? ", "delete from trade.networth where (cid > ? and cid < ? ) and tid = ?"};
    int deleteByTidListSingleRowStmt = 1;
    public static final int insertToDerbyTable = 1;
    public static final int updateToDerbyTableCidRangeTx = 2;
    public static final int updateToDerbyTableTidListTx = 3;
    public static final int deleteToDerbyTableCidRangeTx = 4;
    public static final int deleteToDerbyTableTidListTx = 5;

    @Override
    public void deleteTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        boolean opFailed;
        int cid2;
        int cid;
        int tid;
        int txId;
        int whichDelete;
        HashMap<String, Integer> keys;
        block18: {
            keys = new HashMap<String, Integer>();
            whichDelete = this.getWhichTxDelete();
            txId = modifiedKeys.get(thisTxId);
            tid = this.getTxColocatedTid();
            cid = this.getTxColocatedCid(gConn, tid, txId);
            cid2 = cid + cidRangeForTxOp - 1;
            opFailed = false;
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeDelete(gConn, keys, whichDelete, cid, cid2, txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.deleteToGFXDTableCidRangeTx(gConn, cid, cid2, whichDelete);
                    break block18;
                }
                if (!byTidList) break block18;
                try {
                    this.getKeysForTidListDelete(gConn, keys, whichDelete, cid, cid2, tid, txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.deleteToGFXDTableTidListTx(gConn, cid, cid2, whichDelete, tid);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn != null && byCidRange) {
                    if (!GFXDTxHelper.isColocatedCid(TradeNetworthDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().info("got expected non colocated exception, continuing testing");
                        return;
                    }
                    throw new TestException("got unexpected non colocated exception, keys are colocated" + TestHelper.getStackTrace((Throwable)se));
                }
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn == null && byCidRange) {
                    if (GFXDTxHelper.isColocatedCid(TradeNetworthDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().warning("should not get non colocated exception here");
                    }
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
        }
        if (modifiedKeys.size() > 1 && byCidRange && dConn != null && !GFXDTxHelper.isColocatedCid(TradeNetworthDMLTxStmt.getTableName(), txId, cid)) {
            Set<String> modkeys = modifiedKeys.keySet();
            StringBuffer str = new StringBuffer();
            str.append("The inserted cid is " + cid);
            str.append(", it is not colocated with following cid in this tx: \n");
            for (String key : modkeys) {
                if (key.equalsIgnoreCase(thisTxId)) continue;
                str.append(key + ",\t");
            }
            throw new TestException("Did not get the expected non colocated exception\n" + str.toString());
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.putAll(keys);
        }
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{4, 4, cid, cid2, whichDelete};
            } else if (byTidList) {
                data = new Object[]{4, 5, cid, cid2, whichDelete, tid};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    public void insertTx(Connection dConn, Connection gConn, int size) {
    }

    @Override
    public void populateTx(Connection dConn, Connection gConn) {
    }

    @Override
    public void queryTx(Connection dConn, Connection gConn) {
    }

    @Override
    public void updateTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        int cid2;
        boolean opFailed;
        int txId;
        int tid;
        int whichUpdate;
        HashMap<String, Integer> keys;
        int[] newLoanLimit;
        BigDecimal[] cashDelta;
        BigDecimal[] sec;
        BigDecimal[] availLoanDelta;
        int[] cid;
        block19: {
            int size = 1;
            int[] ignore = new int[size];
            cid = new int[size];
            availLoanDelta = new BigDecimal[size];
            sec = new BigDecimal[size];
            cashDelta = new BigDecimal[size];
            newLoanLimit = new int[size];
            this.getDataForUpdate(gConn, cid, availLoanDelta, sec, cashDelta, newLoanLimit, ignore, size);
            keys = new HashMap<String, Integer>();
            whichUpdate = this.getWhichTxUpdate();
            tid = -1;
            txId = modifiedKeys.get(thisTxId);
            opFailed = false;
            if (byTidList) {
                tid = GFXDTxHelper.getColocatedTid(TradeNetworthDMLTxStmt.getTableName(), TradeNetworthDMLTxStmt.getMyTid());
                cid[0] = this.getCidByList(gConn, tid);
            }
            if (byCidRange) {
                Object txIdCid = SQLBB.getBB().getSharedMap().get((Object)(cid_txId + txId));
                cid[0] = GFXDTxHelper.getColocatedCid(TradeNetworthDMLTxStmt.getTableName(), (Integer)txIdCid);
            }
            cid2 = cid[0] + cidRangeForTxOp;
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeUpdate(gConn, keys, whichUpdate, cid[0], cid2, txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.updateToGFXDTableCidRangeTx(gConn, cid[0], cid2, availLoanDelta[0], sec[0], cashDelta[0], newLoanLimit[0], whichUpdate);
                    break block19;
                }
                if (!byTidList) break block19;
                try {
                    this.getKeysForTidListUpdate(gConn, keys, whichUpdate, cid[0], sec[0], tid, txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.updateToGFXDTableTidListTx(gConn, cid[0], availLoanDelta[0], sec[0], cashDelta[0], newLoanLimit[0], tid, whichUpdate);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn != null && byCidRange) {
                    if (!GFXDTxHelper.isColocatedCid(TradeNetworthDMLTxStmt.getTableName(), txId, cid[0])) {
                        Log.getLogWriter().info("got expected non colocated exception, continuing testing");
                        return;
                    }
                    throw new TestException("got unexpected non colocated exception, keys are colocated" + TestHelper.getStackTrace((Throwable)se));
                }
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn == null && byCidRange) {
                    if (GFXDTxHelper.isColocatedCid(TradeNetworthDMLTxStmt.getTableName(), txId, cid[0])) {
                        Log.getLogWriter().warning("should not get non colocated exception here");
                    }
                    return;
                }
                if (se.getSQLState().equalsIgnoreCase("23513")) {
                    opFailed = true;
                    sExList.add(se);
                }
                SQLHelper.handleSQLException(se);
            }
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.putAll(keys);
        }
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{4, 2, cid[0], cid2, availLoanDelta[0], sec[0], cashDelta[0], newLoanLimit[0], whichUpdate};
            } else if (byTidList) {
                data = new Object[]{4, 3, cid[0], availLoanDelta[0], sec[0], cashDelta[0], newLoanLimit[0], tid, whichUpdate};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    protected void updateToGFXDTableCidRangeTx(Connection conn, int cid, int cid2, BigDecimal availLoanDelta, BigDecimal sec, BigDecimal cashDelta, int newLoanLimit, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int tid = TradeNetworthDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("update networth table in gemfirexd, myTid is " + tid);
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        count = this.updateToTableCidRangeTx(stmt, cid, cid2, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableCidRangeTx(Connection conn, int cid, int cid2, BigDecimal availLoanDelta, BigDecimal sec, BigDecimal cashDelta, int newLoanLimit, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int tid = TradeNetworthDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("update networth table in derby, myTid is " + tid);
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        try {
            count = this.updateToTableCidRangeTx(stmt, cid, cid2, availLoanDelta, sec, cashDelta, newLoanLimit, whichUpdate);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected void updateToGFXDTableTidListTx(Connection conn, int cid, BigDecimal availLoanDelta, BigDecimal sec, BigDecimal cashDelta, int newLoanLimit, int tid, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update networth table in gemfirexd, myTid is " + TradeNetworthDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        count = this.updateToTableTidListTx(stmt, cid, availLoanDelta, sec, cashDelta, newLoanLimit, tid, whichUpdate);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableTidListTx(Connection conn, int cid, BigDecimal availLoanDelta, BigDecimal sec, BigDecimal cashDelta, int newLoanLimit, int tid, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update networth table in derby, myTid is " + TradeNetworthDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        try {
            count = this.updateToTableTidListTx(stmt, cid, availLoanDelta, sec, cashDelta, newLoanLimit, tid, whichUpdate);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected int updateToTableCidRangeTx(PreparedStatement stmt, int cid, int cid2, BigDecimal availLoanDelta, BigDecimal sec, BigDecimal cashDelta, int newLoanLimit, int whichUpdate) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating networth table availLoan to (availLoan- " + availLoanDelta + ") for cid: " + cid);
                stmt.setBigDecimal(1, availLoanDelta);
                stmt.setInt(2, cid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating networth table securities to " + sec + " for cid: " + cid);
                stmt.setBigDecimal(1, sec);
                stmt.setInt(2, cid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating networth table cash to (cash- " + cashDelta + ") for cid: " + cid);
                stmt.setBigDecimal(1, cashDelta);
                stmt.setInt(2, cid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info("updating networth table newLoanLimit with " + newLoanLimit + ", for cid: " + cid + " to " + cid2);
                stmt.setInt(1, newLoanLimit);
                stmt.setInt(2, cid);
                stmt.setInt(3, cid2);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int updateToTableTidListTx(PreparedStatement stmt, int cid, BigDecimal availLoanDelta, BigDecimal sec, BigDecimal cashDelta, int newLoanLimit, int tid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating networth table availLoan to (availLoan- " + availLoanDelta + ") for cid: " + cid + " tid: " + tid);
                stmt.setBigDecimal(1, availLoanDelta);
                stmt.setInt(2, cid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating networth table securities = " + sec + " for cid: " + cid + " tid: " + tid);
                stmt.setBigDecimal(1, sec);
                stmt.setInt(2, cid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating networth table cash to (cash- " + cashDelta + ") for cid: " + cid + " tid: " + tid);
                stmt.setBigDecimal(1, cashDelta);
                stmt.setInt(2, cid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info("updating networth table newLoanLimit with " + newLoanLimit + " for securities is more than " + sec + " and tid: " + tid);
                stmt.setInt(1, newLoanLimit);
                stmt.setBigDecimal(2, sec);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int getWhichTxUpdate() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.updateByCidRange.length);
        }
        if (byCidRange && singleRowTx) {
            return rand.nextInt(this.updateByCidRangeSingleRowStmt);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.updateByTidList.length);
        }
        if (byTidList && singleRowTx) {
            return rand.nextInt(this.updateByTidListSingleRowStmt);
        }
        return -1;
    }

    protected int getWhichTxDelete() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.deleteByCidRange.length);
        }
        if (byCidRange && singleRowTx) {
            return rand.nextInt(this.deleteByCidRangeSingleRowStmt);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.deleteByTidList.length);
        }
        if (byTidList && singleRowTx) {
            return rand.nextInt(this.deleteByTidListSingleRowStmt);
        }
        return -1;
    }

    protected void getKeysForCidRangeDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int cid, int cid2, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select cid from trade.networth where cid=" + cid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " exists for update");
                    keys.put(TradeNetworthDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select cid from trade.networth where cid>" + cid + " and cid<" + cid2;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info("cid: " + availCid + " exists for update");
                    keys.put(TradeNetworthDMLTxStmt.getTableName() + "_" + availCid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void getKeysForTidListDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int cid, int cid2, int tid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select cid from trade.networth where cid=" + cid + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " exists for update");
                    keys.put(TradeNetworthDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select cid from trade.networth where (cid>" + cid + " and cid<" + cid2 + ") and tid = " + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info("cid: " + availCid + " exists for update");
                    keys.put(TradeNetworthDMLTxStmt.getTableName() + "_" + availCid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected boolean deleteToDerbyTableCidRangeTx(Connection conn, int cid, int cid2, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradeNetworthDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete networth table in derby, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        try {
            count = this.deleteToTableCidRangeTx(stmt, cid, cid2, whichDelete);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected void deleteToGFXDTableCidRangeTx(Connection conn, int cid, int cid2, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradeNetworthDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete networth table in gemfirexd, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        count = this.deleteToTableCidRangeTx(stmt, cid, cid2, whichDelete);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected int deleteToTableCidRangeTx(PreparedStatement stmt, int cid, int cid2, int whichDelete) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("delete from networth for cid: " + cid);
                stmt.setInt(1, cid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("delete from networth for cid> " + cid + " and cid< " + cid2);
                stmt.setInt(1, cid);
                stmt.setInt(2, cid2);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong delete sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void deleteToGFXDTableTidListTx(Connection conn, int cid, int cid2, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete networth table in gemfirexd, myTid is " + TradeNetworthDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        count = this.deleteToTableTidListTx(stmt, cid, cid2, whichDelete, tid);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected boolean deleteToDerbyTableTidListTx(Connection conn, int cid, int cid2, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete networth table in derby, myTid is " + TradeNetworthDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        try {
            count = this.deleteToTableTidListTx(stmt, cid, cid2, whichDelete, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected int deleteToTableTidListTx(PreparedStatement stmt, int cid, int cid2, int whichDelete, int tid) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("delete from networth for cid: " + cid + " and tid: " + tid);
                stmt.setInt(1, cid);
                stmt.setInt(2, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("delete from networth for cid>" + cid + " and " + "cid< " + cid2 + " and tid: " + tid);
                stmt.setInt(1, cid);
                stmt.setInt(2, cid2);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong delete sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int getCidByList(Connection conn, int tid) {
        String sql = "select cid from trade.networth where tid = ?";
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setInt(1, tid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkGFXDException(conn, se)) {
                return 0;
            }
            SQLHelper.handleSQLException(se);
        }
        return 0;
    }

    protected void getKeysForCidRangeUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, int cid2, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: 
            case 1: 
            case 2: {
                sql = "select cid from trade.networth where cid=" + cid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " exists for update");
                    keys.put(TradeNetworthDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 3: {
                sql = "select cid from trade.networth where cid>" + cid + " and cid<" + cid2;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info("cid: " + availCid + " exists for update");
                    keys.put(TradeNetworthDMLTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void getKeysForTidListUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, BigDecimal securities, int tid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: 
            case 1: 
            case 2: {
                sql = "select cid from trade.networth where cid=" + cid + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " exists for update");
                    keys.put(TradeNetworthDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 3: {
                sql = "select cid from trade.networth where securities>" + securities + " and tid = " + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt(1);
                    Log.getLogWriter().info("cid: " + availCid + " exists for update");
                    keys.put(TradeNetworthDMLTxStmt.getTableName() + "_" + availCid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size, int[] cid) {
        BigDecimal[] cash = new BigDecimal[size];
        int[] loanLimit = new int[size];
        BigDecimal[] availLoan = new BigDecimal[size];
        this.getDataForInsert(cash, loanLimit, availLoan, size);
        BigDecimal securities = new BigDecimal(Integer.toString(0));
        SQLException derbySe = null;
        SQLException gfxdSe = null;
        if (dConn != null) {
            for (int i = 0; i < cid.length; ++i) {
                try {
                    this.insertToGFXDTable(gConn, cid[i], cash[i], securities, loanLimit[i], availLoan[i]);
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    gfxdSe = se;
                }
                try {
                    boolean success = this.insertToDerbyTable(dConn, cid[i], cash[i], securities, loanLimit[i], availLoan[i]);
                    int count = 0;
                    while (!success) {
                        if (count >= maxNumOfTries) {
                            Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                            gConn.rollback();
                            dConn.rollback();
                            break;
                        }
                        success = this.insertToDerbyTable(dConn, cid[i], cash[i], securities, loanLimit[i], availLoan[i]);
                        ++count;
                    }
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    derbySe = se;
                }
                SQLHelper.compareExceptions(derbySe, gfxdSe);
                derbySe = null;
                gfxdSe = null;
                try {
                    gConn.commit();
                    Log.getLogWriter().info("gfxd committed the operation");
                    dConn.commit();
                    Log.getLogWriter().info("derby committed the operation");
                    continue;
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
            }
        } else {
            for (int i = 0; i < cid.length; ++i) {
                try {
                    this.insertToGFXDTable(gConn, cid[i], cash[i], securities, loanLimit[i], availLoan[i]);
                }
                catch (SQLException se) {
                    Log.getLogWriter().info("inserting to networth using tx failed");
                    SQLHelper.handleSQLException(se);
                }
                try {
                    gConn.commit();
                    continue;
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
            }
        }
    }

    protected void insertToGFXDTable(Connection conn, int cid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan) throws SQLException {
        PreparedStatement stmt = TradeNetworthDMLTxStmt.getStmt(conn, insert);
        int tid = TradeNetworthDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        count = this.insertToTable(stmt, cid, cash, securities, loanLimit, availLoan, tid);
        Log.getLogWriter().info("gfxd inserts " + count + " record");
    }

    protected boolean insertToDerbyTable(Connection conn, int cid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan) throws SQLException {
        PreparedStatement stmt = TradeNetworthDMLTxStmt.getStmt(conn, insert);
        int tid = TradeNetworthDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into derby, myTid is " + tid);
        try {
            count = this.insertToTable(stmt, cid, cash, securities, loanLimit, availLoan, tid);
            Log.getLogWriter().info("derby inserts " + count + " record");
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            throw se;
        }
        return true;
    }

    @Override
    public void insertTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
    }

    public void insertTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList, int cid) {
        int size = 1;
        BigDecimal[] cash = new BigDecimal[size];
        int[] loanLimit = new int[size];
        BigDecimal[] availLoan = new BigDecimal[size];
        this.getDataForInsert(cash, loanLimit, availLoan, size);
        BigDecimal securities = new BigDecimal(Integer.toString(0));
        try {
            this.insertToGFXDTable(gConn, cid, cash[0], securities, loanLimit[0], availLoan[0]);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            sExList.add(se);
        }
        int txId = modifiedKeys.get(thisTxId);
        sExList.add(null);
        modifiedKeys.put(TradeNetworthDMLTxStmt.getTableName() + "_" + cid, txId);
        if (dConn != null) {
            Object[] data = new Object[]{4, 1, cid, cash[0], securities, loanLimit[0], availLoan[0]};
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    public static String getTableName() {
        return "networth";
    }

    @Override
    public String getMyTableName() {
        return TradeNetworthDMLTxStmt.getTableName();
    }

    protected int getTxColocatedTid() {
        int tid = -1;
        if (byTidList) {
            tid = GFXDTxHelper.getColocatedTid(TradeNetworthDMLTxStmt.getTableName(), TradeNetworthDMLTxStmt.getMyTid());
        }
        return tid;
    }

    protected int getTxColocatedCid(Connection gConn, int tid, int txId) {
        int cid = -1;
        if (byTidList) {
            cid = this.getCidByList(gConn, tid);
        } else if (byCidRange) {
            Object txIdCid = SQLBB.getBB().getSharedMap().get((Object)(cid_txId + txId));
            cid = GFXDTxHelper.getColocatedCid(TradeNetworthDMLTxStmt.getTableName(), (Integer)txIdCid);
        }
        return cid;
    }

    @Override
    public void performDerbyTxOps(Connection dConn, Object[] data, ArrayList<SQLException> dExList) {
        boolean success = true;
        try {
            switch ((Integer)data[1]) {
                case 1: {
                    success = this.insertToDerbyTable(dConn, (Integer)data[2], (BigDecimal)data[3], (BigDecimal)data[4], (Integer)data[5], (BigDecimal)data[6]);
                    break;
                }
                case 2: {
                    success = this.updateToDerbyTableCidRangeTx(dConn, (Integer)data[2], (Integer)data[3], (BigDecimal)data[4], (BigDecimal)data[5], (BigDecimal)data[6], (Integer)data[7], (Integer)data[8]);
                    break;
                }
                case 3: {
                    success = this.updateToDerbyTableTidListTx(dConn, (Integer)data[2], (BigDecimal)data[3], (BigDecimal)data[4], (BigDecimal)data[5], (Integer)data[6], (Integer)data[7], (Integer)data[8]);
                    break;
                }
                case 4: {
                    success = this.deleteToDerbyTableCidRangeTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4]);
                    break;
                }
                case 5: {
                    success = this.deleteToDerbyTableTidListTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (Integer)data[5]);
                    break;
                }
                default: {
                    throw new TestException("wrong derby tx ops");
                }
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            dExList.add(se);
            return;
        }
        if (!success) {
            throw new TestException("Only one thread performing derby ops, should not fail");
        }
        dExList.add(null);
    }
}

