/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlTxStatements;

import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import sql.SQLBB;
import sql.SQLHelper;
import sql.dmlStatements.TradePortfolioDMLStmt;
import sql.dmlTxStatements.DMLTxStmtIF;
import sql.sqlTx.SQLDerbyTxBB;
import sql.sqlutil.GFXDTxHelper;
import util.TestException;
import util.TestHelper;

public class TradePortfolioDMLTxStmt
extends TradePortfolioDMLStmt
implements DMLTxStmtIF {
    String[] updateByCidRange = new String[]{"update trade.portfolio set availQty=availQty-100 where cid = ? and sid = ? ", "update trade.portfolio set qty=qty-? where cid = ? and sid = ? ", "update trade.portfolio set tid = ?  where cid = ? and sid = ? ", "update trade.portfolio set subTotal = ? * qty  where cid>=? and cid <? and sid = ? "};
    int updateByCidRangeSingleRowStmt = 3;
    String[] updateByTidList = new String[]{"update trade.portfolio set availQty=availQty-100 where cid = ? and sid = ?  and tid= ?", "update trade.portfolio set qty=qty-? where cid = ? and sid = ?  and tid= ?", "update trade.portfolio set subTotal = ? * qty  where sid = ?  and tid= ?"};
    int updateByTidListSingleRowStmt = 2;
    String[] deleteByCidRange = new String[]{"delete from trade.portfolio where cid=? and sid=?", "delete from trade.portfolio where qty < 100"};
    int deleteByCidRangeSingleRowStmt = 1;
    String[] deleteByTidList = new String[]{"delete from trade.portfolio where cid=? and sid=? and tid=?", "delete from trade.portfolio where qty <100 and tid=?"};
    int deleteByTidListSingleRowStmt = 1;
    public static final int insertToDerbyTable = 1;
    public static final int updateToDerbyTableCidRangeTx = 2;
    public static final int updateToDerbyTableTidListTx = 3;
    public static final int deleteToDerbyTableCidRangeTx = 4;
    public static final int deleteToDerbyTableTidListTx = 5;

    @Override
    public void deleteTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        boolean opFailed;
        int whichDelete;
        int txId;
        HashMap<String, Integer> keys;
        int[] tid;
        int[] sid;
        int[] cid;
        block16: {
            int size = 1;
            cid = new int[size];
            sid = new int[size];
            tid = new int[size];
            keys = new HashMap<String, Integer>();
            txId = modifiedKeys.get(thisTxId);
            whichDelete = this.getWhichTxDelete();
            this.getCidAndTid(gConn, txId, cid, tid);
            try {
                sid[0] = this.getSid(gConn, cid[0]);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            opFailed = false;
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeDelete(gConn, keys, whichDelete, cid[0], sid[0], txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.deleteToGFXDTableCidRangeTx(gConn, cid[0], sid[0], whichDelete);
                    break block16;
                }
                if (!byTidList) break block16;
                try {
                    this.getKeysForTidListDelete(gConn, keys, whichDelete, cid[0], sid[0], tid[0], txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.deleteToGFXDTableTidListTx(gConn, cid[0], sid[0], whichDelete, tid[0]);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn != null && byCidRange) {
                    if (!GFXDTxHelper.isColocatedCid(TradePortfolioDMLTxStmt.getTableName(), txId, cid[0])) {
                        Log.getLogWriter().info("got expected non colocated exception, continuing testing");
                        return;
                    }
                    throw new TestException("got unexpected non colocated exception, keys are colocated\n" + TestHelper.getStackTrace((Throwable)se));
                }
                opFailed = true;
                sExList.add(se);
            }
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.putAll(keys);
        }
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{3, 4, cid[0], sid[0], whichDelete};
            } else if (byTidList) {
                data = new Object[]{3, 5, cid[0], sid[0], whichDelete, tid[0]};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    protected void getKeysForCidRangeDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int cid, int sid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select cid, sid from trade.portfolio where cid=" + cid + " and sid=" + sid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " and sid: " + sid + " exists for update");
                    keys.put(TradePortfolioDMLTxStmt.getTableName() + "_" + rs.getInt("CID") + "_" + rs.getInt("SID"), txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select cid, sid from trade.portfolio where qty<100";
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt("CID");
                    int availSid = rs.getInt("SID");
                    Log.getLogWriter().info("cid: " + availCid + " and sid: " + availSid + " exists for update");
                    keys.put(TradePortfolioDMLTxStmt.getTableName() + "_" + availCid + "_" + availSid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void deleteToGFXDTableCidRangeTx(Connection conn, int cid, int sid, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradePortfolioDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete portfolio table in gemfirexd, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        count = this.deleteToTableCidRangeTx(stmt, cid, sid, whichDelete);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected int deleteToTableCidRangeTx(PreparedStatement stmt, int cid, int sid, int whichDelete) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("delete from portfolio for cid: " + cid + " and sid: " + sid);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("delete from portfolio for qty <100 ");
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong delete sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected boolean deleteToDerbyTableCidRangeTx(Connection conn, int cid, int sid, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradePortfolioDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete porfolio table in derby, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        try {
            count = this.deleteToTableCidRangeTx(stmt, cid, sid, whichDelete);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected void getKeysForTidListDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int cid, int sid, int tid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select cid, sid from trade.portfolio where cid=" + cid + " and sid=" + sid + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " and sid: " + sid + " exists for update");
                    keys.put(TradePortfolioDMLTxStmt.getTableName() + "_" + rs.getInt("CID") + "_" + rs.getInt("SID"), txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select cid, sid from trade.portfolio where qty<100 and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt("CID");
                    int availSid = rs.getInt("SID");
                    Log.getLogWriter().info("cid: " + availCid + " and sid: " + availSid + " exists for update");
                    keys.put(TradePortfolioDMLTxStmt.getTableName() + "_" + availCid + "_" + availSid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void deleteToGFXDTableTidListTx(Connection conn, int cid, int sid, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete portfolio table in gemfirexd, myTid is " + TradePortfolioDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        count = this.deleteToTableTidListTx(stmt, cid, sid, whichDelete, tid);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected boolean deleteToDerbyTableTidListTx(Connection conn, int cid, int sid, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete portfolio table in derby, myTid is " + TradePortfolioDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        try {
            count = this.deleteToTableTidListTx(stmt, cid, sid, whichDelete, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected int deleteToTableTidListTx(PreparedStatement stmt, int cid, int sid, int whichDelete, int tid) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("delete from portfolio for cid: " + cid + " and sid: " + sid + " and tid: " + tid);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("delete from portfolio for qty<100 and tid: " + tid);
                stmt.setInt(1, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong delete sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    @Override
    public String getMyTableName() {
        return TradePortfolioDMLTxStmt.getTableName();
    }

    public static String getTableName() {
        return "portfolio";
    }

    @Override
    public void insertTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        int size = 1;
        int[] cid = new int[size];
        int[] sid = new int[size];
        int[] qty = new int[size];
        int[] tid = new int[size];
        BigDecimal[] sub = new BigDecimal[size];
        this.getDataForInsert(gConn, sid, qty, sub, size);
        int txId = modifiedKeys.get(thisTxId);
        this.getCidAndTid(gConn, txId, cid, tid);
        boolean opFailed = false;
        try {
            this.insertToGFXDTable(gConn, cid[0], sid[0], qty[0], sub[0]);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z04")) {
                throw new TestException("got unexpected non colocated exception, keys are colocated" + TestHelper.getStackTrace((Throwable)se));
            }
            opFailed = true;
            sExList.add(se);
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.put(TradePortfolioDMLTxStmt.getTableName() + "_" + cid[0] + "_" + sid[0], txId);
        }
        if (dConn != null) {
            Object[] data = new Object[]{3, 1, cid[0], sid[0], qty[0], sub[0]};
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        for (int i = 0; i < size; ++i) {
            this.insert(dConn, gConn, size, TradePortfolioDMLTxStmt.getCid());
        }
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size, int cid) {
        int[] sid = new int[size];
        int[] qty = new int[size];
        BigDecimal[] sub = new BigDecimal[size];
        boolean success = false;
        this.getDataForInsert(gConn, sid, qty, sub, size);
        SQLException derbySe = null;
        SQLException gfxdSe = null;
        if (dConn != null) {
            for (int i = 0; i < size; ++i) {
                block32: {
                    try {
                        this.insertToGFXDTable(gConn, cid, sid[i], qty[i], sub[i]);
                    }
                    catch (SQLException se) {
                        SQLHelper.printSQLException(se);
                        gfxdSe = se;
                    }
                    try {
                        success = this.insertToDerbyTable(dConn, cid, sid[i], qty[i], sub[i]);
                        int count = 0;
                        while (!success) {
                            if (count >= maxNumOfTries) {
                                Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                                gConn.rollback();
                                dConn.rollback();
                                break;
                            }
                            success = this.insertToDerbyTable(dConn, cid, sid[i], qty[i], sub[i]);
                            ++count;
                        }
                    }
                    catch (SQLException se) {
                        SQLHelper.printSQLException(se);
                        derbySe = se;
                    }
                    try {
                        try {
                            gConn.commit();
                            Log.getLogWriter().info("gfxd committed the operation");
                            dConn.commit();
                            Log.getLogWriter().info("derby committed the operation");
                        }
                        catch (SQLException se) {
                            SQLHelper.printSQLException(se);
                            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                                Log.getLogWriter().info("get commit conflict exception, roll back the operation");
                                dConn.rollback();
                                derbySe = null;
                                gfxdSe = null;
                                continue;
                            }
                            if (se.getSQLState().equals("X0Z05")) {
                                if (derbySe != null && SQLHelper.isSameRootSQLException(derbySe.getSQLState(), se)) {
                                    if (derbySe.getSQLState().equals("23505")) {
                                        Log.getLogWriter().warning("got duplicate primary key exception and masked as in doubt transaction exception -- primary key should be checked at operation time ");
                                    } else if (derbySe.getSQLState().equals("23503")) {
                                        Log.getLogWriter().warning("got foreign key check violation and masked as in doubt transaction exception -- which is bug# 41898 ");
                                    }
                                    derbySe = null;
                                    gfxdSe = null;
                                    continue;
                                }
                                break block32;
                            }
                            SQLHelper.handleSQLException(se);
                        }
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                }
                SQLHelper.compareExceptions(derbySe, gfxdSe);
                derbySe = null;
                gfxdSe = null;
            }
            try {
                dConn.commit();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        } else {
            try {
                this.insertToGFXDTable(gConn, cid, sid, qty, sub, size);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("23505")) {
                    Log.getLogWriter().info("got expected gfxd duplicate primary key exception, continue testing");
                }
                SQLHelper.handleSQLException(se);
            }
            try {
                gConn.commit();
                Log.getLogWriter().info("gfxd committed the operation");
            }
            catch (SQLException se) {
                if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                    Log.getLogWriter().info("got expected gfxd commit conflict exception, continue testing");
                }
                if (se.getSQLState().equals("X0Z05")) {
                    if (SQLHelper.isSameRootSQLException("23505", se)) {
                        Log.getLogWriter().warning("got duplicate primary key exception and masked as in doubt transaction exception -- primary key should be checked at operation time ");
                    } else if (SQLHelper.isSameRootSQLException("23503", se)) {
                        Log.getLogWriter().warning("got foreign key check violation and masked as in doubt transaction exception -- which is bug# 41898 ");
                    }
                }
                SQLHelper.handleSQLException(se);
            }
        }
    }

    protected void insertToGFXDTable(Connection conn, int cid, int sid, int qty, BigDecimal sub) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        int tid = TradePortfolioDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        count = this.insertToTable(stmt, cid, sid, qty, sub, tid);
        Log.getLogWriter().info("gfxd inserts " + count + " record");
    }

    protected void insertToGFXDTable(Connection gConn, int cid, int[] sid, int[] qty, BigDecimal[] sub, int size) throws SQLException {
        PreparedStatement stmt = gConn.prepareStatement(insert);
        int tid = TradePortfolioDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        for (int i = 0; i < size; ++i) {
            count = this.insertToTable(stmt, cid, sid[i], qty[i], sub[i], tid);
            Log.getLogWriter().info("gfxd inserts " + count + " record");
        }
    }

    protected boolean insertToDerbyTable(Connection conn, int cid, int sid, int qty, BigDecimal sub) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(insert);
        int tid = TradePortfolioDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into derby, myTid is " + tid);
        try {
            count = this.insertToTable(stmt, cid, sid, qty, sub, tid);
            Log.getLogWriter().info("derby inserts " + count + " record");
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            throw se;
        }
        return true;
    }

    protected void getDataForInsert(Connection gConn, int[] sid, int[] qty, BigDecimal[] sub, int size) {
        try {
            for (int i = 0; i < size; ++i) {
                sid[i] = this.getSid();
                qty[i] = this.getQty();
                sub[i] = this.getPrice(gConn, sid[i]).multiply(new BigDecimal(String.valueOf(qty[i])));
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BigDecimal getPrice(Connection gConn, int sid) throws SQLException {
        try (ResultSet rs = null;){
            String sql = "select price from trade.securities where sec_id = " + sid;
            rs = gConn.createStatement().executeQuery(sql);
            if (rs != null && rs.next()) {
                BigDecimal price;
                BigDecimal bigDecimal = price = rs.getBigDecimal("price");
                return bigDecimal;
            }
        }
        return new BigDecimal(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSid(Connection gConn, int cid) throws SQLException {
        int sid = 0;
        try (ResultSet rs = null;){
            String sql = "select sid from trade.portfolio where cid = " + cid;
            rs = gConn.createStatement().executeQuery(sql);
            int count = 0;
            int whichOne = rand.nextInt(10);
            if (rs != null && rs.next()) {
                sid = rs.getInt(1);
                if (count == whichOne) {
                    int n = sid;
                    return n;
                }
                ++count;
            }
        }
        return sid;
    }

    @Override
    public void populateTx(Connection dConn, Connection gConn) {
        int size = 10;
        this.populateTx(dConn, gConn, size);
    }

    public void populateTx(Connection dConn, Connection gConn, int initSize) {
        this.insert(dConn, gConn, initSize);
    }

    @Override
    public void queryTx(Connection dConn, Connection gConn) {
    }

    @Override
    public void updateTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        boolean opFailed;
        int largeCid;
        int smallCid;
        int qty;
        HashMap<String, Integer> keys;
        int whichUpdate;
        BigDecimal price;
        int sid;
        int tid;
        int cid;
        int txId;
        block20: {
            txId = modifiedKeys.get(thisTxId);
            int[] cids = new int[1];
            int[] tids = new int[1];
            this.getCidAndTid(gConn, txId, cids, tids);
            cid = cids[0];
            tid = tids[0];
            sid = 0;
            price = null;
            whichUpdate = this.getWhichTxUpdate();
            try {
                sid = this.getSid(gConn, cid);
                price = this.getPrice(gConn, sid);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
            keys = new HashMap<String, Integer>();
            qty = this.getQty();
            smallCid = 0;
            largeCid = 0;
            if (byCidRange) {
                smallCid = GFXDTxHelper.getRangeEnds(TradePortfolioDMLTxStmt.getTableName(), cid)[0];
                largeCid = GFXDTxHelper.getRangeEnds(TradePortfolioDMLTxStmt.getTableName(), cid)[1];
            }
            opFailed = false;
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeUpdate(gConn, keys, whichUpdate, cid, sid, price, smallCid, largeCid, txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.updateToGFXDTableCidRangeTx(gConn, cid, sid, price, qty, smallCid, largeCid, whichUpdate);
                    break block20;
                }
                if (!byTidList) break block20;
                try {
                    this.getKeysForTidListUpdate(gConn, keys, whichUpdate, cid, sid, price, tid, txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.updateToGFXDTableTidListTx(gConn, cid, sid, price, qty, whichUpdate, tid);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn != null && byCidRange) {
                    if (!GFXDTxHelper.isColocatedCid(TradePortfolioDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().info("got expected non colocated exception, continuing testing");
                        return;
                    }
                    throw new TestException("got unexpected non colocated exception, keys are colocated" + TestHelper.getStackTrace((Throwable)se));
                }
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn == null && byCidRange) {
                    if (GFXDTxHelper.isColocatedCid(TradePortfolioDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().warning("should not get non colocated exception here");
                    }
                    return;
                }
                if (se.getSQLState().equalsIgnoreCase("23513")) {
                    opFailed = true;
                    sExList.add(se);
                }
                SQLHelper.handleSQLException(se);
            }
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.putAll(keys);
        }
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{3, 2, cid, sid, price, qty, smallCid, largeCid, whichUpdate};
            } else if (byTidList) {
                data = new Object[]{3, 3, cid, sid, price, qty, whichUpdate, tid};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    protected int getWhichTxUpdate() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.updateByCidRange.length);
        }
        if (byCidRange && singleRowTx) {
            return rand.nextInt(this.updateByCidRangeSingleRowStmt);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.updateByTidList.length);
        }
        if (byTidList && singleRowTx) {
            return rand.nextInt(this.updateByTidListSingleRowStmt);
        }
        return -1;
    }

    protected int getWhichTxDelete() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.deleteByCidRange.length);
        }
        if (byCidRange && singleRowTx) {
            return rand.nextInt(this.deleteByCidRangeSingleRowStmt);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.deleteByTidList.length);
        }
        if (byTidList && singleRowTx) {
            return rand.nextInt(this.deleteByTidListSingleRowStmt);
        }
        return -1;
    }

    protected int getCidByList(Connection conn, int tid) {
        String sql = "select cid from trade.portfolio where tid = ?";
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setInt(1, tid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkGFXDException(conn, se)) {
                return 0;
            }
            SQLHelper.handleSQLException(se);
        }
        return 0;
    }

    protected void getKeysForCidRangeUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, int sid, BigDecimal price, int smallCid, int largeCid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: 
            case 1: 
            case 2: {
                sql = "select cid, sid from trade.portfolio where cid=" + cid + " and sid=" + sid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " and sid: " + sid + " exists for update");
                    keys.put(TradePortfolioDMLTxStmt.getTableName() + "_" + rs.getInt("CID") + "_" + rs.getInt("SID"), txId);
                }
                rs.close();
                break;
            }
            case 3: {
                sql = "select cid, sid from trade.portfolio where cid>" + smallCid + " and cid<" + largeCid + " and sid=" + sid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt("CID");
                    int availSid = rs.getInt("SID");
                    Log.getLogWriter().info("cid: " + availCid + " and sid: " + availSid + " exists for update");
                    keys.put(TradePortfolioDMLTxStmt.getTableName() + "_" + availCid + "_" + availSid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void getKeysForTidListUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, int sid, BigDecimal price, int tid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: 
            case 1: {
                sql = "select cid, sid from trade.portfolio where cid=" + cid + " and sid=" + sid + " and tid = " + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("cid: " + cid + " and sid: " + sid + " exists for update");
                    keys.put(TradePortfolioDMLTxStmt.getTableName() + "_" + rs.getInt("CID") + "_" + rs.getInt("SID"), txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select cid, sid from trade.portfolio where sid=" + sid + " and tid = " + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availCid = rs.getInt("CID");
                    int availSid = rs.getInt("SID");
                    Log.getLogWriter().info("cid: " + availCid + " and sid: " + availSid + " exists for update");
                    keys.put(TradePortfolioDMLTxStmt.getTableName() + "_" + availCid + "_" + availSid, txId);
                }
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void getCidAndTid(Connection gConn, int txId, int[] cid, int[] tid) {
        if (byTidList) {
            tid[0] = GFXDTxHelper.getColocatedTid(TradePortfolioDMLTxStmt.getTableName(), TradePortfolioDMLTxStmt.getMyTid());
            cid[0] = this.getCidByList(gConn, tid[0]);
        }
        if (byCidRange) {
            Object txIdCid = SQLBB.getBB().getSharedMap().get((Object)(cid_txId + txId));
            cid[0] = GFXDTxHelper.getColocatedCid(TradePortfolioDMLTxStmt.getTableName(), (Integer)txIdCid);
        }
    }

    protected void updateToGFXDTableCidRangeTx(Connection conn, int cid, int sid, BigDecimal price, int qty, int smallCid, int largeCid, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int tid = TradePortfolioDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("update portfolio table in gemfirexd, myTid is " + tid);
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        count = this.updateToTableCidRangeTx(stmt, cid, sid, price, qty, smallCid, largeCid, whichUpdate);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableCidRangeTx(Connection conn, int cid, int sid, BigDecimal price, int qty, int smallCid, int largeCid, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int tid = TradePortfolioDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("update portfolio table in derby, myTid is " + tid);
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        try {
            count = this.updateToTableCidRangeTx(stmt, cid, sid, price, qty, smallCid, largeCid, whichUpdate);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected void updateToGFXDTableTidListTx(Connection conn, int cid, int sid, BigDecimal price, int qty, int whichUpdate, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update portfolio table in gemfirexd, myTid is " + TradePortfolioDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        count = this.updateToTableTidListTx(stmt, cid, sid, price, qty, whichUpdate, tid);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableTidListTx(Connection conn, int cid, int sid, BigDecimal price, int qty, int whichUpdate, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update portfolio table in derby, myTid is " + TradePortfolioDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        try {
            count = this.updateToTableTidListTx(stmt, cid, sid, price, qty, whichUpdate, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected int updateToTableCidRangeTx(PreparedStatement stmt, int cid, int sid, BigDecimal price, int qty, int smallCid, int largeCid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        int tid = TradePortfolioDMLTxStmt.getMyTid();
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating portfolio table availQty to (availQty-100) for cid: " + cid + " and sid: " + sid);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating portfolio to qty - " + qty + " for cid: " + cid + " and sid: " + sid);
                stmt.setInt(1, qty);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating portfolio table tid to " + tid + " for cid: " + cid + " and sid: " + sid);
                stmt.setInt(1, tid);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info("updating portfolio table subTotal to qty * " + price + ", for cid: " + smallCid + " to " + largeCid + " and sid: " + sid);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, smallCid);
                stmt.setInt(3, largeCid);
                stmt.setInt(4, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int updateToTableTidListTx(PreparedStatement stmt, int cid, int sid, BigDecimal price, int qty, int whichUpdate, int tid) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating portfolio table availQty to (availQty-100) for cid: " + cid + " and sid: " + sid + " and tid: " + tid);
                stmt.setInt(1, cid);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating portfolio to qty - " + qty + " for cid: " + cid + " and sid: " + sid + " and tid: " + tid);
                stmt.setInt(1, qty);
                stmt.setInt(2, cid);
                stmt.setInt(3, sid);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating portfolio table subTotal to qty * " + price + ", for sid: " + sid + " and tid: " + tid);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    @Override
    public void performDerbyTxOps(Connection dConn, Object[] data, ArrayList<SQLException> dExList) {
        boolean success = true;
        try {
            switch ((Integer)data[1]) {
                case 1: {
                    success = this.insertToDerbyTable(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (BigDecimal)data[5]);
                    break;
                }
                case 2: {
                    success = this.updateToDerbyTableCidRangeTx(dConn, (Integer)data[2], (Integer)data[3], (BigDecimal)data[4], (Integer)data[5], (Integer)data[6], (Integer)data[7], (Integer)data[8]);
                    break;
                }
                case 3: {
                    success = this.updateToDerbyTableTidListTx(dConn, (Integer)data[2], (Integer)data[3], (BigDecimal)data[4], (Integer)data[5], (Integer)data[6], (Integer)data[7]);
                    break;
                }
                case 4: {
                    success = this.deleteToDerbyTableCidRangeTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4]);
                    break;
                }
                case 5: {
                    success = this.deleteToDerbyTableTidListTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (Integer)data[5]);
                    break;
                }
                default: {
                    throw new TestException("wrong derby tx ops");
                }
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            dExList.add(se);
            return;
        }
        if (!success) {
            throw new TestException("Only one thread performing derby ops, should not fail");
        }
        dExList.add(null);
    }
}

