/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlTxStatements;

import hydra.Log;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.dmlStatements.TradeSecuritiesDMLStmt;
import sql.dmlTxStatements.DMLTxStmtIF;
import sql.sqlTx.SQLDerbyTxBB;
import sql.sqlutil.GFXDTxHelper;
import util.TestException;
import util.TestHelper;

public class TradeSecuritiesDMLTxStmt
extends TradeSecuritiesDMLStmt
implements DMLTxStmtIF {
    String[] updateByCidRange = new String[]{"update trade.securities set price = ? where sec_id = ?  ", "update trade.securities set symbol = ? where sec_id = ? "};
    int updateByCidRangeSingleRowStmt = 2;
    String[] updateByTidList = new String[]{"update trade.securities set price = ? where sec_id = ? and tid = ? ", "update trade.securities set symbol = ? where sec_id = ? and tid = ?", "update trade.securities set price = ? where sec_id > ? and symbol >? and tid = ?  "};
    int updateByTidListSingleRowStmt = 2;
    String[] deleteByCidRange = new String[]{"delete from trade.securities where sec_id = ? ", "delete from trade.securities where symbol= ? and exchange = ? ", "delete from trade.securities where price >? and price <? "};
    int deleteByCidRangeSingleRowStmt = 2;
    String[] deleteByTidList = new String[]{"delete from trade.securities where sec_id = ? and tid = ?", "delete from trade.securities where symbol= ? and exchange = ? and tid = ?", "delete from trade.securities where price >? and price <? and tid =?"};
    int deleteByTidListSingleRowStmt = 2;
    public static final int insertToDerbyTable = 1;
    public static final int updateToDerbyTableCidRangeTx = 2;
    public static final int updateToDerbyTableTidListTx = 3;
    public static final int deleteToDerbyTableCidRangeTx = 4;
    public static final int deleteToDerbyTableTidListTx = 5;

    @Override
    public void deleteTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        boolean opFailed;
        int txId;
        int whichDelete;
        HashMap<String, Integer> keys;
        String exchange;
        String symbol;
        BigDecimal price2;
        BigDecimal price;
        int sid;
        int tid;
        block16: {
            tid = -1;
            sid = -1;
            price = this.getPrice();
            price2 = price.add(new BigDecimal(1));
            symbol = this.getSymbol();
            exchange = this.getExchange();
            keys = new HashMap<String, Integer>();
            whichDelete = this.getWhichTxDelete();
            txId = modifiedKeys.get(thisTxId);
            if (byTidList) {
                tid = GFXDTxHelper.getColocatedTid(TradeSecuritiesDMLTxStmt.getTableName(), TradeSecuritiesDMLTxStmt.getMyTid());
                sid = this.getSidByList(gConn, tid);
            } else if (byCidRange) {
                sid = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary));
            }
            opFailed = false;
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeDelete(gConn, keys, whichDelete, sid, symbol, exchange, price, price2, txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.deleteToGFXDTableCidRangeTx(gConn, sid, symbol, exchange, price, price2, whichDelete);
                    break block16;
                }
                if (!byTidList) break block16;
                try {
                    this.getKeysForTidListDelete(gConn, keys, whichDelete, sid, symbol, exchange, price, price2, tid, txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.deleteToGFXDTableTidListTx(gConn, sid, symbol, exchange, price, price2, whichDelete, tid);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && byCidRange) {
                    throw new TestException("got unexpected non colocated exception: trade.securities is replicate table, all keys are colocated\n" + TestHelper.getStackTrace((Throwable)se));
                }
                opFailed = true;
                sExList.add(se);
            }
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.putAll(keys);
        }
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{2, 4, sid, symbol, exchange, price, price2, whichDelete};
            } else if (byTidList) {
                data = new Object[]{2, 5, sid, symbol, exchange, price, price2, whichDelete, tid};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    @Override
    public void populateTx(Connection dConn, Connection gConn) {
        int initSize = TestConfig.tab().intAt(SQLPrms.initSecuritiesSizePerThread, 100);
        this.populate(dConn, gConn, initSize);
    }

    @Override
    public void queryTx(Connection dConn, Connection gConn) {
    }

    @Override
    public void updateTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        boolean opFailed;
        int sid;
        int whichUpdate;
        int txId;
        int tid;
        HashMap<String, Integer> keys;
        String symbol;
        BigDecimal price;
        block15: {
            price = this.getPrice();
            symbol = this.getSymbol();
            keys = new HashMap<String, Integer>();
            tid = -1;
            txId = modifiedKeys.get(thisTxId);
            whichUpdate = this.getWhichTxUpdate();
            sid = -1;
            opFailed = false;
            if (byTidList) {
                tid = GFXDTxHelper.getColocatedTid(TradeSecuritiesDMLTxStmt.getTableName(), TradeSecuritiesDMLTxStmt.getMyTid());
                sid = this.getSidByList(gConn, tid);
            } else if (byCidRange) {
                sid = rand.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary));
            }
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeUpdate(gConn, keys, whichUpdate, sid, symbol, txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.updateToGFXDTableCidRangeTx(gConn, sid, symbol, price, whichUpdate);
                    break block15;
                }
                if (!byTidList) break block15;
                try {
                    this.getKeysForTidListUpdate(gConn, keys, whichUpdate, sid, symbol, tid, txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.updateToGFXDTableTidListTx(gConn, sid, symbol, price, whichUpdate, tid);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                opFailed = true;
                sExList.add(se);
            }
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.putAll(keys);
        }
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{2, 2, sid, symbol, price, whichUpdate};
            } else if (byTidList) {
                data = new Object[]{2, 3, sid, symbol, price, whichUpdate, tid};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    protected void updateToGFXDTableCidRangeTx(Connection conn, int sid, String symbol, BigDecimal price, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update securities table in gemfirexd, myTid is " + TradeSecuritiesDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        count = this.updateToTableCidRangeTx(stmt, sid, symbol, price, whichUpdate);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableCidRangeTx(Connection conn, int sid, String symbol, BigDecimal price, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update securities table in derby, myTid is " + TradeSecuritiesDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        try {
            count = this.updateToTableCidRangeTx(stmt, sid, symbol, price, whichUpdate);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected void updateToGFXDTableTidListTx(Connection conn, int sid, String symbol, BigDecimal price, int whichUpdate, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update securities table in gemfirexd, myTid is " + TradeSecuritiesDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        count = this.updateToTableTidListTx(stmt, sid, symbol, price, whichUpdate, tid);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableTidListTx(Connection conn, int sid, String symbol, BigDecimal price, int whichUpdate, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update securities table in derby, myTid is " + TradeSecuritiesDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        try {
            count = this.updateToTableTidListTx(stmt, sid, symbol, price, whichUpdate, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected int updateToTableCidRangeTx(PreparedStatement stmt, int sid, String symbol, BigDecimal price, int whichUpdate) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating price to " + price + ", for sec_id: " + sid);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating symbol to " + symbol + ", for sec_id: " + sid);
                stmt.setString(1, symbol);
                stmt.setInt(2, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating price to " + price + ", for sec_id> " + sid + " and symbol> " + symbol);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, sid);
                stmt.setString(3, symbol);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int updateToTableTidListTx(PreparedStatement stmt, int sid, String symbol, BigDecimal price, int whichUpdate, int tid) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating price to " + price + ", for sec_id: " + sid + " and tid: " + tid);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating symbol to " + symbol + ", for sec_id: " + sid + " and tid: " + tid);
                stmt.setString(1, symbol);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating price to " + price + ", for sec_id> " + sid + " and symbol> " + symbol + " and tid: " + tid);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, sid);
                stmt.setString(3, symbol);
                stmt.setInt(4, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void getKeysForTidListUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int sid, String symbol, int tid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: 
            case 1: {
                sql = "select sec_id from trade.securities where sec_id=" + sid + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("sec_id: " + sid + " exists for update");
                    keys.put(TradeSecuritiesDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select sec_id from trade.securities where sec_id>" + sid + " and symbol>'" + symbol + "' and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availSid = rs.getInt(1);
                    Log.getLogWriter().info("sec_id: " + availSid + " exists for update");
                    keys.put(TradeSecuritiesDMLTxStmt.getTableName() + "_" + availSid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void getKeysForCidRangeUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int sid, String symbol, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: 
            case 1: {
                sql = "select sec_id from trade.securities where sec_id=" + sid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("sec_id: " + sid + " exists for update");
                    keys.put(TradeSecuritiesDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select sec_id from trade.securities where sec_id>" + sid + " and symbol>'" + symbol;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availSid = rs.getInt(1);
                    Log.getLogWriter().info("sec_id: " + availSid + " exists for update");
                    keys.put(TradeSecuritiesDMLTxStmt.getTableName() + "_" + availSid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
    }

    protected void getKeysForCidRangeDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int sid, String symbol, String exchange, BigDecimal price, BigDecimal price2, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select sec_id from trade.securities where sec_id=" + sid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("sec_id: " + sid + " exists for update");
                    keys.put(TradeSecuritiesDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select sec_id from trade.securities where symbol='" + symbol + "' and exchange='" + exchange + "'";
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    int availSid = rs.getInt(1);
                    Log.getLogWriter().info("sec_id: " + availSid + " exists for update");
                    keys.put(TradeSecuritiesDMLTxStmt.getTableName() + "_" + availSid, txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select sec_id from trade.securities where price>" + price + " and price<" + price2;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availSid = rs.getInt(1);
                    Log.getLogWriter().info("sec_id: " + availSid + " exists for update");
                    keys.put(TradeSecuritiesDMLTxStmt.getTableName() + "_" + availSid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong delete statement here");
            }
        }
    }

    protected void getKeysForTidListDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int sid, String symbol, String exchange, BigDecimal price, BigDecimal price2, int tid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select sec_id from trade.securities where sec_id=" + sid + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    Log.getLogWriter().info("sec_id: " + sid + " exists for update");
                    keys.put(TradeSecuritiesDMLTxStmt.getTableName() + "_" + rs.getInt(1), txId);
                }
                rs.close();
                break;
            }
            case 1: {
                sql = "select sec_id from trade.securities where symbol='" + symbol + "' and exchange='" + exchange + "' and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                if (rs.next()) {
                    int availSid = rs.getInt(1);
                    Log.getLogWriter().info("sec_id: " + availSid + " exists for update");
                    keys.put(TradeSecuritiesDMLTxStmt.getTableName() + "_" + availSid, txId);
                }
                rs.close();
                break;
            }
            case 2: {
                sql = "select sec_id from trade.securities where price>" + price + " and price<" + price2 + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int availSid = rs.getInt(1);
                    Log.getLogWriter().info("sec_id: " + availSid + " exists for update");
                    keys.put(TradeSecuritiesDMLTxStmt.getTableName() + "_" + availSid, txId);
                }
                rs.close();
                break;
            }
            default: {
                throw new TestException("Wrong delete statement here");
            }
        }
    }

    protected void deleteToGFXDTableCidRangeTx(Connection conn, int sid, String symbol, String exchange, BigDecimal price, BigDecimal price2, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradeSecuritiesDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete securities table in gemfirexd, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        count = this.deleteToTableCidRangeTx(stmt, sid, symbol, exchange, price, price2, whichDelete);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected boolean deleteToDerbyTableCidRangeTx(Connection conn, int sid, String symbol, String exchange, BigDecimal price, BigDecimal price2, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradeSecuritiesDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete securities table in derby, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        try {
            count = this.deleteToTableCidRangeTx(stmt, sid, symbol, exchange, price, price2, whichDelete);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected int deleteToTableCidRangeTx(PreparedStatement stmt, int sid, String symbol, String exchange, BigDecimal price, BigDecimal price2, int whichDelete) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("delete from securities for sec_id: " + sid);
                stmt.setInt(1, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("delete from securites for symbol: " + symbol + " and exchange: " + exchange);
                stmt.setString(1, symbol);
                stmt.setString(2, exchange);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("delete from securities for price> " + price + " and price< " + price2);
                stmt.setBigDecimal(1, price);
                stmt.setBigDecimal(2, price2);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong delete sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void deleteToGFXDTableTidListTx(Connection conn, int sid, String symbol, String exchange, BigDecimal price, BigDecimal price2, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete securities table in gemfirexd, myTid is " + TradeSecuritiesDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        count = this.deleteToTableTidListTx(stmt, sid, symbol, exchange, price, price2, whichDelete, tid);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected boolean deleteToDerbyTableTidListTx(Connection conn, int sid, String symbol, String exchange, BigDecimal price, BigDecimal price2, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete securities table in derby, myTid is " + TradeSecuritiesDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        try {
            count = this.deleteToTableTidListTx(stmt, sid, symbol, exchange, price, price2, whichDelete, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected int deleteToTableTidListTx(PreparedStatement stmt, int sid, String symbol, String exchange, BigDecimal price, BigDecimal price2, int whichDelete, int tid) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("delete from securities for sec_id: " + sid + " and tid: " + tid);
                stmt.setInt(1, sid);
                stmt.setInt(2, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("delete from securities for symbol: " + symbol + " and exchange: " + exchange + " and tid: " + tid);
                stmt.setString(1, symbol);
                stmt.setString(2, exchange);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("delete from securities for price> " + price + " and price< " + price2 + " and tid: " + tid);
                stmt.setBigDecimal(1, price);
                stmt.setBigDecimal(2, price2);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong delete sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int getWhichTxUpdate() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.updateByCidRange.length);
        }
        if (byCidRange && singleRowTx) {
            return rand.nextInt(this.updateByCidRangeSingleRowStmt);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.updateByTidList.length);
        }
        if (byTidList && singleRowTx) {
            return rand.nextInt(this.updateByTidListSingleRowStmt);
        }
        return -1;
    }

    protected int getWhichTxDelete() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.deleteByCidRange.length);
        }
        if (byCidRange && singleRowTx) {
            return rand.nextInt(this.deleteByCidRangeSingleRowStmt);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.deleteByTidList.length);
        }
        if (byTidList && singleRowTx) {
            return rand.nextInt(this.deleteByTidListSingleRowStmt);
        }
        return -1;
    }

    protected int getSidByList(Connection conn, int tid) {
        String sql = "select sec_id from trade.securities where tid = ?";
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setInt(1, tid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkGFXDException(conn, se)) {
                return this.getSid();
            }
            SQLHelper.handleSQLException(se);
        }
        return this.getSid();
    }

    @Override
    public void populate(Connection dConn, Connection gConn, int initSize) {
        this.insert(dConn, gConn, initSize);
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        int i;
        int[] sec_id = new int[size];
        String[] symbol = new String[size];
        String[] exchange = new String[size];
        BigDecimal[] price = new BigDecimal[size];
        SQLException derbySe = null;
        Object gfxdSe = null;
        this.getDataForInsert(sec_id, symbol, exchange, price, size);
        for (i = 0; i < symbol.length; ++i) {
            symbol[i] = this.getSymbol(4, 9);
        }
        if (dConn != null) {
            for (i = 0; i < sec_id.length; ++i) {
                try {
                    this.insertToGFXDTable(gConn, sec_id[i], symbol[i], exchange[i], price[i]);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                try {
                    boolean success = this.insertToDerbyTable(dConn, sec_id[i], symbol[i], exchange[i], price[i]);
                    int count = 0;
                    while (!success) {
                        if (count >= maxNumOfTries) {
                            Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                            gConn.rollback();
                            dConn.rollback();
                            break;
                        }
                        success = this.insertToDerbyTable(dConn, sec_id[i], symbol[i], exchange[i], price[i]);
                        ++count;
                    }
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    derbySe = se;
                }
                TradeSecuritiesDMLTxStmt.getLock();
                try {
                    gConn.commit();
                    Log.getLogWriter().info("gfxd committed the operation");
                    dConn.commit();
                    Log.getLogWriter().info("derby committed the operation");
                }
                catch (SQLException se) {
                    SQLHelper.printSQLException(se);
                    if (derbySe.getSQLState().equals("23505") && se.getSQLState().equals("X0Z05")) {
                        derbySe = null;
                        gfxdSe = null;
                    }
                    SQLHelper.handleSQLException(se);
                }
                this.releaseLock();
            }
        } else {
            for (i = 0; i < sec_id.length; ++i) {
                try {
                    this.insertToGFXDTable(gConn, sec_id[i], symbol[i], exchange[i], price[i]);
                }
                catch (SQLException se) {
                    Log.getLogWriter().info("inserting to securities using tx failed");
                    SQLHelper.handleSQLException(se);
                }
                try {
                    gConn.commit();
                    continue;
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("X0Z05")) {
                        Log.getLogWriter().info("got expected In doubt exception (unique key voilation exception), continuing testing");
                        continue;
                    }
                    SQLHelper.handleSQLException(se);
                }
            }
        }
    }

    protected void insertToGFXDTable(Connection conn, int sec_id, String symbol, String exchange, BigDecimal price) throws SQLException {
        PreparedStatement stmt = TradeSecuritiesDMLTxStmt.getStmt(conn, insert);
        int tid = TradeSecuritiesDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        count = this.insertToTable(stmt, sec_id, symbol, exchange, price, tid);
        Log.getLogWriter().info("gfxd inserts " + count + " record");
    }

    protected boolean insertToDerbyTable(Connection conn, int sec_id, String symbol, String exchange, BigDecimal price) throws SQLException {
        PreparedStatement stmt = TradeSecuritiesDMLTxStmt.getStmt(conn, insert);
        int tid = TradeSecuritiesDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into derby, myTid is " + tid);
        try {
            count = this.insertToTable(stmt, sec_id, symbol, exchange, price, tid);
            Log.getLogWriter().info("derby inserts " + count + " record");
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            throw se;
        }
        return true;
    }

    @Override
    public void insertTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        int size = 1;
        int[] sec_id = new int[size];
        String[] symbol = new String[size];
        String[] exchange = new String[size];
        BigDecimal[] price = new BigDecimal[size];
        this.getDataForInsert(sec_id, symbol, exchange, price, size);
        boolean opFailed = false;
        try {
            this.insertToGFXDTable(gConn, sec_id[0], symbol[0], exchange[0], price[0]);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            opFailed = true;
            sExList.add(se);
        }
        int txId = modifiedKeys.get(thisTxId);
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.put(TradeSecuritiesDMLTxStmt.getTableName() + "_" + sec_id[0], txId);
        }
        if (dConn != null) {
            Object[] data = new Object[]{2, 1, sec_id[0], symbol[0], exchange[0], price[0]};
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    public static String getTableName() {
        return "securities";
    }

    @Override
    public String getMyTableName() {
        return TradeSecuritiesDMLTxStmt.getTableName();
    }

    @Override
    public void performDerbyTxOps(Connection dConn, Object[] data, ArrayList<SQLException> dExList) {
        boolean success = true;
        try {
            switch ((Integer)data[1]) {
                case 1: {
                    success = this.insertToDerbyTable(dConn, (Integer)data[2], (String)data[3], (String)data[4], (BigDecimal)data[5]);
                    break;
                }
                case 2: {
                    success = this.updateToDerbyTableCidRangeTx(dConn, (Integer)data[2], (String)data[3], (BigDecimal)data[4], (Integer)data[5]);
                    break;
                }
                case 3: {
                    success = this.updateToDerbyTableTidListTx(dConn, (Integer)data[2], (String)data[3], (BigDecimal)data[4], (Integer)data[5], (Integer)data[6]);
                    break;
                }
                case 4: {
                    success = this.deleteToDerbyTableCidRangeTx(dConn, (Integer)data[2], (String)data[3], (String)data[4], (BigDecimal)data[5], (BigDecimal)data[6], (Integer)data[7]);
                    break;
                }
                case 5: {
                    success = this.deleteToDerbyTableTidListTx(dConn, (Integer)data[2], (String)data[3], (String)data[4], (BigDecimal)data[5], (BigDecimal)data[6], (Integer)data[7], (Integer)data[8]);
                    break;
                }
                default: {
                    throw new TestException("wrong derby tx ops");
                }
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            dExList.add(se);
            return;
        }
        if (!success) {
            throw new TestException("Only one thread performing derby ops at given time, should not fail");
        }
        dExList.add(null);
    }
}

