/*
 * Decompiled with CFR 0.152.
 */
package sql.dmlTxStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sql.SQLBB;
import sql.SQLHelper;
import sql.dmlStatements.TradeTxHistoryDMLStmt;
import sql.dmlTxStatements.DMLTxStmtIF;
import sql.sqlTx.SQLDerbyTxBB;
import sql.sqlutil.GFXDTxHelper;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class TradeTxHistoryDMLTxStmt
extends TradeTxHistoryDMLStmt
implements DMLTxStmtIF {
    public static final int TXHISTORYINSERT = -100;
    public static final int TXHISTORYUPDATE = -101;
    String[] updateByCidRange = new String[]{"update trade.txhistory set oid = ? where cid = ? and oid= ? ", "update trade.txhistory set price = ? , qty=? where cid = ? and oid= ? and price <? ", "update trade.txhistory set sid = ?  where cid>? and cid<? and sid = ? and price <?", "update trade.txhistory set price = ? where cid>? and cid<? and sid = ?  "};
    int updateByCidRangeSingleRowStmt = 0;
    String[] updateByTidList = new String[]{"update trade.txhistory set oid = ? where oid= ? and tid=? ", "update trade.txhistory set price = ? , qty=? where oid= ? and price <? and tid =? ", "update trade.txhistory set sid = ?  where sid = ? and price<? and (tid =? or tid=? )", "update trade.txhistory set price = ? where sid <? and tid =? "};
    int updateByTidListSingleRowStmt = 0;
    String[] deleteByCidRange = new String[]{"delete from trade.txhistory where cid=? and oid=?", "delete from trade.txhistory where cid>? and cid<? "};
    int deleteByCidRangeSingleRowStmt = 0;
    String[] deleteByTidList = new String[]{"delete from trade.txhistory where oid=? and tid=? ", "delete from trade.txhistory where oid>? and oid<? and tid=? "};
    int deleteByTidListSingleRowStmt = 0;
    public static final int insertToDerbyTable = 1;
    public static final int updateToDerbyTableCidRangeTx = 2;
    public static final int updateToDerbyTableTidListTx = 3;
    public static final int deleteToDerbyTableCidRangeTx = 4;
    public static final int deleteToDerbyTableTidListTx = 5;

    @Override
    public void deleteTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        boolean opFailed;
        int oid2;
        int oid1;
        int oid;
        int cid2;
        int whichDelete;
        int txId;
        HashMap<String, Integer> keys;
        int[] tid;
        int[] cid;
        block18: {
            int size = 1;
            cid = new int[size];
            tid = new int[size];
            keys = new HashMap<String, Integer>();
            txId = modifiedKeys.get(thisTxId);
            whichDelete = this.getWhichTxDelete();
            if (whichDelete < 0) {
                Log.getLogWriter().info("Does not have single row operation in no primary key table");
                return;
            }
            this.getCidAndTid(gConn, txId, cid, tid);
            cid2 = cid[0] + cidRangeForTxOp;
            oid = 0;
            if (byTidList) {
                oid = this.getOidByTid(gConn, tid[0]);
            } else if (byCidRange) {
                oid = this.getOidByCid(gConn, cid[0]);
            }
            oid1 = oid;
            oid2 = oid + 20;
            opFailed = false;
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeDelete(gConn, keys, whichDelete, cid[0], cid2, oid, txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.deleteToGFXDTableCidRangeTx(gConn, cid[0], cid2, oid, whichDelete);
                    break block18;
                }
                if (!byTidList) break block18;
                try {
                    this.getKeysForTidListDelete(gConn, keys, whichDelete, oid1, oid2, oid, tid[0], txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.deleteToGFXDTableTidListTx(gConn, oid1, oid2, oid, whichDelete, tid[0]);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn != null && byCidRange) {
                    if (!GFXDTxHelper.isColocatedCid(TradeTxHistoryDMLTxStmt.getTableName(), txId, cid[0])) {
                        Log.getLogWriter().info("got expected non colocated exception, continuing testing");
                        return;
                    }
                    throw new TestException("got unexpected non colocated exception, keys are colocated\n" + TestHelper.getStackTrace((Throwable)se));
                }
                opFailed = true;
                sExList.add(se);
            }
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.putAll(keys);
        }
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{7, 4, cid[0], cid2, oid, whichDelete};
            } else if (byTidList) {
                data = new Object[]{7, 5, oid1, oid2, oid, whichDelete, tid[0]};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    protected void deleteToGFXDTableCidRangeTx(Connection conn, int cid, int cid2, int oid, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradeTxHistoryDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete txhistory table in gemfirexd, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        count = this.deleteToTableCidRangeTx(stmt, cid, cid2, oid, whichDelete);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected boolean deleteToDerbyTableCidRangeTx(Connection conn, int cid, int cid2, int oid, int whichDelete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByCidRange[whichDelete]);
        int tid = TradeTxHistoryDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("delete txhistory table in derby, myTid is " + tid);
        Log.getLogWriter().info("delete statement is " + this.deleteByCidRange[whichDelete]);
        try {
            count = this.deleteToTableCidRangeTx(stmt, cid, cid2, oid, whichDelete);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected int deleteToTableCidRangeTx(PreparedStatement stmt, int cid, int cid2, int oid, int whichDelete) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("deleting from txhistory table for cid: " + cid + " and oid: " + oid);
                stmt.setInt(1, cid);
                stmt.setInt(2, oid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("deleting from txhistory table for cid> " + cid + " to cid< " + cid2);
                stmt.setInt(1, cid);
                stmt.setInt(2, cid2);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void deleteToGFXDTableTidListTx(Connection conn, int oid1, int oid2, int oid, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete txhistory table in gemfirexd, myTid is " + TradeTxHistoryDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        count = this.deleteToTableTidListTx(stmt, oid1, oid2, oid, whichDelete, tid);
        Log.getLogWriter().info("gfxd deleted " + count + " rows");
    }

    protected boolean deleteToDerbyTableTidListTx(Connection conn, int oid1, int oid2, int oid, int whichDelete, int tid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteByTidList[whichDelete]);
        int count = -1;
        Log.getLogWriter().info("delete txhistory table in derby, myTid is " + TradeTxHistoryDMLTxStmt.getMyTid());
        Log.getLogWriter().info("delete statement is " + this.deleteByTidList[whichDelete]);
        try {
            count = this.deleteToTableTidListTx(stmt, oid1, oid2, oid, whichDelete, tid);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby deleted " + count + " rows");
        return true;
    }

    protected int deleteToTableTidListTx(PreparedStatement stmt, int oid1, int oid2, int oid, int whichDelete, int tid) throws SQLException {
        int rowCount = 0;
        switch (whichDelete) {
            case 0: {
                Log.getLogWriter().info("deleting from txhistory for oid: " + oid + " and tid: " + tid);
                stmt.setInt(1, oid);
                stmt.setInt(2, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("deleting from txhistory for oid > " + oid1 + " oid < " + oid2 + " and tid: " + tid);
                stmt.setInt(1, oid1);
                stmt.setInt(2, oid2);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong delete sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void getKeysForCidRangeDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int cid, int cid2, int oid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select * from trade.txhistory where cid=" + cid + " and oid=" + oid;
                rs = conn.createStatement().executeQuery(sql);
                break;
            }
            case 1: {
                sql = "select * from trade.txhistory where cid>" + cid + " and cid<" + cid2;
                rs = conn.createStatement().executeQuery(sql);
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
        this.processKeys(rs, keys);
    }

    protected void getKeysForTidListDelete(Connection conn, HashMap<String, Integer> keys, int whichDelete, int oid1, int oid2, int oid, int tid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichDelete) {
            case 0: {
                sql = "select * from trade.txhistory where oid=" + oid + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                break;
            }
            case 1: {
                sql = "select * from trade.txhistory where oid>" + oid1 + " and oid<" + oid2 + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
        this.processKeys(rs, keys);
    }

    @Override
    public String getMyTableName() {
        return TradeTxHistoryDMLTxStmt.getTableName();
    }

    public static String getTableName() {
        return "txhistory";
    }

    @Override
    public void insertTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        if (usingTrigger) {
            Log.getLogWriter().info("insert will be done in trigger");
            return;
        }
        int size = 1;
        int[] cid = new int[size];
        int[] oid = new int[size];
        int[] sid = new int[size];
        int[] qty = new int[size];
        String[] type = new String[size];
        Timestamp[] time = new Timestamp[size];
        BigDecimal[] price = new BigDecimal[size];
        int[] tid = new int[size];
        int txId = modifiedKeys.get(thisTxId);
        this.getCidAndTid(gConn, txId, cid, tid);
        this.getDataForInsert(gConn, oid, cid, sid, qty, type, time, price, size);
        boolean opFailed = false;
        try {
            this.insertToGFXDTable(gConn, oid[0], cid[0], sid[0], qty[0], type[0], time[0], price[0]);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (se.getSQLState().equalsIgnoreCase("X0Z04")) {
                throw new TestException("got unexpected non colocated exception, keys are colocated" + TestHelper.getStackTrace((Throwable)se));
            }
            opFailed = true;
            sExList.add(se);
        }
        if (!opFailed) {
            sExList.add(null);
            String key = TradeTxHistoryDMLTxStmt.getTableName() + "_" + oid[0] + "_" + cid[0] + "_" + sid[0] + "_" + qty[0] + "_" + price[0] + "_" + time[0] + "_" + type[0] + "_" + TradeTxHistoryDMLTxStmt.getMyTid();
            if (modifiedKeys.get(key) == null) {
                modifiedKeys.put(key, -100);
            }
        }
        if (dConn != null) {
            Object[] data = new Object[]{7, 1, oid[0], cid[0], sid[0], qty[0], type[0], time[0], price[0]};
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean getDataForInsert(Connection conn, int[] oid, int[] cid, int[] sid, int[] qty, String[] type, Timestamp[] time, BigDecimal[] price, int size) {
        boolean[] success = new boolean[1];
        ResultSet bors = this.getFromBO(conn, cid[0]);
        if (!success[0]) {
            return false;
        }
        ArrayList bolist = (ArrayList)ResultSetHelper.asList(bors, SQLHelper.isDerbyConn(conn));
        ResultSet sors = this.getFromSO(conn, cid[0]);
        if (!success[0]) {
            return false;
        }
        ArrayList solist = (ArrayList)ResultSetHelper.asList(sors, SQLHelper.isDerbyConn(conn));
        if (bolist != null && solist != null) {
            if (solist.size() != 0 && bolist.size() != 0) {
                if (rand.nextInt() % 2 == 0) {
                    this.getDataForInsertFromSO(solist, oid, cid, sid, qty, type, time, price, size);
                    return true;
                } else {
                    this.getDataForInsertFromBO(bolist, oid, cid, sid, qty, type, time, price, size);
                }
                return true;
            } else if (solist.size() != 0) {
                this.getDataForInsertFromSO(solist, oid, cid, sid, qty, type, time, price, size);
                return true;
            } else {
                if (bolist.size() == 0) return false;
                this.getDataForInsertFromBO(bolist, oid, cid, sid, qty, type, time, price, size);
            }
            return true;
        } else if (bolist == null) {
            if (solist.size() == 0) return false;
            this.getDataForInsertFromSO(solist, oid, cid, sid, qty, type, time, price, size);
            return true;
        } else {
            if (solist != null) return false;
            if (bolist.size() == 0) return false;
            this.getDataForInsertFromBO(bolist, oid, cid, sid, qty, type, time, price, size);
        }
        return true;
    }

    protected ResultSet getFromBO(Connection conn, int cid) {
        String sql = null;
        sql = byCidRange ? "select * from trade.buyorders where cid=" + cid + " and status='filled'" : (byTidList ? "select * from trade.buyorders where tid=" + TradeTxHistoryDMLTxStmt.getMyTid() + " and status='filled'" : "select * from trade.buyorders where status='filled'");
        try {
            return conn.createStatement().executeQuery(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            return null;
        }
    }

    protected ResultSet getFromSO(Connection conn, int cid) {
        String sql = null;
        sql = byCidRange ? "select * from trade.sellorders where cid=" + cid + " and status='filled'" : (byTidList ? "select * from trade.sellorders where tid=" + TradeTxHistoryDMLTxStmt.getMyTid() + " and status='filled'" : "select * from trade.sellorders where status='filled'");
        try {
            return conn.createStatement().executeQuery(sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            return null;
        }
    }

    protected void getCidAndTid(Connection gConn, int txId, int[] cid, int[] tid) {
        if (byTidList) {
            tid[0] = GFXDTxHelper.getColocatedTid(TradeTxHistoryDMLTxStmt.getTableName(), TradeTxHistoryDMLTxStmt.getMyTid());
            cid[0] = TradeTxHistoryDMLTxStmt.getCid();
        }
        if (byCidRange) {
            Object txIdCid = SQLBB.getBB().getSharedMap().get((Object)(cid_txId + txId));
            cid[0] = GFXDTxHelper.getColocatedCid(TradeTxHistoryDMLTxStmt.getTableName(), (Integer)txIdCid);
            tid[0] = TradeTxHistoryDMLTxStmt.getMyTid();
        }
    }

    @Override
    public void populateTx(Connection dConn, Connection gConn) {
        if (!usingTrigger) {
            int size = 30;
            this.populateTx(dConn, gConn, size);
        }
    }

    public void populateTx(Connection dConn, Connection gConn, int initSize) {
        this.insert(dConn, gConn, initSize);
    }

    @Override
    public void insert(Connection dConn, Connection gConn, int size) {
        int[] cid = new int[size];
        int[] oid = new int[size];
        int[] sid = new int[size];
        int[] qty = new int[size];
        String[] type = new String[size];
        Timestamp[] time = new Timestamp[size];
        BigDecimal[] price = new BigDecimal[size];
        boolean success = false;
        this.getDataForInsert(gConn, oid, cid, sid, qty, type, time, price, size);
        SQLException derbySe = null;
        SQLException gfxdSe = null;
        if (dConn != null) {
            for (int i = 0; i < size; ++i) {
                block29: {
                    try {
                        this.insertToGFXDTable(gConn, oid[i], cid[i], sid[i], qty[i], type[i], time[i], price[i]);
                    }
                    catch (SQLException se) {
                        SQLHelper.printSQLException(se);
                        gfxdSe = se;
                    }
                    try {
                        success = this.insertToDerbyTable(dConn, oid[i], cid[i], sid[i], qty[i], type[i], time[i], price[i]);
                        int count = 0;
                        while (!success) {
                            if (count >= maxNumOfTries) {
                                Log.getLogWriter().info("Could not get the lock to finish insert into derby, abort this operation");
                                gConn.rollback();
                                dConn.rollback();
                                break;
                            }
                            success = this.insertToDerbyTable(dConn, oid[i], cid[i], sid[i], qty[i], type[i], time[i], price[i]);
                            ++count;
                        }
                    }
                    catch (SQLException se) {
                        SQLHelper.printSQLException(se);
                        derbySe = se;
                    }
                    try {
                        try {
                            gConn.commit();
                            Log.getLogWriter().info("gfxd committed the operation");
                            dConn.commit();
                            Log.getLogWriter().info("derby committed the operation");
                        }
                        catch (SQLException se) {
                            SQLHelper.printSQLException(se);
                            if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                                Log.getLogWriter().info("get commit conflict exception, roll back the operation");
                                dConn.rollback();
                                derbySe = null;
                                gfxdSe = null;
                                continue;
                            }
                            if (se.getSQLState().equals("X0Z05")) {
                                if (derbySe != null && SQLHelper.isSameRootSQLException(derbySe.getSQLState(), se)) {
                                    if (derbySe.getSQLState().equals("23503")) {
                                        Log.getLogWriter().warning("got foreign key check violation and masked as in doubt transaction exception -- which is bug# 41898 ");
                                    }
                                    derbySe = null;
                                    gfxdSe = null;
                                    continue;
                                }
                                break block29;
                            }
                            SQLHelper.handleSQLException(se);
                        }
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                }
                SQLHelper.compareExceptions(derbySe, gfxdSe);
                derbySe = null;
                gfxdSe = null;
            }
            try {
                dConn.commit();
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                try {
                    this.insertToGFXDTable(gConn, oid[i], cid[i], sid[i], qty[i], type[i], time[i], price[i]);
                }
                catch (SQLException se) {
                    if (se.getSQLState().equals("23505")) {
                        Log.getLogWriter().info("got expected gfxd duplicate primary key exception, continue testing");
                    }
                    SQLHelper.handleSQLException(se);
                }
                try {
                    gConn.commit();
                    Log.getLogWriter().info("gfxd committed the operation");
                    continue;
                }
                catch (SQLException se) {
                    if (se.getSQLState().equalsIgnoreCase("X0Z02")) {
                        Log.getLogWriter().info("got expected gfxd commit conflict exception, continue testing");
                        continue;
                    }
                    if (se.getSQLState().equals("X0Z05")) {
                        if (SQLHelper.isSameRootSQLException("23505", se)) {
                            Log.getLogWriter().warning("got duplicate primary key exception and masked as in doubt transaction exception -- primary key should be checked at operation time ");
                            continue;
                        }
                        if (!SQLHelper.isSameRootSQLException("23503", se)) continue;
                        Log.getLogWriter().warning("got foreign key check violation and masked as in doubt transaction exception -- which is bug# 41898 ");
                        continue;
                    }
                    SQLHelper.handleSQLException(se);
                }
            }
        }
    }

    protected void insertToGFXDTable(Connection conn, int oid, int cid, int sid, int qty, String type, Timestamp time, BigDecimal price) throws SQLException {
        PreparedStatement stmt = TradeTxHistoryDMLTxStmt.getStmt(conn, insert);
        int tid = TradeTxHistoryDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into gemfirexd, myTid is " + tid);
        count = this.insertToTable(stmt, oid, cid, sid, qty, type, time, price, tid);
        Log.getLogWriter().info("gfxd inserts " + count + " record");
    }

    protected boolean insertToDerbyTable(Connection conn, int oid, int cid, int sid, int qty, String type, Timestamp time, BigDecimal price) throws SQLException {
        PreparedStatement stmt = TradeTxHistoryDMLTxStmt.getStmt(conn, insert);
        int tid = TradeTxHistoryDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("Insert into derby, myTid is " + tid);
        try {
            count = this.insertToTable(stmt, oid, cid, sid, qty, type, time, price, tid);
            Log.getLogWriter().info("derby inserts " + count + " record");
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                return false;
            }
            throw se;
        }
        return true;
    }

    @Override
    public void queryTx(Connection dConn, Connection gConn) {
    }

    @Override
    public void updateTx(Connection dConn, Connection gConn, HashMap<String, Integer> modifiedKeys, ArrayList<SQLException> dExList, ArrayList<SQLException> sExList) {
        boolean opFailed;
        int largeCid;
        int smallCid;
        HashMap<String, Integer> keys;
        int newOid;
        int oid;
        int tid2;
        int whichUpdate;
        int newSid;
        int sid;
        int qty;
        BigDecimal price;
        int tid;
        int cid;
        int txId;
        block23: {
            txId = modifiedKeys.get(thisTxId);
            int[] cids = new int[1];
            int[] tids = new int[1];
            this.getCidAndTid(gConn, txId, cids, tids);
            cid = cids[0];
            tid = tids[0];
            price = this.getPrice();
            qty = this.getQty();
            sid = this.getSid();
            newSid = this.getSid();
            whichUpdate = this.getWhichTxUpdate();
            if (whichUpdate < 0) {
                Log.getLogWriter().info("Does not have single row operation in no primary key table");
                return;
            }
            tid2 = 0;
            if (byTidList) {
                tid2 = GFXDTxHelper.getColocatedTid(TradeTxHistoryDMLTxStmt.getTableName(), TradeTxHistoryDMLTxStmt.getMyTid());
            }
            oid = 0;
            if (byTidList) {
                oid = this.getOidByTid(gConn, tid);
            } else if (byCidRange) {
                oid = this.getOidByCid(gConn, cid);
            }
            newOid = oid + rand.nextInt(100);
            keys = new HashMap<String, Integer>();
            smallCid = 0;
            largeCid = 0;
            if (byCidRange) {
                int low = GFXDTxHelper.getRangeEnds(TradeTxHistoryDMLTxStmt.getTableName(), cid)[0];
                int high = GFXDTxHelper.getRangeEnds(TradeTxHistoryDMLTxStmt.getTableName(), cid)[1];
                smallCid = rand.nextInt(high - low) + low;
                largeCid = smallCid + 10;
            }
            opFailed = false;
            try {
                if (byCidRange) {
                    try {
                        this.getKeysForCidRangeUpdate(gConn, keys, whichUpdate, cid, sid, oid, price, smallCid, largeCid, txId);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    this.updateToGFXDTableCidRangeTx(gConn, cid, sid, newSid, oid, newOid, price, qty, smallCid, largeCid, whichUpdate);
                    break block23;
                }
                if (!byTidList) break block23;
                try {
                    this.getKeysForTidListUpdate(gConn, keys, whichUpdate, cid, sid, oid, price, tid, tid2, txId);
                }
                catch (SQLException se) {
                    SQLHelper.handleSQLException(se);
                }
                this.updateToGFXDTableTidListTx(gConn, cid, sid, newSid, oid, newOid, price, qty, whichUpdate, tid, tid2);
            }
            catch (SQLException se) {
                SQLHelper.printSQLException(se);
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn != null && byCidRange) {
                    if (!GFXDTxHelper.isColocatedCid(TradeTxHistoryDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().info("got expected non colocated exception, continuing testing");
                        return;
                    }
                    throw new TestException("got unexpected non colocated exception, keys are colocated" + TestHelper.getStackTrace((Throwable)se));
                }
                if (se.getSQLState().equalsIgnoreCase("X0Z04") && dConn == null && byCidRange) {
                    if (GFXDTxHelper.isColocatedCid(TradeTxHistoryDMLTxStmt.getTableName(), txId, cid)) {
                        Log.getLogWriter().warning("should not get non colocated exception here");
                    }
                    return;
                }
                if (se.getSQLState().equalsIgnoreCase("23513")) {
                    opFailed = true;
                    sExList.add(se);
                }
                SQLHelper.handleSQLException(se);
            }
        }
        if (!opFailed) {
            sExList.add(null);
            modifiedKeys.putAll(keys);
        }
        if (dConn != null) {
            Object[] data = null;
            if (byCidRange) {
                data = new Object[]{7, 2, cid, sid, newSid, oid, newOid, price, qty, smallCid, largeCid, whichUpdate};
            } else if (byTidList) {
                data = new Object[]{7, 3, cid, sid, newSid, oid, newOid, price, qty, whichUpdate, tid, tid2};
            }
            ArrayList derbyOps = (ArrayList)SQLDerbyTxBB.getBB().getSharedMap().get((Object)txId);
            derbyOps.add(data);
            SQLDerbyTxBB.getBB().getSharedMap().put((Object)txId, (Object)derbyOps);
        }
    }

    protected void getKeysForCidRangeUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, int sid, int oid, BigDecimal price, int smallCid, int largeCid, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: {
                sql = "select * from trade.txhistory where cid=" + cid + " and oid=" + oid;
                rs = conn.createStatement().executeQuery(sql);
                break;
            }
            case 1: {
                sql = "select * from trade.txhistory where cid=" + cid + " and oid=" + oid + " and price<" + price;
                rs = conn.createStatement().executeQuery(sql);
                break;
            }
            case 2: {
                sql = "select * from trade.txhistory where cid>" + smallCid + " and cid<" + largeCid + " and sid = " + sid + " and price<" + price;
                rs = conn.createStatement().executeQuery(sql);
                break;
            }
            case 3: {
                sql = "select * from trade.txhistory where cid>? and cid<? and sid=?";
                PreparedStatement ps = conn.prepareStatement(sql);
                ps.setInt(1, smallCid);
                ps.setInt(2, largeCid);
                ps.setInt(3, sid);
                rs = ps.executeQuery();
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
        this.processKeys(rs, keys);
    }

    protected void processKeys(ResultSet rs, HashMap<String, Integer> keys) throws SQLException {
        int _oid = 0;
        int _cid = 0;
        int _sid = 0;
        int _qty = 0;
        BigDecimal _price = null;
        String _type = null;
        Timestamp _time = null;
        int _tid = 0;
        while (rs.next()) {
            _oid = rs.getInt("OID");
            _cid = rs.getInt("CID");
            _sid = rs.getInt("SID");
            _qty = rs.getInt("QTY");
            _price = rs.getBigDecimal("PRICE");
            _time = rs.getTimestamp("ORDERTIME");
            _type = rs.getString("TYPE");
            _tid = rs.getInt("TID");
            Log.getLogWriter().info("oid: " + _oid + "cid: " + _cid + "sid: " + _sid + "qty: " + _qty + "price: " + _price + "ordertime: " + _time + "type: " + _type + "tid: " + _tid + " exists for update");
            String key = TradeTxHistoryDMLTxStmt.getTableName() + "_" + _oid + "_" + _cid + "_" + _sid + "_" + _qty + "_" + _price + "_" + _time + "_" + _type + "_" + _tid;
            keys.put(key, -101);
        }
        rs.close();
    }

    protected void updateToGFXDTableCidRangeTx(Connection conn, int cid, int sid, int newSid, int oid, int newOid, BigDecimal price, int qty, int smallCid, int largeCid, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int tid = TradeTxHistoryDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("update txhistory table in gemfirexd, myTid is " + tid);
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        count = this.updateToTableCidRangeTx(stmt, cid, sid, newSid, oid, newOid, price, qty, smallCid, largeCid, whichUpdate);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableCidRangeTx(Connection conn, int cid, int sid, int newSid, int oid, int newOid, BigDecimal price, int qty, int smallCid, int largeCid, int whichUpdate) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByCidRange[whichUpdate]);
        int tid = TradeTxHistoryDMLTxStmt.getMyTid();
        int count = -1;
        Log.getLogWriter().info("update txhistory table in derby, myTid is " + tid);
        Log.getLogWriter().info("update statement is " + this.updateByCidRange[whichUpdate]);
        try {
            count = this.updateToTableCidRangeTx(stmt, cid, sid, newSid, oid, newOid, price, qty, smallCid, largeCid, whichUpdate);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected int updateToTableCidRangeTx(PreparedStatement stmt, int cid, int sid, int newSid, int oid, int newOid, BigDecimal price, int qty, int smallCid, int largeCid, int whichUpdate) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating txhistory table oid to " + newOid + " for cid: " + cid + " and oid: " + oid);
                stmt.setInt(1, newOid);
                stmt.setInt(2, cid);
                stmt.setInt(3, oid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating txhistory table price to " + price + " and  qty to " + qty + " for cid: " + cid + " and oid: " + oid + " and price < " + price);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, qty);
                stmt.setInt(3, cid);
                stmt.setInt(4, oid);
                stmt.setBigDecimal(5, price);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating txhistory table sid to " + newSid + " for cid: " + smallCid + " to " + largeCid + " and sid: " + sid + " and price < " + price);
                stmt.setInt(1, newSid);
                stmt.setInt(2, smallCid);
                stmt.setInt(3, largeCid);
                stmt.setInt(4, sid);
                stmt.setBigDecimal(5, price);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info("updating txhistory table price to " + price + " for cid: " + smallCid + " to " + largeCid + " and sid: " + sid);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, smallCid);
                stmt.setInt(3, largeCid);
                stmt.setInt(4, sid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected void getKeysForTidListUpdate(Connection conn, HashMap<String, Integer> keys, int whichUpdate, int cid, int sid, int oid, BigDecimal price, int tid, int tid2, int txId) throws SQLException {
        String sql = null;
        ResultSet rs = null;
        switch (whichUpdate) {
            case 0: {
                sql = "select * from trade.txhistory where oid=" + oid + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                break;
            }
            case 1: {
                sql = "select * from trade.txhistory where oid=" + oid + " and price<" + price + " and tid=" + tid;
                rs = conn.createStatement().executeQuery(sql);
                break;
            }
            case 2: {
                sql = "select * from trade.txhistory where sid=" + sid + " and price<" + price + " and (tid=" + tid + " or tid=" + tid2 + ")";
                rs = conn.createStatement().executeQuery(sql);
                break;
            }
            case 3: {
                sql = "select * from trade.txhistory where sid< ? and tid =? ";
                PreparedStatement ps = conn.prepareStatement(sql);
                ps.setInt(1, sid);
                ps.setInt(2, tid);
                rs = ps.executeQuery();
                break;
            }
            default: {
                throw new TestException("Wrong update statement here");
            }
        }
        this.processKeys(rs, keys);
    }

    protected void updateToGFXDTableTidListTx(Connection conn, int cid, int sid, int newSid, int oid, int newOid, BigDecimal price, int qty, int whichUpdate, int tid, int tid2) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update txhistory table in gemfirexd, myTid is " + TradeTxHistoryDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        count = this.updateToTableTidListTx(stmt, cid, sid, newSid, oid, newOid, price, qty, whichUpdate, tid, tid2);
        Log.getLogWriter().info("gfxd updated " + count + " rows");
    }

    protected boolean updateToDerbyTableTidListTx(Connection conn, int cid, int sid, int newSid, int oid, int newOid, BigDecimal price, int qty, int whichUpdate, int tid, int tid2) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.updateByTidList[whichUpdate]);
        int count = -1;
        Log.getLogWriter().info("update txhistory table in derby, myTid is " + TradeTxHistoryDMLTxStmt.getMyTid());
        Log.getLogWriter().info("update statement is " + this.updateByTidList[whichUpdate]);
        try {
            count = this.updateToTableTidListTx(stmt, cid, sid, newSid, oid, newOid, price, qty, whichUpdate, tid, tid2);
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                Log.getLogWriter().info("detected the lock issue, will try it again");
                return false;
            }
            throw se;
        }
        Log.getLogWriter().info("derby updated " + count + " rows");
        return true;
    }

    protected int updateToTableTidListTx(PreparedStatement stmt, int cid, int sid, int newSid, int oid, int newOid, BigDecimal price, int qty, int whichUpdate, int tid, int tid2) throws SQLException {
        int rowCount = 0;
        switch (whichUpdate) {
            case 0: {
                Log.getLogWriter().info("updating txhistory table oid to " + newOid + " for  oid: " + oid + " and tid=" + tid);
                stmt.setInt(1, newOid);
                stmt.setInt(2, oid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 1: {
                Log.getLogWriter().info("updating txhistory table price to " + price + " and  qty to " + qty + " for oid: " + oid + " and price < " + price + " and tid=" + tid);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, qty);
                stmt.setInt(3, oid);
                stmt.setBigDecimal(4, price);
                stmt.setInt(5, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 2: {
                Log.getLogWriter().info("updating txhistory table sid to " + newSid + " for sid: " + sid + " and price < " + price + "and (tid=" + tid + " or tid=" + tid2 + ")");
                stmt.setInt(1, newSid);
                stmt.setInt(2, sid);
                stmt.setBigDecimal(3, price);
                stmt.setInt(4, tid);
                stmt.setInt(5, tid2);
                rowCount = stmt.executeUpdate();
                break;
            }
            case 3: {
                Log.getLogWriter().info("updating txhistory table price to " + price + " for sid< " + sid + " and tid=" + tid);
                stmt.setBigDecimal(1, price);
                stmt.setInt(2, sid);
                stmt.setInt(3, tid);
                rowCount = stmt.executeUpdate();
                break;
            }
            default: {
                throw new TestException("Wrong update sql string here");
            }
        }
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    protected int getOidByCid(Connection gConn, int cid) {
        ResultSet rs = null;
        List<Struct> result = null;
        try {
            String sql = "select oid from trade.txhistory where cid= " + cid;
            rs = gConn.createStatement().executeQuery(sql);
            result = ResultSetHelper.asList(rs, false);
            return this.getOid(result);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            return 0;
        }
    }

    protected int getOidByTid(Connection gConn, int tid) {
        ResultSet rs = null;
        List<Struct> result = null;
        try {
            String sql = "select oid from trade.txhistory where tid= " + tid;
            rs = gConn.createStatement().executeQuery(sql);
            result = ResultSetHelper.asList(rs, false);
            return this.getOid(result);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            return 0;
        }
    }

    protected int getOid(List<Struct> result) {
        if (result == null || result.size() == 0) {
            return 0;
        }
        int whichOne = rand.nextInt(result.size());
        return (Integer)result.get(whichOne).getFieldValues()[0];
    }

    protected int getWhichTxUpdate() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.updateByCidRange.length);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.updateByTidList.length);
        }
        return -1;
    }

    protected int getWhichTxDelete() {
        if (byCidRange && !singleRowTx) {
            return rand.nextInt(this.deleteByCidRange.length);
        }
        if (byTidList && !singleRowTx) {
            return rand.nextInt(this.deleteByTidList.length);
        }
        return -1;
    }

    @Override
    public void performDerbyTxOps(Connection dConn, Object[] data, ArrayList<SQLException> dExList) {
        boolean success = true;
        try {
            switch ((Integer)data[1]) {
                case 1: {
                    success = this.insertToDerbyTable(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (Integer)data[5], (String)data[6], (Timestamp)data[7], (BigDecimal)data[8]);
                    break;
                }
                case 2: {
                    success = this.updateToDerbyTableCidRangeTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (Integer)data[5], (Integer)data[6], (BigDecimal)data[7], (Integer)data[8], (Integer)data[9], (Integer)data[10], (Integer)data[11]);
                    break;
                }
                case 3: {
                    success = this.updateToDerbyTableTidListTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (Integer)data[5], (Integer)data[6], (BigDecimal)data[7], (Integer)data[8], (Integer)data[9], (Integer)data[10], (Integer)data[11]);
                    break;
                }
                case 4: {
                    success = this.deleteToDerbyTableCidRangeTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (Integer)data[5]);
                    break;
                }
                case 5: {
                    success = this.deleteToDerbyTableTidListTx(dConn, (Integer)data[2], (Integer)data[3], (Integer)data[4], (Integer)data[5], (Integer)data[6]);
                    break;
                }
                default: {
                    throw new TestException("wrong derby tx ops");
                }
            }
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            dExList.add(se);
            return;
        }
        if (!success) {
            throw new TestException("Only one thread performing derby ops, should not fail");
        }
        dExList.add(null);
    }
}

