/*
 * Decompiled with CFR 0.152.
 */
package sql.generic;

import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import sql.ClientDiscDBManager;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.generic.SQLGenericTest;
import sql.generic.SQLOldTest;
import sql.generic.SQLTestable;
import sql.generic.SqlUtilityHelper;
import util.TestException;
import util.TestHelper;

public class DerbyTest {
    Connection discConn = null;
    SQLTestable sqlTest;
    HydraThreadLocal derbyConnection = new HydraThreadLocal();
    HydraThreadLocal resetDerbyConnection = new HydraThreadLocal();
    boolean testSecurity;

    public DerbyTest(SQLTestable sqlTest) {
        this.sqlTest = sqlTest;
        ((SQLGenericTest)sqlTest).getSQLOldTest();
        this.testSecurity = SQLOldTest.testSecurity;
    }

    public void createDiscDB() {
        if (this.discConn == null) {
            while (true) {
                try {
                    this.discConn = this.getFirstDiscConnection();
                }
                catch (SQLException se) {
                    Log.getLogWriter().info("Not able to connect to Derby server yet, Derby server may not be ready.");
                    SQLHelper.printSQLException(se);
                    int sleepMS = 10000;
                    MasterController.sleepForMs((int)sleepMS);
                    continue;
                }
                break;
            }
        }
    }

    protected void createDiscSchemas() {
        Connection conn = this.getDiscConnection("superUser");
        Log.getLogWriter().info("creating schemas on disc.");
        this.createSchemas(conn);
        Log.getLogWriter().info("done creating schemas on disc.");
        this.closeDiscConnection(conn);
    }

    protected void createSchemas(Connection conn) {
        String[] schemas = SQLPrms.getSchemas();
        this.createSchemas(conn, schemas);
    }

    protected void createSchemas(Connection conn, String[] schemas) {
        int i;
        String ddlThread = "thr_" + SqlUtilityHelper.tid();
        try {
            Statement s = conn.createStatement();
            for (i = 0; i < schemas.length; ++i) {
                if (this.testSecurity) {
                    s.execute(schemas[i] + " AUTHORIZATION " + ddlThread);
                    continue;
                }
                s.execute(schemas[i]);
            }
            s.close();
            this.commit(conn);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("X0Y68")) {
                Log.getLogWriter().info("got schema existing exception if multiple threads try to create schema, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
        StringBuffer aStr = new StringBuffer("Created schemas \n");
        for (i = 0; i < schemas.length; ++i) {
            String o = schemas[i];
            aStr.append(o.toString() + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    protected void createDiscTables() {
        Connection conn = this.getDiscConnection();
        Log.getLogWriter().info("creating tables in derby db.");
        this.createTables(conn);
        Log.getLogWriter().info("done creating tables in derby db.");
        this.closeDiscConnection(conn);
    }

    protected void createTables(Connection conn) {
        String[] derbyTables = SQLPrms.getCreateTablesStatements(true);
        try {
            Statement s = conn.createStatement();
            for (int i = 0; i < derbyTables.length; ++i) {
                Log.getLogWriter().info("derby : executing [" + derbyTables[i] + " ]");
                s.execute(derbyTables[i]);
                Log.getLogWriter().info("derby : executed [ " + derbyTables[i] + " ]");
            }
            s.close();
            this.commit(conn);
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            throw new TestException("Not able to create derby tables\n" + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public Connection getFirstDiscConnection() throws SQLException {
        Connection conn = null;
        conn = this.testSecurity ? ClientDiscDBManager.getAuthConnection(SqlUtilityHelper.tid()) : ClientDiscDBManager.getConnection();
        return conn;
    }

    protected Connection getDiscConnection(String user) {
        Connection conn = null;
        try {
            conn = this.testSecurity ? ClientDiscDBManager.getAuthConnection(user) : ClientDiscDBManager.getConnection();
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to get Derby Connection:\n " + TestHelper.getStackTrace((Throwable)e));
        }
        return conn;
    }

    protected void closeDiscConnection(Connection conn) {
        this.closeDiscConnection(conn, false);
    }

    protected void closeDiscConnection(Connection conn, boolean end) {
        if (end) {
            try {
                conn.close();
                Log.getLogWriter().info("closing the connection");
            }
            catch (SQLException e) {
                SQLHelper.printSQLException(e);
                throw new TestException("Not able to release the connection " + TestHelper.getStackTrace((Throwable)e));
            }
        }
    }

    public void commit(Connection conn) {
        block3: {
            if (conn == null) {
                return;
            }
            try {
                Log.getLogWriter().info("committing the ops for derby");
                conn.commit();
            }
            catch (SQLException se) {
                if (SQLHelper.checkDerbyException(conn, se) || !se.getSQLState().equalsIgnoreCase("08003")) break block3;
                Log.getLogWriter().info("detected current connection is lost, possibly due to reade time out");
                return;
            }
        }
    }

    protected Connection getDiscConnection() {
        Connection conn = (Connection)this.derbyConnection.get();
        if (conn == null || ((Boolean)this.resetDerbyConnection.get()).booleanValue()) {
            Log.getLogWriter().info("derbyConnection is not set yet");
            try {
                conn = this.testSecurity ? ClientDiscDBManager.getAuthConnection(SqlUtilityHelper.tid()) : ClientDiscDBManager.getConnection();
            }
            catch (SQLException e) {
                SQLHelper.printSQLException(e);
                throw new TestException("Not able to get Derby Connection:\n " + TestHelper.getStackTrace((Throwable)e));
            }
            this.derbyConnection.set((Object)conn);
            this.resetDerbyConnection.set((Object)false);
        }
        return conn;
    }
}

