/*
 * Decompiled with CFR 0.152.
 */
package sql.generic;

import hydra.Log;
import hydra.RemoteTestModule;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GfxdConfigPrms;
import java.util.Properties;
import sql.SQLBB;
import sql.generic.DerbyTest;
import sql.generic.MemberType;
import sql.generic.SQLGenericPrms;
import sql.generic.SQLOldTest;
import sql.generic.SQLTestable;
import util.PRObserver;

public class SQLGenericTest
implements SQLTestable {
    SQLOldTest sqlTest;
    DerbyTest derbyTest;
    MemberType memberType;
    String nodeServerGroup;
    Boolean isVMInitialized = new Boolean(false);

    public SQLGenericTest() {
        Log.getLogWriter().info("Creating SQLGenericTest");
        this.sqlTest = new SQLOldTest();
    }

    public SQLOldTest getSQLOldTest() {
        return this.sqlTest;
    }

    public String getNodeServerGroup() {
        return this.nodeServerGroup;
    }

    public void setNodeServerGroup(String nodeServerGroup) {
        this.nodeServerGroup = nodeServerGroup;
    }

    @Override
    public void initialize() {
        this.doTestLevelConfiguration();
        this.doVMLevelConfiguration();
        this.doThreadLevelConfiguration();
    }

    public void doTestLevelConfiguration() {
        if (SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.testLevelConfiguration) == 1L) {
            Log.getLogWriter().info("Configuring global test level config.");
            if (SQLGenericPrms.hasServerGroups()) {
                this.sqlTest.initForServerGroup();
            }
        }
    }

    public synchronized void doVMLevelConfiguration() {
        if (!this.isVMInitialized.booleanValue()) {
            Log.getLogWriter().info("Configuring vm level config.");
            this.sqlTest.initialize();
            this.memberType = MemberType.getMemberType();
            Log.getLogWriter().info("Member type is " + (Object)((Object)this.memberType));
            if (SQLOldTest.hasDerbyServer) {
                this.derbyTest = new DerbyTest(this);
                Log.getLogWriter().info("Created DerbyTest ");
            }
            if (SQLGenericPrms.isHA()) {
                Log.getLogWriter().info("HA is enabled in the tests, configuring PRObserver");
                PRObserver.installObserverHook();
                PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            }
        }
    }

    public void doThreadLevelConfiguration() {
        Log.getLogWriter().info("Configuring thread level config.");
    }

    @Override
    public MemberType getMemberType() {
        return this.memberType;
    }

    @Override
    public void beforeFabricServer() {
        if (SQLGenericPrms.hasServerGroups()) {
            this.nodeServerGroup = this.sqlTest.getSGForNode();
        }
    }

    @Override
    public void startFabricServer() {
        Log.getLogWriter().info("Starting the fabric server");
        Properties p = FabricServerHelper.getBootProperties();
        if (this.nodeServerGroup != null && !this.nodeServerGroup.equals("default")) {
            p.setProperty("server-groups", this.nodeServerGroup);
        }
        this.sqlTest.startFabricServer(p);
    }

    @Override
    public void afterFabricServer() {
    }

    @Override
    public void createGfxdLocator() {
        SQLOldTest.isLocator = true;
        FabricServerHelper.createLocator();
    }

    @Override
    public void startGfxdLocator() {
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        FabricServerHelper.startLocator(networkServerConfig);
    }

    @Override
    public void createDerbyDB() {
        if (SQLOldTest.hasDerbyServer) {
            this.derbyTest.createDiscDB();
        }
    }

    @Override
    public void createDerbySchemas() {
        if (SQLOldTest.hasDerbyServer) {
            this.derbyTest.createDiscSchemas();
        }
    }

    @Override
    public void createDerbyTables() {
        if (SQLOldTest.hasDerbyServer) {
            this.derbyTest.createDiscTables();
        }
    }

    @Override
    public void createDiskStores() {
        this.sqlTest.createDiskStores();
    }

    @Override
    public void createGFESchemas() {
        this.sqlTest.createGFESchemas();
    }

    @Override
    public void createGFETables() {
        this.sqlTest.createGFETables();
    }

    @Override
    public void populateTables() {
        this.sqlTest.populateTables();
    }

    @Override
    public void doDMLOp() {
        this.sqlTest.doDMLOp();
    }

    @Override
    public void cycleStoreVms() {
        this.sqlTest.cycleStoreVms();
    }

    @Override
    public void verifyResultSets() {
        this.sqlTest.verifyResultSets();
    }

    @Override
    public void shutDownAllFabricServers() {
        this.sqlTest.shutDownAllFabricServers();
    }

    @Override
    public void createView() {
        if (SQLGenericPrms.hasView()) {
            this.sqlTest.createViews();
        }
    }

    @Override
    public void populateViewTables() {
        if (SQLGenericPrms.hasView()) {
            this.sqlTest.populateViewTables();
        }
    }

    @Override
    public void queryViews() {
        if (SQLGenericPrms.hasView()) {
            this.sqlTest.queryViews();
        }
    }

    @Override
    public void verifyViews() {
        if (SQLGenericPrms.hasView()) {
            this.sqlTest.verifyViews();
        }
    }

    @Override
    public void createIndex() {
        this.sqlTest.createIndex();
    }

    @Override
    public void callProcedures() {
        this.sqlTest.callProcedures();
    }

    @Override
    public void createProcedures() {
        this.sqlTest.callProcedures();
    }

    @Override
    public void createFunctions() {
        this.sqlTest.createFunctions();
    }

    @Override
    public void doDDLOp() {
        this.sqlTest.doDDLOp();
    }
}

