/*
 * Decompiled with CFR 0.152.
 */
package sql.generic;

import com.gemstone.gemfire.LogWriter;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.datagen.DataGeneratorBB;
import sql.datagen.DataGeneratorHelper;
import sql.generic.GenericBBHelper;
import sql.generic.SQLGenericPrms;
import sql.generic.SqlUtilityHelper;
import sql.generic.ddl.Executor;
import sql.generic.ddl.Functions.FunctionTest;
import sql.generic.ddl.SchemaInfo;
import sql.generic.ddl.alter.GenericAlterDDL;
import sql.generic.ddl.create.CreateTableTest;
import sql.generic.ddl.create.DDLStmtFactory;
import sql.generic.ddl.create.DDLStmtIF;
import sql.generic.ddl.procedures.GeneralProcedure;
import sql.generic.dmlstatements.GenericDML;
import sql.sqlutil.ResultSetHelper;
import sql.view.ViewPrms;
import util.TestException;
import util.TestHelper;

public class SQLOldTest
extends SQLTest {
    public LogWriter log = Log.getLogWriter();
    public static final Random random = new Random(SQLPrms.getRandSeed());
    protected static DDLStmtFactory ddlFactory = new DDLStmtFactory();
    protected static int[] ddls = SQLGenericPrms.getDDLs();
    public String[] tableNames = SQLPrms.getTableNames();
    public CreateTableTest createTable = new CreateTableTest(this);
    public String mapper = this.getMapperFileAbsolutePath();
    public static final String FuncProcMap = "FuncProcMap";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void initForServerGroup() {
        super.initForServerGroup();
    }

    @Override
    public String getSGForNode() {
        return super.getSGForNode();
    }

    @Override
    public void createDiskStores() {
        super.createDiskStores();
    }

    @Override
    public void createDBSynchronizer() {
        super.createDBSynchronizer();
    }

    @Override
    public void startDBSynchronizer() {
        super.startDBSynchronizer();
    }

    @Override
    public void putLastKeyDBSynchronizer() {
        super.putLastKeyDBSynchronizer();
    }

    @Override
    public void verifyResultSetsDBSynchronizer() {
        super.verifyResultSetsDBSynchronizer();
    }

    @Override
    public void shutDownAllFabricServers() {
        super.shutDownAllFabricServers();
    }

    @Override
    public Connection getHdfsQueryConnection() {
        return super.getHdfsQueryConnection();
    }

    @Override
    public void populateTables() {
        Connection dConn = hasDerbyServer ? this.getDiscConnection() : null;
        Connection gConn = this.getGFEConnection();
        this.populateTables(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    @Override
    public void doDMLOp() {
        if (networkPartitionDetectionEnabled) {
            this.doDMLOp_HandlePartition();
        } else {
            Connection dConn = null;
            if (hasDerbyServer) {
                dConn = this.getDiscConnection();
            }
            Connection gConn = this.getHdfsQueryConnection();
            if (useGenericSQL) {
                sqlGen.doDMLOp(dConn, gConn);
            } else {
                this.doDMLOp(dConn, gConn);
            }
            if (dConn != null) {
                this.closeDiscConnection(dConn);
            }
            this.closeGFEConnection(gConn);
        }
        Log.getLogWriter().info("done dmlOp");
    }

    @Override
    public void verifyResultSets() {
        super.verifyResultSets();
    }

    private String getMapperFileAbsolutePath() {
        String mPath = System.getProperty("JTESTS") + "/" + TestConfig.tab().stringAt(SQLGenericPrms.mapperFile, null);
        return mPath;
    }

    @Override
    public void createGFESchemas() {
        ddlThread = this.getMyTid();
        Connection conn = this.getGFEConnection();
        Log.getLogWriter().info("testServerGroupsInheritence is set to " + testServerGroupsInheritence);
        Log.getLogWriter().info("creating schemas in gfe.");
        if (!testServerGroupsInheritence) {
            String[] schemas = SQLPrms.getSchemas();
            this.createSchemas(conn, schemas);
            for (String s : schemas) {
                StringTokenizer tokens = new StringTokenizer(s);
                tokens.nextToken();
                tokens.nextToken();
                String schemaName = tokens.nextToken();
                SchemaInfo schemaInfo = new SchemaInfo(schemaName);
                GenericBBHelper.putSchemaInfo(schemaInfo);
                Log.getLogWriter().info("Created schema info " + schemaInfo);
            }
        } else {
            String[] schemas = SQLPrms.getGFESchemas();
            this.createSchemas(conn, schemas);
            for (String s : schemas) {
                StringTokenizer tokens = new StringTokenizer(s);
                tokens.nextToken();
                tokens.nextToken();
                String schemaName = tokens.nextToken();
                SchemaInfo schemaInfo = new SchemaInfo(schemaName);
                if (s.indexOf("(") > 0) {
                    String serverGroup = s.substring(s.indexOf("(") + 1, s.indexOf(")"));
                    schemaInfo.setServerGroup(serverGroup);
                }
                GenericBBHelper.putSchemaInfo(schemaInfo);
                Log.getLogWriter().info("Created schema info " + schemaInfo);
            }
        }
        Log.getLogWriter().info("done creating schemas in gfe.");
        this.closeGFEConnection(conn);
    }

    @Override
    public void createGFETables() {
        Connection conn = this.getGFEConnection();
        if (random.nextBoolean()) {
            Log.getLogWriter().info("dropping tables in gfe.");
            this.createTable.dropTables(conn);
            Log.getLogWriter().info("done dropping tables in gfe");
        }
        this.executeListener("CLOSE", "PRINT_CONN");
        Log.getLogWriter().info("creating tables in gfe.");
        this.createTable.createGFETables(conn);
        Log.getLogWriter().info("done creating tables in gfe.");
        int[] rowCounts = SQLPrms.getInitialRowCountToPopulateTable();
        DataGeneratorHelper.initDataGenerator(this.mapper, this.tableNames, rowCounts, this.getGFEConnection());
        this.closeGFEConnection(conn);
    }

    @Override
    public void populateTables(Connection dConn, Connection gConn) {
        int totalThreads = SqlUtilityHelper.totalTaskThreads();
        int ttgid = SqlUtilityHelper.ttgid();
        for (int i = 0; i < this.tableNames.length; ++i) {
            if (ttgid % totalThreads != totalThreads - 1 || SqlUtilityHelper.getRowsInTable(this.tableNames[i], gConn) > 0) continue;
            this.populateTables(this.tableNames[i], dConn, gConn);
        }
    }

    private void populateTables(String fullTableName, Connection dConn, Connection gConn) {
        String[] names = fullTableName.trim().split("\\.");
        String schemaName = names[0];
        String tableName = names[1];
        String csvFilePath = DataGeneratorBB.getCSVFileName(fullTableName);
        this.importTablesToGfxd(gConn, schemaName, tableName, csvFilePath);
        if (hasDerbyServer && dConn != null) {
            this.importTablesToDerby(dConn, schemaName, tableName, csvFilePath);
        }
    }

    protected void importTablesToGfxd(Connection conn, String schema, String table, String csvPath) {
        Log.getLogWriter().info("Gfxd - Data Population Started for " + schema + "." + table + " using " + csvPath);
        String delimitor = ",";
        String procedure = "sql.datagen.ImportOraDG";
        String importTable = "CALL SYSCS_UTIL.IMPORT_DATA_EX(?, ?, null,null, ?, ?, NULL, NULL, 0, 0, 10, 0, ?, null)";
        try {
            CallableStatement cs = conn.prepareCall(importTable);
            cs.setString(1, schema.toUpperCase());
            cs.setString(2, table.toUpperCase());
            cs.setString(3, csvPath);
            cs.setString(4, delimitor);
            cs.setString(5, procedure);
            cs.execute();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        Log.getLogWriter().info("Gfxd - Data Population Completed for " + schema + "." + table);
    }

    protected void importTablesToDerby(Connection conn, String schema, String table, String csvPath) {
        Log.getLogWriter().info("Derby - Data Population Started for " + schema + "." + table + " using " + csvPath);
        String delimitor = ",";
        String importTable = "CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE (?, ?, ?, ?, null, null, 0)";
        try {
            CallableStatement cs = conn.prepareCall(importTable);
            cs.setString(1, schema.toUpperCase());
            cs.setString(2, table.toUpperCase());
            cs.setString(3, csvPath);
            cs.setString(4, delimitor);
            cs.execute();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        Log.getLogWriter().info("Derby - Data Population Completed for " + schema + "." + table);
    }

    @Override
    public void doDMLOp(Connection dConn, Connection gConn) {
        try {
            GenericDML dmlOps = new GenericDML(SQLGenericPrms.getAnyDMLGroup(), dConn, gConn);
            dmlOps.execute();
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    public void alterTable() {
        GenericAlterDDL genericAlterDDL = hasDerbyServer ? new GenericAlterDDL(SQLGenericPrms.getAnyAlterDDL(), this.getDiscConnection(), this.getGFEConnection()) : new GenericAlterDDL(SQLGenericPrms.getAnyAlterDDL(), this.getGFEConnection());
        genericAlterDDL.executeDDL();
    }

    public void createProcedures(boolean client) {
        Log.getLogWriter().info("performing create procedure Op, myTid is " + this.getMyTid());
        Connection dConn = null;
        Connection gConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        gConn = client ? this.getGFXDClientConnection() : this.getGFEConnection();
        this.createProcedures(dConn, gConn);
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void createProcedures(Connection dConn, Connection gConn) {
        ArrayList<String> procedures = SQLGenericPrms.getProcedureNames();
        String prefix = "sql.generic.ddl.procedures.";
        String procedureName = "";
        for (String procName : procedures) {
            try {
                procedureName = prefix + procName.trim();
                Class<?> proc = Class.forName(procedureName);
                GeneralProcedure procedure = (GeneralProcedure)proc.newInstance();
                procedure.setExecutor(new Executor(dConn, gConn));
                procedure.createProcedures();
            }
            catch (ClassNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
            catch (IllegalAccessException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
            catch (InstantiationException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
        }
    }

    public void createFunctions() {
        boolean client = false;
        Log.getLogWriter().info("call procedures, myTid is " + this.getMyTid());
        Connection dConn = null;
        Connection gConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        gConn = client ? this.getGFXDClientConnection() : this.getGFEConnection();
        this.createFunctions(dConn, gConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    protected void createFunctions(Connection dConn, Connection gConn) {
        ArrayList<String> functions = SQLGenericPrms.getFunctionNames();
        String prefix = "sql.generic.ddl.Functions.";
        for (String functionName : functions) {
            try {
                functionName = prefix + functionName.trim();
                Class<?> function = Class.forName(functionName);
                FunctionTest currentFunction = (FunctionTest)function.newInstance();
                currentFunction.setExecutor(new Executor(dConn, gConn));
                currentFunction.createDDL();
            }
            catch (ClassNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
            catch (IllegalAccessException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
            catch (InstantiationException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
        }
    }

    @Override
    public void callProcedures() {
        boolean client = false;
        Log.getLogWriter().info("call procedures, myTid is " + this.getMyTid());
        Connection dConn = null;
        Connection gConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        gConn = client ? this.getGFXDClientConnection() : this.getGFEConnection();
        this.callProcedures(dConn, gConn);
        if (hasDerbyServer) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
    }

    @Override
    public void callProcedures(Connection dConn, Connection gConn) {
        String prefix = "sql.generic.ddl.procedures.";
        String procedureName = SQLGenericPrms.getAnyProcedure().trim();
        int loc = SQLGenericPrms.getProcedureNames().indexOf(procedureName);
        try {
            Class<?> proc = Class.forName(prefix + procedureName);
            GeneralProcedure procedure = (GeneralProcedure)proc.newInstance();
            procedure.setExecutor(new Executor(dConn, gConn), loc);
            procedure.callProcedure();
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
        catch (InstantiationException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    @Override
    protected void doDDLOp() {
        Connection dConn = null;
        Connection gConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        gConn = this.getGFEConnection();
        int ddl = ddls[random.nextInt(ddls.length)];
        DDLStmtIF ddlStmt = ddlFactory.createDDLStmt(ddl);
        ddlStmt.setExecutor(new Executor(dConn, gConn));
        ddlStmt.doDDLOp();
        this.commit(dConn);
        this.commit(gConn);
    }

    @Override
    public void createIndex() {
        Connection gConn = this.getGFEConnection();
        this.createIndex(gConn);
        this.commit(gConn);
        this.closeGFEConnection(gConn);
    }

    @Override
    protected void createIndex(Connection gConn) {
        DDLStmtIF ddlStmt = ddlFactory.createDDLStmt(5);
        ddlStmt.setExecutor(new Executor(null, gConn));
        ddlStmt.doDDLOp();
    }

    @Override
    public void cycleStoreVms() {
        if (SQLGenericPrms.isHA()) {
            super.cycleStoreVms();
        } else {
            int sleepMS = 10000;
            MasterController.sleepForMs((int)sleepMS);
        }
    }

    public void createViews() {
        Connection conn;
        String viewDDLPath = ViewPrms.getViewDDLFilePath();
        if (hasDerbyServer) {
            conn = this.getDiscConnection();
            Log.getLogWriter().info("creating views on disc using sql script: " + viewDDLPath);
            SQLHelper.runDerbySQLScript(conn, viewDDLPath, true);
            Log.getLogWriter().info("done creating views on disc.");
            this.closeDiscConnection(conn);
        }
        conn = this.getGFEConnection();
        Log.getLogWriter().info("creating views in gfxd using sql script: " + viewDDLPath);
        SQLHelper.runSQLScript(conn, viewDDLPath, true);
        Log.getLogWriter().info("done creating views in gfxd.");
        this.closeGFEConnection(conn);
    }

    public void populateViewTables() {
        Connection conn;
        String viewDataPath = ViewPrms.getViewDataFilePath();
        if (hasDerbyServer) {
            conn = this.getDiscConnection();
            Log.getLogWriter().info("Populating view base tables in disc using sql script: " + viewDataPath);
            SQLHelper.runDerbySQLScript(conn, viewDataPath, true);
            Log.getLogWriter().info("done populating view base tables in disc.");
            this.closeDiscConnection(conn);
        }
        conn = this.getGFEConnection();
        Log.getLogWriter().info("Populating view base tables in gfxd using sql script: " + viewDataPath);
        SQLHelper.runSQLScript(conn, viewDataPath, true);
        Log.getLogWriter().info("done populating view base tables in gfxd.");
        this.closeGFEConnection(conn);
    }

    public void queryViews() {
        HydraVector queryVec = ViewPrms.getQueryViewsStatements();
        String viewQuery = (String)queryVec.get(random.nextInt(queryVec.size()));
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        this.queryResultSets(dConn, gConn, viewQuery, false);
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    public void verifyViews() {
        HydraVector queryVec = ViewPrms.getQueryViewsStatements();
        Connection dConn = this.getDiscConnection();
        Connection gConn = this.getGFEConnection();
        for (int i = 0; i < queryVec.size(); ++i) {
            String viewQuery = (String)queryVec.get(i);
            this.queryResultSets(dConn, gConn, viewQuery, true);
        }
        this.closeDiscConnection(dConn);
        this.closeGFEConnection(gConn);
    }

    protected void queryResultSets(Connection dConn, Connection gConn, String queryStr, boolean verify) {
        try {
            Log.getLogWriter().info("Query view: " + queryStr);
            ResultSet dRS = dConn.createStatement().executeQuery(queryStr);
            ResultSet gRS = gConn.createStatement().executeQuery(queryStr);
            if (verify) {
                ResultSetHelper.compareResultSets(dRS, gRS);
            }
            this.commit(dConn);
            this.commit(gConn);
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("0A000")) {
                Log.getLogWriter().info("Ignoring " + queryStr + " as got " + se.getMessage());
            }
            SQLHelper.handleSQLException(se);
        }
    }
}

