/*
 * Decompiled with CFR 0.152.
 */
package sql.generic;

import hydra.HydraVector;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.TestTask;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sql.SQLPrms;
import sql.generic.SQLOldTest;
import sql.generic.ddl.Executor;
import sql.generic.dmlstatements.GenerateLikeExpression;
import util.TestException;
import util.TestHelper;

public class SqlUtilityHelper {
    public static List<String> getMatchedPattern(String stmt, String regEx) {
        ArrayList<String> matchedPattern = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(stmt);
        while (matcher.find()) {
            matchedPattern.add(matcher.group().toLowerCase().replaceAll("::", "").trim().replaceAll("\\s+", " "));
        }
        return matchedPattern;
    }

    public static String getTableName(String columnNameWithRelationShip) {
        String[] split = columnNameWithRelationShip.split("\\(");
        String[] splitString = split.length > 1 ? split[1].trim().split("\\.") : split[0].split("\\.");
        return (splitString.length > 2 ? splitString[splitString.length - 3] + "." + splitString[splitString.length - 2] : splitString[splitString.length - 2]).toLowerCase().replaceFirst("::", "").replace(")", "");
    }

    public static String getTableNameWithoutSchema(String tableNameWithSchema) {
        return tableNameWithSchema.trim().split("\\.")[1];
    }

    public static String getSchemaFromTableName(String tableNameWithSchema) {
        return tableNameWithSchema.trim().split("\\.")[0];
    }

    public static String getColumnName(String columnNameWithRelationShip, boolean fullQualifiedName) {
        String[] columnNameWoRelationship = columnNameWithRelationShip.trim().split("[<>!$\\[]");
        if (columnNameWoRelationship[0].toLowerCase().contains("substr")) {
            columnNameWoRelationship[0] = GenerateLikeExpression.getLikeColumnName(columnNameWoRelationship[0]);
        }
        String[] splitString = columnNameWoRelationship[0].split("\\.");
        if (fullQualifiedName) {
            return (SqlUtilityHelper.getTableName(columnNameWoRelationship[0]) + "." + splitString[splitString.length - 1]).toLowerCase().replaceAll("::", "").trim();
        }
        return splitString[splitString.length - 1].trim().toLowerCase();
    }

    public static String getRandomString(int length) {
        String mystr = "";
        int start = 97;
        int end = 122;
        int charLength = SQLOldTest.random.nextInt(length) + 3;
        while (mystr.length() < charLength) {
            mystr = mystr + (char)((int)(SQLOldTest.random.nextDouble() * (double)(end - start + 1)) + start);
        }
        return mystr;
    }

    public static int getRelativeColumnName(String columnName) {
        String relativeName = columnName.substring(columnName.indexOf("$") + 1).trim();
        return Integer.parseInt(relativeName) - 1;
    }

    public static int tid() {
        return RemoteTestModule.getCurrentThread().getThreadId();
    }

    public static int tgid() {
        return RemoteTestModule.getCurrentThread().getThreadGroupId();
    }

    public static int ttgid() {
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        return task.getTaskThreadGroupId(tgname, SqlUtilityHelper.tgid());
    }

    public static int totalTaskThreads() {
        return RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
    }

    public static String[] getTableNames() {
        HydraVector tables = TestConfig.tasktab().vecAt(SQLPrms.dmlTables, TestConfig.tab().vecAt(SQLPrms.dmlTables, new HydraVector()));
        String[] strArr = new String[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            strArr[i] = ((String)tables.elementAt(i)).toUpperCase();
        }
        return strArr;
    }

    public static String getRandomTableName() {
        String[] tables = SqlUtilityHelper.getTableNames();
        int loc = SQLOldTest.random.nextInt(tables.length - 1);
        return tables[loc];
    }

    public static int getRowsInTable(String tableName, Connection conn) {
        String query = "select count(*)  from " + tableName;
        Executor executor = new Executor(conn);
        try {
            ResultSet rs = executor.executeQuery(query);
            if (rs.next()) {
                return rs.getInt(1);
            }
            return 0;
        }
        catch (SQLException se) {
            throw new TestException(TestHelper.getStackTrace((Throwable)se));
        }
    }
}

