/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.dbsync;

import hydra.ClientVmInfo;
import hydra.Log;
import hydra.RemoteTestModule;
import java.sql.Connection;
import sql.SQLBB;
import sql.SQLTest;
import sql.generic.MemberType;
import sql.generic.SQLGenericTest;
import sql.generic.SQLOldTest;
import sql.generic.SQLTestDecorator;
import sql.generic.SQLTestable;

public class SQLDBSyncTest
extends SQLTestDecorator {
    public SQLDBSyncTest(SQLTestable sqlTest) {
        super(sqlTest);
    }

    @Override
    public void beforeFabricServer() {
        super.beforeFabricServer();
        if (this.sqlTest.getMemberType().equals((Object)MemberType.DBsyncDatastore)) {
            this.setClientVmInfoForDBSynchronizerNode();
            String sg = ((SQLGenericTest)this.sqlTest).getNodeServerGroup();
            sg = sg == null ? SQLTest.sgDBSync : "," + SQLTest.sgDBSync;
            ((SQLGenericTest)this.sqlTest).setNodeServerGroup(sg);
            Log.getLogWriter().info("Configured server-group = " + sg);
        }
    }

    protected void setClientVmInfoForDBSynchronizerNode() {
        ClientVmInfo target = new ClientVmInfo(RemoteTestModule.getMyVmid());
        int num = (int)SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.asynchDBTargetVm);
        if (num == 1) {
            SQLBB.getBB().getSharedMap().put((Object)"asyncDBTarget1", (Object)target);
            Log.getLogWriter().info("asyncDBTarget1: client vmID is " + target.getVmid());
        } else {
            ClientVmInfo target1 = (ClientVmInfo)SQLBB.getBB().getSharedMap().get((Object)"asyncDBTarget1");
            if (target1 != null && target1.getVmid() == RemoteTestModule.getMyVmid()) {
                SQLBB.getBB().getSharedMap().put((Object)"asyncDBTarget1", (Object)target);
                Log.getLogWriter().info("asyncDBTarget1: client vmID is " + target.getVmid());
            } else {
                SQLBB.getBB().getSharedMap().put((Object)"asyncDBTarget2", (Object)target);
                Log.getLogWriter().info("asyncDBTarget2: client vmID is " + target.getVmid());
            }
        }
    }

    public void createDBSynchronizer() {
        ((SQLGenericTest)this.sqlTest).getSQLOldTest().createDBSynchronizer();
    }

    public void startDBSynchronizer() {
        ((SQLGenericTest)this.sqlTest).getSQLOldTest().startDBSynchronizer();
    }

    public void putLastKeyDBSynchronizer() {
        ((SQLGenericTest)this.sqlTest).getSQLOldTest().putLastKeyDBSynchronizer();
    }

    @Override
    public void verifyResultSets() {
        ((SQLGenericTest)this.sqlTest).getSQLOldTest().verifyResultSetsDBSynchronizer();
    }

    @Override
    public void populateTables() {
        Connection gConn = ((SQLGenericTest)this.sqlTest).getSQLOldTest().getGFEConnection();
        ((SQLGenericTest)this.sqlTest).getSQLOldTest().populateTables(null, gConn);
        ((SQLGenericTest)this.sqlTest).getSQLOldTest().closeGFEConnection(gConn);
    }

    @Override
    public void doDMLOp() {
        SQLOldTest test = ((SQLGenericTest)this.sqlTest).getSQLOldTest();
        if (SQLTest.networkPartitionDetectionEnabled) {
            test.doDMLOp_HandlePartition();
        } else {
            Connection gConn = test.getHdfsQueryConnection();
            test.doDMLOp(null, gConn);
            test.closeGFEConnection(gConn);
        }
        Log.getLogWriter().info("done dmlOp");
    }
}

