/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.generic.SqlUtilityHelper;
import sql.generic.ddl.CheckConstraint;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.ConstraintInfoHolder;
import sql.generic.ddl.Executor;
import sql.generic.ddl.GenericTableInfoObjectFetcher;
import sql.generic.ddl.TableInfo;
import util.TestException;
import util.TestHelper;

public class CheckInfoObjectFetcher
extends GenericTableInfoObjectFetcher {
    List<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
    String constraintName;
    Connection conn;
    Executor executor;
    String tableName;
    String schemaName;

    CheckInfoObjectFetcher(TableInfo tableInfo, Executor executor, ConstraintInfoHolder constraintInfo) {
        super(tableInfo, executor, constraintInfo);
        this.conn = executor.getConnection();
        this.executor = executor;
        this.tableName = SqlUtilityHelper.getTableNameWithoutSchema(tableInfo.getFullyQualifiedTableName()).toUpperCase();
        this.schemaName = SqlUtilityHelper.getSchemaFromTableName(tableInfo.getFullyQualifiedTableName()).toUpperCase();
    }

    @Override
    public void fetch() {
        try {
            String query = "select  CONSTRAINTNAME, REFERENCEDCOLUMNS , CHECKDEFINITION , TABLESCHEMANAME , TABLENAME   from sys.sysconstraints , sys.syschecks , sys.systables  ";
            String where = " where type='C' and sys.syschecks.CONSTRAINTId= sys.sysconstraints.CONSTRAINTID and sys.sysconstraints.TABLEID = sys.systables.TABLEID ";
            where = where + " and TABLENAME = ? and TABLESCHEMANAME =? order by CONSTRAINTNAME";
            query = query + where;
            String prevConstraintName = " ";
            ArrayList<Object> params = new ArrayList<Object>();
            ArrayList<ColumnInfo> checkColumns = new ArrayList<ColumnInfo>();
            params.add(this.tableName);
            params.add(this.schemaName);
            boolean checkConstraint = false;
            boolean constraintAdded = false;
            String constraintName = "";
            String definition = "";
            String prevDefinition = "";
            ResultSet rs = this.executor.executeQuery(query, params);
            ArrayList<CheckConstraint> checkConstraintList = new ArrayList<CheckConstraint>();
            while (rs.next()) {
                checkConstraint = true;
                definition = rs.getString("CHECKDEFINITION");
                String refColumns = rs.getString("REFERENCEDCOLUMNS");
                constraintName = rs.getString("CONSTRAINTNAME");
                String[] columnList = refColumns.replace("(", "").replace(")", "").split(",");
                if (!prevConstraintName.equals(" ") && prevConstraintName != constraintName) {
                    checkConstraintList.add(new CheckConstraint(this.tableInfo.tableName, prevConstraintName, checkColumns, prevDefinition));
                    checkColumns = new ArrayList();
                    constraintAdded = true;
                }
                for (String columnPlace : columnList) {
                    checkColumns.add(this.tableInfo.getColumnList().get(Integer.parseInt(columnPlace) - 1));
                }
                prevConstraintName = constraintName;
                constraintAdded = false;
                prevDefinition = definition;
            }
            if (checkConstraint && !constraintAdded) {
                checkConstraintList.add(new CheckConstraint(this.tableInfo.tableName, constraintName, checkColumns, definition));
            }
            this.tableInfo.setCheckconstraints(checkConstraintList);
            ArrayList<String> list = new ArrayList<String>(this.constraintInfo.getTablesWithCheckConstraint());
            if (checkConstraintList.size() > 0 && !list.contains(this.tableInfo.getFullyQualifiedTableName())) {
                list.add(this.tableInfo.getFullyQualifiedTableName());
            } else if (checkConstraintList.size() == 0 && list.contains(this.tableInfo.getFullyQualifiedTableName())) {
                list.remove(this.tableInfo.getFullyQualifiedTableName());
            }
            this.constraintInfo.setTablesWithCheckConstraint(list);
        }
        catch (SQLException se) {
            throw new TestException("Error while retrieving the check key information " + TestHelper.getStackTrace((Throwable)se));
        }
    }
}

