/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.ColumnValuesGenerator;
import sql.generic.ddl.ConstraintInfoHolder;
import sql.generic.ddl.Executor;
import sql.generic.ddl.GenericTableInfoObjectFetcher;
import sql.generic.ddl.TableInfo;
import util.TestException;
import util.TestHelper;

public class ColumnInfoObjectFetcher
extends GenericTableInfoObjectFetcher {
    List<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
    ColumnValuesGenerator valueGenerator = new ColumnValuesGenerator(this.executor);
    String FullyQualifiedTableName;
    String fullyQualifiedColumnName;

    public ColumnInfoObjectFetcher(TableInfo tableInfo, Executor executor, ConstraintInfoHolder constraintInfo) {
        super(tableInfo, executor, constraintInfo);
    }

    @Override
    public void fetch() {
        try {
            ResultSet rs = this.executor.getConnection().getMetaData().getColumns(null, this.tableInfo.getSchemaName(), this.tableInfo.getTableName(), null);
            this.FullyQualifiedTableName = this.tableInfo.getFullyQualifiedTableName().toUpperCase();
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                int columnType = rs.getInt("DATA_TYPE");
                int columnSize = rs.getInt("COLUMN_SIZE");
                boolean isNull = rs.getInt("NULLABLE") != 0;
                this.fullyQualifiedColumnName = this.FullyQualifiedTableName + "." + columnName;
                this.columnList.add(new ColumnInfo(columnName, columnType, columnSize, isNull, this.valueGenerator.getValueList(this.fullyQualifiedColumnName, columnType, columnSize)));
            }
            this.tableInfo.setColumnList(this.columnList);
            rs.close();
        }
        catch (SQLException se) {
            throw new TestException("Error while retrieving the column information " + TestHelper.getStackTrace((Throwable)se));
        }
    }
}

