/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl;

import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import sql.datagen.FKMappedColumn;
import sql.datagen.MappedColumnInfo;
import sql.datagen.Mapper;
import sql.datagen.ValueListMappedColumn;
import sql.generic.GenericBBHelper;
import sql.generic.SQLGenericPrms;
import sql.generic.SQLOldTest;
import sql.generic.SqlUtilityHelper;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.Executor;
import sql.generic.ddl.TableInfo;
import util.TestException;
import util.TestHelper;

public class ColumnValuesGenerator {
    HashMap<String, MappedColumnInfo> columnNameMapping;

    ColumnValuesGenerator(Executor executor) {
        try {
            String mapperFile = System.getProperty("JTESTS") + "/" + TestConfig.tab().stringAt(SQLGenericPrms.mapperFile, null);
            Mapper mapper = Mapper.getMapper();
            mapper.parseMapperFile(mapperFile, executor.getConnection());
            this.columnNameMapping = mapper.getColumnNameMapping();
        }
        catch (Exception e) {
            throw new TestException(e.getMessage() + " " + TestHelper.getStackTrace((Throwable)e));
        }
    }

    public boolean columnExistInMapper(String columnName) {
        return this.columnNameMapping.get(columnName) != null;
    }

    public List<Object> getValueList(String columnName, int columnType, int defaultSize) {
        List<Object> valueList;
        TableInfo tableInfo = GenericBBHelper.getTableInfo(SqlUtilityHelper.getTableName(columnName));
        if (tableInfo != null) {
            ColumnInfo columnInfo = tableInfo.getColumn(columnName);
            return columnInfo.getValueList();
        }
        if (this.columnExistInMapper(columnName)) {
            valueList = this.getValueList(columnName, columnType);
        } else {
            int min;
            int max = SQLOldTest.random.nextInt(defaultSize);
            if (max <= 0) {
                max = 1;
            }
            if ((min = SQLOldTest.random.nextInt(max)) <= 0) {
                min = 1;
            }
            valueList = this.generateValueListBasedOntype(columnType, min, max);
        }
        return valueList;
    }

    List<Object> getValueList(String columnName, int columnType) {
        MappedColumnInfo obj = this.columnNameMapping.get(columnName);
        if (obj instanceof ValueListMappedColumn) {
            return this.getColumnValueList(columnName, columnType);
        }
        if (obj instanceof FKMappedColumn) {
            return this.getFKColumnValueList(columnName, columnType);
        }
        return this.getColumnRandomValueList(columnName, columnType);
    }

    List<Object> getColumnRandomValueList(String columnName, int columnType) {
        MappedColumnInfo column = this.columnNameMapping.get(columnName);
        int start = column.getMinLen();
        int end = column.getMaxLen();
        if (end <= 0) {
            end = start;
        }
        return this.generateValueListBasedOntype(columnType, start, end);
    }

    public List<Object> generateValueListBasedOntype(int sqlType, int start, int end) {
        if (sqlType == -5 || sqlType == 5 || sqlType == 2 || sqlType == 4) {
            return this.generateListNumericValues(start, end);
        }
        if (sqlType == 3) {
            return this.generateListDecimalValues(start, end);
        }
        if (sqlType == 12) {
            return this.generateListStringValues(start, end);
        }
        if (sqlType == 1) {
            return this.generateListCharValues();
        }
        if (sqlType == 91) {
            return this.generateListDateValues();
        }
        if (sqlType == 92 || sqlType == 93) {
            return this.generateListTimestampValues();
        }
        if (sqlType == -7 || sqlType == 16) {
            ArrayList<Object> valueList = new ArrayList<Object>();
            valueList.add(new Boolean(true));
            valueList.add(new Boolean(false));
            return valueList;
        }
        return new ArrayList<Object>();
    }

    List<Object> getColumnValueList(String columnName, int columnType) {
        ValueListMappedColumn generic = (ValueListMappedColumn)this.columnNameMapping.get(columnName);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : generic.getValueList()) {
            list.add(obj);
        }
        this.getSortedList(list);
        return list;
    }

    List<Object> getFKColumnValueList(String columnName, int columnType) {
        FKMappedColumn generic = (FKMappedColumn)this.columnNameMapping.get(columnName);
        return this.getValueList(generic.getFullFkParentColumn(), columnType, 1);
    }

    List<Object> getStringValueList(String columnName, String targetColumn, int columnType) {
        return this.getValueList(targetColumn, columnType);
    }

    public List<Object> generateListTimestampValues() {
        ArrayList<Object> valueList = new ArrayList<Object>();
        while (valueList.size() < 20) {
            valueList.add(this.generateTimestamp());
        }
        this.getSortedList(valueList);
        return valueList;
    }

    public List<Object> generateListDateValues() {
        ArrayList<Object> valueList = new ArrayList<Object>();
        while (valueList.size() < 20) {
            valueList.add(this.generateDate());
        }
        this.getSortedList(valueList);
        return valueList;
    }

    public List<Object> generateListNumericValues(int start, int end) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        Long startRange = this.getStartRange(start);
        Long endRange = this.getEndRange(end);
        this.generateNumberRange(startRange, endRange, valueList);
        this.getSortedList(valueList);
        return valueList;
    }

    public List<Object> generateListDecimalValues(int start, int end) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        while (valueList.size() < 20) {
            valueList.add(this.getDecimalNumber(start, end));
        }
        this.getSortedList(valueList);
        return valueList;
    }

    public List<Object> generateListCharValues() {
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (int ch = 0; ch <= 255; ++ch) {
            valueList.add(Character.valueOf((char)ch));
        }
        return valueList;
    }

    List<Object> generateListStringValues(int start, int end) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        this.generateStringRange(start, end, valueList);
        this.getSortedList(valueList);
        return valueList;
    }

    List<Object> generateStringRange(int start, int end, List<Object> valueList) {
        while (valueList.size() < 20) {
            valueList.add(this.getRandomString((int)this.getRandomNumber(start, end)));
        }
        return valueList;
    }

    <T> void getSortedList(List<T> list) {
        TreeSet<T> set = new TreeSet<T>(list);
        list.clear();
        list.addAll(set);
    }

    String getRandomString(int charLength) {
        String mystr = "";
        int start = 65;
        int end = 122;
        while (mystr.length() < charLength) {
            mystr = mystr + (char)((int)(SQLOldTest.random.nextDouble() * (double)(end - start + 1)) + start);
        }
        return mystr;
    }

    Long getStartRange(int digits) {
        long digit = 1L;
        for (int count = 1; count < digits; ++count) {
            digit *= 10L;
        }
        return digit;
    }

    Long getEndRange(int digits) {
        String digit = "9";
        for (int count = 1; count < digits; ++count) {
            digit = digit + "9";
        }
        return Long.parseLong(digit);
    }

    void generateNumberRange(Long start, Long end, List<Object> valueList) {
        while (valueList.size() < 20) {
            long currentVal = (long)(SQLOldTest.random.nextDouble() * (double)(end - start + 1L)) + start;
            valueList.add(currentVal);
        }
        valueList.add(start);
        valueList.add(end);
    }

    BigDecimal getDecimalNumber(int start, int end) {
        String number = "";
        for (int currentVal = (int)this.getRandomNumber(start, end); currentVal > 0; --currentVal) {
            number = number + SQLOldTest.random.nextInt(9);
        }
        return new BigDecimal(number);
    }

    long getRandomNumber(long start, long end) {
        return (long)(SQLOldTest.random.nextDouble() * (double)(end - start + 1L)) + start;
    }

    protected Date generateDate() {
        SimpleDateFormat formatterTimestamp = new SimpleDateFormat(this.getFormatterTimestamp());
        java.util.Date baseDate = null;
        try {
            baseDate = formatterTimestamp.parse(this.getBaseTime());
        }
        catch (ParseException e) {
            throw new RuntimeException("Error is formating Date ", e);
        }
        double addOn = SQLOldTest.random.nextDouble() * 8.64E7 * 100.0;
        long newTime = baseDate.getTime() + (long)addOn;
        Date newDate = new Date(newTime);
        return newDate;
    }

    protected Timestamp generateTimestamp() {
        SimpleDateFormat formatterTimestamp = new SimpleDateFormat(this.getFormatterTimestamp());
        java.util.Date baseDate = null;
        try {
            baseDate = formatterTimestamp.parse(this.getBaseTime());
        }
        catch (ParseException e) {
            throw new TestException("Error is formating TimeStamp ", (Throwable)e);
        }
        double addOn = SQLOldTest.random.nextDouble() * 8.64E7 * 100.0;
        long newTime = baseDate.getTime() + (long)addOn;
        Timestamp newDate = new Timestamp(newTime);
        return newDate;
    }

    protected String timestampToString(Timestamp ts) {
        SimpleDateFormat formatterTimestamp = new SimpleDateFormat(this.getFormatterTimestamp());
        return formatterTimestamp.format(ts);
    }

    protected String getFormatterTimestamp() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    protected String getFormatterDate() {
        return "yyyy-MM-dd";
    }

    protected String getBaseTime() {
        return "2012-01-01 01:01:00";
    }
}

