/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl;

import java.util.List;
import sql.generic.GenericBBHelper;
import sql.generic.ddl.TableInfo;

public class CreateTableDDL {
    String tableName;
    TableInfo tableInfo;
    final String ddl;

    public CreateTableDDL(String fullyQualifiedtableName) {
        this.tableName = fullyQualifiedtableName.toUpperCase();
        this.tableInfo = GenericBBHelper.getTableInfo(this.tableName);
        this.ddl = this.createDDL();
    }

    public CreateTableDDL(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
        this.tableName = tableInfo.getTableName();
        this.ddl = this.createDDL();
    }

    public String createDDL() {
        List<String> asyncList;
        List<String> senders;
        StringBuffer sb = new StringBuffer();
        sb.append(this.tableInfo.getDerbyDDL()).append(" ");
        sb.append(this.tableInfo.getPartitioningClause()).append(" ");
        if (this.tableInfo.getServerGroups().length() > 0 && !this.tableInfo.getServerGroups().equalsIgnoreCase("default")) {
            String serverGroup = "SERVER GROUPS (" + this.tableInfo.getServerGroups() + ")";
            sb.append(serverGroup).append(" ");
        }
        if ((senders = this.tableInfo.getGatewaySenderList()) != null && senders.size() > 0) {
            String gateways = "";
            boolean first = true;
            for (String s : senders) {
                gateways = gateways + (first ? s : " , " + s);
            }
            sb.append("GATEWAYSENDER ( " + gateways + " )").append(" ");
        }
        if ((asyncList = this.tableInfo.getAsyncEventListnerList()) != null && asyncList.size() > 0) {
            String listners = "";
            boolean first = true;
            for (String s : asyncList) {
                listners = listners + (first ? s : " , " + s);
            }
            sb.append("ASYNCEVENTLISTENER ( " + listners + " )").append(" ");
        }
        String evictionClause = this.tableInfo.getEvictionClause();
        sb.append(evictionClause).append(" ");
        sb.append(this.tableInfo.getPersistClause()).append(" ");
        String hdfsClause = this.tableInfo.getHdfsClause();
        sb.append(hdfsClause).append(" ");
        if (this.tableInfo.isOffHeap) {
            sb.append("OFFHEAP ");
        }
        return sb.toString();
    }

    public String getDDL() {
        return this.ddl;
    }
}

