/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl;

import hydra.Log;
import hydra.MasterController;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import sql.SQLHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.GenericExceptionHandler;
import sql.generic.dmlstatements.GenericDML;
import util.TestException;
import util.TestHelper;

public class Executor {
    Connection gConn;
    Connection dConn;
    PreparedStatement ps;

    public Connection getGConn() {
        return this.gConn;
    }

    public void setGConn(Connection conn) {
        this.gConn = conn;
    }

    public Connection getDConn() {
        return this.dConn;
    }

    public void setDConn(Connection conn) {
        this.dConn = conn;
    }

    public Executor(Connection conn) {
        this.gConn = conn;
        this.dConn = null;
    }

    public Executor(Connection dConn, Connection gConn) {
        this.dConn = dConn;
        this.gConn = gConn;
    }

    public ExceptionAt executeOnBothDb(String derby, String gemxd, GenericExceptionHandler exceptionHandler) {
        block5: {
            boolean continueWithGemxd = true;
            try {
                this.dConn.createStatement().executeUpdate(derby);
                Log.getLogWriter().info("Derby - Executed " + derby);
            }
            catch (SQLException se) {
                Log.getLogWriter().info("Derby Exception - " + se.getMessage());
                continueWithGemxd = exceptionHandler.handleDerbyException(this.dConn, se);
            }
            exceptionHandler.afterDerbyExecution();
            if (!continueWithGemxd) {
                return ExceptionAt.DERBY;
            }
            try {
                this.gConn.createStatement().executeUpdate(gemxd);
                Log.getLogWriter().info("Gemxd - Executed " + gemxd);
            }
            catch (SQLException se) {
                Log.getLogWriter().info("Gemxd Exception - " + se.getMessage());
                if (exceptionHandler.handleGfxdException(se)) break block5;
                return ExceptionAt.GEMXD;
            }
        }
        exceptionHandler.afterGemxdExecution();
        return ExceptionAt.NONE;
    }

    public ResultSet[] executeQueryOnBothDB(String queryDerby, String queryGemxd, int maxNumOfRetryDerby, int maxNumOfRetryGemxd, int retrySleepMs, GenericExceptionHandler exceptionHandler, boolean[] success) {
        boolean count = false;
        ResultSet[] rs = new ResultSet[2];
        try {
            rs[0] = this.executeQuery(queryDerby, maxNumOfRetryDerby, retrySleepMs, "Derby");
            success[0] = true;
            exceptionHandler.afterDerbyExecution();
        }
        catch (SQLException se) {
            exceptionHandler.handleDerbyException(this.dConn, se);
        }
        if (rs[0] != null) {
            try {
                rs[1] = this.executeQuery(queryGemxd, maxNumOfRetryGemxd, retrySleepMs, "Gemxd");
                success[1] = true;
                if (rs[1] == null) {
                    success[1] = false;
                    this.handleNullRs();
                }
                exceptionHandler.afterGemxdExecution();
            }
            catch (SQLException se) {
                exceptionHandler.handleGfxdException(se);
            }
        }
        return rs;
    }

    public ResultSet executeQueyOnGfxdOnly(String query, int maxNumOfTry, int sleep, GenericExceptionHandler exceptionHandler) {
        ResultSet rs = null;
        try {
            rs = this.executeQuery(query, maxNumOfTry, sleep, "Gfxd");
            if (rs == null) {
                this.handleNullRs();
            }
        }
        catch (SQLException se) {
            exceptionHandler.handleGfxdExceptionOnly(se);
        }
        return rs;
    }

    public ResultSet executeQuery(String query, int maxNumOfTry, int sleep, String db) throws SQLException {
        int count;
        boolean success = false;
        ResultSet rs = null;
        for (count = 0; count < maxNumOfTry && !success; ++count) {
            MasterController.sleepForMs((int)GenericDML.rand.nextInt(sleep));
            PreparedStatement ps = this.dConn.prepareStatement(query);
            rs = ps.executeQuery();
            success = true;
        }
        if (count >= maxNumOfTry && !success) {
            Log.getLogWriter().info("Could not get the lock to finisht the operation in " + db + ", abort this operation");
        }
        return rs;
    }

    public void handleNullRs() {
        if (SQLOldTest.isHATest) {
            Log.getLogWriter().info("Testing HA and did not get GFXD result set");
        } else if (SQLOldTest.setCriticalHeap) {
            Log.getLogWriter().info("got XCL54 and does not get query result");
        } else {
            throw new TestException("Not able to get gfe result set after retry");
        }
    }

    public boolean executeOnGfxdOnly(String executionString, GenericExceptionHandler exceptionHandler) {
        try {
            Statement stmt = this.gConn.createStatement();
            stmt.executeUpdate(executionString);
            Log.getLogWriter().info(" Completed Execution of ... " + executionString);
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
                return exceptionHandler.handleGfxdWarningsOnly(warning);
            }
        }
        catch (SQLException se) {
            exceptionHandler.handleGfxdExceptionOnly(se);
            return false;
        }
        return true;
    }

    public void execute(String executionString) throws SQLException {
        this.gConn.createStatement().execute(executionString);
    }

    public ResultSet executeQuery(String executionString) throws SQLException {
        return this.gConn.createStatement().executeQuery(executionString);
    }

    public int execute(String executionString, List<Object> parameters) throws SQLException {
        int columnIndex = 1;
        this.ps = this.gConn.prepareStatement(executionString);
        for (Object param : parameters) {
            this.setValues(param, columnIndex++);
        }
        return this.ps.executeUpdate();
    }

    public HashMap<ExceptionMapKeys, SQLException> executeOnlyOnGFXD(String executionString) {
        HashMap<ExceptionMapKeys, SQLException> exceptionMap = new HashMap<ExceptionMapKeys, SQLException>();
        try {
            this.gConn.createStatement().execute(executionString);
        }
        catch (SQLException se) {
            exceptionMap.put(ExceptionMapKeys.GEMXD, se);
        }
        return exceptionMap;
    }

    public HashMap<ExceptionMapKeys, SQLException> executeOnBothDb(String executionString) {
        HashMap<ExceptionMapKeys, SQLException> exceptionMap = new HashMap<ExceptionMapKeys, SQLException>();
        if (SQLOldTest.hasDerbyServer) {
            try {
                this.dConn.createStatement().execute(executionString);
            }
            catch (SQLException se) {
                exceptionMap.put(ExceptionMapKeys.DERBY, se);
            }
        }
        try {
            this.gConn.createStatement().execute(executionString);
        }
        catch (SQLException se) {
            exceptionMap.put(ExceptionMapKeys.GEMXD, se);
        }
        return exceptionMap;
    }

    public ResultSet executeQuery(String executionString, List<Object> parameters) throws SQLException {
        int columnIndex = 1;
        this.ps = this.gConn.prepareStatement(executionString);
        for (Object param : parameters) {
            this.setValues(param, columnIndex++);
        }
        return this.ps.executeQuery();
    }

    public Connection getConnection() {
        return this.gConn;
    }

    public void setValues(Object value, int columnIndex) throws SQLException {
        if (value instanceof Integer) {
            this.ps.setInt(columnIndex, (Integer)value);
        } else if (value instanceof Long) {
            this.ps.setLong(columnIndex, (Long)value);
        } else if (value instanceof Float) {
            this.ps.setFloat(columnIndex, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.ps.setDouble(columnIndex, (Double)value);
        } else if (value instanceof BigDecimal) {
            this.ps.setBigDecimal(columnIndex, (BigDecimal)value);
        } else if (value instanceof Boolean) {
            this.ps.setBoolean(columnIndex, (Boolean)value);
        } else if (value instanceof Blob) {
            this.ps.setBlob(columnIndex, (Blob)value);
        } else if (value instanceof String) {
            this.ps.setString(columnIndex, (String)value);
        } else if (value instanceof Date) {
            this.ps.setDate(columnIndex, (Date)value);
        } else if (value instanceof Byte[]) {
            this.ps.setBytes(columnIndex, (byte[])value);
        } else if (value instanceof Short) {
            this.ps.setShort(columnIndex, (Short)value);
        } else if (value instanceof Time) {
            this.ps.setTime(columnIndex, (Time)value);
        } else if (value instanceof Timestamp) {
            this.ps.setTimestamp(columnIndex, (Timestamp)value);
        } else if (value instanceof Clob) {
            this.ps.setClob(columnIndex, (Clob)value);
        } else {
            Log.getLogWriter().info("This dataType is yet not supported : " + value.getClass() + " for object " + value);
        }
    }

    public void rollback() {
        if (this.dConn != null) {
            this.rollbackDerby();
        }
        this.rollbackGfxd();
    }

    public void commit() {
        if (this.dConn != null) {
            this.commitDerby();
        }
        this.commitGfxd();
    }

    public void commitDerby() {
        try {
            Log.getLogWriter().info(" Derby - Commit  started ");
            this.dConn.commit();
            Log.getLogWriter().info(" Derby - Commit  Completed ");
        }
        catch (SQLException se) {
            throw new TestException(" Error while commiting the derby database  sqlState : " + se.getSQLState() + " error message : " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public void commitGfxd() {
        try {
            Log.getLogWriter().info(" Gfxd - Commit  started ");
            this.gConn.commit();
            Log.getLogWriter().info(" Gfxd - Commit  Completed ");
        }
        catch (SQLException se) {
            throw new TestException(" Error while commiting the Gfxd database  sqlState : " + se.getSQLState() + " error message : " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public void rollbackDerby() {
        try {
            Log.getLogWriter().info(" Derby - Rollback  started ");
            this.dConn.rollback();
            Log.getLogWriter().info(" Derby - Rollback  Completed ");
        }
        catch (SQLException se) {
            throw new TestException(" Error while doing rollback derby database  sqlState : " + se.getSQLState() + " error message : " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public void rollbackGfxd() {
        try {
            Log.getLogWriter().info(" Gfxd - Rollback  started ");
            this.gConn.rollback();
            Log.getLogWriter().info(" Gfxd - Rollback  Completed ");
        }
        catch (SQLException se) {
            throw new TestException(" Error while doing rollback Gfxd database  sqlState : " + se.getSQLState() + " error message : " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public static enum ExceptionAt {
        DERBY,
        GEMXD,
        NONE;

    }

    public static enum ExceptionMapKeys {
        DERBY,
        GEMXD;

    }
}

