/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.generic.GenericBBHelper;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.ConstraintInfoHolder;
import sql.generic.ddl.Executor;
import sql.generic.ddl.FKConstraint;
import sql.generic.ddl.GenericTableInfoObjectFetcher;
import sql.generic.ddl.TableInfo;
import util.TestException;
import util.TestHelper;

public class FKInfoObjectFetcher
extends GenericTableInfoObjectFetcher {
    List<FKConstraint> fkconstraint = new ArrayList<FKConstraint>();
    Connection conn;

    public FKInfoObjectFetcher(TableInfo tableInfo, Executor executor, ConstraintInfoHolder constraintInfo) {
        super(tableInfo, executor, constraintInfo);
        this.conn = executor.getConnection();
    }

    @Override
    public void fetch() {
        try {
            String prevConstraintName = " ";
            ArrayList<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
            ArrayList<ColumnInfo> refColumnList = new ArrayList<ColumnInfo>();
            boolean fkConstraint = false;
            boolean constraintAdded = false;
            String pkTableName = "";
            String fullParentName = "";
            String prevParent = "";
            String constraintName = "";
            ResultSet foreignKeys = this.conn.getMetaData().getImportedKeys(null, this.tableInfo.getSchemaName(), this.tableInfo.getTableName());
            while (foreignKeys.next()) {
                fkConstraint = true;
                pkTableName = foreignKeys.getString("PKTABLE_NAME");
                String pkTachleSchema = foreignKeys.getString("PKTABLE_SCHEM");
                fullParentName = pkTachleSchema + "." + pkTableName;
                String pkColumnName = foreignKeys.getString("PKCOLUMN_NAME");
                String fkColumnName = foreignKeys.getString("FKCOLUMN_NAME");
                constraintName = foreignKeys.getString("FK_NAME");
                ColumnInfo parentCol = GenericBBHelper.getTableInfo(fullParentName).getColumn(pkColumnName);
                if (!prevConstraintName.equals(" ") && prevConstraintName != constraintName) {
                    this.fkconstraint.add(new FKConstraint(this.tableInfo.getFullyQualifiedTableName(), prevConstraintName, columnList, prevParent, refColumnList));
                    columnList = new ArrayList();
                    refColumnList = new ArrayList();
                    constraintAdded = true;
                }
                columnList.add(this.tableInfo.getColumn(fkColumnName));
                refColumnList.add(parentCol);
                prevConstraintName = constraintName;
                constraintAdded = false;
                prevParent = fullParentName;
            }
            if (fkConstraint && !constraintAdded) {
                this.fkconstraint.add(new FKConstraint(this.tableInfo.getFullyQualifiedTableName(), constraintName, columnList, fullParentName, refColumnList));
            }
            this.tableInfo.setForeignKeys(this.fkconstraint, this.constraintInfo);
            ArrayList<String> list = new ArrayList<String>(this.constraintInfo.getTablesWithFKConstraint());
            if (this.fkconstraint.size() > 0 && !list.contains(this.tableInfo.getFullyQualifiedTableName())) {
                list.add(this.tableInfo.getFullyQualifiedTableName());
            } else if (this.fkconstraint.size() == 0 && list.contains(this.tableInfo.getFullyQualifiedTableName())) {
                list.remove(this.tableInfo.getFullyQualifiedTableName());
            }
            this.constraintInfo.setTablesWithFKConstraint(list);
        }
        catch (SQLException se) {
            throw new TestException("Error while retrieving the Foreign key information " + TestHelper.getStackTrace((Throwable)se));
        }
    }
}

