/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.Functions;

import hydra.Log;
import hydra.MasterController;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import sql.SQLHelper;
import sql.SQLTest;
import sql.generic.SQLGenericBB;
import sql.generic.SQLOldTest;
import sql.generic.SqlUtilityHelper;
import sql.generic.ddl.Executor;
import sql.generic.ddl.create.DDLStmtIF;
import sql.generic.ddl.procedures.ProcedureExceptionHandler;

public abstract class FunctionTest
implements DDLStmtIF {
    protected boolean dropFunc = SQLOldTest.dropFunc;
    Executor executor;
    Connection dConn;
    Connection gConn;
    ProcedureExceptionHandler exceptionHandler;
    final int maxNumOfTries = 1;
    ArrayList<String> procNames;
    ArrayList<String> lockAcquiredOnProc = new ArrayList();
    String procWithoutLock;

    protected abstract String getFunctionName();

    protected abstract String getFunctionDdl();

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.dConn = executor.getDConn();
        this.gConn = executor.getGConn();
    }

    @Override
    public void createDDL() {
        Log.getLogWriter().info("performing create Fuunction  Op, myTid is " + SqlUtilityHelper.tid());
        HashMap map = new HashMap();
        map.put(this.getFunctionName().toUpperCase(), new ArrayList());
        SQLGenericBB.getBB().getSharedMap().put((Object)"FuncProcMap", map);
        this.executor.executeOnBothDb(this.getFunctionDdl(), this.getFunctionDdl(), new ProcedureExceptionHandler(ProcedureExceptionHandler.Action.CREATE, false));
    }

    @Override
    public void doDDLOp() {
        int chance = 100;
        if (!this.dropFunc || SQLTest.random.nextInt(chance) != 1) {
            Log.getLogWriter().info("will not perform drop function");
            return;
        }
        this.procNames = this.getDependentProcList();
        if (this.dConn != null && this.doOps()) {
            Log.getLogWriter().info("Other threads are performing op on the Procedure " + this.procWithoutLock + ", abort this operation");
            return;
        }
        int choice = 3;
        int op = SQLOldTest.random.nextInt(choice);
        this.exceptionHandler = new ProcedureExceptionHandler(ProcedureExceptionHandler.Action.CREATE, false);
        if (op == 0 || op == 1) {
            String dropStatement = "drop function " + this.getFunctionName();
            if (this.dConn != null) {
                Executor.ExceptionAt exception = this.executor.executeOnBothDb(dropStatement, dropStatement, this.exceptionHandler);
                if (exception == Executor.ExceptionAt.DERBY) {
                    this.zeroCounter();
                    return;
                }
                exception = this.executor.executeOnBothDb(this.getFunctionDdl(), this.getFunctionDdl(), this.exceptionHandler);
                if (exception == Executor.ExceptionAt.DERBY) {
                    this.zeroCounter();
                    this.executor.rollbackDerby();
                    return;
                }
                SQLHelper.handleMissedSQLException(this.exceptionHandler.getExList());
            } else {
                this.executor.executeOnBothDb(dropStatement, dropStatement, new ProcedureExceptionHandler(ProcedureExceptionHandler.Action.CREATE, true));
            }
        }
        if (op == 2) {
            if (this.dConn != null) {
                Executor.ExceptionAt exception = this.executor.executeOnBothDb(this.getFunctionDdl(), this.getFunctionDdl(), this.exceptionHandler);
                if (exception == Executor.ExceptionAt.DERBY) {
                    this.zeroCounter();
                    return;
                }
            } else {
                this.executor.executeOnBothDb(this.getFunctionDdl(), this.getFunctionDdl(), new ProcedureExceptionHandler(ProcedureExceptionHandler.Action.CREATE, true));
            }
        }
        if (this.dConn != null) {
            this.zeroCounter();
        }
    }

    protected void zeroCounter() {
        for (String procName : this.lockAcquiredOnProc) {
            int loc = (Integer)SQLGenericBB.getBB().getSharedMap().get((Object)procName.toUpperCase());
            Log.getLogWriter().info("zeros counter SQLGenericBB.procedureCounter[" + loc + "] for Procedure " + procName);
            SQLGenericBB.getBB().getSharedCounters().zero(SQLGenericBB.procedureCounter[loc]);
        }
    }

    protected boolean doOp(String procName) {
        int doOp = this.getCounter(procName);
        int count = 0;
        while (doOp != 1) {
            if (count > 1) {
                return false;
            }
            ++count;
            MasterController.sleepForMs((int)(100 * SQLOldTest.random.nextInt(30)));
            doOp = this.getCounter(procName);
            Log.getLogWriter().info("Trying again to see if i can get hold on proc");
        }
        return true;
    }

    protected boolean doOps() {
        if (this.procNames == null) {
            return true;
        }
        for (String procName : this.procNames) {
            boolean success = this.doOp(procName);
            if (success) continue;
            this.procWithoutLock = procName;
            this.zeroCounter();
            return false;
        }
        return true;
    }

    protected int getCounter(String procName) {
        int loc = (Integer)SQLGenericBB.getBB().getSharedMap().get((Object)procName.toUpperCase());
        int counter = (int)SQLGenericBB.getBB().getSharedCounters().incrementAndRead(SQLGenericBB.procedureCounter[loc]);
        return counter;
    }

    private ArrayList<String> getDependentProcList() {
        Map functionProcMap = (Map)SQLGenericBB.getBB().getSharedMap().get((Object)"FuncProcMap");
        ArrayList listOfProc = (ArrayList)functionProcMap.get(this.getFunctionName().toUpperCase());
        if (listOfProc != null && listOfProc.size() > 0) {
            return listOfProc;
        }
        return null;
    }
}

