/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.Index;

import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sql.SQLTest;
import sql.generic.SQLGenericBB;
import sql.generic.SQLGenericPrms;
import sql.generic.SQLOldTest;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.Executor;
import sql.generic.ddl.Index.IndexOperation;
import sql.generic.ddl.create.DDLStmtIF;
import util.TestException;

public class GenericIndex
implements DDLStmtIF {
    Executor executor;
    Connection gConn;
    Connection dConn;
    private String lastIndexOpTime = "lastIndexOpTime";
    static long lastDDLOpTime = 0L;
    private int waitPeriod = 3;
    boolean dropIndex = TestConfig.tab().booleanAt(SQLGenericPrms.dropIndex, false);
    List<String> ddlStmt;
    static List<String> indexNames = new ArrayList<String>();
    Map<String, String> stmtPlaceHolders;

    public GenericIndex(List<String> ddlStmt) {
        this.ddlStmt = ddlStmt;
        this.stmtPlaceHolders = new HashMap<String, String>();
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.gConn = executor.getGConn();
        this.dConn = executor.getDConn();
    }

    @Override
    public void createDDL() {
        this.doDDLOp();
    }

    @Override
    public void doDDLOp() {
        if (!RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK")) {
            if (!SQLOldTest.allowConcDDLDMLOps) {
                Log.getLogWriter().info("This test does not run with concurrent ddl with dml ops, abort the op");
                return;
            }
            if (SQLTest.limitConcDDLOps) {
                long now;
                if (!this.doOps()) {
                    Log.getLogWriter().info("Does not meet criteria to perform concurrent ddl right now, abort the op");
                    return;
                }
                Long lastUpdateTime = (Long)SQLGenericBB.getBB().getSharedMap().get((Object)this.lastIndexOpTime);
                if (lastUpdateTime != null && (now = System.currentTimeMillis()) - (lastDDLOpTime = lastUpdateTime.longValue()) < (long)(this.waitPeriod * 60 * 1000)) {
                    SQLGenericBB.getBB().getSharedCounters().zero(SQLGenericBB.perfLimitedIndexDDL);
                    Log.getLogWriter().info("Does not meet criteria to perform concurrent ddl abort");
                    return;
                }
            }
            Log.getLogWriter().info("performing concurrent index op in main task");
        }
        this.performIndexOperation();
        if (!RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK") && SQLOldTest.limitConcDDLOps) {
            long now = System.currentTimeMillis();
            SQLGenericBB.getBB().getSharedMap().put((Object)this.lastIndexOpTime, (Object)now);
            Log.getLogWriter().info(this.lastIndexOpTime + " is set to " + now / 60000L);
            lastDDLOpTime = now;
            Log.getLogWriter().info("setting perfLimitedIndexDDL to zero");
            SQLGenericBB.getBB().getSharedCounters().zero(SQLGenericBB.perfLimitedIndexDDL);
            Log.getLogWriter().info("read  perfLimitedIndexDDL :" + SQLGenericBB.getBB().getSharedCounters().read(SQLGenericBB.perfLimitedIndexDDL));
        }
    }

    private boolean doOps() {
        long now;
        if (lastDDLOpTime == 0L) {
            Long lastUpdateTime = (Long)SQLGenericBB.getBB().getSharedMap().get((Object)this.lastIndexOpTime);
            if (lastUpdateTime == null || lastUpdateTime == 0L) {
                return this.checkBBForDDLOp();
            }
            lastDDLOpTime = lastUpdateTime;
        }
        if ((now = System.currentTimeMillis()) - lastDDLOpTime < (long)(this.waitPeriod * 60 * 1000)) {
            return false;
        }
        lastDDLOpTime = (Long)SQLGenericBB.getBB().getSharedMap().get((Object)this.lastIndexOpTime);
        if (now - lastDDLOpTime < (long)(this.waitPeriod * 60 * 1000)) {
            return false;
        }
        return this.checkBBForDDLOp();
    }

    private boolean checkBBForDDLOp() {
        int perfLimitedConcDDL = (int)SQLGenericBB.getBB().getSharedCounters().incrementAndRead(SQLGenericBB.perfLimitedIndexDDL);
        return perfLimitedConcDDL == 1;
    }

    public void performIndexOperation() {
        for (String stmt : this.ddlStmt) {
            Log.getLogWriter().info("Executing ..." + stmt);
            IndexOperation operation = new IndexOperation(stmt, this.executor, this.stmtPlaceHolders, this.getAction(stmt));
            operation.executeStatement();
        }
    }

    private DDLAction getAction(String stmt) {
        if (stmt.toUpperCase().startsWith(DDLAction.CREATE.name())) {
            return DDLAction.CREATE;
        }
        if (stmt.toUpperCase().startsWith(DDLAction.DROP.name())) {
            return DDLAction.DROP;
        }
        if (stmt.toUpperCase().startsWith(DDLAction.RENAME.name())) {
            return DDLAction.RENAME;
        }
        throw new TestException("Invalid stmt " + stmt);
    }
}

