/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.Index;

import hydra.Log;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import sql.SQLHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.GenericExceptionHandler;
import sql.generic.ddl.Index.IndexOperation;

public class IndexExceptionHandler
implements GenericExceptionHandler {
    DDLAction action;
    IndexOperation index;

    public IndexExceptionHandler(DDLAction action, IndexOperation index) {
        this.action = action;
        this.index = index;
    }

    @Override
    public void afterDerbyExecution() {
    }

    @Override
    public void afterGemxdExecution() {
    }

    @Override
    public boolean handleDerbyException(Connection derby, SQLException se) {
        return false;
    }

    @Override
    public boolean handleGfxdException(SQLException se) {
        return false;
    }

    @Override
    public boolean handleGfxdExceptionOnly(SQLException se) {
        if (this.action == DDLAction.CREATE) {
            return this.handleGfxdExceptionCreateOnly(se);
        }
        if (this.action == DDLAction.DROP) {
            return this.handleGfxdExceptionDropOnly(se);
        }
        SQLHelper.handleSQLException(se);
        return true;
    }

    private boolean handleGfxdExceptionCreateOnly(SQLException se) {
        SQLHelper.printSQLException(se);
        if (se.getSQLState().equalsIgnoreCase("23505")) {
            Log.getLogWriter().info("Got the expected exception creating unique index, continuing test");
        } else if (se.getSQLState().equalsIgnoreCase("X0Z15")) {
            Log.getLogWriter().info("Got the expected exception creating global hash index, continuing test");
        } else if (se.getSQLState().equalsIgnoreCase("XSAS3")) {
            Log.getLogWriter().info("Got the expected exception creating global hash index with sort, continuing test");
        } else if (se.getSQLState().equalsIgnoreCase("X0Z08") && SQLOldTest.isOfflineTest) {
            Log.getLogWriter().info("Got the expected exception during creating index when no nodes are available, continuing test");
        } else if (se.getSQLState().equalsIgnoreCase("X0X67")) {
            Log.getLogWriter().info("Got the expected exception during creating index on BLOB field, continuing test");
        } else if (se.getSQLState().equalsIgnoreCase("42Y62")) {
            Log.getLogWriter().info("Got the expected exception not able to create index on a view, continuing test");
        } else {
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    private boolean handleGfxdExceptionDropOnly(SQLException se) {
        if (se.getSQLState().equalsIgnoreCase("42X65") && !this.index.getIndexExist()) {
            Log.getLogWriter().info("Got the expected index does not exist exception , continuing test");
        } else if (se.getSQLState().equalsIgnoreCase("X0Z08") && SQLOldTest.isOfflineTest) {
            Log.getLogWriter().info("Got the expected exception during dropping index when no nodes are available, continuing test");
        } else {
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    @Override
    public boolean handleGfxdWarningsOnly(SQLWarning warnings) {
        return !warnings.getSQLState().equalsIgnoreCase("01504");
    }
}

