/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.Index;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sql.generic.GenericBBHelper;
import sql.generic.SQLOldTest;
import sql.generic.SqlUtilityHelper;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.Executor;
import sql.generic.ddl.Index.GenericIndex;
import sql.generic.ddl.Index.IndexExceptionHandler;
import sql.generic.ddl.TableInfo;
import util.TestException;

public class IndexOperation {
    Executor executor;
    Map<String, String> stmtPlaceHolders;
    DDLAction action;
    String ddlStmt;
    String parsedStmt;
    String tableName;
    String schema;
    String newIndex = "";
    String dropIndex = "";
    final String DDL_COLUMN_PATTERN = "::[a-zA-Z0-9_. \\[\\]]*::";
    Random random = SQLOldTest.random;
    int length = 10;
    boolean indexExist = true;

    public IndexOperation(String stmt, Executor executor, Map<String, String> stmtPlaceHolders, DDLAction action) {
        this.executor = executor;
        this.stmtPlaceHolders = stmtPlaceHolders;
        this.action = action;
        this.ddlStmt = stmt;
        this.parsedStmt = stmt;
        this.parseDDLStmt();
    }

    protected void parseDDLStmt() {
        List<String> patterns = this.getMatchedPattern(this.ddlStmt, "::[a-zA-Z0-9_. \\[\\]]*::");
        String value = "";
        this.populateRequiredFields();
        for (String pattern : patterns) {
            if (this.stmtPlaceHolders.containsKey(pattern)) {
                value = this.stmtPlaceHolders.get(pattern);
            } else {
                value = this.getPlaceHolderValue(pattern);
                this.stmtPlaceHolders.put(pattern, value);
            }
            this.parsedStmt = this.parsedStmt.replaceAll(pattern, value);
            this.populateRequiredFields();
        }
        this.populateRequiredFields();
    }

    protected void executeStatement() {
        if (GenericIndex.indexNames.contains(this.dropIndex)) {
            this.indexExist = true;
            GenericIndex.indexNames.remove(this.dropIndex);
        } else {
            this.indexExist = false;
        }
        if (this.executor.executeOnGfxdOnly(this.parsedStmt, new IndexExceptionHandler(this.action, this)) && this.action == DDLAction.CREATE) {
            GenericIndex.indexNames.add(this.newIndex);
        }
        this.executor.commit();
    }

    private void populateRequiredFields() {
        if (this.action == DDLAction.CREATE) {
            int startIndex = this.parsedStmt.toLowerCase().indexOf(" index ");
            int middleIndex = this.parsedStmt.toLowerCase().indexOf(" on ");
            int endIndex = this.parsedStmt.toLowerCase().indexOf("(");
            this.newIndex = this.parsedStmt.substring(startIndex + 7, middleIndex).trim();
            this.tableName = this.parsedStmt.substring(middleIndex + 4, endIndex).trim();
            this.schema = SqlUtilityHelper.getSchemaFromTableName(this.tableName);
            this.newIndex = this.schema.trim() + "." + this.newIndex;
        } else if (this.action == DDLAction.DROP) {
            int startIndex = this.parsedStmt.toLowerCase().indexOf(" index ");
            this.dropIndex = this.parsedStmt.substring(startIndex + 6, this.parsedStmt.length()).trim();
        }
    }

    public List<String> getMatchedPattern(String stmt, String regEx) {
        ArrayList<String> matchedPattern = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(stmt);
        while (matcher.find()) {
            matchedPattern.add(matcher.group());
        }
        return matchedPattern;
    }

    protected String getPlaceHolderValue(String pattern) {
        if (pattern.toLowerCase().contains("table")) {
            this.tableName = this.getTableName();
            return this.tableName;
        }
        if (pattern.toLowerCase().contains("column")) {
            return this.getColumnName();
        }
        if (pattern.toLowerCase().contains("index") && this.action == DDLAction.CREATE) {
            return this.getIndexNameForCreate();
        }
        if (pattern.toLowerCase().contains("index") && this.action == DDLAction.DROP) {
            return this.getIndexNameForDrop();
        }
        throw new TestException("invalid pattern " + pattern + " in the DDL statement" + this.ddlStmt);
    }

    private String getTableName() {
        return SqlUtilityHelper.getRandomTableName();
    }

    private String getColumnName() {
        int columnLoc;
        TableInfo info = GenericBBHelper.getTableInfo(this.tableName);
        List<ColumnInfo> columns = info.getColumnList();
        String columnName = columns.get(columnLoc = this.random.nextInt(columns.size() - 1)).getColumnName();
        if (this.parsedStmt.contains(columnName)) {
            return this.getColumnName();
        }
        return columnName;
    }

    private String getIndexNameForCreate() {
        return "Index_" + SqlUtilityHelper.getRandomString(this.length);
    }

    private String getIndexNameForDrop() {
        int size = GenericIndex.indexNames.size();
        if (size > 0) {
            String indexName = GenericIndex.indexNames.get(this.random.nextInt(GenericIndex.indexNames.size()));
            return indexName;
        }
        return this.getIndexNameForCreate();
    }

    public boolean getIndexExist() {
        return this.indexExist;
    }
}

