/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.ConstraintInfoHolder;
import sql.generic.ddl.Executor;
import sql.generic.ddl.GenericTableInfoObjectFetcher;
import sql.generic.ddl.PKConstraint;
import sql.generic.ddl.TableInfo;
import util.TestException;
import util.TestHelper;

public class PKInfoObjectFetcher
extends GenericTableInfoObjectFetcher {
    List<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
    String constraintName;
    Connection conn;

    PKInfoObjectFetcher(TableInfo tableInfo, Executor executor, ConstraintInfoHolder constraintInfo) {
        super(tableInfo, executor, constraintInfo);
        this.conn = executor.getConnection();
    }

    @Override
    public void fetch() {
        try {
            boolean pkConstraint = false;
            ResultSet primaryKeys = this.conn.getMetaData().getPrimaryKeys(null, this.tableInfo.getSchemaName(), this.tableInfo.getTableName());
            while (primaryKeys.next()) {
                pkConstraint = true;
                String columnName = primaryKeys.getString("COLUMN_NAME");
                this.constraintName = primaryKeys.getString("PK_NAME");
                this.columnList.add(this.tableInfo.getColumn(columnName));
            }
            ArrayList<String> list = new ArrayList<String>(this.constraintInfo.getTablesWithPKConstraint());
            if (pkConstraint) {
                this.tableInfo.setPrimaryKey(new PKConstraint(this.tableInfo.getFullyQualifiedTableName(), this.constraintName, this.columnList));
                if (!list.contains(this.tableInfo.getFullyQualifiedTableName())) {
                    list.add(this.tableInfo.getFullyQualifiedTableName());
                }
            } else if (list.contains(this.tableInfo.getFullyQualifiedTableName())) {
                list.remove(this.tableInfo.getFullyQualifiedTableName());
            }
            this.constraintInfo.setTablesWithPKConstraint(list);
        }
        catch (SQLException se) {
            throw new TestException("Error while retrieving the primary key information " + TestHelper.getStackTrace((Throwable)se));
        }
    }
}

