/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sql.generic.GenericBBHelper;
import sql.generic.ddl.CheckConstraint;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.ConstraintInfoHolder;
import sql.generic.ddl.CreateTableDDL;
import sql.generic.ddl.FKConstraint;
import sql.generic.ddl.PKConstraint;
import sql.generic.ddl.SchemaInfo;
import sql.generic.ddl.UniqueConstraint;

public class TableInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    String tableName;
    SchemaInfo schema;
    Map<String, ColumnInfo> columns;
    List<ColumnInfo> columnList;
    boolean hasConstraints = false;
    PKConstraint primaryKey;
    List<FKConstraint> foreignKeys;
    List<UniqueConstraint> uniqueKeys;
    List<CheckConstraint> checkConstraints;
    String derbyDDL;
    String gfxdDDL;
    int numPrForRecovery;
    TableInfo colocatedParent = null;
    String partitioningClause = "";
    List<ColumnInfo> partitioningColumns;
    String persistClause = "";
    String evictionClause = "";
    String serverGroups = "";
    boolean isOffHeap;
    boolean enableConcurrencyCheck = false;
    String hdfsClause = "";
    List<String> asyncEventListnerList = new ArrayList<String>();
    List<String> gatewaySenderList = new ArrayList<String>();

    public TableInfo(String schemaName, String tableName) {
        this.tableName = tableName;
        this.schema = GenericBBHelper.getSchemaInfo(schemaName);
        this.foreignKeys = new ArrayList<FKConstraint>();
        this.uniqueKeys = new ArrayList<UniqueConstraint>();
        this.checkConstraints = new ArrayList<CheckConstraint>();
    }

    public TableInfo(String fullyQualifiedtableName) {
        this(fullyQualifiedtableName.split("\\.")[0], fullyQualifiedtableName.split("\\.")[1]);
    }

    public int getNumPrForRecovery() {
        return this.numPrForRecovery;
    }

    public void setNumPrForRecovery(int numPrForRecovery) {
        this.numPrForRecovery = numPrForRecovery;
    }

    public String getPartitioningClause() {
        return this.partitioningClause;
    }

    public void setPartitioningClause(String partitioningClause) {
        this.partitioningClause = partitioningClause;
    }

    public List<ColumnInfo> getPartitioningColumns() {
        return this.partitioningColumns;
    }

    public void setPartitioningColumns(List<ColumnInfo> partitioningColumns) {
        this.partitioningColumns = partitioningColumns;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public SchemaInfo getSchemaInfo() {
        return this.schema;
    }

    public String getSchemaName() {
        return this.schema.getSchemaName();
    }

    public void setSchemaInfo(SchemaInfo schemaInfo) {
        this.schema = schemaInfo;
    }

    public Map<String, ColumnInfo> getColumns() {
        return this.columns;
    }

    public void setColumns(Map<String, ColumnInfo> columns) {
        this.columns = columns;
    }

    public ColumnInfo getColumn(String name) {
        if (name.contains(this.tableName)) {
            name = name.split("\\.")[2];
        }
        return this.columns.get(name);
    }

    public boolean isHasConstraints() {
        return this.hasConstraints;
    }

    public void setHasConstraints(boolean hasConstraints) {
        this.hasConstraints = hasConstraints;
    }

    public String getFullyQualifiedTableName() {
        return this.schema.getSchemaName() + "." + this.tableName;
    }

    public PKConstraint getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PKConstraint primaryKey) {
        this.primaryKey = primaryKey;
    }

    public List<FKConstraint> getForeignKeys() {
        return Collections.unmodifiableList(this.foreignKeys);
    }

    public void setForeignKeys(List<FKConstraint> foreignKeys, ConstraintInfoHolder constraintInfoHolder) {
        ArrayList<FKConstraint> oldFK = new ArrayList<FKConstraint>(this.foreignKeys);
        ArrayList<FKConstraint> newFK = new ArrayList<FKConstraint>(foreignKeys);
        HashMap<String, List<FKConstraint>> droppedFKMap = new HashMap<String, List<FKConstraint>>(constraintInfoHolder.getDroppedFkList());
        List<Object> droppedFKs = new ArrayList();
        if (!droppedFKMap.isEmpty() && (droppedFKs = droppedFKMap.get(this.getFullyQualifiedTableName())) == null) {
            droppedFKs = new ArrayList();
        }
        if (oldFK.size() > newFK.size()) {
            oldFK.removeAll(newFK);
            droppedFKs.addAll(oldFK);
            droppedFKMap.put(this.getFullyQualifiedTableName(), droppedFKs);
        } else {
            newFK.removeAll(oldFK);
            droppedFKs.removeAll(newFK);
            if (droppedFKs.isEmpty()) {
                droppedFKMap.remove(this);
            } else {
                droppedFKMap.put(this.getFullyQualifiedTableName(), droppedFKs);
            }
        }
        constraintInfoHolder.setDroppedFkList(droppedFKMap);
        this.foreignKeys = foreignKeys;
    }

    public List<UniqueConstraint> getUniqueKeys() {
        return Collections.unmodifiableList(this.uniqueKeys);
    }

    public void setUniqueKeys(List<UniqueConstraint> uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    public List<ColumnInfo> getColumnList() {
        return this.columnList;
    }

    public String getHdfsClause() {
        return this.hdfsClause;
    }

    public void setHdfsClause(String hdfsClause) {
        this.hdfsClause = hdfsClause;
    }

    public void setColumnList(List<ColumnInfo> columnList) {
        this.columnList = columnList;
        this.columns = new HashMap<String, ColumnInfo>();
        for (ColumnInfo column : columnList) {
            this.columns.put(column.getColumnName(), column);
        }
    }

    public String getServerGroups() {
        return this.serverGroups;
    }

    public void setServerGroups(String serverGroups) {
        this.serverGroups = serverGroups;
    }

    public TableInfo getColocatedParent() {
        return this.colocatedParent;
    }

    public void setColocatedParent(TableInfo colocatedParent) {
        this.colocatedParent = colocatedParent;
    }

    public boolean isOffHeap() {
        return this.isOffHeap;
    }

    public void setOffHeap(boolean isOffHeap) {
        this.isOffHeap = isOffHeap;
    }

    public String getPersistClause() {
        return this.persistClause;
    }

    public void setPersistClause(String persistClause) {
        this.persistClause = persistClause;
    }

    public List<String> getAsyncEventListnerList() {
        return this.asyncEventListnerList;
    }

    public void addAsyncEventListnerToList(String asyncEventListnerName) {
        if (!this.asyncEventListnerList.contains(asyncEventListnerName)) {
            this.asyncEventListnerList.add(asyncEventListnerName);
        }
    }

    public List<String> getGatewaySenderList() {
        return this.gatewaySenderList;
    }

    public void addGatewaySenderToList(String gatewaySenderName) {
        if (!this.gatewaySenderList.contains(gatewaySenderName)) {
            this.gatewaySenderList.add(gatewaySenderName);
        }
    }

    public boolean isEnableConcurrencyCheck() {
        return this.enableConcurrencyCheck;
    }

    public void setEnableConcurrencyCheck(boolean enableConcurrencyCheck) {
        this.enableConcurrencyCheck = enableConcurrencyCheck;
    }

    public String getEvictionClause() {
        return this.evictionClause;
    }

    public void setEvictionClause(String evictionClause) {
        this.evictionClause = evictionClause;
    }

    public String toString() {
        StringBuilder finalInfo = new StringBuilder();
        String columnInfo = this.tableName + " " + this.getLoggingForColumnList(this.columnList, false);
        String partitionClause = "\n Partitioning Clause :: " + this.getPartitioningClause();
        StringBuilder pkInfo = new StringBuilder();
        if (this.primaryKey != null) {
            pkInfo = new StringBuilder("\n Primary Key: ").append(this.primaryKey.getConstraintName()).append(" ").append(this.getLoggingForColumnList(this.primaryKey.getColumns(), false));
        }
        StringBuilder fkInfo = new StringBuilder("\n Foreign Keys: ");
        for (FKConstraint foreignKey : this.foreignKeys) {
            fkInfo.append(foreignKey.getConstraintName()).append(" ").append(this.getLoggingForColumnList(foreignKey.getColumns(), false)).append("\n");
        }
        StringBuilder ukInfo = new StringBuilder("\n Unique Keys: ");
        for (UniqueConstraint uniqueKey : this.uniqueKeys) {
            ukInfo.append(uniqueKey.getConstraintName()).append(" ").append(this.getLoggingForColumnList(uniqueKey.getColumns(), false)).append("\n");
        }
        StringBuilder checkInfo = new StringBuilder("\n Check Constraints: ");
        for (CheckConstraint check : this.checkConstraints) {
            checkInfo.append(check.getConstraintName()).append(" ").append(check.definition).append(this.getLoggingForColumnList(check.getColumns(), false)).append(" ").append("\n");
        }
        return finalInfo.append(columnInfo).append(partitionClause).append((CharSequence)pkInfo).append((CharSequence)fkInfo).append((CharSequence)ukInfo).append((CharSequence)checkInfo).toString();
    }

    public String getLoggingForColumnList(List<ColumnInfo> columns, boolean valueNeeded) {
        String columnInfo = " \n ColumnInformation [";
        for (ColumnInfo column : columns) {
            columnInfo = columnInfo + column.getColumnName() + ":" + column.getColumnType() + " isNull:" + column.isNull() + ",";
            if (!valueNeeded) continue;
            columnInfo = columnInfo + " ValueList: ";
            if (column.getValueList() != null) {
                for (Object Obj : column.getValueList()) {
                    columnInfo = columnInfo + " " + Obj + " ";
                }
                continue;
            }
            columnInfo = columnInfo + column.getValueList();
        }
        columnInfo = columnInfo + "]";
        return columnInfo;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaInfo schema) {
        this.schema = schema;
    }

    public List<CheckConstraint> getCheckConstraints() {
        return Collections.unmodifiableList(this.checkConstraints);
    }

    public void setCheckconstraints(List<CheckConstraint> checkConstraints) {
        this.checkConstraints = checkConstraints;
    }

    public String getDerbyDDL() {
        return this.derbyDDL;
    }

    public void setDerbyDDL(String derbyDDL) {
        this.derbyDDL = derbyDDL;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public String getGfxdDDL() {
        return new CreateTableDDL(this).getDDL();
    }

    public boolean checkUniqIsPartOfPk(UniqueConstraint constraint) {
        List<ColumnInfo> uniqColumns = constraint.getColumns();
        List<ColumnInfo> pkColumns = this.primaryKey.getColumns();
        boolean partOfPk = true;
        for (ColumnInfo column : pkColumns) {
            if (uniqColumns.contains(column)) continue;
            partOfPk = false;
        }
        return partOfPk;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableInfo && obj != null) {
            return ((TableInfo)obj).getFullyQualifiedTableName().equals(this.getFullyQualifiedTableName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFullyQualifiedTableName().hashCode();
    }
}

