/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import sql.generic.GenericBBHelper;
import sql.generic.SqlUtilityHelper;
import sql.generic.ddl.CheckInfoObjectFetcher;
import sql.generic.ddl.ColumnInfoObjectFetcher;
import sql.generic.ddl.ConstraintInfoHolder;
import sql.generic.ddl.Executor;
import sql.generic.ddl.FKInfoObjectFetcher;
import sql.generic.ddl.GenericTableInfoObjectFetcher;
import sql.generic.ddl.PKInfoObjectFetcher;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.UniqueKeyInfoObjectFetcher;

public class TableInfoGenerator {
    Executor executor;
    String fullyQualifiedTableName;
    ResultSet rs;
    ArrayList<GenericTableInfoObjectFetcher> tableInfoObjectFetcherList = new ArrayList();
    TableInfo tableInfo;
    ConstraintInfoHolder constraintInfo;

    public TableInfoGenerator(String fullyQualifiedTableName, Executor executor, ConstraintInfoHolder constraintInfo) {
        this.executor = executor;
        this.fullyQualifiedTableName = fullyQualifiedTableName.toUpperCase();
        this.tableInfo = new TableInfo(fullyQualifiedTableName);
        this.constraintInfo = constraintInfo;
        this.register();
    }

    public TableInfoGenerator(TableInfo tableInfo, Executor executor, ConstraintInfoHolder constraintInfo) {
        this.executor = executor;
        this.tableInfo = tableInfo;
        this.constraintInfo = constraintInfo;
        this.register();
    }

    public TableInfo buildTableInfo() {
        for (GenericTableInfoObjectFetcher fetcher : this.tableInfoObjectFetcherList) {
            fetcher.fetch();
        }
        return this.tableInfo;
    }

    public TableInfo updateTableInfo() {
        for (GenericTableInfoObjectFetcher fetcher : this.tableInfoObjectFetcherList) {
            fetcher.fetch();
        }
        return this.tableInfo;
    }

    public void saveTableInfoToBB() {
        GenericBBHelper.putTableInfo(this.tableInfo);
        String[] tables = SqlUtilityHelper.getTableNames();
        ArrayList<String> tableList = new ArrayList<String>(this.constraintInfo.getTablesList());
        if (Arrays.asList(tables).contains(this.tableInfo.getFullyQualifiedTableName()) && !tableList.contains(this.tableInfo.getFullyQualifiedTableName())) {
            tableList.add(this.tableInfo.getFullyQualifiedTableName());
            this.constraintInfo.setTablesList(tableList);
        }
        GenericBBHelper.putConstraintInfoHolder(this.constraintInfo);
    }

    private void register() {
        this.tableInfoObjectFetcherList.add(new ColumnInfoObjectFetcher(this.tableInfo, this.executor, this.constraintInfo));
        this.tableInfoObjectFetcherList.add(new PKInfoObjectFetcher(this.tableInfo, this.executor, this.constraintInfo));
        this.tableInfoObjectFetcherList.add(new FKInfoObjectFetcher(this.tableInfo, this.executor, this.constraintInfo));
        this.tableInfoObjectFetcherList.add(new UniqueKeyInfoObjectFetcher(this.tableInfo, this.executor, this.constraintInfo));
        this.tableInfoObjectFetcherList.add(new CheckInfoObjectFetcher(this.tableInfo, this.executor, this.constraintInfo));
    }
}

