/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.ConstraintInfoHolder;
import sql.generic.ddl.Executor;
import sql.generic.ddl.GenericTableInfoObjectFetcher;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.UniqueConstraint;
import util.TestException;
import util.TestHelper;

public class UniqueKeyInfoObjectFetcher
extends GenericTableInfoObjectFetcher {
    Connection conn;
    List<UniqueConstraint> ukConstraint = new ArrayList<UniqueConstraint>();

    public UniqueKeyInfoObjectFetcher(TableInfo tableInfo, Executor executor, ConstraintInfoHolder constraintInfo) {
        super(tableInfo, executor, constraintInfo);
        this.conn = executor.getConnection();
    }

    @Override
    public void fetch() {
        try {
            UniqueConstraint uniq;
            boolean uniqConstraint = false;
            boolean constraintAdded = false;
            String columnName = "";
            String constraintName = "";
            String indexName = "";
            String prevConstraintName = " ";
            ArrayList<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
            ResultSet uniqueKeys = this.conn.getMetaData().getIndexInfo(null, this.tableInfo.getSchemaName(), this.tableInfo.getTableName(), true, false);
            boolean partOfPk = false;
            while (uniqueKeys.next()) {
                partOfPk = false;
                uniqConstraint = true;
                columnName = uniqueKeys.getString("COLUMN_NAME");
                indexName = uniqueKeys.getString("INDEX_NAME");
                constraintName = this.getConstraintNameFromIndex(indexName);
                if (!prevConstraintName.equals(" ") && prevConstraintName != constraintName) {
                    uniq = new UniqueConstraint(this.tableInfo.getFullyQualifiedTableName(), prevConstraintName, columnList);
                    if (!this.tableInfo.checkUniqIsPartOfPk(uniq)) {
                        this.ukConstraint.add(uniq);
                    }
                    columnList = new ArrayList();
                    constraintAdded = true;
                }
                columnList.add(this.tableInfo.getColumn(columnName));
                prevConstraintName = constraintName;
                constraintAdded = false;
            }
            if (uniqConstraint && !constraintAdded && !partOfPk && !this.tableInfo.checkUniqIsPartOfPk(uniq = new UniqueConstraint(this.tableInfo.getFullyQualifiedTableName(), constraintName, columnList))) {
                this.ukConstraint.add(uniq);
            }
            this.tableInfo.setUniqueKeys(this.ukConstraint);
            ArrayList<String> list = new ArrayList<String>(this.constraintInfo.getTablesWithUniqConstraint());
            if (this.ukConstraint.size() > 0 && !list.contains(this.tableInfo.getFullyQualifiedTableName())) {
                list.add(this.tableInfo.getFullyQualifiedTableName());
            } else if (this.ukConstraint.size() == 0 && list.contains(this.tableInfo.getFullyQualifiedTableName())) {
                list.remove(this.tableInfo.getFullyQualifiedTableName());
            }
            this.constraintInfo.setTablesWithUniqConstraint(list);
        }
        catch (SQLException se) {
            throw new TestException("Error while retrieving the unique key information " + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public String getConstraintNameFromIndex(String indexName) {
        String query = "SELECT CONSTRAINTNAME FROM SYS.SYSCONSTRAINTS , SYS.SYSKEYS , SYS.SYSCONGLOMERATES ";
        String where = "WHERE SYS.SYSCONSTRAINTS.CONSTRAINTID = SYS.SYSKEYS.CONSTRAINTID AND SYS.SYSKEYS.CONGLOMERATEID = sys.sysCONGLOMERATEs.CONGLOMERATEID AND CONGLOMERATENAME = '" + indexName + "'";
        query = query + where;
        String constraintName = "";
        try {
            ResultSet rs = this.executor.executeQuery(query);
            while (rs.next()) {
                constraintName = rs.getString(1);
            }
        }
        catch (SQLException se) {
            throw new TestException("Error while retrieving the Unique key information " + query + " " + TestHelper.getStackTrace((Throwable)se));
        }
        return constraintName;
    }
}

