/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.alter;

import java.util.ArrayList;
import java.util.List;
import sql.generic.GenericBBHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.CheckConstraint;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.Constraint;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.Executor;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.alter.AlterConstraintOperation;
import sql.generic.ddl.alter.AlterUtilityHelper;

public class AlterCheckOperation
extends AlterConstraintOperation {
    CheckConstraint checkCons;

    AlterCheckOperation(String ddl, Executor executor, DDLAction action) {
        super(ddl, executor, action);
        this.constraintType = Constraint.ConstraintType.CHECK;
    }

    @Override
    public AlterCheckOperation parse() {
        switch (this.action) {
            case ADD: {
                this.addCheckConstraint();
                break;
            }
            case DROP: {
                this.dropConstraint();
            }
        }
        return this;
    }

    protected void addCheckConstraint() {
        this.tableInfo = this.getTableInfoForAddConstraint();
        this.constraintName = AlterUtilityHelper.getRandomConstraintName(this.tableInfo.getTableName(), this.constraintType);
        List<ColumnInfo> checkColumns = this.getColumnForAddCheck();
        String definition = "";
        this.checkCons = new CheckConstraint(this.tableInfo.getFullyQualifiedTableName(), this.constraintName, checkColumns, definition);
        for (ColumnInfo column : checkColumns) {
            if (this.columnName.length() == 0) {
                this.columnName = column.getColumnName();
                continue;
            }
            this.columnName = "," + column.getColumnName();
        }
        this.replacePlaceHolders(this.tableInfo.getFullyQualifiedTableName(), this.constraintName, this.columnName);
    }

    protected List<ColumnInfo> getColumnForAddCheck() {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>(this.tableInfo.getColumnList());
        ArrayList<ColumnInfo> checkColumns = new ArrayList<ColumnInfo>();
        int numCol = SQLOldTest.random.nextInt(1) + 1;
        for (int i = 0; i < numCol; ++i) {
            ColumnInfo column = (ColumnInfo)columns.get(SQLOldTest.random.nextInt(columns.size()));
            columns.remove(column);
            checkColumns.add(column);
        }
        return checkColumns;
    }

    @Override
    protected TableInfo getTableInfoForDropConstraint() {
        this.tablesWithCheckConstraint = new ArrayList<String>(this.constraintHolder.getTablesWithCheckConstraint());
        if (this.tablesWithCheckConstraint.size() == 0) {
            return null;
        }
        this.tableName = (String)this.tablesWithCheckConstraint.get(SQLOldTest.random.nextInt(this.tablesWithCheckConstraint.size()));
        return GenericBBHelper.getTableInfo(this.tableName);
    }

    @Override
    protected CheckConstraint getConstraint() {
        this.checkConstraints = new ArrayList<CheckConstraint>(this.tableInfo.getCheckConstraints());
        return (CheckConstraint)this.checkConstraints.get(SQLOldTest.random.nextInt(this.checkConstraints.size()));
    }
}

