/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.alter;

import hydra.Log;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.SQLTest;
import sql.generic.GenericBBHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.Executor;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.alter.AlterUtilityHelper;
import sql.generic.ddl.alter.ColumnDefinition;
import sql.generic.ddl.alter.DataType;
import sql.generic.ddl.alter.Operation;
import util.TestException;
import util.TestHelper;

public class AlterColumnOperation
extends Operation {
    DataType dataType;
    ColumnInfo column;
    final String defaultToReplace = "[DEFAULT]";
    final String dataTypeToReplace = "[DATA-TYPE]";
    List<ColumnInfo> intNotNullColumns = new ArrayList<ColumnInfo>();
    List<ColumnInfo> intColumns = new ArrayList<ColumnInfo>();
    List<ColumnInfo> columns = new ArrayList<ColumnInfo>();
    AlterColumn setOp;
    String columnDefinition;

    public AlterColumnOperation(String ddl, Executor executor, DDLAction action) {
        super(ddl, executor, action);
        this.tableInfo = this.getTableInfo();
    }

    @Override
    public AlterColumnOperation parse() {
        switch (this.action) {
            case ADD: {
                this.addNewColumn();
                break;
            }
            case DROP: {
                this.dropColumn();
                break;
            }
            case SET: {
                this.setColumn();
            }
        }
        return this;
    }

    protected TableInfo getTableInfo() {
        int tableLoc = SQLOldTest.random.nextInt(this.constraintHolder.getTablesList().size());
        this.tableName = this.constraintHolder.getTablesList().get(tableLoc);
        return GenericBBHelper.getTableInfo(this.tableName);
    }

    protected void addNewColumn() {
        this.executeDDL = false;
        this.columnName = AlterUtilityHelper.getGenericColumnName(this.tableInfo.getFullyQualifiedTableName());
        this.dataType = DataType.getRandomDataType();
        if (SQLOldTest.random.nextInt() % 3 == 0) {
            this.columnDefinition = this.getNewColumnDefinition();
        }
        this.replacePlaceHolders(this.tableInfo.getFullyQualifiedTableName(), "", this.columnName + " " + this.dataType.name() + " " + this.columnDefinition);
    }

    protected String getNewColumnDefinition() {
        return new ColumnDefinition(this.tableInfo, this.columnName, this.dataType).getDefinition();
    }

    protected void dropColumn() {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>(this.tableInfo.getColumnList());
        this.column = (ColumnInfo)columns.get(SQLOldTest.random.nextInt(columns.size()));
        this.columnName = this.column.getColumnName();
        this.replacePlaceHolders(this.tableInfo.getFullyQualifiedTableName(), "", this.columnName);
    }

    public void setColumn() {
        this.columns = new ArrayList<ColumnInfo>(this.tableInfo.getColumnList());
        this.setOp = AlterColumn.getOperation(this.ddl);
        switch (this.setOp) {
            case ALWAYS: {
                this.getIntegerTypeColumns();
                if (this.intNotNullColumns.size() != 0) {
                    this.column = this.intNotNullColumns.get(SQLOldTest.random.nextInt(this.intNotNullColumns.size()));
                    break;
                }
                if (this.intColumns.size() != 0) {
                    this.column = this.intColumns.get(SQLOldTest.random.nextInt(this.intColumns.size()));
                    break;
                }
                this.column = this.columns.get(SQLOldTest.random.nextInt(this.columns.size()));
                break;
            }
            case SETNULL: {
                this.column = this.columns.get(SQLOldTest.random.nextInt(this.columns.size()));
                break;
            }
            case DEFAULT: {
                this.column = this.columns.get(SQLOldTest.random.nextInt(this.columns.size()));
                break;
            }
            case DATATYPE: {
                this.column = this.columns.get(SQLOldTest.random.nextInt(this.columns.size()));
                break;
            }
            default: {
                Log.getLogWriter().info("Invalid alter syntax for alter column in " + this.ddl);
                this.executeDDL = false;
                return;
            }
        }
        this.columnName = this.column.getColumnName();
        this.replacePlaceHolders(this.tableInfo.getFullyQualifiedTableName(), "", this.columnName);
    }

    public void getIntegerTypeColumns() {
        for (ColumnInfo col : this.columns) {
            if (col.getColumnType() != -5 && col.getColumnType() != 4 && col.getColumnType() != 5) continue;
            if (!col.isNull()) {
                this.intNotNullColumns.add(col);
            }
            this.intColumns.add(col);
        }
    }

    @Override
    public void handleAlterDDLException(SQLException derby, SQLException gemxd) {
        Log.getLogWriter().info("Derby Exception is : " + derby);
        Log.getLogWriter().info("GFXD Exception is : " + gemxd);
        if (gemxd != null && derby == null) {
            if (gemxd.getSQLState().equals("X0Z01") && SQLTest.isHATest) {
                Log.getLogWriter().info("gfxd failed - operation due to node failure");
                this.executor.rollbackDerby();
                return;
            }
            if (this.action == DDLAction.DROP) {
                String partitionClause = this.tableInfo.getPartitioningClause().toUpperCase();
                if (gemxd.getSQLState().equals("0A000") && partitionClause.contains("PARTITION") && this.tableInfo.getPartitioningColumns().contains(this.column)) {
                    Log.getLogWriter().info("gfxd failed - partitioned column could not be dropped");
                    this.executor.rollbackDerby();
                    return;
                }
                if (gemxd.getSQLState().equals("0A000") && this.tableInfo.getPrimaryKey().getColumns().contains(this.column)) {
                    Log.getLogWriter().info("gfxd failed - primary column could not be dropped");
                    this.executor.rollbackDerby();
                    return;
                }
                if (gemxd.getSQLState().equals("X0Y25")) {
                    Log.getLogWriter().info("gfxd failed - to drop column as the column is part of constraint.");
                    this.executor.rollbackDerby();
                    return;
                }
            } else if (this.action == DDLAction.ADD && gemxd.getSQLState().equals("0A000")) {
                Log.getLogWriter().info("gfxd failed - to add column.");
            }
        }
        this.compareExceptions(derby, gemxd);
    }

    @Override
    public void handleAlterDDLException(SQLException gemxd) {
        Log.getLogWriter().info("GFXD Exception is : " + gemxd);
        if (this.parsedDDL.contains(" ALTER ") && !this.parsedDDL.contains(" ALWAYS ")) {
            if (this.parsedDDL.contains(" NOT NULL ") && gemxd.getSQLState().equalsIgnoreCase("42Z20") && this.tableInfo.getPrimaryKey().getColumns().contains(this.column)) {
                Log.getLogWriter().info("gfxd failed - primary key or unique key column cannot be nullable.");
            } else if (gemxd.getSQLState().equalsIgnoreCase("0A000") || gemxd.getSQLState().startsWith("42Z")) {
                Log.getLogWriter().info("Got expected exception for column modification not supported");
            } else {
                throw new TestException("Did not get expected exception for column modification" + TestHelper.getStackTrace((Throwable)gemxd));
            }
        }
    }

    public static enum AlterColumn {
        DEFAULT(" default "),
        DATATYPE(" data type "),
        SETNULL(" null"),
        ALWAYS(" always ");

        String opType;

        private AlterColumn(String opType) {
            this.opType = opType;
        }

        public String getOpType() {
            return this.opType.toUpperCase();
        }

        public static AlterColumn getOperation(String ddl) {
            if (ddl.contains(ALWAYS.getOpType())) {
                return ALWAYS;
            }
            if (ddl.contains(DEFAULT.getOpType())) {
                return DEFAULT;
            }
            if (ddl.contains(DATATYPE.getOpType())) {
                return DATATYPE;
            }
            if (ddl.contains(SETNULL.getOpType())) {
                return SETNULL;
            }
            return null;
        }
    }
}

