/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.alter;

import hydra.Log;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.generic.GenericBBHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.CheckConstraint;
import sql.generic.ddl.Constraint;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.Executor;
import sql.generic.ddl.FKConstraint;
import sql.generic.ddl.PKConstraint;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.UniqueConstraint;
import sql.generic.ddl.alter.AlterUtilityHelper;
import sql.generic.ddl.alter.Operation;

public class AlterConstraintOperation
extends Operation {
    Constraint.ConstraintType constraintType;
    List<String> tablesWithCheckConstraint;
    List<String> tablesWithFKConstraint;
    List<String> tablesWithPKConstraint;
    List<String> tablesWithUniqueConstraint;
    List<CheckConstraint> checkConstraints;
    List<FKConstraint> fkConstraints;
    PKConstraint pkConstraint;
    List<UniqueConstraint> uniqueConstraints;
    Constraint dropConstraint;

    AlterConstraintOperation(String ddl, Executor executor, DDLAction action) {
        super(ddl, executor, action);
    }

    @Override
    public AlterConstraintOperation parse() {
        switch (this.action) {
            case ADD: {
                this.addNewConstraint();
                break;
            }
            case DROP: {
                this.dropConstraint();
            }
        }
        return this;
    }

    @Override
    public void handleAlterDDLException(SQLException derbyException, SQLException gemxdException) {
        Log.getLogWriter().info("Derby Exception is : " + derbyException);
        Log.getLogWriter().info("GFXD Exception is : " + gemxdException);
        if (gemxdException != null && this.action == DDLAction.DROP && gemxdException.getSQLState().equals("0A000") && this.dropConstraint.getConstraintType() == Constraint.ConstraintType.PK_CONSTRAINT) {
            Log.getLogWriter().info("gfxd failed - PK constraint could not be dropped");
            if (derbyException == null) {
                this.executor.rollbackDerby();
            }
            return;
        }
        if (derbyException != null && gemxdException == null && !this.isFixed51273 && derbyException.getSQLState().equals("23505") && this.action == DDLAction.ADD) {
            Log.getLogWriter().info("Got bug #51273 - Unique constraint failed to add in derby but successful in gfxd.");
            this.executor.rollbackGfxd();
            return;
        }
        this.compareExceptions(derbyException, gemxdException);
    }

    @Override
    public void handleAlterDDLException(SQLException gemxd) {
        Log.getLogWriter().info("GFXD Exception is : " + gemxd);
    }

    protected void addNewConstraint() {
        this.tableInfo = this.getTableInfoForAddConstraint();
        this.constraintName = AlterUtilityHelper.getRandomConstraintName(this.tableInfo.getTableName(), this.constraintType);
        this.replacePlaceHolders(this.tableInfo.getFullyQualifiedTableName(), this.constraintName, "");
    }

    protected void dropConstraint() {
        this.tableInfo = this.getTableInfoForDropConstraint();
        if (this.tableInfo == null) {
            Log.getLogWriter().info("Did not find any table with required constraint, continuing with random table. ");
            this.tableInfo = this.getTableInfoForAddConstraint();
            this.constraintName = AlterUtilityHelper.getRandomConstraintName(this.tableInfo.getTableName(), this.constraintType);
        } else {
            this.dropConstraint = this.getConstraint();
            this.constraintName = this.dropConstraint.getConstraintName();
        }
        this.replacePlaceHolders(this.tableInfo.getFullyQualifiedTableName(), this.constraintName, "");
    }

    protected Constraint getConstraint() {
        ArrayList<Constraint> tableConstraints = new ArrayList<Constraint>();
        this.checkConstraints = new ArrayList<CheckConstraint>(this.tableInfo.getCheckConstraints());
        this.fkConstraints = new ArrayList<FKConstraint>(this.tableInfo.getForeignKeys());
        this.pkConstraint = this.tableInfo.getPrimaryKey();
        this.uniqueConstraints = new ArrayList<UniqueConstraint>(this.tableInfo.getUniqueKeys());
        tableConstraints.addAll(this.checkConstraints);
        tableConstraints.add(this.pkConstraint);
        tableConstraints.addAll(this.fkConstraints);
        tableConstraints.addAll(this.uniqueConstraints);
        Constraint constraint = (Constraint)tableConstraints.get(SQLOldTest.random.nextInt(tableConstraints.size()));
        this.constraintType = constraint.getConstraintType();
        return constraint;
    }

    protected TableInfo getTableInfoForDropConstraint() {
        ArrayList<String> tables = new ArrayList<String>();
        this.tablesWithFKConstraint = new ArrayList<String>(this.constraintHolder.getTablesWithFKConstraint());
        this.tablesWithUniqueConstraint = new ArrayList<String>(this.constraintHolder.getTablesWithUniqConstraint());
        this.tablesWithCheckConstraint = new ArrayList<String>(this.constraintHolder.getTablesWithCheckConstraint());
        this.tablesWithPKConstraint = new ArrayList<String>(this.constraintHolder.getTablesWithPKConstraint());
        tables.addAll(this.tablesWithFKConstraint);
        tables.addAll(this.tablesWithUniqueConstraint);
        tables.addAll(this.tablesWithCheckConstraint);
        tables.addAll(this.tablesWithPKConstraint);
        if (tables.size() == 0) {
            return null;
        }
        this.tableName = (String)tables.get(SQLOldTest.random.nextInt(tables.size()));
        return GenericBBHelper.getTableInfo(this.tableName);
    }

    protected TableInfo getTableInfoForAddConstraint() {
        List<String> tables = this.constraintHolder.getTablesList();
        this.tableName = tables.get(SQLOldTest.random.nextInt(tables.size()));
        return GenericBBHelper.getTableInfo(this.tableName);
    }
}

