/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.alter;

import hydra.Log;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.Executor;
import sql.generic.ddl.alter.AlterAsyncEventListenerOperation;
import sql.generic.ddl.alter.AlterCheckOperation;
import sql.generic.ddl.alter.AlterColumnOperation;
import sql.generic.ddl.alter.AlterConstraintOperation;
import sql.generic.ddl.alter.AlterEvictionOperation;
import sql.generic.ddl.alter.AlterForeignKeyOperation;
import sql.generic.ddl.alter.AlterGatewaySenderOperation;
import sql.generic.ddl.alter.AlterKeywordParser;
import sql.generic.ddl.alter.AlterPrimaryKeyOperation;
import sql.generic.ddl.alter.AlterUniqueOperation;
import sql.generic.ddl.alter.Operation;
import util.TestException;

public class AlterDDLParser {
    String ddl;
    Executor executor;

    public AlterDDLParser(String ddl, Executor executor) {
        this.ddl = ddl;
        this.executor = executor;
    }

    public Operation parseDDL() {
        Log.getLogWriter().info("DDL before parsing :: " + this.ddl);
        Operation operation = this.getDDLOperation();
        return operation.parse();
    }

    public Operation getDDLOperation() {
        switch (AlterKeywordParser.getKeyWordOperation(this.ddl)) {
            case PRIMARYKEY: {
                return new AlterPrimaryKeyOperation(this.ddl, this.executor, this.getAction());
            }
            case FOREIGNKEY: {
                return new AlterForeignKeyOperation(this.ddl, this.executor, this.getAction());
            }
            case UNIQ: {
                return new AlterUniqueOperation(this.ddl, this.executor, this.getAction());
            }
            case CHECK: {
                return new AlterCheckOperation(this.ddl, this.executor, this.getAction());
            }
            case CONSTRAINT: {
                return new AlterConstraintOperation(this.ddl, this.executor, this.getAction());
            }
            case COLUMN: {
                return new AlterColumnOperation(this.ddl, this.executor, this.getAction());
            }
            case EVICTION: {
                return new AlterEvictionOperation(this.ddl, this.executor, this.getAction());
            }
            case LISTENER: {
                return new AlterAsyncEventListenerOperation(this.ddl, this.executor, this.getAction());
            }
            case GATEWAYSENDER: {
                return new AlterGatewaySenderOperation(this.ddl, this.executor, this.getAction());
            }
        }
        throw new TestException(" Unsupported Alter syntax: " + this.ddl);
    }

    public DDLAction getAction() {
        if (this.ddl.contains(DDLAction.ADD.name())) {
            return DDLAction.ADD;
        }
        if (this.ddl.contains(DDLAction.SET.name()) || this.ddl.contains(" ALTER ")) {
            return DDLAction.SET;
        }
        if (this.ddl.contains(DDLAction.DROP.name())) {
            return DDLAction.DROP;
        }
        throw new TestException(" Unsupported Alter syntax: " + this.ddl);
    }
}

