/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.alter;

import hydra.Log;
import java.sql.SQLException;
import java.util.List;
import sql.generic.GenericBBHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.Executor;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.alter.Operation;

public class AlterEvictionOperation
extends Operation {
    String evictionMaxsize = "";
    int minValue = 5000;
    int maxValue = 10000;
    final String keyToReplace = "[EVICTION-MAXSIZE]";

    AlterEvictionOperation(String ddl, Executor executor, DDLAction action) {
        super(ddl, executor, action);
    }

    @Override
    public AlterEvictionOperation parse() {
        switch (this.action) {
            case SET: {
                this.setEvictionMaxSize();
            }
        }
        return this;
    }

    protected void setEvictionMaxSize() {
        this.tableInfo = this.getTableInfo();
        this.evictionMaxsize = this.getEvicionMaxSize();
        this.parsedDDL = this.parsedDDL.replace("[TABLE-NAME]", this.tableInfo.getFullyQualifiedTableName());
        this.parsedDDL = this.parsedDDL.replace("[EVICTION-MAXSIZE]", this.evictionMaxsize);
    }

    protected TableInfo getTableInfo() {
        List<String> tables = this.constraintHolder.getTablesList();
        this.tableName = tables.get(SQLOldTest.random.nextInt(tables.size()));
        return GenericBBHelper.getTableInfo(this.tableName);
    }

    protected String getEvicionMaxSize() {
        int evictSize = (int)(SQLOldTest.random.nextDouble() * (double)(this.maxValue - this.minValue)) + this.minValue;
        return " " + evictSize;
    }

    @Override
    public void handleAlterDDLException(SQLException derby, SQLException gemxd) {
        Log.getLogWriter().info("Derby Exception is : " + derby);
        Log.getLogWriter().info("GFXD Exception is : " + gemxd);
        this.compareExceptions(derby, gemxd);
    }

    @Override
    public void handleAlterDDLException(SQLException gemxd) {
        Log.getLogWriter().info("GFXD Exception is : " + gemxd);
    }
}

