/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.alter;

import hydra.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sql.generic.GenericBBHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.Constraint;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.Executor;
import sql.generic.ddl.FKConstraint;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.alter.AlterConstraintOperation;
import sql.generic.ddl.alter.AlterUtilityHelper;

public class AlterForeignKeyOperation
extends AlterConstraintOperation {
    AlterForeignKeyOperation(String ddl, Executor executor, DDLAction action) {
        super(ddl, executor, action);
        this.constraintType = Constraint.ConstraintType.FK_CONSTRAINT;
    }

    @Override
    public AlterForeignKeyOperation parse() {
        switch (this.action) {
            case ADD: {
                this.addFKConstraint();
                break;
            }
            case DROP: {
                this.dropConstraint();
            }
        }
        return this;
    }

    protected void addFKConstraint() {
        HashMap<String, List<FKConstraint>> droppedFKMap = new HashMap<String, List<FKConstraint>>(this.constraintHolder.getDroppedFkList());
        if (!droppedFKMap.isEmpty()) {
            Set<String> tables = droppedFKMap.keySet();
            this.tableName = (String)tables.toArray()[SQLOldTest.random.nextInt(tables.size())];
            this.tableInfo = GenericBBHelper.getTableInfo(this.tableName);
            List<FKConstraint> droppedFKs = droppedFKMap.get(this.tableName);
            FKConstraint constraint = droppedFKs.get(SQLOldTest.random.nextInt(droppedFKs.size()));
            List<ColumnInfo> fkColumns = constraint.getColumns();
            for (ColumnInfo c : fkColumns) {
                if (this.columnName.length() == 0) {
                    this.columnName = c.getColumnName();
                    continue;
                }
                this.columnName = this.columnName + "," + c.getColumnName();
            }
            List<ColumnInfo> refColumns = constraint.getParentColumns();
            String refColumn = "";
            for (ColumnInfo c : refColumns) {
                if (refColumn.length() == 0) {
                    refColumn = c.getColumnName();
                    continue;
                }
                refColumn = refColumn + "," + c.getColumnName();
            }
            this.constraintName = AlterUtilityHelper.getRandomConstraintName(this.tableInfo.getTableName(), this.constraintType);
            constraint.setConstraintName(this.constraintName);
            String ref = " REFERENCES " + constraint.getParentTable() + " (" + refColumn + ") ON DELETE RESTRICT";
            this.replacePlaceHolders(this.tableInfo.getFullyQualifiedTableName(), this.constraintName, "(" + this.columnName + ")" + ref);
        } else {
            Log.getLogWriter().info("Did not get FKs to be added, continuing the test...");
            this.executeDDL = false;
        }
    }

    @Override
    protected TableInfo getTableInfoForDropConstraint() {
        this.tablesWithFKConstraint = new ArrayList<String>(this.constraintHolder.getTablesWithFKConstraint());
        if (this.tablesWithFKConstraint.size() == 0) {
            return null;
        }
        this.tableName = (String)this.tablesWithFKConstraint.get(SQLOldTest.random.nextInt(this.tablesWithFKConstraint.size()));
        return GenericBBHelper.getTableInfo(this.tableName);
    }

    @Override
    protected FKConstraint getConstraint() {
        this.fkConstraints = new ArrayList<FKConstraint>(this.tableInfo.getForeignKeys());
        return (FKConstraint)this.fkConstraints.get(SQLOldTest.random.nextInt(this.fkConstraints.size()));
    }
}

