/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.alter;

public enum AlterKeywordParser {
    COLUMN(" column "),
    COLUMN_NAME("column-name"),
    PRIMARYKEY(" primary key"),
    PRIMARY_KEY("primary-key"),
    FOREIGNKEY(" foreign key"),
    UNIQ(" unique"),
    CHECK(" check"),
    CONSTRAINT(" constraint"),
    EVICTION(" eviction maxsize "),
    GATEWAYSENDER(" gatewaysender "),
    LISTENER(" asynceventlistener"),
    UNSUPPORTED("unsupported");

    String keyword;

    private AlterKeywordParser(String keyword) {
        this.keyword = keyword;
    }

    public String getKeyword() {
        return this.keyword.toUpperCase();
    }

    public static AlterKeywordParser getKeyWordOperation(String ddl) {
        if (ddl.contains(PRIMARYKEY.getKeyword()) || ddl.contains(PRIMARY_KEY.getKeyword())) {
            return PRIMARYKEY;
        }
        if (ddl.contains(FOREIGNKEY.getKeyword())) {
            return FOREIGNKEY;
        }
        if (ddl.contains(UNIQ.getKeyword())) {
            return UNIQ;
        }
        if (ddl.contains(CHECK.getKeyword())) {
            return CHECK;
        }
        if (ddl.contains(CONSTRAINT.getKeyword())) {
            return CONSTRAINT;
        }
        if (ddl.contains(COLUMN.getKeyword()) || ddl.contains(COLUMN_NAME.getKeyword())) {
            return COLUMN;
        }
        if (ddl.contains(EVICTION.getKeyword())) {
            return EVICTION;
        }
        if (ddl.contains(GATEWAYSENDER.getKeyword())) {
            return GATEWAYSENDER;
        }
        if (ddl.contains(LISTENER.getKeyword())) {
            return LISTENER;
        }
        return UNSUPPORTED;
    }
}

