/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.alter;

import hydra.Log;
import java.util.ArrayList;
import java.util.List;
import sql.generic.GenericBBHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.Constraint;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.Executor;
import sql.generic.ddl.PKConstraint;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.alter.AlterConstraintOperation;
import sql.generic.ddl.alter.AlterKeywordParser;
import sql.generic.ddl.alter.AlterUtilityHelper;

public class AlterPrimaryKeyOperation
extends AlterConstraintOperation {
    final String CONSTRAINT = " CONSTRAINT ";
    final String PRIMARYKEY = " PRIMARY KEY ";
    final String keyToReplace = "[PRIMARY-KEY]";
    boolean falseTesting = false;

    AlterPrimaryKeyOperation(String ddl, Executor executor, DDLAction action) {
        super(ddl, executor, action);
        this.constraintType = Constraint.ConstraintType.PK_CONSTRAINT;
    }

    @Override
    public AlterPrimaryKeyOperation parse() {
        switch (this.action) {
            case ADD: {
                this.addPK();
                break;
            }
            case DROP: {
                this.dropConstraint();
                break;
            }
        }
        return this;
    }

    protected void addPK() {
        this.tableInfo = this.getTableInfoForAddPK();
        this.constraintName = AlterUtilityHelper.getRandomConstraintName(this.tableInfo.getTableName(), this.constraintType);
        List<ColumnInfo> pkColumns = this.getPKColumn();
        for (ColumnInfo column : pkColumns) {
            if (this.columnName.length() == 0) {
                this.columnName = column.getColumnName();
                continue;
            }
            this.columnName = this.columnName + "," + column.getColumnName();
        }
        String replacement = "";
        if (this.ddl.contains(AlterKeywordParser.PRIMARY_KEY.getKeyword())) {
            if (SQLOldTest.random.nextInt() % 2 == 0) {
                replacement = " CONSTRAINT " + this.constraintName;
            }
            replacement = replacement + " PRIMARY KEY " + "(" + this.columnName + ")";
            this.parsedDDL = this.parsedDDL.replace("[PRIMARY-KEY]", replacement);
            this.replacePlaceHolders(this.tableInfo.getFullyQualifiedTableName(), "", "");
        } else {
            this.replacePlaceHolders(this.tableInfo.getFullyQualifiedTableName(), this.constraintName, this.columnName);
        }
    }

    protected TableInfo getTableInfoForAddPK() {
        ArrayList<String> pkTables = new ArrayList<String>(this.constraintHolder.getTablesWithPKConstraint());
        ArrayList<String> tables = new ArrayList<String>(this.constraintHolder.getTablesList());
        ArrayList<String> nonPkTables = new ArrayList<String>();
        nonPkTables.addAll(tables);
        nonPkTables.removeAll(pkTables);
        if (SQLOldTest.random.nextInt() % 20 != 0 && nonPkTables.size() != 0) {
            String tableName = (String)nonPkTables.get(SQLOldTest.random.nextInt(nonPkTables.size()));
            return GenericBBHelper.getTableInfo(tableName);
        }
        this.falseTesting = true;
        String tableName = (String)tables.get(SQLOldTest.random.nextInt(tables.size()));
        return GenericBBHelper.getTableInfo(tableName);
    }

    protected List<ColumnInfo> getPKColumn() {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>(this.tableInfo.getColumnList());
        ArrayList<ColumnInfo> possColumnsForPK = new ArrayList<ColumnInfo>();
        ArrayList<ColumnInfo> pkColumns = new ArrayList<ColumnInfo>();
        for (ColumnInfo col : columns) {
            if (col.isNull()) continue;
            possColumnsForPK.add(col);
        }
        if (possColumnsForPK == null || possColumnsForPK.size() != 0) {
            int numColumnsToAdd = SQLOldTest.random.nextInt(Math.min(3, possColumnsForPK.size())) + 1;
            for (int i = 0; i < numColumnsToAdd; ++i) {
                ColumnInfo c = (ColumnInfo)possColumnsForPK.get(SQLOldTest.random.nextInt(possColumnsForPK.size()));
                possColumnsForPK.remove(c);
                pkColumns.add(c);
            }
        } else {
            Log.getLogWriter().info("DDL : Did not any column for new PK... ");
            ColumnInfo col = (ColumnInfo)columns.get(SQLOldTest.random.nextInt(columns.size()));
            pkColumns.add(col);
        }
        return pkColumns;
    }

    @Override
    protected TableInfo getTableInfoForDropConstraint() {
        this.tablesWithPKConstraint = new ArrayList<String>(this.constraintHolder.getTablesWithPKConstraint());
        if (this.tablesWithPKConstraint.size() == 0) {
            return null;
        }
        this.tableName = (String)this.tablesWithPKConstraint.get(SQLOldTest.random.nextInt(this.tablesWithPKConstraint.size()));
        return GenericBBHelper.getTableInfo(this.tableName);
    }

    @Override
    protected PKConstraint getConstraint() {
        return this.tableInfo.getPrimaryKey();
    }
}

