/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.alter;

import java.util.ArrayList;
import java.util.List;
import sql.generic.GenericBBHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.Constraint;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.Executor;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.UniqueConstraint;
import sql.generic.ddl.alter.AlterConstraintOperation;
import sql.generic.ddl.alter.AlterUtilityHelper;

public class AlterUniqueOperation
extends AlterConstraintOperation {
    AlterUniqueOperation(String ddl, Executor executor, DDLAction action) {
        super(ddl, executor, action);
        this.constraintType = Constraint.ConstraintType.UNIQUE;
    }

    @Override
    public AlterUniqueOperation parse() {
        switch (this.action) {
            case ADD: {
                this.addUnique();
                break;
            }
            case DROP: {
                this.dropConstraint();
            }
        }
        return this;
    }

    protected void addUnique() {
        this.tableInfo = this.getTableInfoForAddConstraint();
        this.constraintName = AlterUtilityHelper.getRandomConstraintName(this.tableInfo.getTableName(), this.constraintType);
        List<ColumnInfo> uniqColumns = this.getColumnForAddUnique();
        for (ColumnInfo column : uniqColumns) {
            if (this.columnName.length() == 0) {
                this.columnName = column.getColumnName();
                continue;
            }
            this.columnName = this.columnName + "," + column.getColumnName();
        }
        this.replacePlaceHolders(this.tableInfo.getFullyQualifiedTableName(), this.constraintName, this.columnName);
    }

    protected List<ColumnInfo> getColumnForAddUnique() {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>(this.tableInfo.getColumnList());
        ArrayList<ColumnInfo> uniqColumns = new ArrayList<ColumnInfo>();
        int numColumnsToAdd = SQLOldTest.random.nextInt(Math.min(2, columns.size())) + 1;
        for (int i = 0; i < numColumnsToAdd; ++i) {
            ColumnInfo c = (ColumnInfo)columns.get(SQLOldTest.random.nextInt(columns.size()));
            uniqColumns.add(c);
            columns.remove(c);
        }
        return uniqColumns;
    }

    @Override
    protected TableInfo getTableInfoForDropConstraint() {
        this.tablesWithUniqueConstraint = new ArrayList<String>(this.constraintHolder.getTablesWithUniqConstraint());
        if (this.tablesWithUniqueConstraint.size() == 0) {
            return null;
        }
        this.tableName = (String)this.tablesWithUniqueConstraint.get(SQLOldTest.random.nextInt(this.tablesWithUniqueConstraint.size()));
        return GenericBBHelper.getTableInfo(this.tableName);
    }

    @Override
    protected UniqueConstraint getConstraint() {
        this.uniqueConstraints = new ArrayList<UniqueConstraint>(this.tableInfo.getUniqueKeys());
        return (UniqueConstraint)this.uniqueConstraints.get(SQLOldTest.random.nextInt(this.uniqueConstraints.size()));
    }
}

