/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.alter;

import hydra.Log;
import java.util.ArrayList;
import java.util.List;
import sql.generic.GenericBBHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.Constraint;
import sql.generic.ddl.ConstraintInfoHolder;
import sql.generic.ddl.PKConstraint;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.UniqueConstraint;
import sql.generic.ddl.alter.AlterUtilityHelper;
import sql.generic.ddl.alter.DataType;

public class ColumnDefinition {
    StringBuilder columnDef = new StringBuilder();
    TableInfo tableInfo;
    String columnName;
    DataType type;
    String checkDef;
    ConstraintInfoHolder constraintHolder = GenericBBHelper.getConstraintInfoHolder();
    boolean defaultDefInConstraint = false;
    Constraint.ConstraintType constraintType;
    String constraintName = "";

    public ColumnDefinition(TableInfo tableInfo, String columnName, DataType type) {
        this.tableInfo = tableInfo;
        this.columnName = columnName;
        this.type = type;
    }

    public String getDefinition() {
        if (SQLOldTest.random.nextInt() % 2 == 0) {
            this.columnDef.append(this.getConstraints());
        }
        if (this.columnDef.indexOf("PRIMARY KEY") != -1) {
            this.columnDef.append(this.getDefaultDefinition());
        }
        if ((this.type == DataType.BIGINT || this.type == DataType.INTEGER) && SQLOldTest.random.nextInt() % 2 == 0) {
            this.columnDef.append(this.getGeneratedDefaultString());
        } else if (this.getConstantExpressionBasedOnType() != null && SQLOldTest.random.nextInt() % 2 == 0) {
            this.columnDef.append(this.getDefaultDefinition());
        }
        return this.columnDef.toString();
    }

    private String getGeneratedDefaultString() {
        StringBuilder generatedDefault = new StringBuilder("GENERATED ");
        if (SQLOldTest.random.nextInt() % 2 == 0) {
            generatedDefault.append(" ALWAYS  ");
        } else {
            generatedDefault.append(" BY DEFAULT ");
        }
        generatedDefault.append(" AS IDENTITY ");
        if (SQLOldTest.random.nextInt() % 2 == 0) {
            generatedDefault.append(" (START WITH ").append(SQLOldTest.random.nextInt(1) + 1);
            if (SQLOldTest.random.nextInt() % 2 == 0) {
                generatedDefault.append(" , INCREMENTED BY ").append(SQLOldTest.random.nextInt(1) + 1);
            }
            generatedDefault.append(" ) ");
        }
        Log.getLogWriter().info(" generatedDefaultString is " + generatedDefault.toString());
        return generatedDefault.toString();
    }

    private String getDefaultDefinition() {
        StringBuilder defaultDef = new StringBuilder();
        if (!this.defaultDefInConstraint) {
            this.defaultDefInConstraint = true;
            if (SQLOldTest.random.nextInt() % 2 == 0 || this.columnDef.indexOf("PRIMARY KEY") != -1) {
                defaultDef.append(" NOT NULL");
            }
            if (SQLOldTest.random.nextInt() % 2 == 0) {
                defaultDef.append(" WITH ");
            }
            defaultDef.append(" DEFAULT ");
            if (SQLOldTest.random.nextInt() % 2 == 0 || defaultDef.indexOf("NOT NULL") != -1) {
                defaultDef.append(this.getConstantExpressionBasedOnType());
            } else {
                defaultDef.append(" NULL ");
            }
            Log.getLogWriter().info(" final column default definition is " + defaultDef.toString());
        }
        return defaultDef.toString();
    }

    private String getConstantExpressionBasedOnType() {
        switch (this.type) {
            case BIGINT: {
                return Long.valueOf(SQLOldTest.random.nextLong()).toString();
            }
            case DECIMAL: {
                return Float.valueOf(SQLOldTest.random.nextFloat()).toString();
            }
            case DOUBLE: {
                return Double.valueOf(SQLOldTest.random.nextDouble()).toString();
            }
            case FLOAT: {
                return Float.valueOf(SQLOldTest.random.nextFloat()).toString();
            }
            case INTEGER: {
                return Integer.valueOf(SQLOldTest.random.nextInt()).toString();
            }
            case NUMERIC: {
                return Integer.valueOf(SQLOldTest.random.nextInt()).toString();
            }
            case REAL: {
                return Double.valueOf(SQLOldTest.random.nextDouble()).toString();
            }
            case SMALLINT: {
                return Integer.valueOf(SQLOldTest.random.nextInt()).toString();
            }
        }
        return null;
    }

    private String getConstraints() {
        StringBuilder constraintDef = new StringBuilder();
        this.constraintType = Constraint.ConstraintType.values()[SQLOldTest.random.nextInt(Constraint.ConstraintType.values().length)];
        if (SQLOldTest.random.nextInt() % 2 == 0) {
            this.constraintName = AlterUtilityHelper.getRandomConstraintName(this.tableInfo.getTableName(), this.constraintType);
            constraintDef.append(" CONSTRAINT ").append(this.constraintName);
        }
        switch (this.constraintType) {
            case FK_CONSTRAINT: {
                String refTableName = this.getParentTable();
                TableInfo refTable = GenericBBHelper.getTableInfo(refTableName);
                String refColumn = this.getRefColumn(refTable);
                constraintDef.append(" REFERCENCES ").append(refTableName).append(" (").append(refColumn).append(")");
                break;
            }
            case CHECK: {
                constraintDef.append(" CHECK ").append(" (").append(this.columnName).append(this.getRegularExpr()).append(")");
                break;
            }
            case PK_CONSTRAINT: {
                constraintDef.append(" PRIMARY KEY ");
                break;
            }
            case UNIQUE: {
                constraintDef.append(" UNIQUE ");
            }
        }
        Log.getLogWriter().info(" generatedConstraintString is " + constraintDef.toString());
        return constraintDef.toString();
    }

    private String getRefColumn(TableInfo refTable) {
        String refColumnName = "";
        ArrayList<Constraint> tableConstraints = new ArrayList<Constraint>();
        PKConstraint pkConstraint = refTable.getPrimaryKey();
        ArrayList<UniqueConstraint> uniqueConstraints = new ArrayList<UniqueConstraint>(refTable.getUniqueKeys());
        tableConstraints.add(pkConstraint);
        tableConstraints.addAll(uniqueConstraints);
        Constraint constraint = (Constraint)tableConstraints.get(SQLOldTest.random.nextInt(tableConstraints.size()));
        List<ColumnInfo> uniqOrPKColumns = constraint.getColumns();
        for (ColumnInfo column : uniqOrPKColumns) {
            if (refColumnName.length() == 0) {
                refColumnName = column.getColumnName();
                continue;
            }
            refColumnName = "," + column.getColumnName();
        }
        return refColumnName;
    }

    private String getParentTable() {
        ArrayList<String> tableList = new ArrayList<String>();
        ArrayList<String> pkTables = new ArrayList<String>(this.constraintHolder.getTablesWithPKConstraint());
        ArrayList<String> uniqTables = new ArrayList<String>(this.constraintHolder.getTablesWithUniqConstraint());
        tableList.addAll(pkTables);
        tableList.addAll(uniqTables);
        return (String)tableList.get(SQLOldTest.random.nextInt(tableList.size()));
    }

    private String getRegularExpr() {
        return "";
    }
}

