/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.alter;

import hydra.Log;
import java.sql.SQLException;
import java.util.HashMap;
import sql.SQLHelper;
import sql.generic.GenericBBHelper;
import sql.generic.ddl.ConstraintInfoHolder;
import sql.generic.ddl.DDLAction;
import sql.generic.ddl.Executor;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.TableInfoGenerator;
import util.TestException;
import util.TestHelper;

public abstract class Operation {
    DDLAction action;
    Executor executor;
    String ddl;
    String parsedDDL;
    TableInfo tableInfo;
    ConstraintInfoHolder constraintHolder;
    String columnName = "";
    String constraintName = "";
    boolean executeDDL = true;
    TableInfoGenerator tableInfoGen;
    String tableName;
    boolean genericDDL = true;
    boolean isFixed51273 = false;
    boolean isFixed51200 = false;
    final String consNameToReplace = "[CONSTRAINT-NAME]";
    final String tableNameToReplace = "[TABLE-NAME]";
    final String columnNameToReplace = "[COLUMN-NAME]";

    Operation(String ddl, Executor executor, DDLAction action) {
        this.action = action;
        this.ddl = ddl;
        this.executor = executor;
        this.constraintHolder = GenericBBHelper.getConstraintInfoHolder();
        this.parsedDDL = ddl;
        if (!ddl.contains("[")) {
            this.genericDDL = false;
        }
    }

    public abstract Operation parse();

    public void execute() {
        if (!this.genericDDL) {
            String[] ddlArr = this.ddl.split(" ");
            this.tableName = ddlArr[2];
            this.tableInfo = GenericBBHelper.getTableInfo(this.tableName);
        }
        if (this.executeDDL) {
            HashMap<Executor.ExceptionMapKeys, SQLException> exceptionMap;
            Log.getLogWriter().info("DDL after parsing :: " + this.getParsedDDL());
            if (this.action == DDLAction.SET) {
                Log.getLogWriter().info("Executing alter statement on GFXD ...");
                exceptionMap = this.executor.executeOnlyOnGFXD(this.parsedDDL);
                if (exceptionMap.get((Object)Executor.ExceptionMapKeys.GEMXD) == null) {
                    Log.getLogWriter().info("Successfully executed alter statement GFXD ...");
                    this.executor.commit();
                    this.updateBB();
                } else {
                    this.handleAlterDDLException(exceptionMap.get((Object)Executor.ExceptionMapKeys.GEMXD));
                }
            } else {
                exceptionMap = this.executor.executeOnBothDb(this.parsedDDL);
                if (exceptionMap.get((Object)Executor.ExceptionMapKeys.DERBY) == null && exceptionMap.get((Object)Executor.ExceptionMapKeys.GEMXD) == null) {
                    Log.getLogWriter().info("Successfully executed alter statement on DERBY and GFXD ...");
                    this.executor.commit();
                    this.updateBB();
                } else {
                    this.handleAlterDDLException(exceptionMap.get((Object)Executor.ExceptionMapKeys.DERBY), exceptionMap.get((Object)Executor.ExceptionMapKeys.GEMXD));
                }
            }
        } else {
            Log.getLogWriter().info("Could not execute alter statement, continuing test ...");
        }
    }

    public void compareExceptions(SQLException dse, SQLException sse) {
        Log.getLogWriter().info("In compare exceptions...");
        if (dse != null && sse != null) {
            if (!dse.getSQLState().equalsIgnoreCase(sse.getSQLState())) {
                Log.getLogWriter().warning("Compare exceptions failed...");
                Log.getLogWriter().info("Derby exception : ");
                SQLHelper.printSQLException(dse);
                Log.getLogWriter().info("GFXD Exception : ");
                SQLHelper.printSQLException(sse);
                throw new TestException("Exceptions are not same -- for derby: " + TestHelper.getStackTrace((Throwable)dse) + "\n for gfxd: " + TestHelper.getStackTrace((Throwable)sse));
            }
        } else {
            if (dse != null) {
                SQLHelper.printSQLException(dse);
                Log.getLogWriter().warning("Compare exceptions failed");
                throw new TestException("Derby got the exception, but gfxd did not\n" + TestHelper.getStackTrace((Throwable)dse));
            }
            Log.getLogWriter().warning("Compare exceptions failed");
            SQLHelper.printSQLException(sse);
            throw new TestException("GFXD got the exception, but derby did not\n" + TestHelper.getStackTrace((Throwable)sse));
        }
        Log.getLogWriter().info("Got the same exceptions from derby and gfxd.");
    }

    protected abstract void handleAlterDDLException(SQLException var1);

    protected abstract void handleAlterDDLException(SQLException var1, SQLException var2);

    protected void updateBB() {
        this.tableInfoGen = new TableInfoGenerator(this.tableInfo, this.executor, this.constraintHolder);
        this.tableInfo = this.tableInfoGen.updateTableInfo();
        this.tableInfoGen.saveTableInfoToBB();
    }

    protected void replacePlaceHolders(String tableName, String constraintName, String columnName) {
        this.parsedDDL = this.parsedDDL.replace("[TABLE-NAME]", this.tableInfo.getFullyQualifiedTableName());
        this.parsedDDL = this.parsedDDL.replace("[CONSTRAINT-NAME]", constraintName);
        this.parsedDDL = this.parsedDDL.replace("[COLUMN-NAME]", columnName);
    }

    public String getParsedDDL() {
        return this.parsedDDL;
    }
}

