/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.create;

import com.gemstone.gemfire.LogWriter;
import hydra.HydraVector;
import hydra.Log;
import hydra.TestConfig;
import hydra.gemfirexd.FabricServerHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.generic.GenericBBHelper;
import sql.generic.SQLGenericPrms;
import sql.generic.SQLOldTest;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.ConstraintInfoHolder;
import sql.generic.ddl.Executor;
import sql.generic.ddl.PKConstraint;
import sql.generic.ddl.SchemaInfo;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.TableInfoGenerator;
import sql.generic.ddl.UniqueConstraint;
import sql.generic.ddl.create.PartitionClauseGenerator;
import sql.wan.SQLWanBB;
import util.TestException;
import util.TestHelper;

public class CreateTableTest {
    protected Random random = SQLOldTest.random;
    private SQLOldTest sqlGen;
    LogWriter log;
    PartitionClauseGenerator partClause;
    List<TableInfo> tableInfoList = new ArrayList<TableInfo>();

    public CreateTableTest(SQLOldTest gen) {
        this.sqlGen = gen;
        this.log = gen.log;
        this.partClause = new PartitionClauseGenerator(this.random, this.log);
    }

    public void createGFETables(Connection conn) {
        this.populateBBWithTableData();
        this.log.info("Starting create GFE Tables");
        this.getTableInfosFromBB();
        this.setTablePartitionClause();
        this.setServerGroupClause();
        this.setAsyncEventListnerClause();
        this.setEvictionClause();
        this.setPersistentClause();
        this.setHdfsClause();
        this.setOffHeapClause();
        this.setEnableConcurrecyCheckClause();
        this.setNumPrForRecovery();
        this.updateTableInfosToBB();
        Executor executor = new Executor(conn);
        int tableCount = this.tableInfoList.size();
        for (int i = 0; i < tableCount; ++i) {
            TableInfo table = this.tableInfoList.get(i);
            this.sqlGen.executeListener("CLOSE", "PRINT_CONN");
            String tableDDL = table.getGfxdDDL();
            Log.getLogWriter().info("About to create table " + tableDDL);
            try {
                executor.execute(tableDDL);
                continue;
            }
            catch (SQLException se) {
                if (SQLOldTest.multiThreadsCreateTables && se.getSQLState().equalsIgnoreCase("X0Y32")) {
                    Log.getLogWriter().info("Got the expected exception, continuing tests");
                    continue;
                }
                if (se.getSQLState().equalsIgnoreCase("X0Y99")) {
                    SQLHelper.printSQLException(se);
                    Log.getLogWriter().info("Got the expected exception X0Y99, continuing tests");
                    continue;
                }
                SQLHelper.printSQLException(se);
                throw new TestException("Not able to create tables\n" + TestHelper.getStackTrace((Throwable)se));
            }
        }
        this.sqlGen.executeListener("CLOSE", "PRINT_CONN");
        this.sqlGen.commit(conn);
        this.sqlGen.executeListener("CLOSE", "PRINT_CONN");
    }

    public void populateBBWithTableData() {
        Log.getLogWriter().info("Populating BB with tables information");
        String[] createTablesStmt = SQLPrms.getCreateTablesStatements(true);
        Executor executor = new Executor(this.sqlGen.getGFEConnection());
        ArrayList<String> tableList = new ArrayList<String>();
        ConstraintInfoHolder constraintHolder = new ConstraintInfoHolder();
        try {
            for (String ddl : createTablesStmt) {
                executor.execute(ddl);
                Log.getLogWriter().info("executed : " + ddl);
                tableList.add(this.getFullyQualifiedTableName(ddl));
                TableInfoGenerator generator = new TableInfoGenerator(this.getFullyQualifiedTableName(ddl), executor, constraintHolder);
                generator.buildTableInfo().setDerbyDDL(ddl);
                generator.saveTableInfoToBB();
                GenericBBHelper.getTableInfo(this.getFullyQualifiedTableName(ddl)).setDerbyDDL(ddl);
            }
            while (!tableList.isEmpty()) {
                String command = "drop table " + (String)tableList.get(tableList.size() - 1);
                executor.execute(command);
                Log.getLogWriter().info("executed : " + command);
                tableList.remove(tableList.size() - 1);
            }
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    public String getFullyQualifiedTableName(String ddl) {
        return ddl.toUpperCase().split("\\(")[0].split("TABLE")[1].trim().split(" ")[0];
    }

    public void getTableInfosFromBB() {
        String[] tablesDDLs = SQLPrms.getCreateTablesStatements(true);
        for (int i = 0; i < tablesDDLs.length; ++i) {
            String fullTableName = this.getFullyQualifiedTableName(tablesDDLs[i]);
            TableInfo t = GenericBBHelper.getTableInfo(fullTableName);
            if (t == null) {
                throw new TestException("No TableInfo found in BB for " + fullTableName);
            }
            this.tableInfoList.add(t);
        }
    }

    public void updateTableInfosToBB() {
        int numOfPRs = 0;
        for (TableInfo tbl : this.tableInfoList) {
            this.log.info("numOfPR for " + tbl.getFullyQualifiedTableName() + " is " + tbl.getNumPrForRecovery() + " totalnumpr=" + (numOfPRs += tbl.getNumPrForRecovery()));
            GenericBBHelper.putTableInfo(tbl);
        }
        SQLBB.getBB().getSharedCounters().add(SQLBB.numOfPRs, (long)numOfPRs);
    }

    protected void setTablePartitionClause() {
        boolean hasDDLExtension;
        this.log.info("Inside getTablePartitionClause");
        int tableCount = this.tableInfoList.size();
        HydraVector gfeDDLExtension = TestConfig.tab().vecAt(SQLPrms.gfeDDLExtension, new HydraVector());
        boolean bl = hasDDLExtension = gfeDDLExtension.size() > 0;
        if (hasDDLExtension && tableCount != gfeDDLExtension.size()) {
            throw new TestException("Found " + tableCount + " tables but " + gfeDDLExtension.size() + " gfeDDLExtension");
        }
        for (int i = 0; i < tableCount; ++i) {
            String ddlExtension = (String)gfeDDLExtension.elementAt(i);
            TableInfo tbl = this.tableInfoList.get(i);
            String partition = this.partClause.getPartitionedClause(tbl, ddlExtension);
            String redundancyClause = "";
            if (SQLGenericPrms.hasRedundancy() && !partition.toLowerCase().contains("replicate")) {
                HydraVector redClauseVector = TestConfig.tab().vecAt(SQLPrms.redundancyClause, new HydraVector());
                if (i < redClauseVector.size()) {
                    redundancyClause = (String)redClauseVector.elementAt(i);
                } else {
                    int r = SQLGenericPrms.redundancy();
                    redundancyClause = " REDUNDANCY " + r;
                }
            }
            partition = partition + redundancyClause;
            tbl.setPartitioningClause(partition);
        }
    }

    protected void setServerGroupClause() {
        HydraVector gfeDDLExtension = TestConfig.tab().vecAt(SQLPrms.gfeDDLExtension, new HydraVector());
        ArrayList groups = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"serverGroup_tables");
        int tableCount = this.tableInfoList.size();
        for (int i = 0; i < tableCount; ++i) {
            TableInfo tbl = this.tableInfoList.get(i);
            String ddlExtension = (String)gfeDDLExtension.elementAt(i);
            String[] str = ddlExtension.split(":");
            if (!SQLOldTest.testServerGroups) continue;
            String serverGroup = "";
            if (str.length > 2) {
                serverGroup = str[2];
                if (serverGroup.equals("random")) {
                    TableInfo parent = tbl.getColocatedParent();
                    if (parent != null) {
                        serverGroup = parent.getServerGroups();
                    } else if (SQLTest.random.nextBoolean()) {
                        String[] group = (String[])groups.get(SQLTest.random.nextInt(groups.size()));
                        serverGroup = group[SQLTest.random.nextInt(group.length)];
                    } else {
                        serverGroup = "default";
                    }
                    Log.getLogWriter().info("random server group is " + serverGroup);
                } else {
                    serverGroup = serverGroup.replace('.', ',');
                    Log.getLogWriter().info("server group is " + serverGroup);
                }
            } else {
                String[] group = (String[])groups.get(SQLTest.random.nextInt(groups.size()));
                serverGroup = group[SQLTest.random.nextInt(group.length)];
            }
            tbl.setServerGroups(serverGroup);
        }
    }

    protected void setOffHeapClause() {
        TableInfo tbl;
        int i;
        if (SQLOldTest.isOffheap && SQLOldTest.randomizeOffHeap) {
            throw new TestException("SqlPrms.isOffheap and SqlPrms.randomizeOffHeap are both set to true");
        }
        int tableCount = this.tableInfoList.size();
        if (SQLOldTest.isOffheap) {
            Log.getLogWriter().info("enabling offheap.");
            for (i = 0; i < tableCount; ++i) {
                tbl = this.tableInfoList.get(i);
                if (tbl.isOffHeap()) continue;
                tbl.setOffHeap(true);
            }
        }
        if (SQLOldTest.randomizeOffHeap) {
            Log.getLogWriter().info("Randomizing off-heap in some tables but not others");
            for (i = 0; i < tableCount; ++i) {
                tbl = this.tableInfoList.get(i);
                if (tbl.isOffHeap() || TestConfig.tab().getRandGen().nextInt(1, 100) > 50) continue;
                tbl.setOffHeap(true);
            }
        }
    }

    protected void setPersistentClause() {
        boolean hasPersistClause;
        int tableCount = this.tableInfoList.size();
        HydraVector gfePersistExtension = TestConfig.tab().vecAt(SQLPrms.gfePersistExtension, new HydraVector());
        boolean bl = hasPersistClause = gfePersistExtension.size() > 0;
        if (hasPersistClause && tableCount != gfePersistExtension.size()) {
            throw new TestException("Found " + tableCount + " tables but " + gfePersistExtension.size() + " gfePersistExtension");
        }
        if (hasPersistClause) {
            for (int i = 0; i < tableCount; ++i) {
                TableInfo tbl = this.tableInfoList.get(i);
                tbl.setPersistClause((String)gfePersistExtension.elementAt(i));
            }
        }
    }

    protected void setGatewaySenderClause() {
        SQLWanBB wanBB = SQLWanBB.getBB();
        int myWanSite = FabricServerHelper.getDistributedSystemId();
        ArrayList senderIDs = (ArrayList)wanBB.getSharedMap().get((Object)(myWanSite + "_senderIDs"));
        if (senderIDs == null) {
            throw new TestException("senderIDs are not setting yet for creating tables");
        }
        int tableCount = this.tableInfoList.size();
        for (int i = 0; i < tableCount; ++i) {
            TableInfo tbl = this.tableInfoList.get(i);
            for (int j = 0; j < senderIDs.size(); ++j) {
                tbl.addGatewaySenderToList((String)senderIDs.get(j));
            }
        }
    }

    protected void setAsyncEventListnerClause() {
        int tableCount = this.tableInfoList.size();
        for (int i = 0; i < tableCount; ++i) {
            TableInfo tbl = this.tableInfoList.get(i);
            if (!SQLOldTest.hasAsyncDBSync) continue;
            String partition = tbl.getPartitioningClause();
            if (partition.contains("REPLICATE")) {
                String serverGroups = tbl.getServerGroups();
                if (SQLOldTest.testServerGroupsInheritence) {
                    SchemaInfo schema = tbl.getSchemaInfo();
                    serverGroups = schema.getServerGroup();
                }
                if (!serverGroups.contains(SQLOldTest.sgDBSync)) {
                    serverGroups = SQLOldTest.sgDBSync + "," + serverGroups;
                }
                tbl.setServerGroups(serverGroups);
            }
            if (SQLOldTest.hasAsyncEventListener) {
                String basicListener = "BasicAsyncListener";
                tbl.addAsyncEventListnerToList(basicListener);
                continue;
            }
            tbl.addAsyncEventListnerToList(SQLOldTest.asyncDBSyncId);
        }
    }

    protected void setHdfsClause() {
        if (SQLOldTest.hasHdfs) {
            Log.getLogWriter().info("creating hdfs extn...");
            String[] ddlString = SQLPrms.getCreateTablesStatements(true);
            String[] hdfsDDL = SQLPrms.getHdfsDDLExtn(ddlString);
            for (int i = 0; i < hdfsDDL.length; ++i) {
                TableInfo tbl = this.tableInfoList.get(i);
                tbl.setHdfsClause(hdfsDDL[i]);
                Log.getLogWriter().info("hdfs extention: " + hdfsDDL[i]);
            }
        }
    }

    protected void setEnableConcurrecyCheckClause() {
        String ENABLECONCURRENCYCHECKS = " ENABLE CONCURRENCY CHECKS ";
        int tableCount = this.tableInfoList.size();
        if (SQLOldTest.enableConcurrencyCheck) {
            for (int i = 0; i < tableCount; ++i) {
                TableInfo tbl = this.tableInfoList.get(i);
                tbl.setEnableConcurrencyCheck(true);
            }
        }
    }

    protected void setEvictionClause() {
        int tableCount = this.tableInfoList.size();
        for (int i = 0; i < tableCount; ++i) {
            String string;
            TableInfo tbl = this.tableInfoList.get(i);
            if (SQLOldTest.useHeapPercentage) {
                if (SQLOldTest.alterTableDropColumn) {
                    CreateTableTest createTableTest = this;
                    string = createTableTest.sqlGen.getEvictionHeapPercentageOverflowForAlterTable();
                } else {
                    CreateTableTest createTableTest = this;
                    string = createTableTest.sqlGen.getEvictionHeapPercentageOverflow();
                }
            } else {
                CreateTableTest createTableTest = this;
                string = createTableTest.sqlGen.getEvictionOverflow();
            }
            String evictionClause = string;
            tbl.setEvictionClause(evictionClause);
        }
    }

    protected void setNumPrForRecovery() {
        int tableCount = this.tableInfoList.size();
        for (int i = 0; i < tableCount; ++i) {
            TableInfo tbl = this.tableInfoList.get(i);
            tbl.setNumPrForRecovery(this.calculateNumOfPRs(tbl));
        }
    }

    protected int calculateNumOfPRs(TableInfo table) {
        String partition = table.getPartitioningClause().toLowerCase();
        boolean isReplicated = partition.contains("replicate");
        if (isReplicated) {
            return 0;
        }
        int numPrs = 1;
        PKConstraint pk = table.getPrimaryKey();
        List<Object> primaryCols = pk == null ? new ArrayList() : pk.getColumns();
        List<ColumnInfo> partitionedCols = table.getPartitioningColumns();
        boolean isPartitionedPrimary = false;
        for (ColumnInfo col : partitionedCols) {
            if (!primaryCols.contains(col)) continue;
            isPartitionedPrimary = true;
            break;
        }
        if (!isPartitionedPrimary) {
            ++numPrs;
        }
        List<UniqueConstraint> uniqueList = table.getUniqueKeys();
        numPrs += uniqueList.size();
        String hdfsClause = table.getHdfsClause();
        if (!hdfsClause.equals("")) {
            numPrs += numPrs;
        }
        List<String> aeqList = table.getAsyncEventListnerList();
        for (String aeq : aeqList) {
            numPrs *= 2;
        }
        ArrayList senderList = new ArrayList();
        for (String sender : senderList) {
            boolean isparallel = false;
            if (!isparallel) continue;
            numPrs *= 2;
        }
        return numPrs;
    }

    public void dropTables(Connection conn) {
        String sql = null;
        ArrayList<String> tables = new ArrayList<String>();
        for (int i = this.sqlGen.tableNames.length - 1; i >= 0; --i) {
            tables.add(this.sqlGen.tableNames[i]);
        }
        boolean testDropTableIfExists = SQLTest.random.nextBoolean();
        sql = "drop table " + (testDropTableIfExists ? " if exists " : "");
        try {
            Statement s = conn.createStatement();
            for (String table : tables) {
                s.execute(sql + table);
                Log.getLogWriter().info("executed : " + sql + table);
            }
        }
        catch (SQLException se) {
            if (se.getSQLState().equalsIgnoreCase("42Y55") && !testDropTableIfExists) {
                Log.getLogWriter().info("Got expected table not exists exception, continuing tests");
            }
            SQLHelper.handleSQLException(se);
        }
    }
}

