/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.create;

import sql.generic.SQLGenericPrms;
import sql.generic.ddl.Index.GenericIndex;
import sql.generic.ddl.create.DDLStmtIF;
import util.TestException;
import util.TestHelper;

public class DDLStmtFactory {
    public static final int PROCEDURE = 1;
    public static final int AUTHORIZATION = 2;
    public static final int FUNCTION = 3;
    public static final int DAP = 4;
    public static final int INDEX = 5;

    public DDLStmtIF createDDLStmt(int whichDDL) {
        DDLStmtIF ddlStmtIF = null;
        switch (whichDDL) {
            case 1: 
            case 4: {
                String prefix = "sql.generic.ddl.procedures.";
                String procedureName = SQLGenericPrms.getAnyProcedure().trim();
                int loc = SQLGenericPrms.getProcedureNames().indexOf(procedureName);
                ddlStmtIF = this.loadClass(prefix + procedureName);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                String prefixFunction = "sql.generic.ddl.Functions.";
                String functionName = SQLGenericPrms.getAnyFunction().trim();
                int loc = SQLGenericPrms.getFunctionNames().indexOf(functionName);
                ddlStmtIF = this.loadClass(prefixFunction + functionName);
                break;
            }
            case 5: {
                ddlStmtIF = new GenericIndex(SQLGenericPrms.getAnyIndexGroup());
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichDDL);
            }
        }
        return ddlStmtIF;
    }

    public static int getInt(String ddl) {
        int whichDDL = -1;
        if (ddl.equalsIgnoreCase("procedure")) {
            whichDDL = 1;
        } else if (ddl.equalsIgnoreCase("authorization")) {
            whichDDL = 2;
        } else if (ddl.equalsIgnoreCase("function")) {
            whichDDL = 3;
        } else if (ddl.equalsIgnoreCase("dap")) {
            whichDDL = 4;
        } else if (ddl.equalsIgnoreCase("index")) {
            whichDDL = 5;
        }
        return whichDDL;
    }

    public DDLStmtIF loadClass(String fullyQualifiedClassName) {
        DDLStmtIF loadedClass = null;
        try {
            Class<?> proc = Class.forName(fullyQualifiedClassName);
            loadedClass = (DDLStmtIF)proc.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
        catch (InstantiationException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
        return loadedClass;
    }
}

