/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.create;

import hydra.Log;
import java.util.List;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.create.AbstractPartitionClause;

public class PartitionByListClause
extends AbstractPartitionClause {
    @Override
    public boolean generatePartitionClause(TableInfo table) {
        boolean clauseFound = false;
        String valuesstr = "";
        List<ColumnInfo> columns = this.matchedColumnHelper.getNumericOrStringTypeColumns(table, 1);
        String column = "";
        if (columns.size() == 1) {
            clauseFound = true;
            ColumnInfo col = columns.get(0);
            column = col.getColumnName();
            this.partColumns.add(col);
            List<Object> vals = col.getValueList();
            String quot = this.isOfNumberType(col) ? "" : "'";
            int valuesCount = vals.size();
            int groups = valuesCount == 1 || valuesCount == 2 ? valuesCount : this.random.nextInt(1 + valuesCount / 3) + 1;
            int diff = valuesCount / groups;
            Log.getLogWriter().info("Partition by list for " + table.getFullyQualifiedTableName() + " on column " + col.getColumnName() + ", groups=" + groups + " ColumnValuesCount=" + valuesCount);
            int _min = 0;
            int _max = 0;
            for (int i = 0; i < groups; ++i) {
                String v = "VALUES (";
                _min = _max;
                if ((_max = _min + this.random.nextInt(diff) + 1) > valuesCount || i == groups - 1) {
                    _max = valuesCount;
                }
                for (int j = _min; j < _max; ++j) {
                    v = v + quot + vals.get(j) + quot;
                    if (j == _max - 1) continue;
                    v = v + ", ";
                }
                v = v + ")";
                valuesstr = valuesstr + v;
                if (i == groups - 1) continue;
                valuesstr = valuesstr + ", ";
            }
            this.partitionClause = availablePartitionClause[3] + "(" + column + ")" + " (" + valuesstr + ")";
        }
        return clauseFound;
    }
}

