/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.create;

import hydra.Log;
import java.util.List;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.create.AbstractPartitionClause;

public class PartitionByRangeClause
extends AbstractPartitionClause {
    @Override
    public boolean generatePartitionClause(TableInfo table) {
        boolean clauseFound = false;
        String valuesstr = "";
        List<ColumnInfo> columns = this.matchedColumnHelper.getNumericOrStringTypeColumns(table, 1);
        String column = "";
        if (columns.size() == 1) {
            clauseFound = true;
            ColumnInfo col = columns.get(0);
            column = col.getColumnName();
            this.partColumns.add(col);
            List<Object> vals = col.getValueList();
            int valuesCount = vals.size();
            int groups = valuesCount == 1 || valuesCount == 2 ? 1 : this.random.nextInt(1 + valuesCount / 3) + 1;
            int diff = valuesCount / groups;
            Log.getLogWriter().info("Partition by range for " + table.getFullyQualifiedTableName() + " on column " + col.getColumnName() + ", groups=" + groups + " ColumnValuesCount=" + valuesCount);
            String quot = this.isOfNumberType(col) ? "" : "'";
            for (int i = 0; i < groups; ++i) {
                int _min = diff * i;
                int _max = _min + diff;
                if (_max > valuesCount || i == groups - 1) {
                    _max = valuesCount - 1;
                }
                String v = "VALUES BETWEEN " + quot + vals.get(_min) + quot + " AND " + quot + vals.get(_max) + quot;
                valuesstr = valuesstr + v;
                if (i == groups - 1) continue;
                valuesstr = valuesstr + ", ";
            }
            this.partitionClause = availablePartitionClause[4] + "(" + column + ")" + " (" + valuesstr + ")";
        }
        return clauseFound;
    }
}

